/* @(#) if_prgreg.h 1.1@(#) Solbourne id 9/22/93 00:12:17 */
/*
 * Copyright 1991 Solbourne Computer, Inc.
 * All rights reserved.
 */
#ifndef if_if_prgreg_h
#define	if_if_prgreg_h
/*
 * This file contains common definitions specifiec to interphase boards
 * which support the COMMON BOOT and RC interfaces.
 */

/* The format of the start of short io space as seen by the host. */
struct prg_shio {
    u_short	prg_shio_cint;		/* Controller interrupt field */
    u_short	prg_shio_icid;		/* Interrupting channel id */
};
#define	PRGPSHIO_MAXSIZE	1024

/*
 * RESET DEFINITIONS:
 * After a power up or a reset the controller fills the entire shared memory
 * region with the following 32 bit pattern.
 */
struct prg_cb_herald {
    u_char	cb_herald_hdr;
#define		CB_HERALD		0xcb
    u_char	cb_herald_off;		/* offset from base to CB_START */
    u_short	cb_herald_shio_len;	/* size of boards shortio region */
};

/*
 * COMMON BOOT DEFINITIONS:
 *
 * Common boot commands are delivered by copying CB command blocks to the
 * address CB_START.  Commands must be copied into this region in reverse
 * order so all the parameters are available by the time the command is
 * specified.  The controllers responce is available when the command field
 * has the value CB_CBOK.
 */
#define	MAKE_LONG(a, b, c, d)	(((a) << 24) | ((b) << 16) | ((c) << 8) | (d))

struct prg_cb {
    u_int	cb_cmd;
#define		  CB_CMD_BOOT		MAKE_LONG('B', 'O', 'O', 'T')
#define		  CB_CMD_BURN		MAKE_LONG('B', 'U', 'R', 'N')
#define		  CB_CMD_FILL		MAKE_LONG('F', 'I', 'L', 'L')
#define		  CB_CMD_FLSH		MAKE_LONG('F', 'L', 'S', 'H')
#define		  CB_CMD_GRNL		MAKE_LONG('G', 'R', 'N', 'L')
#define		  CB_CMD_JUMP		MAKE_LONG('J', 'U', 'M', 'P')
#define		  CB_CMD_PEEK		MAKE_LONG('P', 'E', 'E', 'K')
#define		  CB_CMD_POKE		MAKE_LONG('P', 'O', 'K', 'E')
#define		  CB_CMD_REDL		MAKE_LONG('R', 'E', 'D', 'L')
#define		  CB_CMD_STUF		MAKE_LONG('S', 'T', 'U', 'F')
#define		cb_response	cb_cmd
#define		  CB_CBOK		MAKE_LONG('C', 'B', 'O', 'K')
#define		  CB_FAIL		MAKE_LONG('F', 'A', 'I', 'L')
#define		CB_MAX_DNLD_SIZE	128
#define		CB_CMD_HEADER_LEN	4
    union {
	struct cbboot {		/* Format of a a CB boot command. */
	    u_int	cbboot_index;	/* Index of image to boot. */
	    u_int	cbboot_len;	/* length of remaining parameters. */
					/* ... RC commands to init the board */
	}	cbboot;
	struct cbboot1 {	/* Format of a a CB boot command. (index != 0)*/
	    u_int	cbboot1_index;	/* Index of image to boot. */
	    u_int	cbboot1_startpc;/* start pc for image */
	    u_int	cbboot1_isize;	/* # bytes in image */
	}	cbboot1;
	struct cbfill {		/* Format of a CB fill command. */
	    u_int	cbfill_pattern;	/* Pattern to fill board memory with.*/
	    u_int	cbfill_addr;	/* board address to fill */
	    u_int	cbfill_count;	/* Number units of pattern to write */
	    u_int	cbfill_unit;	/* # bytes/unit */
	}	chfill;
	struct cbflsh {		/* Format of a a CB flsh command. */
	    u_int	cbflsh_count;	/* # red-to-green transitions */
	}	cbflsh;
	struct cbjump {		/* Format of a a CB flsh command. */
	    u_int	cbjump_addr;	/* execution address */
	}	cbjump;
	struct cbpeek {		/* Format of a a CB peek command. */
	    u_int	cbpeek_addr;	/* board address to peek */
	    u_int	cbpeek_count;	/* Number of units to write. */
	    u_int	cbpeek_unit;	/* # bytes/unit */
	}	cbpeek;
	struct cbpoke {		/* Format of a a CB poke command. */
	    u_int	cbpoke_addr;	/* board address to poke */
	    u_int	cbpoke_count;	/* Number of units to write. */
	    u_int	cbpoke_unit;	/* # bytes/unit */
	    u_char	cbpoke_data[CB_MAX_DNLD_SIZE];
	}	cbpoke;
	struct cbstuf {		/* Format of a a CB poke command. */
	    u_int	cbstuf_addr;	/* board address to stuf */
	    u_int	cbstuf_count;	/* Number of units to write. */
	    u_int	cbstuf_unit;	/* # bytes/unit */
	    u_char	cbstuf_data[CB_MAX_DNLD_SIZE];
	}	cbstuf;
	u_char	cb_peek_data_8[CB_MAX_DNLD_SIZE];
	u_short	cb_peek_data_16[CB_MAX_DNLD_SIZE/2];
    }	cb_cmda;
};

/*
 * RC DEFINITIONS:
 *
 * After RC is booted the shortio space is used for RC channel control
 * structures.  The initial control structures are set up as a result
 * of RC commands specified in the CB_CMD_BOOT COMMON BOOT command structure.
 *
 * For each control structure the driver is either a writer (host to board: h2b)
 * or a reader (board to host: b2h).  The CB_CMD_BOOT will set up the initial
 * h2b channel control structure followed by the b2h channel control structure
 * (this b2h channel is also used as the default response channel).  The
 * actual communication between the board/driver occurs in areas of memory
 * called segments; the segments themselves are controlled and synchronized
 * by the channel control structures that are held in the boards shortio space.
 *
 *                             h2b channels
 *           writer |>----->(request/directives)>---->| reader
 *     driver       |                                 |       board
 *           reader |<----<(response/indication)>---->| writer
 *                             b2h channels
 *
 * The driver controlls the board by writing requests and directives into
 * segments that are associated with the h2b * channel(s) and fielding the
 * boards responses (to requests) and indications by reading from segments
 * associated with the b2h channel(s).  When adding a command to a segment
 * attached to the h2b list the driver knows the length of the command and
 * the amount of free space remaining in the segment.  If there is enough
 * space in the current segment it will copy the command into the segment
 * and update the h2b write pointers (with the RC_UPDATE_WRITE_PTR macro).
 * If there is not enough space in the current segment and there is a
 * currently empty segment available for use is places a link segment command
 * in the current segment and puts the command in the start of the new segment.
 * If there is not enough space in the current segment and there is not a
 * currently empty segment it must delay the command until the board returns
 * a segment back to the host.
 *
 * Reading and writing pointers in the channel control structure must
 * be done carefully due to the fact that the writer of the channel may be
 * updating them.  When updating the segment number in the channel control
 * struecute the segment offset must first be set to indicate an update is
 * in progress. This prevents the board from reading an invalid pointer.
 */
struct prg_rc {			/* rc channel control structure */
    u_short	__0;			/* Reserved word */
    u_short	rc_intr_timer;		/* Interrupt/timer word */
#define	RC_DISABLE_TIMER	0xffff
    u_short	rc_r_seg;		/* Read segment number */
    u_short	rc_r_off;		/* Read offset value */
    u_short	rc_w_seg;		/* Write segment number */
    u_short	rc_w_off;		/* Write offset value */
    u_short	__1;
    u_short	__2;
};

#define	RC_UPDATE_IN_PROGRESS	0xffff

/*
 * This macro is used to get a pointer from a channel when the user is
 * not the writer/owner of the channel.  We must be careful when
 * doing this because the pointer may be in the process of being updated by
 * the writer. It is passed a pointer to the segment controll structure
 * and variebes to be assigned the current seg and offset.
 * NOTE: The driver is only allowed to use the RC_GET_READ_PTR for h2b
 * channels; and RC_GET_WRITE_PTR for b2h channels.
 */
#define	RC_GET_READ_PTR(rc, seg, off) {				\
    do {							\
	(seg) = (rc)->rc_r_seg;					\
	while(((off) = (rc)->rc_r_off) == RC_UPDATE_IN_PROGRESS)\
	    DELAY(1);						\
    } while ((seg) != (rc)->rc_r_seg);				\
}
#define	RC_GET_WRITE_PTR(rc, seg, off) {			\
    do {							\
	(seg) = (rc)->rc_w_seg;					\
	while(((off) = (rc)->rc_w_off) == RC_UPDATE_IN_PROGRESS)\
	    DELAY(1);						\
    } while ((seg) != (rc)->rc_w_seg);				\
}

/* transfer options: look in ../mfg/autoconf.h for VMEbus AM's */
#define	TOPTS_16BIT	0x100
#define	TOPTS_32BIT	0x200

/*===============definitions for common rc commands/responses===============*/

/* general command block header template */
struct rc_ccb {
    u_int	ccb_len;		/* length of request command */
    u_int	ccb_cmd;		/* request command code */
};

/*
 * commands that are placed in segments of the driver to the board (h2b)
 * channels are broken up into two categories: "requests" and "directives".
 * Requests result in a "Responses" in a segment of the indicated b2h channel.
 */
/*----------------requests: RC Common command ReQuest Blocks----------------*/
struct rc_crqb_info {		/* CMD_CRQB_INFO */
    u_int	info_len;		/* length of request command */
    u_int	info_cmd;		/* request command code */
#define		  CMD_CRQB_INFO		0x0003
    u_int	info_rchid;		/* channel id for command response */
    u_int	info_rtag;		/* driver tag for command response */
};
struct rc_crqb_creat_h2b {	/* CMD_CRQB_CREATE_H2B */
    u_int	creat_h2b_len;		/* length of request command */
    u_int	creat_h2b_cmd;		/* request command code */
#define		  CMD_CRQB_CREATE_H2B	0x0005
    u_int	creat_h2b_rchid;	/* channel id for command response */
    u_int	creat_h2b_rtag;		/* driver tag for command response */
    u_int	creat_h2b_seg_xopt;	/* transfer options word */
    u_int	creat_h2b_seg_paddr;	/* physical address of the seg */
    u_int	creat_h2b_seg_len;	/* length of segment */
};
struct rc_crqb_creat_b2h {	/* CMD_CRQB_CREATE_H2B */
    u_int	creat_b2h_len;		/* length of request command */
    u_int	creat_b2h_cmd;		/* request command code */
#define		  CMD_CRQB_CREATE_B2H	0x0006
    u_int	creat_b2h_rchid;	/* channel id for command response */
    u_int	creat_b2h_rtag;		/* driver tag for command response */
};

/*--------------directives: RC Common command DIrective Blocks--------------*/
struct rc_cdib_setburst {	/* CMD_CDIB_SETBURST */
    u_int	setburst_len;		/* length of directive command */
    u_int	setburst_cmd;		/* directive command code */
#define		  CMD_CDIB_SETBURST	0x0001
    u_int	setburst_value;		/* number of transfers per burst */
};
struct rc_cdib_setto {		/* CMD_CDIB_SETTO */
    u_int	setto_len;		/* length of directive command */
    u_int	setto_cmd;		/* directive command code */
#define		  CMD_CDIB_SETTO	0x0002
    u_int	setto_timeout;		/* number of milliseconds */
};
struct rc_cdib_setint {		/* CMD_CDIB_SETINT */
    u_int	setint_len;		/* length of directive command */
    u_int	setint_cmd;		/* directive command code */
#define		  CMD_CDIB_SETINT	0x0004
    u_int	setint_chid;		/* Id of channel to set level/vector */
    u_int	setint_level;		/* Interrupt level */
    u_int	setint_vector;		/* Interrupt vector */
};
struct rc_cdib_link {		/* CMD_CDIB_LINK */
    u_int	link_len;		/* length of directive command */
    u_int	link_cmd;		/* directive command code */
#define		  CMD_CDIB_LINK		0x0007
    u_int	link_xopt;		/* transfer options lower 16 bits */
    u_int	link_seg_paddr;		/* Physical VME Address */
    u_int	link_seg_len;		/* Length of new segment */
};
struct rc_cdib_segmem {		/* CMD_CDIB_SEG_MEM */
    u_int	segmem_len;		/* length of directive command */
    u_int	segmem_cmd;		/* directive command code */
#define		  CMD_CDIB_SEGMEM	0x0009
    u_int	segmem_xopts;		/* Transfer type for segments */
    u_int	segmem_seg_len;		/* length of each segment */
    struct rc_segmem_seg {
	u_int	seg_paddr;		/* Paddress of VME memory */
	u_int	seg_rtag;		/* tag for host */
    }		segmem_seg[1];
};

/*
 * information from the board to the driver is available from segments
 * of the (b2h) channels.  This information is broken up into two categories:
 * "responses" and "indications".  "Responses" are the boards response to a
 * "Request" from the driver.  "Indications" are asynchronous events which
 * inform the driver of state changes on the board.
 */
/*---------------responses: RC Common command ReSponse Blocks---------------*/
/* general response block header template */
struct rc_crs {
    u_int	crs_len;		/* length of request command */
    u_int	crs_cmd;		/* request command code */
    u_int	crs_rtag;		/* driver tag specified in request */
};
struct rc_crsb_info {		/* CMD_CRSB_INFO */
    u_int	info_len;		/* length of response */
    u_int	info_cmd;		/* response command code */
#define		  CMD_CRSB_INFO		0x0083
    u_int	info_rtag;		/* driver tag specified in request */
    char	info_fw_id[16];
    char	info_rel_date[16];
    u_int	info_buf_size;
    u_int	info_static_size;
};
struct rc_crsb_creat_h2b {	/* CMD_CRSB_CREATE_H2B */
    u_int	creat_h2b_len;		/* length of response */
    u_int	creat_h2b_cmd;		/* response command code */
#define		  CMD_CRSB_CREATE_H2B	0x0084
    u_int	creat_h2b_rtag;		/* driver tag specified in request */
    u_int	creat_h2b_chid;		/* offset into shortio of new channel */
};
struct rc_crsb_creat_b2h {	/* CMD_CRSB_CREATE_B2H */
    u_int	creat_b2h_len;		/* length of response */
    u_int	creat_b2h_cmd;		/* response command code */
#define		  CMD_CRSB_CREATE_B2H	0x0085
    u_int	creat_b2h_rtag;		/* driver tag specified in request */
    u_int	creat_b2h_chid;		/* offset into shortio of new channel */
    u_int	creat_b2h_seg_rtag;	/* virtual address of segment */
    u_int	creat_b2h_seg_len;	/* length of segment */
};

/*-------------indications: RC Common command INdication Blocks-------------*/
struct rc_cinb_msg {		/* CMD_CINB_MSG */
    u_int	msg_len;		/* length of response */
    u_int	msg_cmd;		/* response command code */
#define		  CMD_CINB_MSG		0x0081
    char	msg[4];			/* ... variable length */
};
struct rc_cinb_err {		/* CMD_CINB_ERR */
    u_int	err_len;		/* length of response */
    u_int	err_cmd;		/* response command code */
#define		  CMD_CINB_ERR		0x0082
    u_int	err_code;
#define		  ERR_CODE_BUS_TIMEOUT	0x01
#define		  ERR_CODE_INTERNAL	0x02
#define		  ERR_CODE_CMD_BADARG	0x03
#define		  ERR_CODE_ALLOC_M	0x04
#define		  ERR_CODE_CMD_UNIMP	0x05
#define		  ERR_CODE_CMD_UNKNOWN	0x06
#define		  ERR_CODE_BAD_NOVRAM	0x07
#define		  ERR_CODE_BUS_ERROR	0x08
#define		  ERR_CODE_ALLOC_MBLK	0x09
#define		  ERR_CODE_BAD_ALIGN	0x0B
#define		  ERR_CODE_NO_B2H_SEGS	0x0D
#define		  ERR_CODE_ALLOC_B	0x0E
#define		  ERR_CODE_ALLOC_S	0x0F
#define		  ERR_CODE_NO_CHANSPACE	0x10
    u_int	err_err_len;		/* length of command in error */
    u_int	err_err_cmd;		/* Command code of command in error */
    char	err_msg[4];		/* ... variable length */
};
struct rc_cinb_link {		/* CMD_CINB_LINK */
    u_int	link_len;		/* length of response */
    u_int	link_cmd;		/* response command code */
#define		  CMD_CINB_LINK		0x0086
    u_int	link_seg_rtag;		/* virtual tag from host */
    u_int	link_seg_len;		/* Length of new segment */
};
#endif if_if_prgreg_h
