/* @(#) if_exvar.h 1.1@(#) Solbourne id 9/22/93 00:11:12 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/* Excelan EXOS 203 Link Level Ethernet Interface Driver */

#define EXOS_ADDR(x)		\
		((u_long)(((u_int)(x) - (u_int)DVMA) | (u_int)(0x3d << 24)))
#define EXOS_OFFSET(x, ptr)	\
		((u_short)((u_int)(x) - (u_int)((ptr)->xs_shmem)))

/*
 * Sparc is incapable of splitting 32-bit accesses into two
 * 16-bit accesses.  This means that the driver must make the
 * split when 16-bit accesses are required.
 *
 * N.B:	These definitions are sensitive to machine byte-ordering
 *	conventions!
 */
#define	bigendian
#ifdef	bigendian
#define	_LSW_OFF	1
#define	_MSW_OFF	0
#else	bigendian
#define	_LSW_OFF	0
#define	_MSW_OFF	1
#endif	bigendian

#define	_lsw(x)	(*((u_short *)(x) + _LSW_OFF))
#define	_msw(x)	(*((u_short *)(x) + _MSW_OFF))

#ifdef	sparc
#define	ex_get(lv, t)	((t) _lsw(lv))
#define	ex_put(lv, v)	(_lsw(lv) = (u_short)(v), \
			_msw(lv) = (u_short)((unsigned)(v) >> 16))
#else	sparc
#define	ex_get(lv, t)	(lv)
#define	ex_put(lv, v)	(lv) = (v)
#endif	sparc

#define	NH2X 4			/* Host to eXcelan request buffers */
#define	NX2H 4			/* eXcelan to Host reply buffers */

/*
 * Ethernet software status per interface:
 * Each interface is referenced by a network interface structure, xs_if, which 
 * the routing code uses to locate the interface.  This structure contains the 
 * output queue for the interface, its address, ... 
 */
struct ex_shmem {
	u_short		es_h2xhdr;	/* EXOS's request queue header */
	u_short		es_x2hhdr;	/* EXOS's reply queue header */
	struct ex_msg 	es_h2xent[NH2X];/* request msg buffers */
	struct ex_msg 	es_x2hent[NX2H];/* reply msg buffers */
	struct confmsg	es_cm;		/* configuration message */
	struct stat_array es_xsa;	/* EXOS writes stats here */
};

struct	ex_softc {
	struct		arpcom xs_ac;	/* Ethernet common part */
#define	xs_if		xs_ac.ac_if	/* network-visible interface */
#define	xs_addr		xs_ac.ac_enaddr	/* hardware Ethernet address */
	int		xs_flags;	/* private flags */
#define	EX_XPENDING	1		/* xmit rqst pending on EXOS */
#define	EX_STATPENDING	2		/* stats rqst pending on EXOS */
	int		xs_cvec;	/* probe stores cvec here */
	struct	ex_msg	*xs_h2xnext;	/* host pointer to request queue */
	struct	ex_msg 	*xs_x2hnext;	/* host pointer to reply queue */
	struct ex_shmem	*xs_shmem;	/* shared info between device and host*/
	caddr_t		ex_rbuf;	/* temporary receive buffer */
	caddr_t		ex_tbuf;	/* temporary transmit buffer */
};
#define xs_h2xhdr	xs_shmem->es_h2xhdr
#define xs_x2hhdr	xs_shmem->es_x2hhdr
#define xs_h2xent	xs_shmem->es_h2xent
#define xs_x2hent	xs_shmem->es_x2hent
#define xs_cm		xs_shmem->es_cm
#define xs_xsa		xs_shmem->es_xsa
