/* @(#) pte.h 1.1@(#) Solbourne id 9/22/93 00:01:51 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*      @(#)pte.h 1.1 88/03/29 SMI      */

/*
 * Copyright (c) 1987 by Sun Microsystems, Inc.
 */

/*
 * KAP hardware page table entry
 * 
 * Software must handle updating the reference and modify bits. This
 * is handled via the software protection information.
 */

#ifndef	_machine_pte_h
#define	_machine_pte_h

#ifndef LOCORE
struct pte {
	unsigned int	pg_pfnum:19;	/* page frame number */
	unsigned int	:1;
	unsigned int	pg_lock:1;	/* software lock pte bit */
	unsigned int	pg_nosync:1;	/* software don't sync pg_r and pg_m */
	unsigned int	pg_r:1;		/* software reference bit */
	unsigned int	pg_m:1;		/* software modify bit */
	unsigned int	pg_sro:1;	/* software read-only bit , for pg_m */
	unsigned int	pg_sv:1;	/* software valid bit, for pg_r */
	unsigned int	pg_g:1;		/* global bit */
	unsigned int	pg_ma:2;	/* memory attribute bits */
	unsigned int	pg_prot:2;	/* access protection */
	unsigned int	pg_v:1;		/* valid bit */
};
#endif	!LOCORE

#define	PG_V		0x00000001	/* page is valid */
#define	PG_RO		0x00000002	/* read only page */
#define	PG_UP		0x00000004	/* user protected page */
#define	PG_MA0		0x00000008	/* memory attribute bit 0 */
#define	PG_MA1		0x00000010	/* memory attribute bit 1 */
#define PG_MA		(PG_MA1|PG_MA0)
#define	PG_G		0x00000020	/* global bit */
#define	PG_SV		0x00000040	/* sftw valid, for sftw pg_r bit */
#define	PG_SRO		0x00000080	/* sftw read-only, for sftw pg_m bit */
#define	PG_M		0x00000100	/* software modify bit */
#define	PG_R		0x00000200	/* software reference bit */
#define	PG_NOSYNC	0x00000400	/* sftw nosync */
#define	PG_LOCK		0x00000800	/* sftw lock */
#define PG_UNUSED1	0x00001000	/* unused */
#define PG_IO		0x00001000	/* this is defined to satisfy mapin().
					 * It is used by mapin() to 
					 * determine whether PTELD_IO should
					 * be passed to segkmem_mapin().
					 */
#define	PG_PFNUM	0xFFFFE000	/* page frame number mask */

#define	KW		0x2
#define	KR		0x3
#define	UW		0x0
#define UR		0x1
#define	URKR		0x1
#define RDONLY		0x1		/* ro bit in prot field */
#define KERNONLY	0x2

#define	MAKE_PROT(v)	((v) << 1)
#define	PG_PROT		MAKE_PROT(0x3)
#define	PG_KW		MAKE_PROT(KW)
#define	PG_KR		MAKE_PROT(KR)
#define	PG_UW		MAKE_PROT(UW)
#define	PG_URKR		MAKE_PROT(URKR)
#define	PG_UR		MAKE_PROT(UR)
#define	PG_UPAGE	PG_KW		/* kap u pages not user accessable */
#define PG_RDONLY	MAKE_PROT(RDONLY)

/* values for MA bits */

#define MA_IO		0	/* i/o */
#define MA_CACHE	1	/* cacheable */
#define MA_BYTE_SHARED	2	/* byte-writeable shared */
#ifdef SELFMOD
#define MA_TEXT_PROTECT	2	/* protected from text accesses */
#endif SELFMOD
#define MA_SHARED	3	/* non-byte-writeable shared */

#define MAKE_MA(v)		((v) << 3)
#define PG_MA_IO		MAKE_MA(MA_IO)
#define PG_MA_CACHE		MAKE_MA(MA_CACHE)
#define PG_MA_BYTE_SHARED	MAKE_MA(MA_BYTE_SHARED)
#ifdef SELFMOD
#define PG_MA_TEXT_PROTECT	MAKE_MA(MA_TEXT_PROTECT)
#endif SELFMOD
#define PG_MA_SHARED		MAKE_MA(MA_SHARED)

#define MAKE_PGT(v)		((v) << 28)
/*
 * This macro can be used to convert a struct pte * in to the relevant
 * bits needed for things like mapin and cdevsw[] mmap routine which
 * still deal with integers.
 */
#define	MAKE_PFNUM(pte)	(((*(unsigned int *)(pte)) & PG_PFNUM) >> 13)

/*
 * Macros to test a pte.
 */
#define	pte_valid(pte)	((pte)->pg_v != 0)
#define	pte_svalid(pte)	((pte)->pg_sv != 0)
#define pte_konly(pte)	((*(int *)(pte) & PG_UP) != 0)
#define pte_ronly(pte)	((*(int *)(pte) & PG_RO) != 0)
#define pte_setio(ppte)	(ppte)->pg_ma = MA_IO;
#define pte_io(ppte)	((ppte)->pg_ma == MA_IO)

#if !defined(LOCORE) && defined(KERNEL)
/* utilities defined in locore.s */
extern	struct pte Heapptes[];
extern	char Heapbase[];
extern	char Heaplimit[];
extern	struct pte Bufptes[];
extern	char Bufbase[];
extern	char Buflimit[];
extern	struct pte Sysmap[];
extern	char Sysbase[];
extern	struct pte Forkmap[];
extern	struct pte mmap[];
extern	char Syslimit[];

/*
 * These defines are just here to be an aid
 * for someone that was using these defines.
 */
#define	Usrptmap	Sysmap
#define	usrpt		Sysbase

extern	struct pte mmu_pteinvalid;
#endif !defined(LOCORE) && defined(KERNEL)
#endif _machine_pte_h
