/* @(#) nvram.h 1.1@(#) Solbourne id 9/22/93 00:01:34 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

#define NVRAM_INCR	8	/* space between consecutive bytes */
#define NVRAM_SHIFT	3	/* shift index to address */

#ifdef SIMULATOR
# define NVRAM_WAIT	2	/* this will varify that the code is correct */
#else
# define NVRAM_WAIT	10000
#endif
#define NVRAM_SIZE	0x800	/* size in bytes (2K) */

/*
 * These are some environment strings which have a fixed size because
 * they are copied onto static allocated strings during boot time.
 */
#define NVRAM_BANNER_SIZE 64
#define NVRAM_COPYRIGHT_SIZE 64
#define NVRAM_LOGO_SIZE 512

/*
 * The hard-wired fields below are the first things in the NVRAM,
 * the space util NVRAM_ENDADDR is available for user-defined strings.
 * (Some strings are added by the ROM by default.)  
 * Whenever the NVRAM is changed the checksum must be adjusted so that
 * everything between NVRAM_START and NVRAM_ENDADDR plus NVRAM_VERSION
 * equals the value found at NVRAM_CHKADDR.  If it doesn't equal the nvram
 * will be reinitialized.
 *
 * N.B. the NVRAM_VERSION number should be incremented whenever the
 *      fields in the NVRAM struct change.  this will cause the
 *      ROM to re-initialize the field automatically.
 */
#define NVRAM_VERSION	0x4	/* nvram struct version (must be non-zero) */

#define NVRAM_SERIAL_ADDR 0
#define NVRAM_SERIAL_SIZE 16

#define NVRAM_ENETADDR	(NVRAM_SERIAL_ADDR + NVRAM_SERIAL_SIZE)
#define NVRAM_ENETSIZE	17	/* format is "xx:xx:xx:xx:xx:xx" */

#define NVRAM_HOSTADDR	(NVRAM_ENETADDR + NVRAM_ENETSIZE)
#define NVRAM_HOSTSIZE	4

/*
 * Once the hostid and ethernet address are set we must not alow these
 * variables to change.  To checksum the nvram start at offset NVRAM_START.
 */
#define NVRAM_START	(NVRAM_HOSTADDR + NVRAM_HOSTSIZE)

#define NVRAM_BOOTADDR	(NVRAM_START)
#define NVRAM_BOOTSIZE	1
# define BOOTMODE_AUTO		1
# define BOOTMODE_MANUAL	2
# define BOOTMODE_DIAG		3

#define NVRAM_MODELADDR	(NVRAM_BOOTADDR + NVRAM_BOOTSIZE)
#define NVRAM_MODELSIZE	20

#define NVRAM_TTYA_ADDR	(NVRAM_MODELADDR + NVRAM_MODELSIZE)
#define NVRAM_TTYA_SIZE	4

#define NVRAM_TTYB_ADDR	(NVRAM_TTYA_ADDR + NVRAM_TTYA_SIZE)
#define NVRAM_TTYB_SIZE	4

/*
 * After this point in the nvram user defined strings can be found here.
 */
#define NVRAM_USERENV	(NVRAM_TTYB_ADDR + NVRAM_TTYB_SIZE)

/*
 * keytable information is the last 256 bytes of NVRAM 
 * previously reserved for environment strings
 */
#define	NVRAM_KEYTABLE_SIZE	128
#define	NVRAM_STRINGS_ENDADDR	(NVRAM_ENDADDR - NVRAM_KEYTABLE_SIZE * 2)

#define	NVRAM_KEYTAB_LC_ADDR	(NVRAM_STRINGS_ENDADDR)

#define	NVRAM_KEYTAB_UC_ADDR	(NVRAM_KEYTAB_LC_ADDR + NVRAM_KEYTABLE_SIZE)

/*
 * DIAGNOSTIC defines are in the last 256 bytes of NVRAM
 */ 
#define NVRAM_DIAGSIZE	256
#define NVRAM_DIAGADDR	(NVRAM_SIZE - NVRAM_DIAGSIZE)

/* error register block */
#define NV_DG_REGS		0
#define NV_DG_REGS_SIZE 	200	

/* diagnostic flags */
#define NV_DG_FLAGS		NV_DG_REGS+NV_DG_REGS_SIZE
#define NV_DG_FLAGS_SIZE	1
#define NVRAM_DGMODE_SIZE	NV_DG_FLAGS_SIZE

/* NV_DG_FLAG values: */
# define DIAG_SHORT		0x00			/* short self test */
# define DIAG_HALT		0x01			/* long self test */
# define DG_HALT		DIAG_HALT		/* halt on error */
# define DIAG_LOOP		0x02			/* long self test */
# define DG_LOOP		DIAG_LOOP		/* loop on test */
# define DIAG_LONG		0x04			/* long self test */
# define DG_LONG		DIAG_LONG		/* cont on error */

/* amount of RAM to be tested in extended tests (determined by total size - banks mapped out) */
#define NV_RAM_TEST   		NV_DG_FLAGS+NV_DG_FLAGS_SIZE
#define NV_RAM_TEST_SIZE      	4			
#define NVRAM_RAMTEST_SIZE	NV_RAM_TEST_SIZE

/* POST failure record */
#define NV_DG_RECORD		NV_RAM_TEST+NV_RAM_TEST_SIZE
#define NV_DG_RECORD_SIZE	8

/* Sbus POST failure record */
#define NV_SBUS_RECORD		NV_DG_RECORD+NV_DG_RECORD_SIZE
#define NV_SBUS_RECORD_SIZE	1

/* EXT failure record */
#define NV_EXT_RECORD		NV_SBUS_RECORD+NV_SBUS_RECORD_SIZE
#define NV_EXT_RECORD_SIZE	1

/* test location */
#define NV_TEST_LOC		NV_EXT_RECORD+NV_EXT_RECORD_SIZE
#define NV_TEST_LOC_SIZE 	1

/* Manufacturing history */
#define NV_MAN_HIS		NV_TEST_LOC+NV_TEST_LOC_SIZE
#define NV_MAN_HIS_SIZE 	8

/* FRU string pointers */
#define NV_FRU1                 NV_MAN_HIS+NV_MAN_HIS_SIZE
#define NV_FRU1_SIZE            4
#define NV_FRU1_ALT             NV_FRU1+NV_FRU1_SIZE
#define NV_FRU1_ALT_SIZE        4

#define NV_FRU2                 NV_FRU1_ALT+NV_FRU1_ALT_SIZE
#define NV_FRU2_SIZE            4
#define NV_FRU2_ALT             NV_FRU2+NV_FRU2_SIZE
#define NV_FRU2_ALT_SIZE        4

#define NVRAM_DGREGS_ADDR	NVRAM_DIAGADDR+NV_DG_REGS
#define NVRAM_DGMODE_ADDR	NVRAM_DIAGADDR+NV_DG_FLAGS
#define NVRAM_RAMTEST_ADDR      NVRAM_DIAGADDR+NV_RAM_TEST
#define NVRAM_DGREC_ADDR	NVRAM_DIAGADDR+NV_DG_RECORD
#define NVRAM_SBREC_ADDR	NVRAM_DIAGADDR+NV_SBUS_RECORD
#define NVRAM_EXTREC_ADDR	NVRAM_DIAGADDR+NV_EXT_RECORD
#define NVRAM_MANHIS_ADDR	NVRAM_DIAGADDR+NV_MAN_HIS
#define NVRAM_FRU1_ADDR         NVRAM_DIAGADDR+NV_FRU1
#define NVRAM_FRU1_ALT_ADDR     NVRAM_DIAGADDR+NV_FRU1_ALT
#define NVRAM_FRU2_ADDR         NVRAM_DIAGADDR+NV_FRU2
#define NVRAM_FRU2_ALT_ADDR     NVRAM_DIAGADDR+NV_FRU2_ALT

/*
 * From the DIAGNOSTIC area of nvram working downward are some debug 
 * locations and state information
 */
#define NVRAM_CHKADDR	(NVRAM_DIAGADDR - NVRAM_CHKSIZE)
#define NVRAM_CHKSIZE	1

#define NVRAM_MEMADDR	(NVRAM_CHKADDR - NVRAM_MEMSIZE)
#define NVRAM_MEMSIZE	1	/* 4 bytes */

#define NVRAM_PCADDR	(NVRAM_MEMADDR - NVRAM_PCSIZE)
#define NVRAM_PCSIZE	4

#define NVRAM_FVARADDR	(NVRAM_PCADDR - NVRAM_FVARSIZE)
#define NVRAM_FVARSIZE	4

#define NVRAM_FPARADDR	(NVRAM_FVARADDR - NVRAM_FPARSIZE)
#define NVRAM_FPARSIZE	4

#define NVRAM_STATE_ADDR (NVRAM_FPARADDR - NVRAM_STATE_SIZE)
#define NVRAM_STATE_SIZE 1
# define ROM_ST_COLD	0x00		/* normal cold start */
# define ROM_ST_WARM	0x01		/* warm start */
# define ROM_ST_DTRAP	0x02		/* double trap info */
# define ROM_ST_SINGLE	0x04		/* don't try to stop other CPUs */
# define ROM_ST_NOAUTO	0x08		/* force no autoboot */
# define ROM_ST_AUTO	0x10		/* force autoboot */
# define ROM_ST_CMD	0x20		/* execute command if autoboot */

#define NVRAM_ENDADDR	(NVRAM_STATE_ADDR)

#ifndef	LOCORE
struct ee_keymap {
	unsigned char	keymap[NVRAM_KEYTABLE_SIZE];
};
#endif	LOCORE

