/* @(#) l2cache.h 1.1@(#) Solbourne id 9/22/93 00:01:09 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 *
 * Second level cache for the S4000
 *
 * Rick McNeal, Jan 21, 1992
 */

struct l2cache_control {
    long	*dis_mode;	/* disable cache */
    long	*norm_mode;	/* normal mode */
    long	*inval_mode;	/* invalidate mode */
    long	*data_mode;	/* diagnostic mode */
    long	*read_mode;	/* read mode it <10:8> */
};

/* size of l2 cache used for flushing */
#define L2_CACHE_SIZE (256 * 1024)

/* bits which get changed into an address or a value returned by read-mode */
#define L2_DISABLE_MODE	0
#define L2_NORMAL_MODE	1
#define L2_INVAL_MODE	2
#define L2_DATA_MODE	3

/* convert a mode bit into the lower 28 bits of an address */
#define MODE_TO_ADR(x)	((x) << 25)

/* convert a mode bit into the value returned from read mode */
#define MODE_TO_VAL(x)	((x) << 8)

/* the various modes are enabled by reading from the address */
#define L2_NIBBLE		0xa
#define L2_BASE			(L2_NIBBLE << 28)
#define L2_DISABLE_MODE_ADR	(L2_BASE | MODE_TO_ADR(L2_DISABLE_MODE))
#define L2_NORMAL_MODE_ADR	(L2_BASE | MODE_TO_ADR(L2_NORMAL_MODE))
#define L2_INVAL_MODE_ADR	(L2_BASE | MODE_TO_ADR(L2_INVAL_MODE))
#define L2_DATA_MODE_ADR	(L2_BASE | MODE_TO_ADR(L2_DATA_MODE))
#define L2_READ_MODE_ADR	(L2_BASE | 0xe000000)

