/* @(#) environ.h 1.1@(#) Solbourne id 9/22/93 00:00:40 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*
 * Kernel environment related information
 *
 * The kernel is passed an environment from it's booter.
 */

#define MAXENV		32	/* max number of environment variables */
#define MAXENVSTR	128	/* max length of environ string "name=value" */

#define FIND_SUCCESS	0	/* found environ string */
#define FIND_FREE	1	/* free entry found, environ string not */
#define FIND_FAIL	-1	/* no free entry, didn't find environ string */

struct envstr {
	char	inuse;			/* ==1 if this entry is in use */
	char	str[MAXENVSTR];		/* environment string */
};

struct	bootf {
	char	let;
	short	bit;
};

#define CSP		' '
#define CHT		'\t'

extern char **environ;			/* pointer to environment */
extern char *envbuf[];			/* pointers to environ strings */
extern struct envstr envstr[];		/* environment strings */

extern char *atob();
extern char *getenv();
