/* @(#) cpuboard.h 1.1@(#) Solbourne id 9/22/93 00:00:20 */
/*
 * Copyright 1989 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*
 * This file contains information specific to the S4000 product.
 */

#define ADDR_TO_SPACE(a) (((a) >> 28) & 0xf)

#define iCU_RETRY_BUG

#define SOFT_INT_MASK(level)	(1 << level)
#define IR_SOFT_INT1 SOFT_INT_MASK(1)
#define IR_SOFT_INT3 SOFT_INT_MASK(3)
#define IR_SOFT_INT4 SOFT_INT_MASK(4)
#define IR_SOFT_INT5 SOFT_INT_MASK(5)

#ifdef PreProto
# define PREPRO
#endif

#ifdef PREPRO
/* test feature to disable interrupts for a short time */
#define DISINT	0xc0000000
#endif PREPRO
#ifdef SIMULATOR
#define DISINT	iGLU_BSR1
#endif SIMULATOR

/*
 * definitions for the iGLU (glue logic ASIC)
 */

#define iGLU_NIBBLE	6
#if defined(PREPRO) && !defined(SIMULATOR)
# define iGLU_BASE	(iGLU_NIBBLE << 28)+4		/* located on byte 4 for prepro */
# define iGLU_PHYS_OFF	0				/* for use with ASI_PHYS */
#else
# define iGLU_BASE	(iGLU_NIBBLE << 28)
# define iGLU_PHYS_OFF	0				/* for use with ASI_PHYS */
#endif /* PREPRO && !SIMULATOR */

/* board status register */
#define iGLU_BSR (iGLU_BASE + 0x0001800)		/* physical address */
# define BSR_LED	0x07	/* mask for LED control bits */
#  define BSR_LED_OFF	0x00	/* LED off */
#  define BSR_LED_YEL	0x02	/* LED yellow */
#  define BSR_LED_BYEL	0x03	/* LED blink yellow */
#  define BSR_LED_GRN	0x04	/* LED green */
#  define BSR_LED_BGRN	0x05	/* LED blink green */
#  define BSR_LED_BALT	0x07	/* LED blink alternating yellow/green */
# define BSR_DG_MODE	0x08	/* Diagnostic mode */
# define BSR_WARM	0x10	/* Warm start bit. Read/Write */
# define BSR_NMI	0x20	/* NMI or DMA tout bit. 0=NMI, 1=DMA */

/* eight r/w byte registers for diagnostics */
#define iGLU_BSR1 (iGLU_BASE + 0x0001808)		/* physical address */
#define iGLU_BSR2 (iGLU_BASE + 0x0001810)		/* physical address */
#define iGLU_BSR3 (iGLU_BASE + 0x0001818)		/* physical address */
#define iGLU_BSR4 (iGLU_BASE + 0x0001820)		/* physical address */
#define iGLU_BSR5 (iGLU_BASE + 0x0001828)		/* physical address */
#define iGLU_BSR6 (iGLU_BASE + 0x0001830)		/* physical address */
#define iGLU_BSR7 (iGLU_BASE + 0x0001838)		/* physical address */
#define iGLU_BSR8 (iGLU_BASE + 0x0001840)		/* physical address */

/* for LEDs on the diagnostic board (test connector) */
#define iGLU_LED (iGLU_BASE + 0x0001000)		/* physical address */

/* interrupt control register */
#define iGLU_ICR (iGLU_BASE + 0x0002000)		/* physical address */
# define ICR_SINT(V)	((V) & 0xf) 	/* post software interrupt level V */
# define ICR_IDIS	0x10		/* disable all interrupts */

/* any write to this register clears the scheduling interrupt */
#define iGLU_SCHED_CLR (iGLU_BASE + 0x0000800)		/* physical address */

/* programmable interrupt levels: sbus 1-7 and audio chip */
#define iGLU_SBUS1 (iGLU_BASE + 0x0002008)		/* physical address */
#define iGLU_SBUS2 (iGLU_BASE + 0x0002010)		/* physical address */
#define iGLU_SBUS3 (iGLU_BASE + 0x0002018)		/* physical address */
#define iGLU_SBUS4 (iGLU_BASE + 0x0002020)		/* physical address */
#define iGLU_SBUS5 (iGLU_BASE + 0x0002028)		/* physical address */
#define iGLU_SBUS6 (iGLU_BASE + 0x0002030)		/* physical address */
#define iGLU_SBUS7 (iGLU_BASE + 0x0002038)		/* physical address */
#define iGLU_AUDIO (iGLU_BASE + 0x0002040)		/* physical address */
# define SBUS_INT(V)	((V) & 0xf) 			/* program to int level V */

/* warm reset register */
#define iGLU_WRR (iGLU_BASE + 0x0003000)		/* physical address */
/* These are offsets to iGLU_WRR */
# define WRR_CLR	0x000	/* clears all warm reset signals */
# define WRR_SCSI	0x008	/* Issues reset to SCSI */
# define WRR_SBUS       0x010	/*   "      "   "  SBUS */
# define WRR_SCC	0x020	/*   "      "   "  SCC */
# define WRR_FDC	0x040	/*   "      "   "  FDC */
# define WRR_CUDP	0x080	/*   "      "   "  iCU and iDP */
# define WRR_ETHER	0x100	/*   "      "   "  Ethernet */
# define WRR_AUDIO	0x200	/*   "      "   "  Audio */
# define WRR_IMC	0x400	/*   "      "   "  iMC */

/* A write to this register address will force a system reset. */
#define iGLU_COLD (iGLU_BASE + 0x0002800)		/* physical address */

/* programmable base for iGLU */
#define iGLU_DECODE (iGLU_BASE + 0x0003808)		/* physical address */
# define DECODE_iGLU_MSK 0xf	/* upper nibble for iGLU address */

/* programmable base for i/o devices */
#define iGLU_IO_DECODE (iGLU_BASE + 0x0003800)		/* physical address */
# define DECODE_IO_MSK	0xf	/* upper nibble for I/O address */

/* profile interrupt timing register */
#define iGLU_PROF_SPEED	(iGLU_BASE + 0x0000000)		/* physical address */
	/* 1 = 51.2usec (doubles for each incremental value) */
# define PROF_SPEED(s)	((s) & 0xf)	/* set profiling speed to s */

/* A 1 enables profile interrupt and a 0 disables it */
#define iGLU_PROF_ENABLE (iGLU_BASE + 0x0000008)	/* physical address */

/* A write to this register clears the profile interrupt */
#define iGLU_PROF_CLR (iGLU_BASE + 0x00000010)		/* physical address */

/*
 * definitions for the iMC (memory controller ASIC)
 */

#define iMC_NIBBLE	7
	/* located on byte 5 of Kbus data bus */
#if defined(PREPRO) && !defined(SIMULATOR)
# define iMC_BASE	(iMC_NIBBLE << 28)+5
#else
# define iMC_BASE	(iMC_NIBBLE << 28)+1
#endif	/* PREPRO && !SIMULATOR */

#define iMC_OFFSET	0x01000000		
#define LAST_IMC_ADDR	(iMC_BASE + iMC_OFFSET + 4)	/* only two in a system */
#define iMC_MCR_OFF	0	/* offset from iMC base adddr */
# define BANKB_EN	0x08
# define BANKA_EN	0x04
# define BANKB_8M	0
# define BANKB_32M	0x02
# define BANKA_8M	0
# define BANKA_32M	0x01
#define iMC_MDR_OFF	0x08	/* offset of Memory Decode Register */
#define iMC_A32DR_OFF	0x10	/* offset of Bank A 32M Decode Register */
#define iMC_A8DR_OFF	0x18	/* offset of Bank A 8M Decode Register */
#define iMC_B32DR_OFF	0x20	/* offset of Bank B 32M Decode Register */
#define iMC_B8DR_OFF	0x28	/* offset of Bank B 8M Decode Register */
#define iMC_IODR_OFF	0x30	/* offset of I/O Decode Register */
#define iMC_MoCR_OFF	0x38	/* offset of Mode Control Register */
# define AUTO_PG_MODE	0x04	/* Auto-page mode */
# define ICACHE_MODE	0x0a	/* I-cache fill Page mode */
				/* need to set both bit3 and bit1 */
#define iMC_WSPR_OFF	0x40	/* offset of Wait State Program Register */
#define iMC_RCTR_OFF	0x48	/* offset of RAS/CAS Timing Register */
#define iMC_RPR_OFF	0x50	/* offset of RAS Precharge Register */

/*
 * definitions for the i/o devices
 */

#define IO_NIBBLE	0x8
#if defined(PREPRO) && !defined(SIMULATOR)
# define IO_BASE		(IO_NIBBLE << 28)+4
#else
# define IO_BASE		(IO_NIBBLE << 28)
#endif /* PREPRO && !SIMULATOR */

#define IO_NVRAM_ADDR	(IO_BASE + 0x0000000)
#define IO_TODCLOCK_ADDR (IO_BASE + 0x0014000)
#ifdef SIMULATOR
# define IO_UART_ADDR	(IO_BASE + 0x0008000)
#else
# define IO_UART_KEYBD	(IO_BASE + 0x00004000)
# define IO_UART_MOUSE	(IO_BASE + 0x00004010)
# define IO_UART_PORTB	(IO_BASE + 0x00008000)
# define IO_UART_PORTA	(IO_BASE + 0x00008010)
#endif /* SIMULATOR */
#define IO_FLOPPY_ADDR	(IO_BASE + 0x000C000) 
#define IO_AUDIO_ADDR	(IO_BASE + 0x0010000) 

#ifdef SIMULATOR
/* a write to this register clears the simuart interrupt */
# define IO_UART_CLEAR_INT	(IO_BASE + 0x1234500)
#endif SIMULATOR

/*
 * definitions for the memory
 */

#define MEM_NIBBLE	0xf
#define MEM_BASE	(MEM_NIBBLE << 28)

/*
 * definitions for the scsi and enthernet (actually handled by the iCU)
 */

/* SCSI/ethernet addresses */
#define SE_NIBBLE	0x4
#if defined(PREPRO) && !defined(SIMULATOR)
# define SE_BASE		(SE_NIBBLE << 28)+4
#else
# define SE_BASE		(SE_NIBBLE << 28)
#endif /* PREPRO && !SIMULATOR */

/* SCSI address register */
#define SE_SCSI_ADDR	(SE_BASE + 0x0000000)		/* physical address */

/* SCSI control register */
#define SE_SCSI_CTL	(SE_BASE + 0x0000004)		/* physical address */

/* SCSI line buffer (16 bytes) */
#define SE_SCSI_DATA0	(SE_BASE + 0x0000008)		/* physical address */
#define SE_SCSI_DATA1	(SE_BASE + 0x000000c)		/* physical address */
#define SE_SCSI_DATA2	(SE_BASE + 0x0000010)		/* physical address */
#define SE_SCSI_DATA3	(SE_BASE + 0x0000014)		/* physical address */

/* ethernet address mapping register */
#define SE_ENET_OFFSET	0x18
#define SE_ENET_ADDR	(SE_BASE + SE_ENET_OFFSET)	/* physical address */

/* ethernet control register */
#define SE_ENET_CTL	(SE_BASE + 0x000001c)		/* physical address */

/* ethernet line buffer (16 bytes) */
#define SE_ENET_DATA0	(SE_BASE + 0x0000028)		/* physical address */
#define SE_ENET_DATA1	(SE_BASE + 0x000002c)		/* physical address */
#define SE_ENET_DATA2	(SE_BASE + 0x0000034)		/* physical address */
#define SE_ENET_DATA3	(SE_BASE + 0x000003c)		/* physical address */

/* 33C93 register A0=0 */
#define SE_SCSI_REG0	(SE_BASE + 0x0000020)		/* physical address */
/* 33C93 register A0=1 */
#define SE_SCSI_REG1	(SE_BASE + 0x0000024)		/* physical address */

#if defined(PREPRO) && !defined(SIMULATOR)
# define SE_ENET_REG0	(SE_BASE + 0x00)
# define SE_ENET_REG1	(SE_BASE + 0x10)
#else
# define SE_ENET_REG0	(SE_BASE + 0x0000030)		/* physical address */
# define SE_ENET_REG1	(SE_BASE + 0x0000038)		/* physical address */
#endif /* PREPRO && !SIMULATOR */

/*
 * definitions for the iCU (control unit ASIC)
 */

#define iCU_NIBBLE	0x5
#define iCU_BASE	(iCU_NIBBLE << 28)

/* interrupt status register */
#define iCU_ISR		(iCU_BASE + 0x0000000)		/* physical address */
# define ISR_S0_DMA_SECC 0x00000001	/* Sbus Slot 0 DMA SECC */
# define ISR_S0_DMA_MECC 0x00000002 	/* Sbus Slot 0 DMA MECC */
# define ISR_S0_DMA_SERR 0x00000004	/* Sbus Slot 0 DMA Error */
# define ISR_S1_DMA_SECC 0x00000008	/* Sbus Slot 1 DMA SECC */
# define ISR_S1_DMA_MECC 0x00000010	/* Sbus Slot 1 DMA MECC */
# define ISR_S1_DMA_SERR 0x00000020	/* Sbus Slot 1 DMA Error */
# define ISR_S2_DMA_SECC 0x00000040	/* Sbus Slot 2 DMA SECC */
# define ISR_S2_DMA_MECC 0x00000080 	/* Sbus Slot 2 DMA MECC */
# define ISR_S2_DMA_SERR 0x00000100	/* Sbus Slot 2 DMA Error */
# define ISR_EN_DMA_SECC 0x00000200	/* Ethernet DMA SECC */
# define ISR_EN_DMA_MECC 0x00000400	/* Ethernet DMA MECC */
# define ISR_EN_DMA_SERR 0x00000800	/* Ethernet DMA Error */
# define ISR_SC_DMA_SECC 0x00001000	/* SCSI DMA SECC */
# define ISR_SC_DMA_MECC 0x00002000	/* SCSI DMA MECC */
# define ISR_SC_DMA_SERR 0x00004000	/* SCSI DMA Error */
# define ISR_RIO_NMI_EN  0x00008000	/* RIO NMI Enable */
# define ISR_DMA_NMI_EN  0x00010000	/* DMA NMI Enable */
# define ISR_ICUIRQ_EN   0x00020000	/* iCU IRQ Enable */
# define ISR_SECC_CNT    0x003c0000	/* SECC Count */
# define ISR_SECC_CNT_OV 0x00400000	/* SECC Counter Overflow */
# define ISR_MEMDEC_MIS  0x00800000	/* Memory Decode Miss */
# define ISR_TRAN_INVLD  0x01000000	/* Translation Invalid */
# define ISR_WIN_MISS    0x02000000	/* Translation Window Miss */
# define ISR_FAULT       0x04000000	/* KAPbus Fault */
# define ISR_S0_RIO_ERR  0x08000000	/* Sbus Slot 0 RIO Error */
# define ISR_S1_RIO_ERR  0x10000000	/* Sbus Slot 1 RIO Error */
# define ISR_S2_RIO_ERR  0x20000000	/* Sbus Slot 2 RIO Error */
# define ISR_EN_RIO_ERR  0x40000000	/* Ethernet RIO Error */
# define ISR_RETRY_TO    0x80000000	/* RIO Retry Timeout */

/* i/o decode register */
#define iCU_IO_DECODE	(iCU_BASE + 0x0000004)		/* physical address */

/* translation index register */
#define iCU_TIR		(iCU_BASE + 0x0000008)		/* physical address */

/* translation enable register */
#define iCU_TER		(iCU_BASE + 0x000000c)		/* physical address */
# define TER_ESLOT0	0x0000002	/* enable trans. for Sbus Slot 0 */
# define TER_ESLOT1	0x0000004	/* enable trans. for Sbus Slot 1 */
# define TER_ESLOT2	0x0000008	/* enable trans. for Sbus Slot 2 */
# define TER_ELAN	0x0000010	/* enable trans. for Ethernet */
# define TER_ESCSI	0x0000020	/* enable trans. for SCSI */
# define TER_IO_DISABLE	0x0000040	/* disable I/O access */
# define TER_W_COMP_DIS	0x0000080	/* disable compare of upper byte of virtual address */

/* translation window register */
#define iCU_TWR		(iCU_BASE + 0x0000010)		/* physical address */

/* translation RAM register */
#define iCU_TRR		(iCU_BASE + 0x0000014)		/* physical address */

/* configuration register */
#define iCU_CONF	(iCU_BASE + 0x0000018)		/* physical address */
# define CONF_ICACHEDIS 0x00000400	/* icache disable */
# define CONF_FROM_WREN	0x00000200	/* Flash rom write enables */
# define CONF_SLOWDMARD	0x00000100	/* slow dma reads */
# define CONF_SLOWDMAWR	0x00000080	/* slow dma writes */
# define CONF_FAC2	0x00000040	/* sets XKAS low time for iCU dma */
# define CONF_SBUS_CLK	0x00000020	/* Sbus clock
					 * 0 = 20MHz clock
					 * 1 = 25MHz clock */
# define CONF_MEMBANKS	0x00000008	/* Memory banks
					 * 0 = three or four banks
					 * 1 = one or two banks */
# define CONF_ECCEN	0x00000004	/* enable ecc */
