;----------------------------------------------------------------
; Structures
;----------------------------------------------------------------
dpb		struc
sectors_per_trk	db	?
number_of_heads	db	?
dpb		ends
hdpb		struc
		db	8 dup (?)
step_rate	db	?
hdpb		ends
;----------------------------------------------------------------
; Interupt vector space definition
;----------------------------------------------------------------
vectors		segment at 0
vector_0	dd	?
vector_1	dd	?
vector_2	dd	?
vector_3	dd	?
vector_4	dd	?
vector_5	dd	?
vector_6	dd	?
vector_7	dd	?
vector_8	dd	?
vector_9	dd	?
vector_a	dd	?
vector_b	dd	?
vector_c	dd	?
vector_d	dd	?
vector_e	dd	?
vector_f	dd	?
vector_10	dd	?
vector_11	dd	?
vector_12	dd	?
vector_13	dd	?
vector_14	dd	?
vector_15	dd	?
vector_16	dd	?
vector_17	dd	?
vector_18	dd	?
vector_19	dd	?
vector_1a	dd	?
vector_1b	dd	?
vector_1c	dd	?
vector_1d	dd	?
vector_1e	dd	?
vector_1f	dd	?
		org	033h*4
vector_33	dd	?
		org	03bh*4
vector_3b	dd	?
		org	067h*4
vector_67	dd	?
		org	0f8h*4
vector_f8	dd	?
vector_f9	dd	?
vector_fa	dd	?
vector_fb	dd	?
vector_fc	dd	?
vector_fd	dd	?
vector_fe	dd	?
vector_ff	dd	?
kludge		label	word
kludge1		label	word

		org	7c00h
ibm_boot	label	far
vectors		ends

;----------------------------------------------------------------
; Data for BIOS
;----------------------------------------------------------------

data		segment	at 40h	
ser_addr	dw	4 dup(?)
pport_addr	dw	4 dup(?)
equip_flag	dw	?
function_cmd	db	?


		org	13h
memory_size	dw	?
old_temp_char	label	byte
ibm_temp_char	db	?
nd_error_flag	db	?
		org	17h
shift_status	db	0
shift_status1	db	0
alt_input	db	0
buffer_head	dw	0
buffer_tail	dw	0

kb_buffer	dw	10h dup (0)		;buffer
kb_buffer_end	label	word
nd_sector_count	dw	?
dpb0		dpb	<,>
dpb1		dpb	<,>
dpb2		dpb	<,>
dpb3		dpb	<,>
temp		db	?		;status after fdc_int

		org	49h
crt_mode	db	?			;current mode
num_columns	db	?			;number of columns for mode
		db	?
page_size	dw	?			;page size in bytes for mode
buffer_seg	dw	?			;segment of current video buffer
cursor_posn	dw	8 dup (?)		;position for each of 8 pages
cursor_mode	dw	?			;start and stop line of cursor
cur_page	db	?			;current page
adr_6845	dw	?			;address of current video board
crt_mode_set	db	?
crt_pallette	db	?
page_seg	dw	?			;segment of current video page
temp_ax		dw	?
com_flags	db	?
com_hold	db	?
com_hold_enable	db	?
com1_int_status	db	?
com2_int_status	db	?

sector_size	dw	?		;sector size in bytes for current transfer
d_type_0	db	?		;definition of disk in each drive
d_type_1	db	?
d_type_2	db	?
d_type_3	db	?
track_0		db	?		;current track for each drive
track_1		db	?
track_2		db	?
track_3		db	?
recal_required	db	?		;bits 0-3 set to home disk head on each drive
diskette_status	db	?
drive_number	db	?
head_number	db	?
drive_track	db	?
disk_track	db	?
sector_number	db	?
num_of_sectors	db	?
disk_flags	db	?		;disk in service, op done, write status
fdc_cmd		db	?
		even
f_dma_cmd	dw	?
f_state		dw	?
f_return	dw	?
s_state		dw	?
sasi_return	dw	?
sasi_block_size	dw	?
sasi_xfer_count	dw	?
sasi_xfer_count1	dw	?
sasi_bx_temp	dw	?
sasi_es_temp	dw	?
sasi_bp_temp	dw	?
sasi_si_temp	dw	?
sasi_cmd	db	?
sasi_status	db	?
wait_flags	db	8 dup (?)
;----------------------------------------------------------------
;  Data for new function dispatcher
;----------------------------------------------------------------
device_numbers	dw	20h dup (?)	;high byte is input driver# for the channel
					;low  byte is output driver# if bit 8 is set
					;the driver is external
external_limit	db	?		;number of external drivers
function_ptr	dw	?


spb		struc
		db	10h dup (?)
head		db	?
tail		db	?
spb		ends

		org	0eeh		;locations for old monitor
memsize		dw	?
duout		db	?
duimr		db	?
settle		db	? 		;ADDED BY JONATHAN OFFSET 0F2H

	
dskseg		dw	?
dskmem		dw	?
dsknum		db	?
dsktrack	dw	?
dsksector	db	?
;----------------------------------------------------------------
; more keyboard data
;----------------------------------------------------------------
port_status	db	?
byte_flag	db	?
key_int_enable	db	?


reset_location	dw	?		;set to 1234 for warm boot

port1_buf	db	10h dup (?)
port1_head	db	0
port1_tail	db	0
port2_buf	db	10h dup (?)
port2_head	db	?
port2_tail	db	?

port3_buf	db	10h dup (?)
port3_head	db	?
port3_tail	db	?

port4_buf	db	10h dup (?)
port4_head	db	?
port4_tail	db	?
day		dw	?
day1		dw	?		;for ibm tod call
min		db	?
hours		db	?
hundredth	db	?
seconds		db	?
;----------------------------------------------------------------
; terminal emulator data
;----------------------------------------------------------------
vid_temp	db	?
esc_flag	db	?

;----------------------------------------------------------------
;   Data for new disk io
;----------------------------------------------------------------
am_buffer	label	byte
am_track	db	?		;address mark buffer for disk io
am_side		db	?
am_sector	db	?
am_size		db	?
am_crc		db	2 dup (?)
hdpb0		hdpb	<>
hdpb1		hdpb	<>
hd_command	db	6 dup (?)
hd_last_drive	db	?
hd_ax_temp	dw	?
hd_bx_temp	dw	?
hd_cx_temp	dw	?
hd_cx_temp1	dw	?
hd_dx_temp	dw	?
hd_si_temp	dw	?
hd_es_temp	dw	?
		even
hdisk_time_out	dw	?
hdisk_time_out1	dw	?
prn_countl	dw	?
prn_counth	dw	?

axsave		dw	?
bxsave		dw	?
cxsave		dw	?
dxsave		dw	?
bpsave		dw	?
sisave		dw	?
disave		dw	?
spsave		dw	?
cssave		dw	?
dssave		dw	?
sssave		dw	?
essave		dw	?
ipsave		dw	?
fsave		dw	?
word1		dw	?
word2		dw	?
seg1		dw	?
seg2		dw	?
monsp		dw	?
mem1		dw	?
mem2		dw	?
mem3		dw	?
port1		dw	?
break1		dw	3 dup (?)
break2		dw	3 dup (?)
bits		db	?
seccnt		db	?
trksize		db	?
linbuf	       	db	50h dup (?)

motor_count	dw	?		;time out value for motor
select_count	dw	?		;value for select
disk_time_out	dw	?
motor_count1	dw	?		;current time out counts
select_count1	dw	?		;this was moved from 40:8
disk_time_out1	dw	?
external_table	dd	?		;pointer to table of pointers to drivers


tty_on		db	?		;some bytes needed by jonathan
printer_stat	db	?		
spin_up		dw	?		;word count
duart_base	dw	?		;for int 14h
key_status2	db	?		;bit 1 ctrl num
ibm_timer_cnt	db	?
bits2		db	?

radius		dw	?		;three variables for 8087
		dw	?		;check out
scale		dw	?
		dw	?
area		dw	?
		dw	?
data		ends

;----------------------------------------------------------------
;  Stack for initialization
;----------------------------------------------------------------
stack		segment at 064h
		db	0100h dup (?)
stack_top	label	word
stack		ends
