/*	@(#)telecom.h	20.1	*/

/*******************************************************/
/*     INTERFACE              MAD         :            */
/*                                                     */
/*        METHODE  D'ACCES  DISTRIBUEE                 */
/*******************************************************/

/*------------------------------*/
/* Type des commandes des ioctl */
/*------------------------------*/

#define  REQUETE        1
#define  RECEPTION      2
#define  REPONSE        3
#define  ACTISER        4
#define  DESACTISER     5


/*---------------*/
/* Mode sur open */
/*---------------*/

#define GLOBAL          0x8000
#define LOCAL		0


/*-----------------------*/
/* Move de l'UCB reponse */
/*-----------------------*/

#define MOVE            1
#define NON_MOVE        0


/*--------------------*/
/* Type de l'UCB recu */
/*--------------------*/

#define ICB_IND         0
#define UCB_REQ         2
#define UCB_REP         3


/*--------------------------------------------------------*/
/* code fonction des UCB speciaux de chargement de tables */
/*--------------------------------------------------------*/

#define RQ_CHARGE_ROUT 201      /* chargement table de routage (SC7)*/
#define RQ_LIRE_ROUT   202      /* lecture table de routage   (SC7) */

#define RQ_CHARGE_SERV 203      /* chargement table de service      */
#define RQ_LIRE_SERV   204      /* lecture table de service         */
#define RQ_CHARGE_SITE 207      /* chargement d'une table de site   */
#define RQ_LIRE_SITE   208      /* lecture d'une table de site      */


/*---------------------------------*/
/* Erreurs retournees sur un ioctl */
/*---------------------------------*/

#define  ER_CODREQINV            0x30  /* code requete inconnu                */
#define  ER_DEVOCCUPE            0x31  /* device occupe (deja ouvert)         */
#define  ER_LGINFOINV            0x32  /* longueur champ info impaire         */
#define  ER_UN_INC               0x33  /* unite destinataire inconnue	      */
#define  ER_UN_NON               0x34  /* unite destinataire non init.        */
#define  ER_SC7INAC              0x35  /* SC7 ou SC9 inaccessible             */
#define  ER_SERV_INC             0x36  /* service inconnu                     */
#define  ER_SERV_NON_ACTIV       0x37  /* service non actif                   */
#define  ER_DON_TRONQ            0x38  /* donnees tronquees                   */
#define	 ER_TYPUCB_INC           0x39  /* type d'UCB recu inconnu             */
#define  ER_UTI_INC              0x3a  /* utilisateur inconnu		      */
#define  ER_SERV_ACTIF           0x3c  /* service deja actif                  */
#define  ER_TAB_SAT              0x3d  /* tables systeme saturees             */
#define  ER_SERV_INT             0x3e  /* service interdit                    */
#define  ER_ADR_IMP              0x3f  /* adresse UCB impaire                 */
#define	 ER_SITE_INA             0x40  /* site inaccessible		      */
#define	 ER_FERM_RESEAU          0x41  /* fermeture du reseau		      */
#define  ER_SERV_CLOS            0x42  /* fermeture du service		      */
#define  ER_TYPBLOC_INC          0x43  /* type de bloc inconnu		      */
#define  ER_SC_HS                0x44  /* systeme de communication HS         */
#define  ER_CMDINV               0x47  /* code commande ioctl inconnu         */
#define  ER_GSME_NON_INIT        0x48  /* gestionnaire memoire non initialise */
#define  ER_SIGNAL               0x49  /* appel syst. interrompu par  signal  */
#define  ER_ADRINV               0x4a  /* adresse invalide                    */
#define  ER_LGTAMPUE             0x4b  /* tampon ME trop petit                */
#define  ER_MODE_MOVE            0x4c  /* mode inconnu                        */
#define  ER_NINFO                0x4d  /* erreur nbinfo                       */
#define  ER_NDESCIN              0x4e  /* erreur nombre de descripteurs in    */
#define  ER_NDESCOUT             0x4f  /* erreur nombre de descripteurs out   */
#define  ER_SITE_OUVERT          0x50  /* site deja ouvert                    */

#define  ER_INDEXCL              0x51
#define  ER_CTOS_SERV_INC        0x52
#define  ER_CTOS_SERV_ACTIF      0x53
#define  ER_CTOS_SERV_NON_ACTIF  0x54
#define  ER_TABUSER_SAT          0x55
#define  ER_USER_UNKNOWN         0x56
#define  ER_MAXREQREC            0x57
#define  ER_MAXREQENV            0x58
#define  ER_INDEXSE              0x59
#define  ER_OPEN_INCORRECT       0x5a
#define  ER_DEV_NOOPEN           0x5b
#define  ER_DEV_NOCTOS           0x5c
#define  ER_RECEP_LG             0x5d
#define  ER_TYPRQB_INC           0x5e


/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
/*                                                           */
/* si l'erreur n'appartient pas a cette liste                */
/*                                                           */
/*   consulter la liste des erreurs du systeme correspondant */
/*                                                           */
/*            ( R O S        ou       U N I X )              */
/*                                                           */
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/





/*--------------------------------------------------------------------------*/
/* structure d'un descripteur de zone parametre d'entree ou sortie d'un UCB */
/* ------------------------------------------------------------------------ */

struct ucb_descr
{
       char          *adrdata ;           /* adresse des donnees ou du descr. */
       unsigned short lgdata ;            /* longueur des donnees             */
       unsigned short depldata ;          /* deplacement du debut des donnees */
};

/*------------------------------------------------------------*/
/* structure de la partie fixe (en-tete) d'un UCB utilisateur */
/* ---------------------------------------------------------- */

struct ucb_util
{
       char           u ;              /* 'U'                                */
       char           v ;              /* numero de version                  */
       unsigned short nbinfo ;         /* longueur du champ facultatif 'info'*/
       unsigned char  nbdescout ;      /* nbre de descripteurs en sortie     */
       unsigned char  nbdescin ;       /*  "   "      "        "  entree     */
       short          res1 ;
       int	      res2 ;
       int	      res3 ;
       char	      res4 ;
       unsigned char  un_dest ;        /* unite destinataire                 */
       short	      res5 ;
       unsigned char  un_prl_dest ;    /* UT passerelle si syst. distant # 0 */
       unsigned char  sys_dest ;       /* systeme destinataire (0 si local)  */
       short	      res6 ;
       short	      res7 ;
       unsigned short codreq ;         /* code requete                       */
       int 	      codret ;         /* compte-rendu de la requete         */
};

/*-------------------------------------------------*/
/*  structure interface IOCTL REQUETE              */
/*-------------------------------------------------*/
       

struct madrequete
{
        struct ucb_util *adrucb;      /* adresse en zone util. ucb a emettre */
        int              move;        /* UCB de reponse move                 */
};

/*-------------------------------------------------*/
/*  structure interface IOCTL RECEPTION            */
/*-------------------------------------------------*/

struct madreception
{
        int              delai;       /* attente ou non selon delai # ou = 0 */
        struct ucb_util *adrucb;      /* adresse en zone util. ucb a emettre */
                                      /* ou adresse du tampon en reception   */
        int              lgucb;       /* longueur du tampon utilisateur      */
        int              type_ucb;    /* type d'UCB recu, requete ou reponse */
};

/*-------------------------------------------------*/
/*  structure interface IOCTL REPONSE              */
/*-------------------------------------------------*/

struct madreponse
{
        struct ucb_util *adrucb;      /* adresse de l'UCB de reponse */
};

/*---------------------------------------------------------*/
/* structure  pour  chargement  et  lecture  de  service   */
/*---------------------------------------------------------*/

struct tab_service
{
        unsigned short service ;      /* numero de service a charger */
        unsigned short cod_req_min ;  /* numero de requete min       */
        unsigned short cod_req_max ;  /* numero de requete max       */
        unsigned short activite ;     /* indicateur d'activite du    */
                                      /* service (=0 au chargement)  */
};

/*---------------------------------------------------------*/
/* structure  pour  chargement  et  lecture  de  site      */
/*---------------------------------------------------------*/

struct  table_site
{
     char              stcl ;      /* classe de service 0,2,3 ou 4   */
     char              staltcl ;   /* classe alternee 0,2,3 ou 4     */
     short             stexp ;     /* flot express 1:oui   0:non     */
     short             stctrl ;    /* controle de flot 1:oui  0:non  */
     short             stcrdt ;    /* credit   1 a 15                */
     short             stltpdu ;   /* longueur tpdu (128 a 2048)     */
                                   /* doit etre une puissance de 2   */
     short             stcheck ;   /* champ de controle 1:oui        */
                                   /* uniquement si stcl = 4         */
     short             stlnsdu ;   /* longueur nsdu : >= stltpdu     */
     short             stlnpdu ;   /* longueur npdu :                */
                                   /* transpac : 128  RLE3 : 1500    */
     char              stwi ;      /* fenetre reception reseau       */
     char              stwo ;      /* fenetre emission reseau        */
     char              stypres ;   /* type de reseau :               */
                                   /* transpac : 1    RLE3 : 2       */
     char              stcnx ;     /* type de connexion reseau :     */
                                   /* avec cnx : 0   sans cnx : 1    */
     unsigned short    ladrloc ;   /* lg. adresse reseau locale :    */
                                   /* transpac : lg en demi octet    */
                                   /* RLE3 : lg en octet             */
     unsigned char     adrloc[8] ; /* adresse reseau locale          */
     unsigned short    ladrdis ;   /* ld et adr reseau distante      */
     unsigned char     adrdis[8] ;
     unsigned short    lfac ;      /* longueur facilites transpac    */
     unsigned char     facil[10] ; /* facilites transpac             */

/*--------------------------------------------------------*/
/*                                                        */
/* ajouter les parametres TSAP appelant et TSAP appele.   */
/* Chaque parametre est de la forme :                     */
/*  - un octet (8 bits) contenant la longueur L du TSAP   */
/*  - un champ TSAP de L octets                           */
/*                                                        */
/*--------------------------------------------------------*/

} ;



/*******************************************************/
/*     INTERFACE              ASU      :               */
/*                                                     */
/*       ACCES  SERVICE  UFT                           */
/*******************************************************/



/*----------------------*/
/* code requetes        */
/*----------------------*/

#define ASU_OPEN  177 
#define ASU_CLOS  178 
#define ASU_TRAN  179
#define ASU_INTR  180 
#define ASU_CREA  181 
#define ASU_DETR  182 
#define ASU_INFO  183 
#define ASU_IDENT 184 
#define ASU_ABRT  185 

/*----------------------------------*/
/*codes retour de l'ucb utilisateur */
/*----------------------------------*/

/*--------------------*/
/*codes de severite 0 */
/*--------------------*/

#define ASUOK		 0x10000000	/*pas d' erreurs		     */
#define ASUdetfich	 0x10000004     /*refus de suppression du distant    */
#define ASUcrefich	 0x10000002     /*refus de creation du distant	     */
#define ASUattfich	 0x10000003     /*refus demande attributs du distant */
#define ASUtronq	 0x10000001     /*donnees tronquees		     */

/*--------------------*/
/*codes de severite 1 */
/*--------------------*/

#define ASUlogin	 0x10010009 	/* login local incorrect              */
#define ASUdescout	 0x10010010     /*nbr descripteurs en sortie incorrect*/
#define ASUdescin	 0x10010011     /*nbr descripteurs en entree incorrect*/
#define ASUctx  	 0x10010012     /*ident de connexion incorrect        */
#define ASUblk		 0x10010013     /*nom de bloc inconnu		      */
#define ASUinfo		 0x10010014     /*champ info doit etre a zero         */
#define ASUacb		 0x10010015     /*syntaxe du acb incorrecte           */
#define ASUlgacb	 0x10010016     /*longueur pour acb incorrecte	      */
#define ASUlgadtran	 0x10010017     /*lg adressage transport incorrect    */
#define ASUrecs		 0x10010018     /* taille record invalide             */
#define ASUattrib	 0x10010019	/* attributs incorrect                */
#define ASUlog		 0x1001001a	/* lg struct identification incorrect */
#define ASUident	 0x1001001b	/* ident de transfert incorrect       */
#define ASUoldident	 0x1001001c	/* ancien ident de transfert incorrect*/
#define ASUconfail 	 0x1001001d	/* connexion echoue                   */
#define ASUnbmaxtran	 0x1001001e	/* trop de transfert en cours         */
#define ASUlgdata	 0x1001001f	/* longueur data deconnexion > 512    */

/*--------------------------------*/
/*services non geres sur le canal */
/*--------------------------------*/

#define ASUerrservcr	 0x10010020     /*service creation non permis	     */
#define ASUerrservsup	 0x10010021     /*service suppression non permis     */
#define ASUerrservatt	 0x10010022     /*serv demande attributs non permis  */
#define ASUerrservred	 0x10010023     /*service redemarrage non permis     */

/*-----------------------*/
/* erreurs de parametres */
/*-----------------------*/

#define ASUparam	 0x10010030     /*param incorrect dans le fcb fourni  */
#define ASUtyp		 0x10010031     /*type d'acces incorrect              */
#define ASUtypfic	 0x10010032     /*type de fichier incorrect           */
#define ASUnum    	 0x10010033     /*numero de redemmarrage incorrect    */
#define ASUsusp		 0x10010034     /*param interrup transfert incorrect  */
#define ASUfileid	 0x10010035     /*file_id inexistant		      */
#define ASUlgfileid	 0x10010036     /*longueur file_id > max	      */
#define ASUcreat	 0x10010037	/* param controle creation incorrect  */
#define ASUtrans	 0x10010038     /*erreur lors du transfert            */
#define ASUinterrup	 0x10010039	/* interruption de transfert          */
#define ASUabtran 	 0x1001003a     /*abandon de transfert                */
#define ASUcodinc	 0x1001003b	/* code inconnu                       */
#define ASUlginv	 0x1001003c	/* taille ucb + descripteur trop grand*/
#define ASUfilseq	 0x1001003d	/* file seq number incorrect          */
#define ASUcomp 	 0x0100103e	/* parametre compactage incorrect     */

/*---------------*/
/* erreur d'etat */
/*---------------*/

#define ASUetat   	  0x10010040     /*requete incompatible avec l'etat   */

/*----------------*/
/*codes d'abandon */
/*----------------*/

#define ASUprot    	 0x10010050     /*erreur protocole                    */
#define ASUab		 0x10010051     /*abandon en cours                    */

/*--------------------*/
/*codes de severite 2 */
/*--------------------*/

#define ASUmad		 0x10020060     /*ouverture  driver mad impossible    */
#define ASUipc		 0x10020061	/* creation ipc impossible            */
#define ASUficlog	 0x10020062	/* pb a l'ouverture du fichier log    */
#define ASUactiser	 0x10020063	/* err lors de l'activation de service*/
#define ASUnmaxctx	 0x10020064	/* trop de connexion en cours         */
#define ASUfils		 0x10020065	/* pb lors de la creation d'un        */
					/* fils (voir votre ingenieur systeme)*/


/*-------------------------*/
/* structure acb           */
/*-------------------------*/

struct tacb {
                char     nom[3]  ;
                char     version  ;
                char    *idsys   ;
                char    *iduser  ;
		unsigned int codret ;          /* code retour                 */
                short    nummach ;             /* numero de machine           */
		short    cons ;                /* nom de la console           */
		short    uid ;                 /* uid                         */
		short    gid ;                 /* gid                         */
		long     recs ;	               /* taille enregsitrement       */
		char 	 creatc ;	       /* controle creation           */
		char 	 acct ;		       /* type d'acces                */
		char 	 datac ;               /* type de codage              */
		char 	 subset ;	       /* subset                      */
		char 	 datacomp ;	       /* demande de compactage       */
		char 	 tcc ;		       /* code d'arret de transfert   */
		char 	 file_organ ;	       /* file organisation           */
		char 	 attrib ;	       /* attributs demandes          */
		long 	 restart_rank ;	       /* rang de redemmarrage        */
		char 	 redem ;               /* demande de redemmarrage     */
		char 	 alloc_size_unit;      /* taille des unites de taille */
		short	 file_seq_num ;	       /* file sequence number        */
		long	 cur_alloc_size ;      /* taille courante du fichier  */
		long	 inc_alloc_size ;      /* increment de taille         */
		long 	 max_alloc_size ;      /* taille max du fichier       */
		char	 creat_dat_time[12] ;
		char	 last_ac_dat_time[12] ;
		char 	 last_mo_dat_time[12] ;
		char	 exp_dat_time[12] ;
		char	 transoldid [20] ;     /* old ident de transfert      */
		short	 lgtransoldid ;
		char 	 transid [20] ;	       /* ident de transfert          */
		short 	 lgtransid ;
                 } ;


 struct tident       {
			char filler[18] ;
			char entete[6] ;
			char billing [12] ; 
			char login[12] ; 
			char project [12] ;
			char password [12] ;
			} ;





/*******************************************************/
/*     INTERFACE              APU          :           */
/*                                                     */
/*       ACCES  PROTOCOLE  UFT                         */
/*******************************************************/




/*------------------------*/
/*  requetes utilisateur  */ 
/*------------------------*/

#define APU_OPEN	 		113
#define APU_ACPT	 		114
#define APU_RACPT		 	115
#define APU_CLOS			116
#define APU_RCLO			117
#define APU_ABRT			118
#define APU_DATA			119
#define APU_FTRA			120
#define APU_ATTE		        121
#define APU_CREA		        122
#define APU_RCREA			123
#define APU_DETR		        124
#define APU_RDETR			125
#define APU_INFO			126
#define APU_RINFO			127
#define APU_ASSG			128
#define APU_RASSG			129
#define APU_DASSG			130
#define APU_RDASSG			131
#define APU_OPFI			132
#define APU_ROPFI			133
#define APU_CLFI			134
#define APU_RCLFI			135

/*----------------------*/
/* code signaux         */
/*----------------------*/

#define APU_SIGCREA		101
#define APU_SIGDEL		102
#define APU_SIGASSGN	        103
#define APU_SIGDASSGN	        104
#define APU_SIGOPEN		105
#define APU_SIGFERM		106
#define APU_SIGINTERR	        107
#define APU_SIGDATA		108
#define APU_SIGDEMDATA	        109
#define APU_SIGABANDON	        110
#define APU_SIGDEMCLCANAL	111
#define APU_SIGSP  		112
#define APU_SIGATTR		113


/*--------------------*/
/*codes de severite 0 */
/*--------------------*/

#define APU_OK		 0x06000000	/*pas d' erreurs		     */
#define APUdetfich	 0x06000009     /*refus de suppression du distant    */
#define APUcrefich	 0x06000002     /*refus de creation du distant	     */
#define APUattfich	 0x06000003     /*refus demande attributs du distant */
#define APUassfich	 0x06000004     /*refus d'assignation du distant     */
#define APUouvfich	 0x06000005     /*refus d'ouverture du distant	     */
#define APUdeassfich	 0x06000006     /*refus de deassignation du distant  */	
#define APUfermfich	 0x06000007     /*refus de fermeture du distant	     */
#define APUtransf	 0x06000008     /*err transfert detectee par distant */
#define APUrefferm	 0x0600000a	/* refus de fermeture canal          */
#define APUtronq	 0x06000001     /*donnees tronquees		     */

/*--------------------*/
/*codes de severite 1 */
/*--------------------*/

#define APUdescout	 0x06010010     /*nbr descripteurs en sortie incorrect*/
#define APUdescin	 0x06010011     /*nbr descripteurs en entree incorrect*/
#define APUnocan	 0x06010012     /*numero de canal non fourni	      */
#define APUblk		 0x06010013     /*nom de bloc inconnu		      */
#define APUinfo		 0x06010014     /*champ info doit etre a zero         */
#define APUfcb		 0x06010015     /*syntaxe du fcb incorrecte           */
#define APUlgfcb	 0x06010016     /*longueur pour fcb incorrecte	      */
#define APUlgadtran	 0x06010017     /*lg adressage transport incorrect    */
#define APUrecs		 0x06010018     /* taille record invalide             */
#define APUattrib	 0x06010019	/* attributs incorrect                */
#define APUdat		 0x0601001a	/* structure date incorrect           */

/*--------------------------------*/
/*services non geres sur le canal */
/*--------------------------------*/

#define APUservcr	 0x06010020     /*service creation non permis	      */
#define APUservsup	 0x06010021     /*service suppression non permis      */
#define APUservatt	 0x06010022     /*serv demande attributs non permis   */
#define APUservred	 0x06010023     /*service redemarrage non permis      */

/*-----------------------*/
/* erreurs de parametres */
/*-----------------------*/

#define APUparam	 0x06010030     /*param incorrect dans le fcb fourni  */
#define APUdonnees	 0x06010031     /*donnees inexistantes en emission    */
#define APUlgdata	 0x06010032     /*longueur des donnees > max	      */
#define APUlgemiss	 0x06010033     /*longueur de l'enregistrement <>     */
                                        /* de celle negociee auparavant       */
#define APUlgrecept	 0x06010034     /*longueur des donnees en reception   */
                                        /*  incorrect                         */
#define APUfileid	 0x06010035     /*file_id inexistant		      */
#define APUlgfileid	 0x06010036     /*longueur file_id > max	      */
#define APUlgtr		 0x06010037	/* longueur ident transfert incorrect */
#define APUtrid		 0x06010038     /*transfer_id non fourni	      */
#define APUlgrest	 0x06010039	/*lg ident redemmarrage incorrect     */
#define APUrest		 0x0601003a     /*restarted_transfer non fourni	      */
#define APUretfcb        0x0601003b     /*code retour fcb inconnu             */

/*---------------*/
/* erreur d'etat */
/*---------------*/

#define APUreqetat	 0x06010040     /*requete incompatible avec l'etat    */
#define APUreq		 0x06010041     /*requete non permise		      */
#define APUconnect	 0x06010042     /*refus de connexion du distant	      */
#define APUferm		 0x06010043     /*fermeture en cours		      */
#define APUintr 	0x06010046	/*interruption par le server          */

/*----------------*/
/*codes d'abandon */
/*----------------*/

#define APUsession	 0x06010050     /*abandon session ou erreur detectee  */
			                /*par la session entrainant  abandon  */
#define APUprot		 0x06010051     /*erreur protocole distant entrainant */
				        /*un abandon			      */
#define APUaband	 0x06010052     /*abandon en cours                    */

/*--------------------*/
/*codes de severite 2 */
/*--------------------*/

#define APUctx		 0x06020060     /*plus de contexte ftp		      */

/*------------------------------------------*/
/*codes utilises pour le code retour du fcb */
/*------------------------------------------*/		
                         
/*-------------------------------------------------*/
/* erreurs de parametres dans un message protocole */ 
/*-------------------------------------------------*/

#define APUmispar        0x01000014     /*parametre manquant                 */
#define APUinvpar        0x01000015     /*valeur de parametre invalide       */
#define APUincpar        0x01000016     /*valeur de parametre incorrecte     */
#define APUunkpar        0x00000018     /*parametre inconnu                  */
#define APUseqpar        0x01000019     /*parametre hors sequence            */
#define APUsuppar        0x0100001a     /*valeur non supportee               */

/*-------------------------------------------*/
/*codes d'abandon autres que ceux ci_dessous */
/*-------------------------------------------*/

#define APUprneg	 8           /*profil de negociation recu incorrect  */

/*-----------------------------------------------------------*/
/*codes d'abandon utilises pour la requete d'abandon session */
/*-----------------------------------------------------------*/

    
#define abshutdown                1     /*immediate shutdown                 */ 
#define abunsupmes                2     /*unsupported_message                */
#define abmessseq                 3     /*message out of sequence            */
#define abmescont                 4     /*illegal message contents           */
#define abillegjet                5     /*illegal data token usage           */
#define abmesssess                6     /*unsupported session usage          */
#define abtime_out                7     /*time out                           */

/*--------------------------------------------*/
/*codes normalises pour le code retour du fcb */
/*--------------------------------------------*/

#define APUfcbnoraison		  0x06010000
#define APUfcbmispar1   	  0x06010001
#define APUfcbinvpar1		  0x06010002
#define APUfcbincpar1		  0x06010003
#define APUfcbduppar1		  0x06010004
#define APUfcbunkpar1		  0x06010005
#define APUfcbseqpar1		  0x06010006
#define APUfcbsuppar1		  0x06010007
#define APUfcbaccperm		  0x06010008
#define APUfcbnofile		  0x06010009
#define APUfcbfilebusy		  0x0601000a
#define APUfcbnodevice		  0x0601000b
#define APUfcbsyntax		  0x0601000c
#define APUfcbioerror		  0x0601000d
#define APUfcbsystem		  0x0601000e
#define APUfcbunschar		  0x0601000f
#define APUfcbnomemory		  0x06010010
#define APUfcbnego		  0x06010011
#define APUfcbcantopen		  0x06010012
#define APUfcbcomp		  0x06010013
#define APUfcbinvchar		  0x06010014
#define APUfcbabort		  0x06010015
#define APUfcbnoack		  0x06010016
#define APUfcbtranserr		  0x06010017
#define APUfcbspace		  0x06010018
#define APUfcbrecordsize	  0x06010019
#define APUfcbnumrec		  0x0601001a
#define APUfcbkey		  0x0601001b
#define APUfcbdupkey		  0x0601001c
#define APUfcbclose		  0x0601001d
#define APUfcbwexist		  0x0601001e
#define APUfcbexist		  0x0601001f
#define APUfcbunsspace		  0x06010020
#define APUfcbunswchar		  0x06010021
#define APUfcbwfileinex		  0x06010022 
#define APUfcbshutdown            0x06010050    /*immediate shutdown	    */ 
#define APUfcbunsupmes            0x06010051    /*unsupported_message	    */
#define APUfcbmessseq             0x06010052    /*message out of sequence   */
#define APUfcbmescont             0x06010053    /*illegal message contents  */
#define APUfcbillegjet            0x06010054    /*illegal data token usage  */
#define APUfcbmesssess            0x06010055    /*unsupported session usage */





/*-------------------------*/
/* structure   fcb         */
/*-------------------------*/
  	
typedef struct  {
		char yy1 ;
		char yy2 ;
		char mm1 ;
		char mm2 ;
		char dd1 ;
		char dd2 ;
		char hh1 ;
		char hh2 ;
		char mn1 ;
		char mn2 ;
		char ss1 ;
		char ss2 ;
      		}     date ;  

  typedef struct   tfcb     {
	char		name[3] ;
	char		version ;
	unsigned int    idsys  ;
	unsigned int	iduser ;
	unsigned short	signal ;
	unsigned short	indic ;
	unsigned int	codret ;
	unsigned int	recs ;
	unsigned char	creatc ;
	unsigned char	acct ;
	unsigned char	datac ;
	unsigned char	subset ;
	unsigned char	datacomp ;
	unsigned char   tcc ;
	unsigned char 	file_organ ;
	unsigned char	desired_attr ;
	int		restart_rank ;
	unsigned char	redem ;
	unsigned char	alloc_size_unit ;
	short        	file_seq_num ;
	unsigned int	cur_alloc_size ;
	unsigned int    inc_alloc_size ;
	unsigned int	max_alloc_size ;
	date            creat_date_time ;
	date    	last_ac_date_time ;
	date    	last_mo_date_time ;
	date    	exp_date_time ;
	 } ;





/*******************************************************/
/*     INTERFACE              SESSION                  */
/*                                                     */
/*       ACCES  METHODE D'ACCES SESSION                */
/*******************************************************/



/*----------------------*/
/* code requete session */
/*----------------------*/


#define SES_OPEN  65 
#define SES_ACPT  66 
#define SES_OPNO  67 
#define SES_OPNN  68 
#define SES_CLOS  69 
#define SES_RCLO  70 
#define SES_ABRT  71 
#define SES_SEND  72 
#define SES_RECE  73 
#define SES_SENX  74  
#define SES_SENT  75  
#define SES_ERRO  76  
#define SES_GIVE  77  
#define SES_PLEA  78  
#define SES_MARK  79  
#define SES_RMRK  80  
#define SES_RESY  81  
#define SES_RRES  82  
#define SES_SACT  83  
#define SES_RACT  84  
#define SES_FACT  85  
#define SES_CFAC  86  
#define SES_IACT  87  
#define SES_RIAC  88  
#define SES_DACT  89 
#define SES_RDAC  90  
#define SES_CAPA  91  
#define SES_RCAP  92  
#define SES_ETAT  93  
#define SES_STAT  94  
#define SES_SIGN  95  
#define SES_TSIG  96  

/*---------------------------------*/
/*  definition des signaux session */
/*---------------------------------*/

#define SES_SIGCLOS  5 
#define SES_SIGABRT  7 
#define SES_SIGDATA  8 
#define SES_SIGSENX  10  
#define SES_SIGSENT  11  
#define SES_SIGERRO  12  
#define SES_SIGGIVE  13  
#define SES_SIGPLEA  14  
#define SES_SIGMARK  15  
#define SES_SIGRMRK  16  
#define SES_SIGRESY  17  
#define SES_SIGSACT  19  
#define SES_SIGRACT  20  
#define SES_SIGFACT  21  
#define SES_SIGIACT  23  
#define SES_SIGDACT  25 
#define SES_SIGCAPA  27  

/*---------------*/
/* code d'erreur */
/*---------------*/


#define SES_OK 	 0x56000000	/* normal                              */
#define SEStron  0x56000001    	/* donnees tronquees                   */
#define SESinc 	 0x56010009   	/* requete non connu du service        */
#define SESucb 	 0x5601000a   	/* nombre de descripteur erronnes      */
#define SESbat   0x5601000b 	/* taille structure erronnee           */
#define SESscb 	 0x5601000c     /* scb incorrect                       */
#define SESinex  0x5601000d   	/* numero de session inexistant        */
#define SESrqid  0x5601000f   	/* requete de meme type en cours       */
#define SESdsa 	 0x5601001a    	/* controle raccordement dsa incorrect */
#define SESstid  0x5601001d   	/* controle stid incorrect             */





#define SEStronc       0x05000001    /* DONNEES TRONQUEES                    */
#define SEScapa        0x05010003    /* SERVICE CAPABILITE NON PERMIS        */ 
#define SEStyped       0x05010004    /* SERVICE DONNEES TYPEES NON PERMIS    */ 
#define SESsermrkb     0x05010005    /* SERVICE MARQUE MINEURE NON PERMIS    */ 
#define SESsermrkd     0x05010006    /* SERVICE MARQUE MAJEURE NON PERMIS    */ 
#define SESserrs       0x05010007    /* SERVICE RESYNCHRO NON PERMIS         */ 
#define SESserit       0x05010008    /* SERVICE MESSAGE EXPRESS NON PERMIS   */ 
#define SESsertok      0x05010009    /* SERVICE GESTION TOK_ NON PERMIS      */ 
#define SESsererr      0x0501000A    /* SERVICE ERREUR NON PERMIS            */ 
#define SESsernf       0x0501000B    /* SERVICE FERMETURE NEGOCIE NON PERMIS */ 
 /*  */ 
 /*  */ 
#define SESrefclo      0x05010013    /* REFUS DE DECONNEXION PAR DISTANT     */
#define SESoption      0x05010014    /* OPTION NON  PERMISE                  */ 
#define SESlgappel     0x05010015    /* LONGUEUR DONNEES APPEL INCORRECTE    */ 
#define SESsubset      0x05010016    /* SUBSET NON GERE                      */ 
#define SESprofneg     0x05010017    /* STRUC PROFIL NEGOTIATION INCORRECT   */ 
#define SESproftrp     0x05010018    /* STRUCT PROFIL TRANSPORT INCORRECT    */ 
#define SESprofadd     0x05010019    /* STRUCT PROFIL address INCORRECTE     */ 
#define SESnummrk      0x0501001D    /* NUMERO DE MARQUE INCORRECT           */ 
#define SESraison      0x0501001E    /* CODE RAISON INCONNU                  */ 
#define SESferactiv    0x05010020    /* FERMETURE ACTIVITE EN COURS          */ 
#define SESconcat      0x05010021    /* CONCATENATION NON PERMISE            */ 
#define SEStyprs       0x05010022    /* TYPE DE RESYNCHRO INCORRECTE         */ 
#define SEStymrk       0x05010023    /* TYPE DE MARQUE INCORRECT             */ 
 /*  */ 
 /*  */ 
#define SESnomid        0x05010032   /* NOM IDENTIQUE EN COURS               */ 
#define SESetat         0x05010033   /* INCOMPATIBLE AVEC L  ETAT            */ 
#define SESturn         0x05010034   /* INCOMPATIBLE  TURN                   */ 
#define SEStoken        0x05010035   /* INCOMPATIBLE TOK_                    */ 
#define SESlg           0x05010036   /* LONGUEUR INCORRECTE                  */ 
#define SESdt           0x05010037   /* DON OU DEMANDE TOK_ IMPOSSIBLE       */ 
#define SESidses        0x05010038   /* IDENTIFICATION SESSION INCORRECTE    */ 
#define SESreq          0x05010039   /* REQUETE NON PERMISE                  */ 
#define SESclos         0x0500003A   /* CLOSE EN COURS                       */ 
#define SESab           0x0501003B   /* ABORT EN COURS                       */ 
#define SESsync         0x0501003C   /* RESYNCHRO EN COURS                   */ 
#define SESdem          0x0501003D   /* REQUETE IDENTIQUE EN COURS           */ 
#define SESto           0x0501003E   /* ERREUR SUR TIME OUT                  */ 
#define SESmrkd         0x0501003F   /* MARQUE D EN COURS                    */ 
#define SESexcept       0x05010040   /* ARRIVEE MESSAGE EXCEPTION            */
#define SESenclo        0x05010041   /* INCOMPATIBLE ENCLOSURE               */ 
#define SESnonsig       0x05010042   /* PAS DE DONNES EN QUARANTAINE         */ 
#define SESrefus        0x05010043   /* REFUS DE CONNEXION                   */ 
#define SEStrans        0x05010044   /* FERMETURE  TRANSPORT                 */ 
#define SEScolclo       0x05000045   /* COLLISION DECONNEXION TRANSPORT      */ 
#define SESactiv        0x05010046   /* ACTIVITE EN COURS                    */ 
#define SESnonactiv     0x05010048   /* PAS D ACTIVITE EN COURS              */ 
#define SEScollres      0x05010049   /* COLLISION DE RESYNCHRO               */ 
#define SESclo         0x05010066    /* SESSION FERMEE                       */ 
#define SESactivnger   0x05010067    /* ACTIVITE NON GERE                    */ 
 /*  */ 
 /*  */ 
#define SESgenses      0x0502004B    /* PLUS DE CONTEXTES SESSSION           */ 
#define SESgencv       0x0502004C    /* PLUS DE CONTEXTES CV                 */ 
#define SESchain       0x0502004D    /* PLUS DE CHAINE                       */ 
#define SEStsapinc     0x0502004E    /* TSAP INCONNU                         */ 
 /*  */ 
 /*  */ 

/*------------------------*/
/* structure scb          */
/*------------------------*/

struct TSCB {
                char    name[3]  ;
                char    version  ;
                long    idsys   ;
                long    iduser  ;
                short   signal  ;
                short   typrac  ;
                short   origsev ;
                short   causdiag ;
                long    nomarque  ;
                char    delimiteur ;
                char    typmarque  ;
                char    etatjetdata  ;
                char    etatjetsyn  ;
                char    etatjetsynm  ;
                char    etatjetfin  ;
                char    donjetdata  ;
                char    donjetsyn  ;
                char    donjetsynm  ;
                char    donjetfin  ;
                short   typresync ;
                char    indicateur ;    
                char    lg48  ;
                char    data48  ;
                char    lg40 ;
                char    data40   ;
                char    lg45 ;
                short   data45 ;
                char    lg44 ;
                char    data44 ;
                char    oldident[6]  ;
                char    ident[6] ;
		char	lgoldident ;
                char    lgident  ;
           }  ;


/*----------------------------*/
/*   profil adressage session */
/*----------------------------*/


struct  ADRESSESSION {
                       unsigned short lgingus ;
                       char           inguser[64];
                       unsigned short lgedus ;
                       char           eduser[64] ;
                       unsigned short lgcom ;
                       char           comref[64] ;
                       unsigned short lgref ;
                       char           addref[4] ;
                       unsigned short lgsesing;
                       char           sesing[16];
                       unsigned short lgsesed ;
                       char           sesed[16];
                     };

/*------------------------*/
/*  profil de negociation */
/*------------------------*/


struct  NEGOCIATION {
                         unsigned short lgssdue   ;
                         unsigned short lgssdur   ;
                         unsigned short lgquare   ;
                         unsigned short lgquarr   ;
                         unsigned short lgspdue   ;
                         unsigned short lgspdur   ;
                         unsigned short lg2       ;
                         char           data2[6]   ;
                         unsigned short option    ;
                         char           segment   ;
                         unsigned char  choisubset   ;
                         unsigned char  jetondata   ;
                         unsigned char  jetonsyn  ;
                         unsigned char  jetonsynm  ;
                         unsigned char  jetonfin   ;
                         unsigned short lg8       ;
                         unsigned char  data8     ;
			 unsigned char  fil1 ;
                         char           nomarque[4]   ;
                         char           concatene  ;
                         char           demtour   ;
                        } ;





/*******************************************************/
/*     INTERFACE              TRANSPORT                */
/*                                                     */
/*       ACCES METHODE D'ACCES TRANSPORT               */
/*******************************************************/


/*----------------------------*/
/* codes requetes transport   */
/*----------------------------*/


#define TRA_RQOPEN       49           /* requete d'ouverture de connexion */
#define TRA_RQACPT       50           /* requete d'attente de connexion   */
#define TRA_RQOPENR      51           /* reponse a open                   */
#define TRA_RQCLOS       52           /* requete de fermeture de connexion*/
#define TRA_RQSEND       53           /* emission message normel          */
#define TRA_RQSENX       54           /* emission message express         */
#define TRA_RQLECSIG     55           /* lecture de signal                */
#define TRA_RQTSTSIG     56           /* test de signal                   */


/*-------------------------*/
/* code des signaux        */
/*-------------------------*/


#define TRA_ZOPEN  1
#define TRA_ZSEND  2
#define TRA_ZSENX  3
#define TRA_ZCLOS  4
#define TRA_ZRESE  5

/*-----------------*/
/* code retour ucb */
/*-----------------*/

#define TRA_OK     0x46000000   /* requete correcte                 */
#define TRA_TRONC  0x46000001	/* donnees tronquees		    */
#define TRA_NOSIG  0x46000002	/* pas de signal en attente	    */
#define TRA_CLOSE  0x46000003	/* close en cours   		    */
#define TRA_CLTQ   0x46000005	/* data tronquees + close en cours  */

/*-------------------------*/
/* erreurs niveau 1        */
/*-------------------------*/

#define TRA_UCB   0x4601000a    /* code requete incorrect ou parametres */
                                /* UCB errones (nbdescin,nbdescout...)  */
#define TRA_SIZE  0x4601000b    /* erreur sur parametre longueur des    */
                                /* descripteurs                         */
#define TRA_XCB   0x4601000c    /* erreur sur TCB                       */
#define TRA_INEX  0x4601000d    /* contexte methode d'cces non trouve   */
                                /* (parametre du TCB)                   */
#define TRA_IDEM  0x4601000f    /* requete identique en cours           */
#define TRA_CLOS  0x46010011    /* connexion fermee                     */
#define TRA_ENCH  0x46010013    /* erreur enchainement requete          */
#define TRA_PRM   0x46010018    /* erreur parametres table de site      */

/*-------------------------------------------------*/
/* alarme : numero de module - numero de procedure */
/*-------------------------------------------------*/

#define TRA_LIB    0x4601	/* lib_ucb     */
#define TRA_TCB    0x4602	/* creat_tcb   */
#define TRA_SSIG   0x4603	/* sup_signal  */
#define TRA_IICB   0x4604	/* icb_init    */
#define TRA_SICB   0x4605	/* sup_icb     */
#define TRA_SCTX   0x4606	/* sup_ctx     */
#define TRA_CCTX   0x4607	/* creat_ctxt  */
#define TRA_SCHN   0x4608	/* sup_chn     */
#define TRA_COPI   0x4609	/* copie       */
#define TRA_CTCB   0x4610	/* cop_tcb     */
#define TRA_SCRU   0x4611	/* scrut_sig   */ 
#define TRA_INIT   0x4612	/* inimat      */
#define TRA_MATT   0x4613       /* matt        */
#define TRA_QOPE   0x4614       /* mtrq_open   */
#define TRA_QACP   0x4615       /* mtrq_acpt   */
#define TRA_QROP   0x4616       /* mtrq_rope   */
#define TRA_IOPE   0x4617       /* mtin_open   */
#define TRA_FOPE   0x4618       /* mtcf_open   */
#define TRA_QSND   0x4619       /* mtrq_send   */
#define TRA_QSNX   0x4620       /* mtrq_senx   */
#define TRA_QCLO   0x4621       /* mtrq_clos   */
#define TRA_QRED   0x4622       /* mtrq_read   */
#define TRA_IGEN   0x4623       /* mtin_gene   */
#define TRA_FGEN   0x4624       /* mtcf_gene   */

/*----------------------------*/
/* code complementaire alarme */
/*----------------------------*/

#define TRA_BDC     0x0030	/* Abort acces debut de chaine  */
#define TRA_SDC     0x0031	/* Abort suppression debut chain*/
#define TRA_ADFC    0x0032	/* Abort ajout signal en debut  */
#define TRA_ALOB    0x0033
#define TRA_ALOT    0x0034
#define TRA_DALOT   0x0035
#define TRA_DALOB   0x0036
#define TRA_CHAI    0x0037
#define TRA_DCHAI   0x0038
#define TRA_CDES    0x0039
#define TRA_RDES    0x003a
#define TRA_ADC     0x003b
#define TRA_MVOUT   0x003c
#define TRA_CCC     0x003d
#define TRA_FILE    0x003e
#define TRA_IUTI    0x003f

#define TRA_DEL     0x0040	/* Scratch suppression contexte	     */
#define TRA_RETRI   0x0041	/* Scratch retrouver contexte	     */
#define TRA_CTRL    0x0042	/* Scratch retrouver adresse ucb     */
#define TRA_ABONN   0x0043	/* Scratch + de deux abonnements     */
#define TRA_RESN    0x0044	/* Scratch plus de cvp libre         */
#define TRA_RESO    0x0045      /* Scratch sur reset off pas trouve  */
#define TRA_READ    0x0046      /* Scratch sur lecture dans mail box */




/*-----------------------------------*/
/* Definition de la structure du TCB */
/*-----------------------------------*/

typedef struct type_tcb {
		char  name [3];
		char  version ;
		char  *nocv   ; 
		char  *nouser ;
		short signal  ;
                short inutil ;
		char  origine ;
		char  severite;
		char  cause   ;
		char  diagno  ;				
		};




/*******************************************************/
/*     INTERFACE              X253                     */
/*                                                     */
/*       ACCES METHODE D'ACCES X25_3                   */
/*******************************************************/



/*------------------------------*/
/* requetes utilisateurs	*/
/*------------------------------*/

#define X3_RQOPEN	33	/* ouverture de connexion		     */
#define X3_RQWAIT_OPEN	34	/* attente de connexion entrante	     */
#define X3_RQACK_OPEN	35	/* confirmation d'etablissement de connexion */
#define X3_RQCLOSE	36	/* fermeture de connexion		     */
#define X3_RQRESET	37	/* reinitialisation de connexion	     */
#define X3_RQSEND	38	/* emission de message normal		     */
#define X3_RQSEND_EXP	39	/* emission de message express		     */
#define X3_RQREAD	40	/* lecture de signal			     */
#define X3_RQTEST	41	/* test de signal			     */

/*--------------------------------------*/
/* signaux transmis a l'utilisateur	*/
/*--------------------------------------*/

#define X3S_DATA	1	/* message recu				*/
#define X3S_DATA_EXP	2	/* message d'interruption recu		*/
#define X3S_RESET	3	/* reinitialisation du CV		*/
#define X3S_CLOSE	4	/* fermeture du CVC			*/
				/* ou abonnement inactif si CVP		*/


/*----------------------*/
/* Codes retour des UCB	*/
/*----------------------*/

#define	OK_MAX3		0x36000000	/* requete executee normalement	*/
#define X3_NO_SIG	0x36000002	/* pas de signal en attente	*/
#define X3_CLOSE	0x36000003	/* fermeture en cours		*/
#define X3_RESET	0x36000004	/* reinitialisation en cours	*/
#define X3_OPEN		0x36000005	/* ouverture en cours		*/

#define X3_UCB_IDENT	0x36010010	/* erreur identification UCB	*/
#define X3_UCB_VERSION	0x36010011	/* erreur version UCB		*/

#define X3_NBINFO	0x36010020	/* erreur nbinfo		*/
#define X3_NBDESCOUT	0x36010021	/* erreur nbdescout		*/
#define X3_NBDESCIN	0x36010022	/* erreur nbdescin		*/
#define X3_REQ_UNKNOWN	0x36010023	/* requete inconnue		*/
#define X3_REQ_SAME	0x36010024	/* requete identique en cours	*/

#define X3_NCB_SIZE	0x36010030	/* erreur taille NCB		*/
#define X3_NCB_IDENT	0x36010031	/* erreur identification NCB	*/
#define X3_NCB_VERSION	0x36010032	/* erreur version NCB		*/
#define X3_NCB_TYPE	0x36010033	/* type CV inconnu		*/
#define X3_NCB_IN	0x36010034	/* taille NCB IN trop petite	*/
#define X3_NCB_DEPL	0x36010035	/* deplacement NCB non nul	*/

#define X3_CNX_UNKNOWN	0x36010040	/* connexion inexistante	*/
#define X3_CNX_SAT	0x36010041	/* saturation connexions	*/
#define X3_CTX_SAT	0x36010042	/* saturation contextes		*/

#define X3_SITE_SIZE	0x36010050	/* erreur taille table de site	*/
#define X3_CVP_SIZE	0x36010051	/* erreur longueur nom de CVP	*/
#define X3_CVP_UNKNOWN	0x36010052	/* CVP inconnu ou abn non actif	*/
#define X3_CVP_USED	0x36010053	/* CVP utilise			*/
#define X3_ADR_SIZE	0x36010054	/* erreur longueur adresse	*/
#define X3_FAC_SIZE	0x36010055	/* longueur facilites > 63 	*/
#define X3_DATA_OPEN	0x36010056	/* lg donnees d'appel > 128	*/
#define X3_ABN_UNKNOWN	0x36010057	/* abn inconnu ou non actif	*/
#define X3_NSAP_SIZE	0x36010058	/* lg NSAP > 3			*/
#define X3_SITE_IN	0x36010059	/* table de site trop petite	*/
#define X3_CVC_REFUSED	0x3601005a	/* ouverture CVC refusee	*/

#define X3_DATA_IN	0x36010060	/* taille reception trop petite */
#define X3_DATA_OUT	0x36010061	/* taille emission trop grande	*/
#define X3_DATA_EXP	0x36010062	/* taille IT != [1,32]		*/
#define X3_DATA_DEPL	0x36010063	/* deplacement < 8		*/


/*--------------------*/
/*   structure NCB    */
/*--------------------*/

struct ncb {

unsigned char	ident[3] ;	/* identification 'NCB'		*/
unsigned char	version	;	/* version			*/
unsigned long	idsys  ;	/* ident systeme		*/
unsigned long	iduser ;	/* ident utilisateur		*/
unsigned short	signal ;	/* signal recu			*/
unsigned short  indic  ;	/* indicateurs (bits Q,M )	*/
unsigned long	retour ;	/* code retour			*/
unsigned short	type   ;	/* type ( CVC,CVP )		*/
} ;


/*--------------------------------------*/
/*     structure de la table de site    */
/*--------------------------------------*/

struct site_cvc {

unsigned char	type ;		/* type de CV				    */
unsigned char	lgadrl ;	/* longueur adresse locale en demi-octets   */
unsigned char	adrl[8] ;	/* adresse locale codee BCD		    */

unsigned char	r2 ;
unsigned char	lgadrd ;	/* longueur adresse distante en demi-octets */
unsigned char	adrd[8] ;	/* adresse distante codee BCD		    */

unsigned char	r3 ;
unsigned char	lgfac ;		/* longueur champ facilites		    */
unsigned char	fac[64] ;	/* champ facilites			    */
} ;

struct site_cvp {

unsigned char	type ;		/* type de CV				    */
unsigned char	lgadrl ;	/* longueur adresse locale en demi-octets   */
unsigned char	adrl[8] ;	/* adresse locale codee BCD		    */

unsigned char	r2 ;
unsigned char	lgsite ;	/* longueur nom de site			    */
unsigned char	site[8];	/* nom de site global			    */
} ;



/*******************************************************/
/*     INTERFACE              X25-2                    */
/*                                                     */
/*       ACCES METHODE D'ACCES X25_2                   */
/*******************************************************/


/*------------------------------*/
/* requetes utilisateurs	*/
/*------------------------------*/

#define X2_RQOPEN	17	/* ouverture de connexion		*/
#define X2_RQWAIT_OPEN	18	/* attente de connexion entrante	*/
#define X2_RQCLOSE	19	/* fermeture de connexion		*/
#define X2_RQSEND	20	/* emission de message normal		*/
#define X2_RQREAD	21	/* lecture de signal			*/
#define X2_RQTEST	22	/* test de signal			*/


/*--------------------------------------*/
/* signaux transmis a l'utilisateur	*/
/*--------------------------------------*/

#define X2S_DATA	2	/* message recu				*/
#define X2S_RESET	3	/* reinitialisation de la liaison	*/
#define X2S_CLOSE	4	/* fermeture de la liaison		*/

/*---------------------------*/
/* Codes retour des UCB	     */
/*---------------------------*/

#define	OK_MAX2		0x26000000	/* requete executee normalement	*/
#define X2_NO_SIG	0x26000002	/* pas de signal en attente	*/
#define X2_CLOSE	0x26000003	/* fermeture en cours		*/
#define X2_RESET	0x26000004	/* reinitialisation en cours	*/
#define X2_OPEN		0x26000005	/* ouverture en cours		*/

#define X2_UCB_IDENT	0x26010010	/* erreur identification UCB	*/
#define X2_UCB_VERSION	0x26010011	/* erreur version UCB		*/

#define X2_NBINFO	0x26010020	/* erreur nbinfo		*/
#define X2_NBDESCOUT	0x26010021	/* erreur nbdescout		*/
#define X2_NBDESCIN	0x26010022	/* erreur nbdescin		*/
#define X2_REQ_UNKNOWN	0x26010023	/* requete inconnue		*/
#define X2_REQ_SAME	0x26010024	/* requete identique en cours	*/

#define X2_LCB_SIZE	0x26010030	/* erreur taille LCB		*/
#define X2_LCB_IDENT	0x26010031	/* erreur identification LCB	*/
#define X2_LCB_VERSION	0x26010032	/* erreur version LCB		*/
#define X2_LCB_IN	0x26010034	/* taille LCB IN trop petite	*/
#define X2_LCB_DEPL	0x26010035	/* deplacement LCB non nul	*/

#define X2_CNX_UNKNOWN	0x26010040	/* connexion inexistante	*/
#define X2_CNX_SAT	0x26010041	/* saturation connexions	*/
#define X2_CTX_SAT	0x26010042	/* saturation contextes		*/

#define X2_SITE_SIZE	0x26010050	/* erreur taille table de site	*/
#define X2_LK_UNKNOWN	0x26010052	/* liaison inconnue		*/
#define X2_LK_USED	0x26010053	/* liaison utilisee		*/
#define X2_NUM_SIZE	0x26010054	/* erreur longueur numero appel	*/
#define X2_LK_REFUSED	0x2601005a	/* ouverture liaison refusee	*/

#define X2_DATA_IN	0x26010060	/* taille reception trop petite */
#define X2_DATA_OUT	0x26010061	/* taille emission trop grande	*/
#define X2_DATA_DEPL	0x26010063	/* deplacement < 4		*/

/*------------------------------------------------------*/
/* Codes retour LCB des refus d'ouverture de connexion	*/
/*------------------------------------------------------*/

#define OPEN_LK01       0x02010001      /* non reponse distante		*/
#define OPEN_LK02       0x02010002      /* reponse DM a l'ouverture	*/
#define LK_USED		0x02010003      /* liaison deja utilisee	*/

#define OPEN_LN01	0x01010303      /* non ouverture de ligne	*/
 
/*--------------------------------------------------------------*/
/* Codes retour LCB des signaux de reinitialisation de liaison	*/
/*--------------------------------------------------------------*/

#define REI_LK01	0x82000000	/* reinit distante (SABM recu)	*/
#define REI_LK02 	0x02000000      /* reinit locale sans FRMR recu	*/
#define REI_LK03	0x02000001      /* reinit locale sur FRMR recu	*/
 
/*--------------------------------------------------------*/
/* Codes retour LCB des signaux de deconnexion de liaison */
/*--------------------------------------------------------*/

#define FER_LK01	0x82000000	/* fermeture distante (DISC recu)*/
#define FER_LK02	0x02010001      /* echec de reinitialisation	 */
					/*  (non reponse du distant)	 */
#define FER_LK03	0x02010002      /* echec de reinitialisation	 */
					/*  ( DM recu)			 */


/*--------------------*/
/*   structure LCB    */
/*--------------------*/

struct lcb {

unsigned char	ident[3] ;	/* identification 'LCB'		*/
unsigned char	version	;	/* version			*/
unsigned long	idsys  ;	/* ident systeme		*/
unsigned long	iduser ;	/* ident utilisateur		*/
unsigned short	signal ;	/* signal recu			*/
unsigned short  indic  ;	/* indicateurs			*/
unsigned long	retour ;	/* code retour			*/
} ;

/*---------------------------------*/
/* structure de la table de site   */
/*---------------------------------*/

struct site {

unsigned char	liaison[4] ;	/* nom de la liaison			*/

unsigned short	lgnum ;		/* longueur numero d'appel		*/
unsigned char	num[256] ;	/* numero d'appel code BCD		*/
} ;




