/* "@(#)procstate.h	5.1	6/9/86" */

/*
 *	Definition of process state record
 */

#ifndef _KIM_PROCSTATE_
#define _KIM_PROCSTATE_

typedef struct
  {					/* Process State */
    int			registers[16];	/* registers */
    int			pc;		/* program counter */
    unsigned int	parent;		/* parent process id */
    double		Traps;
    int			ProcRunTime;
    int			status;
    int			priority;
    int			msgWait;
    int			numFaults;
    int			stateUnused;
    double		codeFile;
    double		dataFile;
    double		queueFile;
    int			ttyd;
    int			window;
    int			uid;
    int			gid;
    int			pgrp;
    int			extra[27];
  } stateRecord;

typedef union
  {
    stateRecord		p;
    double		d[1];
  } processState;

#endif
