/* "@(#)graf.h	5.1	6/9/86" */
/* graf.h - Ridge monochrome graphics */

#define WHITing           0     /* integer codes for BitBlt "rule" */
#define ANDing            1
#define SANDNOTDing       2
#define STORing           3
#define NOTSANDDing       4
#define NoOPing           5
#define XORing            6
#define ORing             7
#define NORing            8
#define NXORing           9
#define NOTing            10
#define SORNOTDing        11
#define NOTSing           12
#define NOTSORDing        13
#define NANDing           14
#define BLACKing          15

#define White             0     /* color values */
#define Black             1

struct Form     {
                int width;
                int height;
                unsigned int *bits;  /* pts to array of words */
                };

struct RasterOp {
                struct Form destForm;
                struct Form sourceForm;
                struct Form maskForm;
                int  rule;
                int  destX;
                int  destY;
                int  width;
                int  height;
                int  clipX;
                int  clipY;
                int  clipWidth;
                int  clipHeight;
                int  sourceX;
                int  sourceY;
                };

struct Point    {
                int x;
                int y;
                };

struct Rectangle{
                struct Point origin;
                struct Point extent;
                };
