/* "@(#)sgtty.h	5.1	6/10/86" */

/*
 * Structure for stty and gtty system calls.
 */

#include <ros/sgttyb.h>

#ifdef BSD

#ifndef	_IOCTL_
#include <sys/ioctl.h>
#endif

#else

#include <ros/ioctl.h>

/*
 * Modes
 */

#define	TANDEM	BSD_TANDEM
#define	CBREAK	BSD_CBREAK
#define	LCASE	BSD_LCASE
#define	ECHO	BSD_ECHO
#define	CRMOD	BSD_CRMOD
#define	RAW	BSD_RAW
#define	ODDP	BSD_ODDP
#define	EVENP	BSD_EVENP
#define ANYP	BSD_ANYP
#define	NLDELAY	BSD_NLDELAY
#define	TBDELAY	BSD_TBDELAY
#define	CRDELAY	BSD_CRDELAY
#define	VTDELAY	BSD_VTDELAY
#define BSDELAY BSD_BSDELAY
#define ALLDELAY BSD_ALLDELAY

/*
 * Delay algorithms
 */
#define	CR0	BSD_CR0
#define	CR1	BSD_CR1
#define	CR2	BSD_CR2
#define	CR3	BSD_CR3
#define	NL0	BSD_NL0
#define	NL1	BSD_NL1
#define	NL2	BSD_NL2
#define	NL3	BSD_NL3
#define	TAB0	BSD_TAB0
#define	TAB1	BSD_TAB1
#define TAB2	BSD_TAB2
#define XTABS	BSD_XTABS
#define	NOAL	BSD_NOAL
#define	FF0	BSD_FF0
#define	FF1	BSD_FF1
#define	BS0	BSD_BS0
#define	BS1	BSD_BS1

#include <ros/ttydev.h>

/*
 * Speeds
 */
#define B0	BSD_B0
#define B50	BSD_B50
#define B75	BSD_B75
#define B110	BSD_B110
#define B134	BSD_B134
#define B150	BSD_B150
#define B200	BSD_B200
#define B300	BSD_B300
#define B600	BSD_B600
#define B1200	BSD_B1200
#define	B1800	BSD_B1800
#define B2400	BSD_B2400
#define B4800	BSD_B4800
#define B9600	BSD_B9600
#define EXTA	BSD_EXTA
#define EXTB	BSD_EXTB

/*
 *	ioctl arguments
 */
#define FIOCLEX		BSD_FIOCLEX	
#define FIONCLEX	BSD_FIONCLEX
#define	TIOCHPCL	BSD_TIOCHPCL
#define	TIOCGETP	BSD_TIOCGETP
#define	TIOCSETP	BSD_TIOCSETP
#define	TIOCEXCL	BSD_TIOCEXCL
#define	TIOCNXCL	BSD_TIOCNXCL

#endif
