/* "@(#)ttychars.h	5.1	6/10/86" */

#ifndef _ROS_TTYCHARS_
#define _ROS_TTYCHARS_

struct ttychars {
	char	tc_erase;	/* erase last character */
	char	tc_kill;	/* erase entire line */
	char	tc_intrc;	/* interrupt */
	char	tc_quitc;	/* quit */
	char	tc_startc;	/* start output */
	char	tc_stopc;	/* stop output */
	char	tc_eofc;	/* end-of-file */
	char	tc_brkc;	/* input delimiter (like nl) */
	char	tc_suspc;	/* stop process signal */
	char	tc_dsuspc;	/* delayed stop process signal */
	char	tc_rprntc;	/* reprint line */
	char	tc_flushc;	/* flush output (toggles) */
	char	tc_werasc;	/* word erase */
	char	tc_lnextc;	/* literal next character */
};

#endif

#ifndef _ROS_DEFAULT_CHARS_
#define _ROS_DEFAULT_CHARS_

#define	CTRL(c)	('c'&037)

#ifdef ridge
#define	BSD_CERASE	CTRL(h)
#define	BSD_CKILL	CTRL(x)
#define	BSD_CINTR	0177
#else
#define	BSD_CERASE	0177
#define	BSD_CKILL	CTRL(u)
#define	BSD_CINTR	CTRL(c)
#endif
#define	BSD_CQUIT	034		/* FS, ^\ */
#define	BSD_CSTART	CTRL(q)
#define	BSD_CSTOP	CTRL(s)
#define	BSD_CEOF	CTRL(d)
#define	BSD_CEOT	CEOF
#define	BSD_CBRK	0377
#define	BSD_CSUSP	CTRL(z)
#define	BSD_CDSUSP	CTRL(y)
#define	BSD_CRPRNT	CTRL(r)
#define	BSD_CFLUSH	CTRL(o)
#define	BSD_CWERASE	CTRL(w)
#define	BSD_CLNEXT	CTRL(v)

#endif
