/* "@(#)scsi.cmds.h	5.1	6/10/86"*/
/*   scsi.h   */

/*
    This file contains typedefs and #defines which define the structure of
    the CIO's SCSI control blocks.

    The file <ros/ciomem.h> contains definitions of the locations
    of all control blocks, and offsets of each field.

    Note that due to different byte ordering of the 8086, and the Ridge
    processors, the order of bytes within a 16 bit word will appear
    to be swapped if these structures are compared to the (8086 style)
    addresses contained in ciomem.h
*/

#include <ros/scsi.data.h>

/*
** Templates for Group 0 Commands
*/

typedef struct
    {
    Byte	CmdCode;
    Byte	Cmd1;
    Byte	Cmd2;
    Byte	Cmd3;
    Byte	Cmd4;
    Byte	Control;
    Byte	ExtraBytes[6];
    }  tGroup0CDB;

typedef struct 
    {
    Byte	CmdCode;
    unsigned	LUN		: 3;
    unsigned	NotUsed		: 5;
    Byte	Cmd2;
    Byte	Cmd3;
    Byte	Cmd4;
    unsigned	VendorUnique	: 2;
    unsigned	Reserved	: 4;
    unsigned	Flag		: 1;
    unsigned	Link		: 1;
    Byte	ExtraBytes[6];
    }tGroup0t1;

typedef struct
    {
    Byte	CmdCode;
    unsigned	LUN		: 3;
    unsigned	LBAHi 		: 5;
    Byte	LBAMid;
    Byte	LBALow;
    Byte	NumBlocks;
    unsigned	VendorUnique	: 2;
    unsigned	Reserved	: 4;
    unsigned	Flag		: 1;
    unsigned	Link		: 1;
    Byte	ExtraBytes[6];
    }tGroup0t2;

typedef struct
    {
    Byte 	CmdCode;
    unsigned	LUN		: 3;
    unsigned	NotUsed		: 4;
    unsigned	Immed		: 1;
    Byte	Cmd2;
    Byte	Cmd3;
    Byte	Cmd4;
    unsigned	VendorUnique	: 2;
    unsigned	Reserved	: 4;
    unsigned	Flag		: 1;
    unsigned	Link		: 1;
    Byte	ExtraBytes[6];
    }tGroup0t3;

typedef struct
    {
    Byte	CmdCode;
    unsigned	LUN		: 3;
    unsigned	NotUsed		: 2;
    unsigned	SelfTst		: 1;
    unsigned	DevOff		: 1;
    unsigned	UnitOff		: 1;
    Byte	Cmd2;
    Byte	Cmd3;
    Byte	Cmd4;
    unsigned	VendorUnique	: 2;
    unsigned	Reserved	: 4;
    unsigned	Flag		: 1;
    unsigned	Link		: 1;
    Byte	ExtraBytes[6];
    }tGroup0t4;

typedef struct
    {
    Byte 	CmdCode;
    unsigned	LUN		: 3;
    unsigned	FmtData		: 1;
    unsigned	CmpLst		: 1;
    unsigned	DefListFmt	: 3;
    Byte	Reserved1;
    Byte	IntLeaveHi;
    Byte	IntLeaveLow;
    unsigned	VendorUnique	: 2;
    unsigned	Reserved	: 4;
    unsigned	Flag		: 1;
    unsigned	Link		: 1;
    Byte	ExtraBytes[6];
    }tGroup0t5;

typedef struct 
    {
    Byte	CmdCode;
    unsigned	LUN		: 3;
    unsigned	NotUsed		: 3;
    unsigned 	Code		: 2;
    Byte	Count1;
    Byte	Count2;
    Byte	Count3;
    unsigned	VendorUnique	: 2;
    unsigned	Reserved	: 4;
    unsigned	Flag		: 1;
    unsigned	Link		: 1;
    Byte	ExtraBytes[6];
    }tGroup0t6;

typedef struct 
    {
    Byte	CmdCode;
    unsigned	LUN		: 3;
    unsigned	NotUsed		: 3;
    unsigned 	BC		: 1;
    unsigned	Fix		: 1;
    Byte	Length1;
    Byte	Length2;
    Byte	Length3;
    unsigned	VendorUnique	: 2;
    unsigned	Reserved	: 4;
    unsigned	Flag		: 1;
    unsigned	Link		: 1;
    Byte	ExtraBytes[6];
    }tGroup0t7;

typedef struct 
    {
    Byte	CmdCode;
    unsigned	LUN		: 3;
    unsigned	LengthHi	: 5;
    Byte	LengthMidHi;
    Byte	LengthMidLow;
    Byte	LengthLo;
    unsigned	VendorUnique	: 2;
    unsigned	Reserved	: 4;
    unsigned	Flag		: 1;
    unsigned	Link		: 1;
    Byte	ExtraBytes[6];
    }tGroup0t8;

/*
** Templates for Group 1 Commands
*/
typedef struct
    {
    Byte	CmdCode;
    Byte	Cmd1;
    Byte	Cmd2;
    Byte	Cmd3;
    Byte	Cmd4;
    Byte	Cmd5;
    Byte	Cmd6;
    Byte	Cmd7;
    Byte	Cmd8;
    Byte	Control;
    Byte	ExtraBytes[2];
    }  tGroup1CDB;

typedef struct
    {
    Byte	CmdCode;
    unsigned	LUN		: 3;
    unsigned	NotUsed		: 4;
    unsigned	RelAddr		: 1;
    Byte	LBAHi;
    Byte	LBAHiMid;
    Byte	LBALowMid;
    Byte	LBALow;
    Byte	Cmd6;
    Byte	Cmd7;
    unsigned    VendorUnique2	: 2;
    unsigned	Reserved2	: 5;
    unsigned	PMI		: 1;
    unsigned	VendorUnique	: 2;
    unsigned	Reserved	: 4;
    unsigned	Flag		: 1;
    unsigned	Link		: 1;
    Byte	ExtraBytes[2];
    }  tGroup1t1;

typedef struct
    {
    Byte	CmdCode;
    unsigned	LUN		: 3;
    unsigned	NotUsed		: 3;
    unsigned	Check		: 1;
    unsigned	RelAddr		: 1;
    Byte	LBAHi;
    Byte	LBAHiMid;
    Byte	LBALowMid;
    Byte	LBALow;
    Byte	Cmd6;
    Byte	NumBlocksHi;
    Byte	NumBlocksLow;
    unsigned	VendorUnique	: 2;
    unsigned	Reserved	: 4;
    unsigned	Flag		: 1;
    unsigned	Link		: 1;
    Byte	ExtraBytes[2];
    }  tGroup1t2;

typedef struct
    {
    Byte	CmdCode;
    unsigned	LUN		: 3;
    unsigned	NotUsed		: 5;
    Byte	NumBytesHi;
    Byte	NumBytesMed;
    Byte	NumBytesLow;
    Byte	Cmd5;
    Byte	Cmd6;
    Byte	Cmd7;
    Byte	Cmd8;
    unsigned	VendorUnique	: 2;
    unsigned	Reserved	: 4;
    unsigned	Flag		: 1;
    unsigned	Link		: 1;
    Byte	ExtraBytes[2];
    }  tGroup1t3;

/*
** Templates  for SCSI Group 5 Commands
*/
typedef struct
    {
    Byte	CmdCode;
    Byte	Cmd1;
    Byte	Cmd2;
    Byte	Cmd3;
    Byte	Cmd4;
    Byte	Cmd5;
    Byte	Cmd6;
    Byte	Cmd7;
    Byte	Cmd8;
    Byte	Cmd9;
    Byte	Cmd10;
    Byte	Control;
    }  tGroup5CDB;

typedef struct
    {
    Byte	CmdCode;
    unsigned	LUN		: 3;
    unsigned	NotUsed		: 5;
    Byte	LBAHi;
    Byte	LBAHiMid;
    Byte	LBALowMid;
    Byte	LBALow;
    Byte	LBA2Hi;
    Byte	LBA2HiMid;
    Byte	LBA2LowMid;
    Byte	LBA2Low;
    unsigned	Reserved1	: 8;
    unsigned	ReadInhibit	: 1;
    unsigned	WriteInhibit	: 1;
    unsigned	VendorUnique	: 2;
    unsigned	Reserved	: 4;
    unsigned	Flag		: 1;
    unsigned	Link		: 1;
    } tGroup5t1;

/*
** CIO Command Blocks
*/
typedef union
    {
    tGroup0CDB Raw0CMD;
    tGroup1CDB Raw1CMD;
    tGroup5CDB Raw5CMD;
    tGroup0t1 TestRdyCMD, InquiryCMD, ReqSenseCMD, ModeSelectCMD, ReserveCMD, 
              ReleaseCMD, ModeSenseCMD, RcvDiagResultCMD, RezeroCMD, RewindCMD,
              StartStopCMD, RdBlkLimitsCMD, TrackSelectCMD,  ReadReverseCMD, 
              CopyCMD, LoadUnloadCMD, WCopyCMD, ReceiveCMD, SendCMD;
    tGroup0t2 ReassignBlkCMD, ReadCMD, WriteCMD;
    tGroup0t3 SReadCMD, SWriteCMD, WrFileMarkCMD, RecvrBufDataCMD, EraseCMD;
    tGroup0t4 SendDiagCMD;
    tGroup0t5 FormatCMD;
    tGroup0t6 SpaceCMD;
    tGroup0t7 SVerifyCMD;
    tGroup0t8 DirectWriteCMD;
    tGroup1t1 ReadCapacityCMD;
    tGroup1t2 Read1CMD, Write1CMD, WriteVerifyCMD, VerifyCMD, 
	      SearchHiCMD, SearchEqualCMD, SearchLowCMD;
    tGroup1t3 RecieveNetCMD, SendNetCMD;
    tGroup5t1 SetLimitsCMD;
    } tScsiCmds;

typedef	struct
    {
    tGroup0CDB  CDB; /*
		     ** this line could be replaced with the line
		     ** 'tScsiCmds  CDB;'; it has been left as is for
		     ** historical reasons.
		     */
    Byte	RidgeStatus;
    Byte	ScsiStatus;
    }  tScsiCmdSet;

typedef struct
    {
    Byte	OrderType;
    Byte	StartIO;
    Byte	AuxMsg;
    Byte	IdentifyMsg;
    Byte	TargetID;
    Byte	RidgeDevNum;
    Halfword	XferCntMsb;
    Halfword	XferCntLsb;
    tScsiCmdSet	Cmds[3];
    unsigned	Pages[16];
    }  tScsiCB;

/* Bits in Control byte */
#define	sLink	0x01		/* 1 = link to next command */
#define	sFlag	0x02		/* 1 = interrupt on linked commands */

/*
** COMMAND CODES
*/

/*
** All device classes (Group 0)
*/
#define	sTestRdy	0x00
#define	sInquiry	0x12
#define	sReqSense	0x03
#define	sModeSelect	0x15
#define	sReserve	0x16
#define	sRelease	0x17
#define	sModeSense	0x1A
#define	sRcvDiagResult	0x1C
#define	sSendDiag	0x1D

/*
** Direct access device commands (Group 0)
*/
#define	sRezero		0x01
#define	sFormat		0x04
#define	sReassignBlk	0x07
#define	sRead		0x08
#define	sWrite		0x0A
#define	sSeek		0x0B
#define	sStartStop	0x1B
/*
** Direct access device commands (Group 1)
*/
#define sReadCapacity	0x25
#define sRead1		0x28
#define sWrite1		0x2a
#define sWriteVerify	0x2e
#define sVerify		0x2f
#define sSearchHi	0x30
#define sSearchEqual	0x31
#define sSearchLow	0x32
/*
** Direct access device commands (Group 5)
*/
#define sSetLimits	0xa9


/*
** Sequential access device commands (Group 0)
*/
#define	sRewind		0x01
#define	sRdBlkLimits	0x05
#define	sSRead		0x08	
#define	sSWrite		0x0A
#define	sTrackSelect	0x0B
#define	sReadReverse	0x0F
#define	sWrFileMark	0x10
#define	sSpace		0x11
#define	sSVerify	0x13
#define	sRecvrBufData	0x14
#define	sCopy		0x18
#define	sErase		0x19
#define	sLoadUnload	0x1B

/*
** Write-only device comands (Group 0)
*/
#define sDirectWrite	0x0a
#define	sWCopy		0x18

/*
** Host device commands (Group 0)
*/
#define	sRecieve	0x08
#define	sSend		0x0a

/*
** Bus Converter device commands (Group 1)
*/
#define sReceiveNet	0x28
#define sSendNet	0x2a
