/* "@(#)maint.h	5.1	6/9/86" */
/* Maint opcode definitions for assemblers without this knowledge */
CONSTANT(MAINTOP,HEX(4C))
CONSTANT(MACHINEID,10)
CONSTANT(CREG,12)
#define RR(r1,r2) r1*16+r2

/* definitions for CREG  maint opcode on headwall only */
/* Req and DataOut are in R1 */
CONSTANT(HWClockReq,1)
CONSTANT(HWClockDataOut,2)
/* Ack and DataIn are in R1+1 */
CONSTANT(HWClockAck,1)
CONSTANT(HWClockDataIn,2)

/* definitions for headwall bits returned in ELOGR */
CONSTANT(HWPowerFail,HEX(100))

/* Bits returned by MACHINEID in R1+1 */
CONSTANT(FTCopyOnWrite,	HEX(1))	/* Memory controller does copy-on-write */
CONSTANT(FTWaterFall,	HEX(2))	/* Enhanced Floating Point (Waterfall) processor */
CONSTANT(FTExtMemory,	HEX(4))	/* Memory controller maps more than 8M==>new VRT */
CONSTANT(FTHeadwall,	HEX(8))	/* Headwall processor */
