/* "@(#)list.h	5.1	6/10/86" */
/* list.h

   Purpose:	General-purpose macros for doubly-linked circular lists.

   Caveat:	Assumes that the head of a list is an empty list entry.

   Author:	Keith Lantz and Jonathan Reichbach

   History:
   7/84		created from Jeff Mogul's queue routines
*/

#ifndef _ROS_LIST_
#define _ROS_LIST_

typedef struct listPtr
  {
    struct listPtr *	next;
    struct listPtr *	previous;
  } List,  *ListPtr;

/* Some defines for queue manipulation */
/* Temporary used by queue macros. */

List *			tmpList;

#define Dequeue(head) 			  \
    (((tmpList = ((ListPtr) head)->next) == ((ListPtr) head)) ? NULL : \
     (((tmpList->previous)->next = tmpList->next),         \
      ((tmpList->next)->previous = tmpList->previous),	  \
      (tmpList)))

#define IsListEmpty(head) \
    (((ListPtr) head)->next == ((ListPtr) head))

#define InitList(head)  \
    { ((ListPtr) head)->next = ((ListPtr) head); ((ListPtr) head)->previous = ((ListPtr) head); };

#define forAllInList(head, ptr) \
     for ((ListPtr) ptr = ((ListPtr) head)->next; \
          (ListPtr) ptr != (ListPtr) head;        \
          (ListPtr) ptr = ((ListPtr) ptr)->next)

#endif
