/*"@(#)iodev.h	5.1	6/10/86"*/
/*
  Constants for IO addresses and IO device types.
*/

/* highest legal device address */
#define HighestDevAddr	    255

/*
  Shifter for extraction of device address.
  Use this for generating IO addresses for use in READ, WRITE, 
  and for IO interrupt word comparisons.
*/
#define DeviceAddrShiftCnt   24

/*
  Shifter for extraction of device type.
  Use this for automatic recognition of a device which is responding
  to a given address.
*/
#define DeviceTypeShiftCnt   24

/*
  Enumeration of known device types follows.
  The first few types are not actually returned by the devices
  in the high 8 bits on IORead, but are inferred based on device
  address, and the bits returned in the high 8 bits on IORead.
*/

/* ... types for Z80 controller boards */
#define DTFDLP		0x01
#define DTANSI		0x02
#define DTSMD		0x03
/* ... types for Ridge monochrome display board */
#define DTKeyboard	0x04
#define DTDisplay	0x05
/* ... types for Comprehensive IO board */
#define DTCIODebug	0x06
#define DTCIODiag	0x07
#define DTCIOLance	0x08
#define DTCIOEnet	0x09
#define DTCIOTTY	0x0a
#define DTCIOLP		0x0b
#define DTCIOIsbx	0x0c
#define DTCIOTape	0x0d
#define DTCIODisc	0x0e
#define DTCIOSCSI	0x0f

#define DTTape		0x20
/* 0x21 through 0x2f    Ridge reserved */
#define DTDR11m		0x30
/* 0x31                 Ridge reserved */
#define DTDR11UBnet	0x32
/* 0x33                 Ridge reserved */
/* 0x34                 Ridge reserved */
/* 0x35 through 0x3b    Ridge (DR11) reserved */
/* 0x3c through 0x3f    Ridge (customer) reserved */
#define DTEnet		0x40
#define DTCIO		0x41
/* 0x42 through 0x4f    Ridge (other CIO) reserved */
#define DTMultibus	0x50
/* 0x51 through 0x5f    Ridge (other multibus) reserved */
/* 0x60 through 0x6f    Ridge reserved */
/* 0x60 through 0xdf    Ridge reserved */
/* 0xe0 through 0xef    Customer reserved */
/* 0xf0 through 0xff    Ridge reserved */
