/* "@(#)ciomem.h	5.1	6/10/86" */
/*   ciomem.h - contains defines for CIO board shared memory locations */

/* Interrupt UnitID's for each device on CIO board */
#define DebugUnitID	0
#define DiagUnitID	1
#define LanceUnitID	2
#define EtherUnitID	3
#define	TermUnitID	4
#define	LpUnitID	5
#define	IsbxUnitID	6
#define	Tape0UnitID	8
#define	Tape1UnitID	9
#define	Disc0UnitID	10
#define	Disc1UnitID	11

/* Memory select, control bits in I/O Addresses */
#define	MapRAMBit	0x00800000		/* This bit on selects Address Mapping Ram */
#define	_BHEBit		0x00400000		/* ~BHE - if on disables high byte write/read */

/* shared memory locations */
#define EtherCB		0x000			/* Ethernet control block */
		/* Offsets of elements in EtherCB */
#define		ECommand	0
			/* Enet command codes */
#define			EBootCmd	1	/* reserved */
#define			EWriteRegsCmd	2	/* Write to all 4 Lance regs. */
#define			EWriteReg0Cmd	3	/* Write to CSR0 only */
#define			EReadRegsCmd	4	/* Read all 4 Lance regs.  */
#define			EReadReg0Cmd	5	/* Read CSR0 only */
#define			EReadAddrCmd	6	/* Read Enet physical address */
#define			EDmdXmitCmd	7	/* Tell Lance to transmit NOW */
#define			EEnLanceCmd	8	/* Enable interrupts from Lance Interrupt unit */
#define			EDisLanceCmd	9	/* Disable interrupts from Lance Interrupt unit */
#define			EEnEtherCmd	10	/* Enable interrupts from Enet Command unit */
#define			EDisEtherCmd	11	/* Disable interrupts from Enet Command unit */
#define			EReadRevCodes	12	/* Read revision codes of prom, code, PCB */
#define		EError		1
			/* Enet error codes */
#define			EBadCmdErr	1	/* Received unknown command */
#define			EIntOvflErr	2	/* Lance interrupt Q overflowed */
#define			EPAddrErr	3	/* Bad checksum in address prom */
#define		EWriteData	0x002		/* Data to be written to regs. (1 or 4 words) */
#define		EReadData	0x00A		/* Data read from Lance regs. */
#define		EPAddress	0x012		/* Enet physical address */
#define		EIntHead	0x018		/* Pointer to head of Lance Interrupt Queue */
#define		EIntTail	0x01A		/* Pointer to tail of Lance Interrupt Queue */
#define		EPROMRev	0x01C		/* Revision level of PROM code */
#define		EPROMRevL	0x01C
#define		EPROMRevH	0x01D
#define		ECodeRev	0x01E		/* Main code version (possibly downloaded code) */
#define		EPCBRev		0x01F		/* Printed Circuit board version */
#define		EPAddrCheck	0x020		/* Checksum on Enet Address prom */
#define EtherCBEnd	0x027
#define	EtherInitBlock	0x028			/* Location of Lance's Initialization block */

#define ScsiGlobalCB	0x040			/* Used for global SCSI control/status */
#define		SCSIReset	0x00  /*db*/	/* Writing a 01 here causes a bus reset */
	/* Line Printer Control Block */
#define LpCB		0x080			/* Line printer control block */
		/* Offsets of elements of Line Printer CB */
#define		LpOrder         0x000		/* Order to perform LP operation */
			/* LP orders */
#define			LpWrite		0x02	/* write a block from ridge to printer */
#define			LpWait		0x04	/* interrupt when transfer complete */
#define			LpWriteLocal	0x06	/* write a block from shared memory (for diags.) */
#define		LpType          0x001		/* printer type  (must match type from cable) */
			/* LP types */
#define			LpTypeVers	0xC	/* Versatec interface */
#define			LpTypeDP	0x8	/* Data products interface */
#define			LpTypeCent	0x4	/* Centronics interace */
#define			LpTypeNone	0x0	/* No interface connected */
#define		LpByteCount	0x002		/* Number of bytes to send (up to 1 page) */
#define		LpRidgeAddrU	0x004		/* Upper 16 bits of Ridge buffer address */
#define		LpRidgeAddrL	0x006		/* Lower 16 bits of Ridge buffer address */
#define		LpCmd2          0x008		/* Sets control lines during transfer */
#define		LpCmd1          0x009		/* Sets control lines just before transfer */
			/* control line bit definitions */
#define			LpReset		0x80
#define			LpClear		0x40	/* Versatec only */
#define			LpFormFeed	0x20	/* Versatec only */
#define			LpEOT		0x10	/* Versatec only */
#define			LpLineTerm	0x08	/* Versatec only */
#define			LpPlot		0x04	/* Versatec only */
#define			LpPrintPlot	0x02	/* Versatec only */
#define			LpSMGo		0x01    /* A zero here clears LP state machine */
#define		LpReturnStatus  0x00A		/* Response to commands */
			/* ReturnStatus bit definitions */
#define			LpOK		0x00
#define			LpBadType	0x02	/* LpType does not match sensed device type */
#define			LpAbortAck	0x04	/* Acknowledgement to abort command */
#define		LpAbortStatus   0x00B		/* Reserved */
#define		LpDeviceStatus  0x00C		/* Status of interface lines */
			/* status line bits	   Data Prod.	  Centronics	Versatec	*/
#define			LpTOFL		0x80	/* -Top of Form	  FALSE		follows +RFFED	*/
#define			LpBOFL		0x40	/* -Bottom Form	  +Fault	follows +REOTR	*/
#define			LpCFault	0x40	/* -Bottom Form	  +Fault	follows +REOTR	*/
#define			LpDPOnlineL	0x20	/* -online	  -Selected	+online		*/
#define			LpCSelectedL	0x20	/* -online	  -Selected	+online		*/
#define			LpVOnline	0x20	/* -online	  -Selected	+online		*/
#define			LpNoPaperL	0x10	/* +IFace Conn.	  -No Paper	-No Paper	*/
#define			LpDPIFaceConn	0x10	/* +IFace Conn.	  -No Paper	-No Paper	*/
#define			LpTypeMask	0x0C	/*  1 0		   0 1		 1 1		*/
#define			LpCBusyL	0x02	/* -Ready	  -Centr Bsy	FALSE		*/
#define			LpDPReadyL	0x02	/* -Ready	  -Centr Bsy	FALSE		*/
#define			LpDPDemandL	0x01	/* -DP Demand	  +Centr Ack	-Vers Busy	*/
#define			LpCAck		0x01	/* -DP Demand	  +Centr Ack	-Vers Busy	*/
#define			LpVBusyL	0x01	/* -DP Demand	  +Centr Ack	-Vers Busy	*/
#define		LpReserved1     0x00D
#define		LpAbortCmd      0x00E		/* non-zero aborts current write */
#define		LpReserved2     0x00F
#define DiagLPAddr1	0x0B0			/* Diagnostics will write a buffer address here */
#define DiagLPAddr2	0x0B4
	/* Debugger Control Block */
#define	DebugCB		0x0C0
#define		DB_BootReq	0		/* C0 is a the magic location uCode writes to boot */
#define		DB_BdFailures	2		/* Selftest routines report failures here */
			/* Test request/failure flag bits used in BdFailures, and RequestWord */
#define			D_LRegFailed	0x0001		/* Lance register test failed */
#define			D_LMemFailed	0x0002		/* Local memory test failed */
#define			D_SMemFailed	0x0004		/* Shared memory test failed */
#define			D_lanceinitfail 0x0008		/* lance initialization and internal loopback */
#define			D_DMActfailed	0x0010		/* DMA counter test */
#define			D_Timerfailed	0x0020		/* 8254 timer test */
#define			D_DMAfailed	0x0040		/* DMA test */
#define			D_Siofailed	0x0080		/* Sio test */
#define			D_scsiintfail	0x0100		/* scsi internal loopbk */
#define			D_scsiprifail	0x0200		/* scsi priority check	 */
#define			D_DMArdgfail	0x0400		/* ridge DMA test */
#define			D_SioLoopbkfail	0x0800		/* sio loopback test */
#define			D_lpextfail	0x1000		/* lp external loopback */

#define		DB_PROMVersion	4		/* Version number of EPROMs */
#define		DB_RAMVersion	6		/* Version number of running code */
#define		DB_PCAConfig	7		/* PCA configuration switch */
#define			D_NoSelfTestEnbl  0x01
#define			D_LoopBackCnctr	  0x02
#define			D_TestForever	  0x04
#define			D_PCVersMask	  0x30
#define			D_NoLanceLoaded	  0x40
#define			D_CompleteLoad	  0x80
#define		DB_Halt		8		/* Writing nonzero word here traps to debugger */
#define		DB_Command	10		/* Commands to debug interface */
			/* debug command codes */
#define			DEnableIntCmd	1	/* Enable interrupts from debug command unit */
#define			DDisableIntCmd	2	/* Disable interrupts from debug command unit */
#define			DEnableBIntCmd	3	/* Enable interrupts from breakpoints */
#define			DDisableBIntCmd	4	/* Disable interrupts from breakpoints */
#define			DMoveToRAMCmd	5	/* Copy a block of data from DiagBuf to local RAM */
#define			DMoveFromRAMCmd	6	/* Copy a block of data from local RAM to DiagBuf */
#define			DExecuteCmd	7	/* Go directly to a location in code */
#define			DResumeCmd	8	/* Resume execution, and wait for BP */
#define			DReadIOWordCmd	9	/* Perform an IO read word into shared memory */
#define			DReadIOByteCmd	10	/* Perform an IO read byte into shared memory */
#define			DWriteIOWordCmd	11	/* Perform an IO write word from shared memory */
#define			DWriteIOByteCmd	12	/* Perform an IO write byte from shared memory */
#define			DCallCmd	13	/* Call a procedure, and interrupt */
#define			DReadRegsCmd	14	/* Move saved registers from stack to DiagBuf */
#define			DWriteRegsCmd	15	/* Move reg. values from DiagBuf to stack */
#define			DMoveToBuf	16
#define			DMoveFromBuf	17
#define			DWriteForever	18
#define			DReadForever	19
#define			DLastCommand	19
#define		DB_Error		11
#define			DB_ErOK		0
#define			DB_BadCmdErr	1	/* Unknown command */
#define			DB_BadIntErr	2	/* Unexpected interrupt type */
#define		DB_BreakMode	12		/* Types of Breakpoint interrupts */
#define			DB_noBreak	0	/* nop */
#define			DB_BPBreak	1	/* Breakpoint was encountered */
#define			DB_SSBreak	2	/* Single step trap */
#define			DB_UnexpectedInt 3	/* Bad 8086 interrupt vector */
#define			DB_HaltInt	4	/* Board was requested to enter Debug interface */
#define		DB_Count	14		/* Count for transfer commands */
#define		DB_Addr		16		/* Address for transfer commands */
#define		DB_Segment	18		/* Segment to be used in transfers */
#define		DB_IORdData	20		/* Data returned from IORead commands */
#define		DB_IOWriteData	22		/* Data to be used in IO write commands */
#define		DB_IOWriteData2	24
#define		DB_IPReg	26		/* Instruction pointer for Exec, Call */
#define		DB_CSReg	28		/* Code Segment for Exec, Call */
#define		DB_CurrentTest  30		/* diagnostics put test # here */
#define		DB_InitDone	32		/* code writes here when init complete */
#define DebugCBEnd	0x0FF

	/* Terminal Control Blocks */
#define	TermCBs		0x100
#define	TCBSize		0x20
#define	TCB0		0x100
#define	TCB1		0x120
#define	TCB2		0x140
#define	TCB3		0x160
#define	TCB4		0x180
#define	TCB5		0x1A0
#define	TCB6		0x1C0
#define	TCB7		0x1E0
		/* Offsets of Elements of TCBs */
#define		TCBReadHead             0x00	/* Pointer to head of read data Queue */
#define		TCBReadTail             0x02	/* Pointer to tail of read data Queue */
#define		TCBWriteHead            0x04	/* Pointer to head of write data Queue */
#define		TCBWriteTail            0x06	/* Pointer to tail of write data Queue */
#define		TCBR0Interrupt          0x08	/* Chip Reg0 from interrupt */
#define		TCBR0Return             0x09	/* Chip Reg0 from read command */
#define		TCBR2Return             0x0A	/* Chip Reg2 from read command */
#define		TCBR1Return             0x0B	/* Chip Reg1 from read command */
#define		TCBStopOutput           0x0C	/* Ridge stop output byte */
#define		TCBOutputControl        0x0D	/* 8086 output control byte */
#define		TCBRidgeStopChar        0x0E	/* current stop character */
#define		TCBRidgeStartChar       0x0F	/* current start character */
#define		TCBCmdPtr               0x10	/* command list pointer */
#define		TCBOverflow             0x11	/* receive buffer overflow flag */
#define		TCBCmdList              0x12	/* Contains 7 command words */
			/* Terminal Control Commands */
#define			TWrReg0			0	/* Write to chip reg. 0 */
#define			TWrReg1			1	/* Write to chip reg. 1 */
#define				TEnParity	0x15	/* Enables input parity checking */
#define				TDisParity	0x1D	/* Disables input parity checking */
#define			TWrReg2			2	/* Write to chip reg. 2 */
#define			TWrReg3			3	/* Write to chip reg. 3 */
				/* Bit field definitions for reg 3 */
#define				TRCharSize5	0x00	/* bits 7,6 = 0, 0 -> 5 bit recv. chars */
#define				TRCharSize6	0x40	/* bits 7,6 = 0, 1 -> 6 bit recv. chars */
#define				TRCharSize7	0x80	/* bits 7,6 = 1, 0 -> 7 bit recv. chars */
#define				TRCharSize8	0xC0	/* bits 7,6 = 1, 1 -> 8 bit recv. chars */
#define				TAutoEnables	0x20	/* DCD enables rcv; CTS enables send */
#define				TRecvEnable	0x01	/* should always be on */
#define			TWrReg4			4	/* Write to chip reg. 4 */
				/* Bit field definitions for reg 4 */
#define				Tx1Clk		0x00	/* bits 7,6 = 0, 0 -> x1 clock */
#define				Tx16Clk		0x00	/* bits 7,6 = 0, 1 -> x16 clock */
#define				Tx32Clk		0x00	/* bits 7,6 = 1, 0 -> x32 clock */
#define				Tx64Clk		0x00	/* bits 7,6 = 1, 1 -> x64 clock */
#define				T1StopBit	0x04	/* bits 3,2 = 0, 1 -> 1   stop bit */
#define				T1_5StopBit	0x04	/* bits 3,2 = 1, 0 -> 1.5 stop bit */
#define				T2StopBit	0x04	/* bits 3,2 = 1, 1 -> 2   stop bit */
#define			TWrReg5			5	/* Write to chip reg. 5 */
				/* Bit field definitions for reg 5 */
#define				TDtr		0x80	/* sets DTR on */
#define				TTCharSize5	0x00	/* bits 6,5 = 0, 0 -> 5 bit xmit chars */
#define				TTCharSize6	0x20	/* bits 6,5 = 0, 1 -> 6 bit xmit chars */
#define				TTCharSize7	0x40	/* bits 6,5 = 1, 0 -> 7 bit xmit chars */
#define				TTCharSize8	0x60	/* bits 6,5 = 1, 1 -> 8 bit xmit chars */
#define				TBreakMode	0x10	/* sets break mode on */
#define				TXmitEnable	0x08	/* should always be on */
#define				TRts		0x02	/* sets RTS on */
#define			TWrReg6			6	/* Write to chip reg. 6 */
#define			TWrReg7			7	/* Write to chip reg. 7 */
#define			TRdReg0			8	/* Read chip reg. 0	*/
				/* Bit field definitions for reg 0 */
#define				TBreak		0x80	/* break status */
#define				TCts		0x20	/* CTS status */
#define				TDsr		0x10	/* DSR status */
#define				TDcd		0x08	/* DCD status */
#define				TXmitBufEmpty	0x04	/* not useful to ridge */
#define				TIntrPending	0x02	/* not useful to ridge */
#define				TRecvCharAvail	0x01	/* not useful to ridge */
#define			TRdReg1			9	/* Read chip reg. 1	*/
#define			TRdReg2			10	/* Read chip reg. 2	*/
#define			TSetBaudRate		11
				/* Baud rate codes */
#define				T50Baud			1
#define				T75Baud			2
#define				T110Baud		3
#define				T134_5Baud		4
#define				T150Baud		5
#define				T200Baud		6
#define				T300Baud		7
#define				T600Baud		8
#define				T1200Baud		9
#define				T1800Baud		10
#define				T2400Baud		11
#define				T4800Baud		12
#define				T9600Baud		13
#define				T19200Baud		14
#define			TClearFlowCtrl		12
#define			TSetIXOn		13
#define			TSetIXOnIXAny		14
#define			TSetIXOnIXOff		15
#define			TSetIXOnIXOffIXAny	16
#define			TSetIXOff		17
#define			TSetRtsHS		18
#define			TReserved1		19
#define			TWriteHiPri		20
#define			TClearStopFlag		21
#define			TClearOutputCtrl	22
#define			TFlushOutput		23
#define			TFlushInput		24
#define			TFlushBoth		25
#define			TSendInterrupt		26
#define			TSetIntTimer		27

/* The following buffer is used by the Debugger, and by diagnostics */
#define	DiagBuffer	0x200
		/* The debugger copies the saved registers from/to these offsets */
#define		SSOffset	0
#define		ESOffset	2
#define		DSOffset	4
#define		SPOffset	6
#define		BPOffset	8
#define		DIOffset	10
#define		SIOffset	12
#define		DXOffset	14
#define		CXOffset	16
#define		BXOffset	18
#define		AXOffset	20
#define		IPOffset	22
#define		CSOffset	24
#define		FlOffset	26
#define		NumRegs	14

/*  Power on test variables defined here */
#define	RequestWord	0x0280	/*dw*/		/* used by BLT code to select tests to be run */
/* BLT control bytes */
#define	D_flaketrap	0x0282 /*db*/		/* if set tests will repeat */
#define	D_continue	0x0283 /*db*/		/* continuous mode request flag */
#define	D_squealer	0x0284 /*db*/		/* overall error report */
#define	D_allign1	0x0285 /*db*/

/* Control block used by diagnostics */
#define	NDiagCB	0x0286
		/* Diagnostic CB fields */
#define		ND_Rsvd1	0x0000 /*dw*/
#define		ND_Rsvd2	0x0002 /*dw*/
#define		ND_Command	0x0004 /*db*/	/* host writes a command here */
#define		ND_Error	0x0005 /*db*/	/* 8086 posts error/status code here */
#define		ND_Count	0x0006 /*dw*/	/* count for copy commands */
#define		ND_Addr		0x0008 /*dw*/	/* local Mem or IO address */
#define		ND_Segment	0x000A /*dw*/	/* ?for use by generic move commands */
#define		ND_IORdData	0x000C /*dw*/	/* for read IO command */
#define		ND_IOWrData	0x000E /*dw*/	/* for write IO command */
#define		ND_IOWrData2	0x0010 /*dw*/	/* ?used by write forever command */
#define		ND_Rsvd3	0x0012 /*dw*/
#define		ND_Rsvd4	0x0014 /*dw*/
#define		ND_Rsvd5	0x0016 /*dw*/
#define		ND_Rsvd6	0x0018 /*dw*/
			/* Test Codes - saved in D_CurrentTest, and displayed on LED's */
#define			D_mem		0x001	/* local memory test */
#define			D_smem		0x002	/* shared memory test */
#define			D_lancebus	0x003	/* lance bus test */
#define			D_lanceinit	0x004	/* lance initialization test */
#define			D_DMAct		0x005	/* DMA counter test */
#define			D_Timer		0x006	/* 8254 timer test */
#define			D_DMA		0x007	/* DMA 8237 and Ridge xfer test */
#define			D_Sio		0x008	/* Sio test */
#define			D_scsiintloop	0x009	/* scsi internal data loopback test */
#define			D_scsiprior	0x00a	/* scsi priority setting check */
#define			D_rdgDMA   	0x00b	/* ridge DMA test */
#define			D_SioLoop	0x00c	/* Sio loopback test */
#define			D_lpextloop	0x00d	/* lp external loopback test */


/* Test Report locations */
	/* Local Memory Test Reports */
#define	lmemfailexp	0x02A0 /*dw*/		/* expected response at failure of local mem test */
#define	lmemfailact	0x02A2 /*dw*/		/* actual response at failure of local mem test */
#define	lmemfailaddr	0x02A4 /*dw*/		/* address at failure of local mem test */
	/* TestSMem */
#define	smemfailexp	0x02A6 /*dw*/		/* expected response at failure of smem test */
#define	smemfailact	0x02A8 /*dw*/		/* actual response at failure of smem test */
#define	smemfailaddr	0x02AA /*dw*/		/* address at failure of shared mem test */
	/* testlancebus */
#define	lancebitfail	0x02AC /*dw*/		/* records bits which failed in lancebustest */
	/* testlance */
#define	lancestat	0x02AE /*dw*/		/* status word from CSR0 after timeout */
#define	lancedataexp	0x02B0 /*dw*/		/* expected data transmitted, internal loop */
#define	lancedataact	0x02B2 /*dw*/		/* actual data received, internal loop */
#define	lancedataaddr	0x02B4 /*dw*/		/* smem address at failure of internal loop */
	/* TestDMActr */
#define	DMActbitFail 	0x02B6 /*dw*/		/* failed bit in write/read bit test */
#define	DMActFailexp	0x02B8 /*dw*/		/* expected count at failure of count test. */
#define	DMActFailact 	0x02BA /*dw*/		/* actual count at failure of count test. */
	/* TestTimers */
#define	whichcounter	0x02BC /*dw*/		/* used in TestTimers Indicates which counter tested */
#define	timestatexp	0x02BE /*db*/		/* expected status from 8254 timers */
#define	timestatact	0x02BF /*db*/		/* actual status from 8254 timers */
#define	TimerFailexp	0x02C0 /*db*/		/* expected response at failure */
#define	TimerFailact	0x02C1 /*db*/		/* actual response at failure  */
	/* dma8237 */
#define	fail8237exp	0x02C2 /*dw*/		/* expected response at failure of bit test */
#define	fail8237act	0x02C4 /*dw*/		/* actual response at failure of bit test	 */
	/* SioTest */
#define	SioFailexp	0x02C6 /*db*/		/* expected response at failure */
#define	SioFailact	0x02C7 /*db*/		/* actual response at failure */
#define	thisSIO		0x02C8 /*db*/		/* which SIO failed */
	/* SCSI internal data loopback test */
#define	scsidataexp	0x02C9 /*db*/		/* expected response at failure */
#define	scsidataact	0x02CA /*db*/		/* actual response */
	/* RdPrior */
#define	scsifailpri	0x02CB /*db*/		/* priority read from scsi switch */
	/* dmaridge */
#define	DMAxferAdrLo	0x02CC /*dw*/		/* low Ridge address at failure of xfer test	 */
#define	DMAxferAdrHi	0x02CE /*dw*/		/* high Ridge address at failure of xfer test */
#define	DMAxferExp	0x02D0 /*db*/		/* expected data at failure of xfer test */
#define	DMAxferAct	0x02D1 /*db*/		/* actual data at failure of xfer test */
#define	DMAsmemfail	0x02D2 /*dw*/		/* shared memory address at failure of xfer test */
	/* Sio Loopback */
#define	loopfailexp	0x02D4 /*db*/		/* data sent out transmit SIO at failure */
#define	loopfailact	0x02D5 /*db*/		/* data received during SIO external loop */
#define	WhichSIO	0x02D6 /*dw*/		/* which SIO xmit and receive pair failed */
#define	BufNotMT	0x02D8 /*db*/		/* non zero is transmit buffer not empty flag */
#define	looptimeout	0x02D9 /*db*/		/* timeout flag waiting for receive interrupt */
#define	rs232fail	0x02DA /*db*/		/* rs232 driver/receiver failure report */
#define	dsrfailexp	0x02DB /*db*/		/* loopback dsr signals sent */
#define	dsrfailact	0x02DC /*db*/		/* loopback dsr signals received from 13S (255 F) */
	/* LP/SCSI external loopback test */
#define	lpctrlfail	0x02DD /*db*/		/* saves indication of lp control that failed loopback */
#define	lploopexp	0x02DE /*db*/		/* expected response at failure */
#define	lploopact	0x02DF /*db*/		/* actual response */

#define	LanceQBegin	0x300	/* beginning of Lance Interrupt Q */
#define	LanceQEnd	0x3FE	/* end of Lance Interrupt Q */
#define LanceQLoc	0x300
#define XmitRingLoc	0x400	/* beginning of transmit descriptor ring */
#define RecvRingLoc	0x800	/* beginning of receive descriptor ring */
#define UnusedSMLoc	0xC00

/* SCSI Device control blocks */
#define ScsiCBs		0x1000
#define	ScsiCBSize	0x080
#define	sTapeCB0	0x1000
#define	sTapeCB1	0x1080
#define	ScsiDiscCB0	0x1100
#define	ScsiDiscCB1	0x1180
#define	ScsiCB4		0x1200
#define	ScsiCB5		0x1280
#define	ScsiCB6		0x1300
#define	ScsiCB7		0x1380
#define	ScsiCB8		0x1400
#define	ScsiCB9		0x1480
#define	ScsiCB10	0x1500
#define	ScsiCB11	0x1580
#define	ScsiCB12	0x1600
#define	ScsiCB13	0x1680
#define	ScsiCB14	0x1700
#define	ScsiCB15	0x1780

		/* This portion is for use by the 8086 exclusively. */
#define		sDataPtr	0x00 /*dw*/
#define		sCmdPtr		0x02 /*dw*/
#define		sStatusPtr	0x04 /*dw*/
#define		sActive		0x06 /*db*/
#define		sSpare1		0x07 /*db*/
#define		sSavedDataPtr	0x08 /*dw*/
#define		sMsgVector	0x0A /*dw*/

		/* This portion is used by the driver to control data transfers */
#define		sStartIO	0x0C /*db*/	/* write non-zero to start operation */
#define		sOrderType	0x0D /*db*/	/* Direction - 0 = Read;  1 = Write */
			/* Order Types */
#define			sReadType	0
#define			sWriteType	1
#define			sDiagReadType	8
#define			sDiagWriteType	9
#define		sIdentifyMsg  0x0E /*db*/	/* Message sent to Device to identify host */
			/* Identify message format */
#define			sIdentBit	0x80	/* This bit must be on in identify message */
#define			sCanReconnect	0x40	/* This should be on to indicate we can reconnect */
			/* Device's Logical Unit # must be last 3 bits of above byte */
#define		sAuxMsg		0x0F /*db*/	/* for later use to talk to a processor */
#define		sRidgeDevNum	0x10 /*db*/	/* interrupt unit number for this device (8-15) */
#define		sTargetId	0x11 /*db*/	/* SCSI ID num of target device */
#define			sTape0ID	6
#define			sDisc0ID	7
#define		sXferCntMsb	0x12 /*dw*/	/* high part of transfer byte count */
#define		sXferCntLsb	0x14 /*dw*/	/* lower 16 bits of byte count */

		/* Up to 3 commands may be executed with one start IO */
#define		sCmdSet1	0x16 /*db12*/	/* 12 command bytes to be sent to device */
#define		sScsiStatus1	0x22 /*db*/	/* Status byte returned by device */
			/* SCSI status bit fields */
#define			sStatRsvd		0x80	/* 1st bit of status byte is reserved */
#define			sStatVendorMask		0x61	/* 3 bits are Vendor unique */
#define			sStatCodeMask		0x1E	/* status code is remaining 4 bits */
				/* SCSI Status codes */
#define				sStatGood	0x00	/* command completed successfully */
#define				sStatCheckCond	0x02	/* host should issue request sense cmd */
#define				sStatCondMet	0x04	/* search data cmd completed */
#define				sStatBusy	0x08	/* target unable to accept command */
#define				sStatIGood	0x10	/* Intermed./Good - linked cmd completed */
#define				sStatICondMet	0x14	/* linked search completed */
#define				sStatRsvConf	0x18	/* exclusive access violation */
#define		sRidgeStatus1	0x23 /*db*/	/* Status byte returned by Ridge host adapter */
			/* Ridge status codes */
#define			sScsiTimeOut		1	/* bus timeout */
#define			sDma2BitErr		2	/* double bit Ridge DMA memory error */
#define			sBusError		3	/* scsi protocol error */
#define			sBusReset		4	/* someone reset scsi bus */
#define			sXferCntErr		5	/* device xfer count did not match request */
		/* second command set */
#define		sCmdSet2	0x24 /*db12*/
#define		sScsiStatus2	0x30 /*db*/
#define		sRidgeStatus2	0x31 /*db*/
		/* third command set */
#define		sCmdset3	0x32 /*db12*/
#define		sScsiStatus3	0x3E /*db*/
#define		sRidgeStatus3	0x3F /*db*/

#define		sPages        0x40 /* dw 32*/	/* List of 16 32 bit page addresses to use
						   to satisfy the transfer count          */
#define LPBuffer	0x1800
#define TermBuffers	0x2000
#define		TermBufSize	0x200
#define		TermRdBufs	0x2000
#define			Term0RdBuf	0x2000
#define			Term1RdBuf	0x2200
#define			Term2RdBuf	0x2400
#define			Term3RdBuf	0x2600
#define			Term4RdBuf	0x2800
#define			Term5RdBuf	0x2a00
#define			Term6RdBuf	0x2c00
#define			Term7RdBuf	0x2e00
#define		TermWrBufs	0x3000
#define			Term0WrBuf	0x3000
#define			Term1WrBuf	0x3200
#define			Term2WrBuf	0x3400
#define			Term3WrBuf	0x3600
#define			Term4WrBuf	0x3800
#define			Term5WrBuf	0x3a00
#define			Term6WrBuf	0x3c00
#define			Term7WrBuf	0x3e00
