(* @(#)stdio.h	5.4	6/10/86 *)
{This is a translation of the standard C stdio.h. The translation was manual
 but the right way to do it is automatically
}
#include <pas/ctypes.h>
#ifndef _NFILE
#define _NFILE	64

#define BUFSIZ	4096

(* buffer size for multi-character output to unbuffered files *)
#define _SBFSIZ 8

type 
     FILE_DESCRIPTOR = record
        _cnt: integer;
	_ptr: ^ u_char;
	_base: ^ u_char;
	_flag: char;
	_file: char
     end;

     FILE_PTR = ^FILE_DESCRIPTOR;

{*** The next two types allow the overriding of Pascal pointer type checking}
{*** These will be used in library routines                                 }
     GENERIC_FILE = text; {text or binary, actually}
     GENERIC_POINTER = integer;

(*
 * _IOLBF means that a file's output will be buffered line by line
 * In addition to being flags, _IONBF, _IOLBF and _IOFBF are possible
 * values for "type" in setvbuf.
 *)
{
#define _IOFBF		0000
#define _IOREAD		0001
#define _IOWRT		0002
#define _IONBF		0004
#define _IOMYBUF	0010
#define _IOEOF		0020
#define _IOERR		0040
#define _IOLBF		0100
#define _IORW		0200
}
#define _IOFBF		0
#define _IOREAD		1
#define _IOWRT		2
#define _IONBF		4
#define _IOMYBUF	8
#define _IOEOF		16
#define _IOERR		32
#define _IOLBF		64
#define _IORW		128

#ifndef NULL
#define NULL		0
#endif
#ifndef EOF
#define EOF		(-1)
#endif

#define stdin		(&_iob[0])
#define stdout		(&_iob[1])
#define stderr		(&_iob[2])

{
#define _bufend(p)	_bufendtab[(p)->_file]
#define _bufsiz(p)	(_bufend(p) - (p)->_base)
}

{
#ifndef lint
#define getc(p)		(--(p)->_cnt < 0 ? _filbuf(p) : (int) *(p)->_ptr++)
#define putc(x, p)	(--(p)->_cnt < 0 ? \
			_flsbuf((unsigned char) (x), (p)) : \
			(int) (*(p)->_ptr++ = (unsigned char) (x)))
#define getchar()	getc(stdin)
#define putchar(x)	putc((x), stdout)
#define clearerr(p)	((void) ((p)->_flag &= ~(_IOERR | _IOEOF)))
#define feof(p)		((p)->_flag & _IOEOF)
#define ferror(p)	((p)->_flag & _IOERR)
#define fileno(p)	(p)->_file
#endif
}


procedure setbuf (f: FILE_PTR; buf: GENERIC_POINTER); external;


function getfp (var f: GENERIC_FILE): FILE_PTR; external;


{
******** the following externals should eventually be added. Wait to see
	 if there is use for them.
********
extern char	*ctermid(), *cuserid(), *fgets(), *gets(), *tempnam(), *tmpnam();
extern unsigned char *_bufendtab[];
}

#define L_ctermid	20
#define L_cuserid	9
{
#define P_tmpdir	"/usr/tmp/"
#define L_tmpnam	(sizeof(P_tmpdir) + 15)
}
#endif

