(* @(#)a.out.h	5.4  6/10/86 *)
#include <pas/ctypes.h>

type

{------------- Header prepended to each object and executeable --------------}

    ucb_exec = record
	a_magic  : u_short;  { magic number              }
	r_bra    : u_short;  { branch offset highvalue   }
	r_brb    : u_short;  { branch offset lowvalue    }
	a_type   : u_short;  { type field for um         }
	a_version: u_long;   { version field for um      }
	a_text   : u_long;   { size of text segment      }
	a_data   : u_long;   { size of initialized data  }
	a_bss    : u_long;   { size of unitialized data  }
	a_syms   : u_long;   { size of symbol table      }
	a_entry  : u_long;   { entry point               }
	a_trsize : u_long;   { size of text relocation   }
	a_drsize : u_long;   { size of data relocation   }
    end;


#define r_EXECSIZE 40
#define r_BRVAL    40

{ #define MAGIC  0x09b00 }
{ #define MAGIC1 0x09b01 }
#define MAGIC  39680
#define MAGIC1 39681

#define N_BADMAG(x) ( (x.a_magic<>MAGIC) and (x.a_magic<>MAGIC1) )
#define N_TXTOFF(x) ( 10 { really size of exec structure } )
#define N_SYMOFF(x) (N_TXTOFF(x) + x.a_text+x.a_data + x.a_trsize+x.a_drsize)
#define N_STROFF(x) (N_SYMOFF(x) + x.a_syms)


{---------------- format of relocation datum (real thing ) ----------------}

    ucb_relocation_info = record
	r_address : int;
	r_other   : word;
    end;

{---------------- format of relocation datum ( fake version )   -----------}

    ucb_fakereloc_info = record
	r_address   : int;    { address which is relocated }
	r_symbolnum : Bits24; { local symbol ordinal }
	r_pcrel     : Bits1;  { was relocated pc relative already }
	r_length    : Bits2;  { 0=byte, 1=word, 2=long }
	r_extern    : Bits1;  { does not include value of sym referenced  }
	r_relocate  : Bits4;  { 1 => special relocation datum for Ridge   }
			      { points to load or laddr that needs to be  }
			      { fixed up to point to the correct section, }
			      { i.e. opcode changed by 0x20		  }
    end;


{------------------ format of symbol table entry ------------------}

    ucb_n_un_type  = record
      case integer of
        0: (pn_name : charptr); { for use when in-core         }
        1: (n_strx  : long);    { index into file string table }
    end;

    ucb_nlist = record
	n_un    : ucb_n_un_type;
	n_type  : u_char;         { type flag, i.e. N_TEXT etc; see below  }
	n_other : u_char;         { unused                                 }
	n_desc  : short;          { see "stab.h"                           }
	n_value : u_long;         { value of this symbol (or sdb offset    }
    end;

#define N_UNDF  0	{ undefined                   }
#define N_ABS   2	{ absolute                    }
#define N_TEXT  4	{ text                        }
#define N_DATA  6	{ data                        }
#define N_BSS   8	{ bss                         }
#define N_COMM  18	{ common (internal to ld)     }
#define N_FN    31	{ file name symbol            }

#define N_EXT	1	{ exteranl bit, or'd in       }
{ #define N_TYPE  30	{ mask for all the type bits  }
