/*	<@(#)max2.h	22.1	86/12/05>	*/


/******************************************************************************
*
* TITRE       :	max2.h
*
* AUTEUR      :	schiehle
*
* DATE        : 31-07-85
*
* FONCTION    :	structures et constantes utilisees par la methode
*		d'acces x25-2
*
* ENTREE      :	
*
*
* SORTIE      :	
*
*
* REMARQUES   :	
*
******************************************************************************/

/*************************************************************
*   structure d'un descripteur de donnees
*************************************************************/

typedef struct desc {
	char	*adr ;		/* adresse des donnees			*/
unsigned short	lg ;		/* longueur des donnees			*/
unsigned short	depl ;		/* deplacement en debut de chaine	*/
} Tdesc ;

/*************************************************************
*   structure LCB
*************************************************************/

typedef struct lcb {
unsigned char	ident[3] ;	/* identification 'LCB'		*/
unsigned char	version	;	/* version			*/
unsigned long	idsys  ;	/* ident systeme		*/
unsigned long	iduser ;	/* ident utilisateur		*/
unsigned short	signal ;	/* signal recu			*/
unsigned short  indic  ;	/* indicateurs			*/
unsigned long	retour ;	/* code retour			*/
} Tlcb ;

/*************************************************************
*   structure UCB
*************************************************************/

typedef struct ucb {
unsigned char	ident	;	/* identification 'U'		*/
unsigned char	version	;	/* version			*/
unsigned short	nbinfo	;	/* lg partie info		*/
unsigned char	nbdescout ;	/* nbre descripteurs en sortie	*/
unsigned char	nbdescin  ;	/* nbre descripteurs en entree	*/
unsigned short	r12 ;
unsigned long	r20 ;
unsigned long	r30 ;
unsigned char	r40 ;
unsigned char	tamd ;		/* unite destinataire		*/
unsigned short	r42 ;
unsigned long	r50 ;
unsigned short	r60 ;
unsigned short	requete ;	/* code requete			*/
unsigned long	retour ;	/* code retour			*/
	Tdesc	desc[8] ;	/* zone des descripteurs	*/
} Tucb ;

/******************************************************************************
* structure de la table de site
******************************************************************************/

typedef struct site {
unsigned char	liaison[4] ;	/* nom de la liaison			*/

unsigned short	lgnum ;		/* longueur numero d'appel		*/
unsigned char	num[256] ;	/* numero d'appel code BCD		*/
} Tsite ;

/* requetes utilisateurs	*/
/********************************/

#define RQ_OPEN		17	/* ouverture de connexion		*/
#define RQ_WAIT_OPEN	18	/* attente de connexion entrante	*/
#define RQ_CLOSE	19	/* fermeture de connexion		*/
#define RQ_SEND		20	/* emission de message normal		*/
#define RQ_READ		21	/* lecture de signal			*/
#define RQ_TEST		22	/* test de signal			*/

#define IND_D		4	/* indicateur d'attente d'acquittement	*/

/* signaux transmis a l'utilisateur	*/
/****************************************/

#define SIG_DATA	2	/* message recu				*/
#define SIG_RESET	3	/* reinitialisation de la liaison	*/
#define SIG_CLOSE	4	/* fermeture de la liaison		*/

/* indice des descripteurs ( par rapport au 1er desc du meme type OUT ou IN */
/****************************************************************************/

#define LCBO	0	/* LCB OUT					*/
#define DATAO	1	/* donnees OUT					*/
#define SITEO	1	/* table de site OUT				*/

#define LCBI	0	/* LCB IN					*/
#define DATAI	1	/* donnees IN					*/

/* longueurs de structures ou de chaines	*/
/************************************************/

#define	LGLCB		20	/* lg LCB				*/
#define LGSITE	       262	/* lg max table de SITE			*/

/* Codes retour des UCB							     */
/*****************************************************************************/

#define	OK_MAX2		0x26000000	/* requete executee normalement	*/
#define ER_NO_SIG	0x26000002	/* pas de signal en attente	*/
#define ER_CLOSE	0x26000003	/* fermeture en cours		*/
#define ER_RESET	0x26000004	/* reinitialisation en cours	*/
#define ER_OPEN		0x26000005	/* ouverture en cours		*/

#define ER_UCB_IDENT	0x26010010	/* erreur identification UCB	*/
#define ER_UCB_VERSION	0x26010011	/* erreur version UCB		*/

#define ER_NBINFO	0x26010020	/* erreur nbinfo		*/
#define ER_NBDESCOUT	0x26010021	/* erreur nbdescout		*/
#define ER_NBDESCIN	0x26010022	/* erreur nbdescin		*/
#define ER_REQ_UNKNOWN	0x26010023	/* requete inconnue		*/
#define ER_REQ_SAME	0x26010024	/* requete identique en cours	*/

#define ER_LCB_SIZE	0x26010030	/* erreur taille LCB		*/
#define ER_LCB_IDENT	0x26010031	/* erreur identification LCB	*/
#define ER_LCB_VERSION	0x26010032	/* erreur version LCB		*/
#define ER_LCB_IN	0x26010034	/* taille LCB IN trop petite	*/
#define ER_LCB_DEPL	0x26010035	/* deplacement LCB non nul	*/

#define ER_CNX_UNKNOWN	0x26010040	/* connexion inexistante	*/
#define ER_CNX_SAT	0x26010041	/* saturation connexions	*/
#define ER_CTX_SAT	0x26010042	/* saturation contextes		*/

#define ER_SITE_SIZE	0x26010050	/* erreur taille table de site	*/
#define ER_LK_UNKNOWN	0x26010052	/* liaison inconnue		*/
#define ER_LK_USED	0x26010053	/* liaison utilisee		*/
#define ER_NUM_SIZE	0x26010054	/* erreur longueur numero appel	*/
#define ER_LK_REFUSED	0x2601005a	/* ouverture liaison refusee	*/

#define ER_DATA_IN	0x26010060	/* taille reception trop petite */
#define ER_DATA_OUT	0x26010061	/* taille emission trop grande	*/
#define ER_DATA_DEPL	0x26010063	/* deplacement < 4		*/

/* Codes retour LCB des refus d'ouverture de connexion			*/

#define OPEN_LK01       0x02010001      /* non reponse distante		*/
#define OPEN_LK02       0x02010002      /* reponse DM a l'ouverture	*/
#define LK_USED		0x02010003      /* liaison deja utilisee	*/

#define OPEN_LN01	0x01010303      /* non ouverture de ligne	*/
 
/* Codes retour LCB des signaux de reinitialisation de liaison		*/

#define REI_LK01	0x82000000	/* reinit distante (SABM recu)	*/
#define REI_LK02 	0x02000000      /* reinit locale sans FRMR recu	*/
#define REI_LK03	0x02000001      /* reinit locale sur FRMR recu	*/
 
/* Codes retour LCB des signaux de deconnexion de liaison		*/

#define FER_LK01	0x82000000	/* fermeture distante (DISC recu)*/
#define FER_LK02	0x02010001      /* echec de reinitialisation	*/
					/*  (non reponse du distant)	*/
#define FER_LK03	0x02010002      /* echec de reinitialisation	*/
					/*  ( DM recu)			*/

