/*	@(#)maduif.h	20.1	*/
/*******************************************************/
/*     INTERFACE              MAD                      */
/*******************************************************/

/*------------------------------*/
/* Type des commandes des ioctl */
/*------------------------------*/

#define  REQUETE        1
#define  RECEPTION      2
#define  REPONSE        3
#define  ACTISER        4
#define  DESACTISER     5





/*---------------*/
/* Mode sur open */
/*---------------*/

#define GLOBAL          0x8000
#define LOCAL		0






/*-----------------------*/
/* Move de l'UCB reponse */
/*-----------------------*/

#define MOVE            1
#define NON_MOVE        0







/*--------------------*/
/* Type de l'UCB recu */
/*--------------------*/

#define ICB_IND         0
#define UCB_REQ         2
#define UCB_REP         3







/*--------------------------------------------------------*/
/* code fonction des UCB speciaux de chargement de tables */
/*--------------------------------------------------------*/

#define RQ_CHARGE_ROUT 201 /* chargement table de routage (SC7)*/
#define RQ_LIRE_ROUT   202 /* lecture table de routage   (SC7) */

#define RQ_CHARGE_SERV 203 /* chargement table de service */
#define RQ_LIRE_SERV   204 /* lecture table de service    */
#define RQ_CHARGE_SITE 207 /* chargement d'une table de site */
#define RQ_LIRE_SITE   208 /* lecture d'une table de site    */







/*---------------------------------*/
/* Erreurs retournees sur un ioctl */
/*---------------------------------*/

#define  ER_CODREQINV            0x30  /* code requete inconnu                */
#define  ER_DEVOCCUPE            0x31  /* device occupe (deja ouvert)         */
#define  ER_LGINFOINV            0x32  /* longueur champ info impaire         */
#define  ER_UN_INC               0x33  /* unite destinataire inconnue	      */
#define  ER_UN_NON               0x34  /* unite destinataire non init.        */
#define  ER_SC7INAC              0x35  /* SC7 ou SC9 inaccessible             */
#define  ER_SERV_INC             0x36  /* service inconnu                     */
#define  ER_SERV_NON_ACTIV       0x37  /* service non actif                   */
#define  ER_DON_TRONQ            0x38  /* donnees tronquees                   */
#define	 ER_TYPUCB_INC           0x39  /* type d'UCB recu inconnu             */
#define  ER_UTI_INC              0x3a  /* utilisateur inconnu		      */
#define  ER_SERV_ACTIF           0x3c  /* service deja actif                  */
#define  ER_TAB_SAT              0x3d  /* tables systeme saturees             */
#define  ER_SERV_INT             0x3e  /* service interdit                    */
#define  ER_ADR_IMP              0x3f  /* adresse UCB impaire                 */
#define	 ER_SITE_INA             0x40  /* site inaccessible		      */
#define	 ER_FERM_RESEAU          0x41  /* fermeture du reseau		      */
#define  ER_SERV_CLOS            0x42  /* fermeture du service		      */
#define  ER_TYPBLOC_INC          0x43  /* type de bloc inconnu		      */
#define  ER_SC_HS                0x44  /* systeme de communication HS         */
#define  ER_CMDINV               0x47  /* code commande ioctl inconnu         */
#define  ER_GSME_NON_INIT        0x48  /* gestionnaire memoire non initialise */
#define  ER_SIGNAL               0x49  /* appel syst. interrompu par  signal  */
#define  ER_ADRINV               0x4a  /* adresse invalide                    */
#define  ER_LGTAMPUE             0x4b  /* tampon ME trop petit                */
#define  ER_MODE_MOVE            0x4c  /* mode inconnu                        */
#define  ER_NINFO                0x4d  /* erreur nbinfo                       */
#define  ER_NDESCIN              0x4e  /* erreur nombre de descripteurs in    */
#define  ER_NDESCOUT             0x4f  /* erreur nombre de descripteurs out   */
#define  ER_SITE_OUVERT          0x50  /* site deja ouvert                    */

#define  ER_INDEXCL              0x51
#define  ER_CTOS_SERV_INC        0x52
#define  ER_CTOS_SERV_ACTIF      0x53
#define  ER_CTOS_SERV_NON_ACTIF  0x54
#define  ER_TABUSER_SAT          0x55
#define  ER_USER_UNKNOWN         0x56
#define  ER_MAXREQREC            0x57
#define  ER_MAXREQENV            0x58
#define  ER_INDEXSE              0x59
#define  ER_OPEN_INCORRECT       0x5a
#define  ER_DEV_NOOPEN           0x5b
#define  ER_DEV_NOCTOS           0x5c
#define  ER_RECEP_LG             0x5d
#define  ER_TYPRQB_INC           0x5e


/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
/*                                                           */
/* si l'erreur n'appartient pas a cette liste                */
/*                                                           */
/*   consulter la liste des erreurs du systeme correspondant */
/*                                                           */
/*            ( R O S        ou       U N I X )              */
/*                                                           */
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/




/*--------------------------------------------------------------------------*/
/* structure d'un descripteur de zone parametre d'entree ou sortie d'un UCB */
/* ------------------------------------------------------------------------ */

struct ucb_descr
{
       char        *adrdata ;             /* adresse des donnees ou du descr. */
       unsigned short lgdata ;            /* longueur des donnees             */
       unsigned short depldata ;          /* deplacement du debut des donnees */
};

/*------------------------------------------------------------*/
/* structure de la partie fixe (en-tete) d'un UCB utilisateur */
/* ---------------------------------------------------------- */

struct ucb_util
{
       char        u ;                 /* 'U'                                */
       char        v ;                 /* numero de version                  */
       unsigned short nbinfo ;         /* longueur du champ facultatif 'info'*/
       unsigned char nbdescout ;       /* nbre de descripteurs en sortie     */
       unsigned char nbdescin ;        /*  "   "      "        "  entree     */
       short       res1 ;
       int	   res2 ;
       int	   res3 ;
       char	   res4 ;
       unsigned char   un_dest ;       /* unite destinataire                 */
       short	   res5 ;
       unsigned char   un_prl_dest ;   /* UT passerelle si syst. distant # 0 */
       unsigned char   sys_dest ;      /* systeme destinataire (0 si local)  */
       short	   res6 ;
       short	   res7 ;
       unsigned short  codreq ;        /* code requete                       */
       int 	   codret ;            /* compte-rendu de la requete         */
};

/*-------------------------------------------------*/
/*  structure interface IOCTL REQUETE              */
/*-------------------------------------------------*/
       

struct madrequete
{
        struct ucb_util *adrucb;      /* adresse en zone util. ucb a emettre */
        int            move;          /* UCB de reponse move                 */
};

/*-------------------------------------------------*/
/*  structure interface IOCTL RECEPTION            */
/*-------------------------------------------------*/

struct madreception
{
        int            delai;         /* attente ou non selon delai # ou = 0 */
        struct ucb_util *adrucb;      /* adresse en zone util. ucb a emettre */
                                      /* ou adresse du tampon en reception   */
        int            lgucb;         /* longueur du tampon utilisateur      */
        int            type_ucb;      /* type d'UCB recu, requete ou reponse */
};

/*-------------------------------------------------*/
/*  structure interface IOCTL REPONSE              */
/*-------------------------------------------------*/

struct madreponse
{
        struct ucb_util *adrucb;      /* adresse de l'UCB de reponse */
};

/*---------------------------------------------------------*/
/* structure  pour  chargement  et  lecture  de  service   */
/*---------------------------------------------------------*/

struct tab_service
{
        unsigned short service ;      /* numero de service a charger */
        unsigned short cod_req_min ;  /* numero de requete min       */
        unsigned short cod_req_max ;  /* numero de requete max       */
        unsigned short activite ;     /* indicateur d'activite du    */
                                      /* service (=0 au chargement)  */
};

/*---------------------------------------------------------*/
/* structure  pour  chargement  et  lecture  de  site      */
/*---------------------------------------------------------*/

struct  table_site
{
     char              stcl ;      /* classe de service 0,2,3 ou 4   */
     char              staltcl ;   /* classe alternee 0,2,3 ou 4     */
     short             stexp ;     /* flot express 1:oui   0:non     */
     short             stctrl ;    /* controle de flot 1:oui  0:non  */
     short             stcrdt ;    /* credit   1 a 15                */
     short             stltpdu ;   /* longueur tpdu (128 a 2048)     */
                                   /* doit etre une puissance de 2   */
     short             stcheck ;   /* champ de controle 1:oui        */
                                   /* uniquement si stcl = 4         */
     short             stlnsdu ;   /* longueur nsdu : >= stltpdu     */
     short             stlnpdu ;   /* longueur npdu :                */
                                   /* transpac : 128  RLE3 : 1500    */
     char              stwi ;      /* fenetre reception reseau       */
     char              stwo ;      /* fenetre emission reseau        */
     char              stypres ;   /* type de reseau :               */
                                   /* transpac : 1    RLE3 : 2       */
     char              stcnx ;     /* type de connexion reseau :     */
                                   /* avec cnx : 0   sans cnx : 1    */
     unsigned short    ladrloc ;   /* lg. adresse reseau locale :    */
                                   /* transpac : lg en demi octet    */
                                   /* RLE3 : lg en octet             */
     unsigned char     adrloc[8] ; /* adresse reseau locale          */
     unsigned short    ladrdis ;   /* ld et adr reseau distante      */
     unsigned char     adrdis[8] ;
     unsigned short    lfac ;      /* longueur facilites transpac    */
     unsigned char     facil[10] ; /* facilites transpac             */

/*--------------------------------------------------------*/
/*                                                        */
/* ajouter les parametres TSAP appelant et TSAP appele.   */
/* Chaque parametre est de la forme :                     */
/*  - un octet (8 bits) contenant la longueur L du TSAP   */
/*  - un champ TSAP de L octets                           */
/*                                                        */
/*--------------------------------------------------------*/

} ;
