/* "@(#)mtio.h	5.1	6/6/86" */
/* THIS HEADER FILE CONTAINS RIDGE SPECIFIC INFORMATION */

/*
 * Structures and definitions for mag tape io control commands
 */

#ifndef _MTIO_
#define _MTIO_

#include <ros/mtio.h>
#include <ros/ioctl.h>

/* operations */
#define MTWEOF	BSD_MTWEOF	/* write an end-of-file record */
#define MTFSF	BSD_MTFSF	/* forward space file */
#define MTBSF	BSD_MTBSF	/* backward space file */
#define MTFSR	BSD_MTFSR	/* forward space record */
#define MTBSR	BSD_MTBSR	/* backward space record */
#define MTREW	BSD_MTREW	/* rewind */
#define MTOFFL	BSD_MTOFFL	/* rewind and put the drive offline */
#define MTNOP	BSD_MTNOP	/* no operation, sets status only */

/*
 * Constants for mt_type byte
 */
#define	MT_ISTS		BSD_MT_ISTS		
#define	MT_ISHT		BSD_MT_ISHT		
#define	MT_ISTM		BSD_MT_ISTM		
#define	MT_ISMT		BSD_MT_ISMT		
#define	MT_ISUT		BSD_MT_ISUT		
#define	MT_ISCPC	BSD_MT_ISCPC	
#define	MT_ISAR		BSD_MT_ISAR		

/* mag tape io control commands */
#define	MTIOCTOP	BSD_MTIOCTOP	/* do a mag tape op */
#define	MTIOCGET	BSD_MTIOCGET	/* get tape status */

#define	DEFTAPE	BSD_DEFTAPE	

#endif
