/* "@(#)mbuf.h	5.1	6/6/86" */
/* THIS HEADER FILE CONTAINS RIDGE SPECIFIC INFORMATION */

/*
 * Constants related to memory allocator.
 */
#define	MSIZE		128			/* size of an mbuf */
#define	MMINOFF		12			/* mbuf header length */
#define	MTAIL		4
#define	MMAXOFF		(MSIZE-MTAIL)		/* offset where data ends */
#define	MLEN		(MSIZE-MMINOFF-MTAIL)	/* mbuf data length */
#define MSHIFTCOUNT	7			/* amount to shift mbuf addr to */
						/* get index into buffer array */

/* size of buffer arrays */
#define MAXBUFS		800			/* allocate this many mbufs initially and */
						/*   this many additional mbufs as needed */
#define MAXBIGBUFS	100			/* allocate this many big bufs initially and */
						/*   this many additional big bufs as needed */
#define MAXMALLOC	4			/* maximum # of times we'll call malloc */
						/*   for more buffers off of the heap */


#define MBIGSIZE	PageSize		/* Big buffer size */
#define MNBIGBUFS       4                       /* Big data areas   */
#define MBUFSPERPAGE    PAGESIZE/MSIZE          /* # mbufs per page */
#define MNMBUFS         MBUFSPERPAGE * 4        /* 8 pages of mbufs = 32 * 8 */
#define MBIGSHIFTCOUNT	12			/* amount to shift bigbuf addr to */
						/* get index into bigbuffer array */

/* defines for types of memory allocation */
#define MPG_MBUFS       1                 
#define MPG_BIGBUFS     2                 

/*
 * Macros
 */

/* address in mbuf to mbuf head */
#define	dtom(x)		((struct mbuf *)((int)x & ~(MSIZE-1)))

/* mbuf head, to typed data */
#define	mtod(x,t)	((t)((int)(x) + (x)->m_off))

#define bcopy(from,to,length) memcpy(to, from, length)

struct mbuf {
	struct	mbuf *m_next;		/* next buffer in chain */
	u_long	m_off;			/* offset of data */
	short	m_len;			/* amount of data in this mbuf */
	short	m_type;			/* mbuf type (0 == free) */
	u_char	m_dat[MLEN];		/* data storage */
	struct	mbuf *m_act;		/* link in higher-level mbuf list */
};

/* mbuf types */
#define	MT_FREE		0	/* should be on free list */
#define	MT_DATA		1	/* dynamic (data) allocation */
#define	MT_HEADER	2	/* packet header */
#define	MT_SOCKET	3	/* socket structure */
#define	MT_PCB		4	/* protocol control block */
#define	MT_RTABLE	5	/* routing tables */
#define	MT_HTABLE	6	/* IMP host tables */
#define	MT_ATABLE	7	/* address resolution tables */
#define	MT_SONAME	8	/* socket name */
#define	MT_ZOMBIE	9	/* zombie proc status */
#define	MT_SOOPTS	10	/* socket options */
#define	MT_FTABLE	11	/* fragment reassembly header */
#define MT_IOBUF	12	/* asynchronuous message header */
#define MT_MSG		13	/* asynchronuous message body */

/* flags to m_get */
#define	M_DONTWAIT	0
#define	M_WAIT		1

/* length to m_copy to copy all */
#define	M_COPYALL	1000000000

/*
 * Mbuf statistics.
 */
struct mbstat {
	short	m_mbufs;	/* mbufs obtained from page pool */
	short	m_mbfree;	/* mbufs on our free list */
	short	m_clusters;	/* clusters obtained from page pool */
	short	m_clfree;	/* free clusters */
	short	m_drops;	/* times failed to find space */
	short	m_mtypes[256];	/* type specific mbuf allocations */
};

