/* "@(#)signal.h	5.1	6/6/86" */

#ifndef	NSIG
#define NSIG	32

#define	SIGHUP	1	/* hangup */
#define	SIGINT	2	/* interrupt */
#define	SIGQUIT	3	/* quit */
#define	SIGILL	4	/* illegal instruction (not reset when caught) */
#define	    ILL_RESAD_FAULT	0x0	/* reserved addressing fault */
#define	    ILL_PRIVIN_FAULT	0x1	/* privileged instruction fault */
#define	    ILL_RESOP_FAULT	0x2	/* reserved operand fault */
/* CHME, CHMS, CHMU are not yet given back to users reasonably */
#define	SIGTRAP	5	/* trace trap (not reset when caught) */
#define	SIGIOT	6	/* IOT instruction */
#define	SIGEMT	7	/* EMT instruction */
#define	SIGFPE	8	/* floating point exception */
#define	    FPE_INTOVF_TRAP	0x1	/* integer overflow */
#define	    FPE_INTDIV_TRAP	0x2	/* integer divide by zero */
#define	    FPE_FLTOVF_TRAP	0x3	/* floating overflow */
#define	    FPE_FLTDIV_TRAP	0x4	/* floating/decimal divide by zero */
#define	    FPE_FLTUND_TRAP	0x5	/* floating underflow */
#define	    FPE_DECOVF_TRAP	0x6	/* decimal overflow */
#define	    FPE_SUBRNG_TRAP	0x7	/* subscript out of range */
#define	    FPE_FLTOVF_FAULT	0x8	/* floating overflow fault */
#define	    FPE_FLTDIV_FAULT	0x9	/* divide by zero floating fault */
#define	    FPE_FLTUND_FAULT	0xa	/* floating underflow fault */
#define	SIGKILL	9	/* kill (cannot be caught or ignored) */
#define	SIGBUS	10	/* bus error */
#ifdef ridge
#define     BUS_ALIGN_FAULT	0x1	/* data alignment fault */
#endif
#define	SIGSEGV	11	/* segmentation violation */
#ifdef ridge
#define	    SEG_CODE_SEGMENT	0x00000	/* faulted in code segment */
#define	    SEG_DATA_SEGMENT	0x00001	/* faulted in data segment */
#define	    SEG_OVER_SOFT_LIM	0x10000	/* faulted past soft limit */
#define	    SEG_OVER_HARD_LIM	0x20000	/* faulted past hard limit */
#define	    SEG_CANT_GROW_SEG	0x40000	/* could not grow data file */
#define	    SEG_QUEUE_SEGMENT	0x00002	/* faulted in queue segment */
#endif
#define	SIGSYS	12	/* bad argument to system call */
#define	SIGPIPE	13	/* write on a pipe with no one to read it */
#define	SIGALRM	14	/* alarm clock */
#define	SIGTERM	15	/* software termination signal from kill */
#define	SIGURG	16	/* urgent condition on IO channel */
#define	SIGSTOP	17	/* sendable stop signal not from tty */
#define	SIGTSTP	18	/* stop signal from tty */
#define	SIGCONT	19	/* continue a stopped process */
#define	SIGCHLD	20	/* to parent on child stop or exit */
#define	SIGTTIN	21	/* to readers pgrp upon background tty read */
#define	SIGTTOU	22	/* like TTIN for output if (tp->t_local&LTOSTOP) */
#define	SIGIO	23	/* input/output possible signal */
#define	SIGXCPU	24	/* exceeded CPU time limit */
#define	SIGXFSZ	25	/* exceeded file size limit */
#define	SIGVTALRM 26	/* virtual time alarm */
#define	SIGPROF	27	/* profiling time alarm */

#ifdef ridge
#define SIGRBUG         33   /* trap 0, enter rbug                        */
#define SIGDEBUG        34   /* trap 1, enter program debugger            */
#define SIGTRACE        35   /* trap 2, trace trap                        */
#define SIGEMULATE      36   /* trap 3, emulator trap                     */
#define SIGTRAP4        37   /* trap 4,  unused                           */
#define SIGTRAP5        38   /* trap 5,  unused                           */
#define SIGTRAP6        39   /* trap 6,  unused                           */
#define SIGTRAP7        40   /* trap 7,  unused                           */
#define SIGTRAP8        41   /* trap 8,  unused                           */
#define SIGTRAP9        42   /* trap 9,  unused                           */
#define SIGTRAP10       43   /* trap 10, unused                           */
#define SIGTRAP11       44   /* trap 11, unused                           */
#define SIGTRAP12       45   /* trap 12, unused                           */
#define SIGTRAP13       46   /* trap 13, unused                           */
#define SIGTRAP14       47   /* trap 14, unused                           */
#define SIGTRAP15       48   /* trap 15, unused                           */

/* Use these with fpesig* calls to affect individual arithmetic traps/faults.
   These individual traps/faults will all be reported as SIGFPE with the
   appropriate code being provided (see lists of codes above).

   NOTE:  Masks developed for these signals must use an expression of the
	  form (1<<((sig-1)&0x1f)) since these signal numbers are greater
	  then 32.
*/

#define SIGFPEINTOVER		 49 /* trap 16, Integer Overflow */
#define SIGFPEINTDIVZERO	 50 /* trap 17, divide by Zero */
#define SIGFPEREALOVER		 51 /* trap 18, real overflow */
#define SIGFPEREALUNDER		 52 /* trap 19, real underflow */
#define SIGFPEREALDIVZERO	 53 /* trap 20, real divide by zero */

#define SIGINTOVER      49   /* trap 16, Integer Overflow                 */
#define SIGINTDIVZERO   50   /* trap 17, divide by Zero                   */
#define SIGREALOVER     51   /* trap 18, real overflow                    */
#define SIGREALUNDER    52   /* trap 19, real underflow                   */
#define SIGREALDIVZERO  53   /* trap 20, read divide by zero              */
#define SIGTRAP21       54   /* trap 21, unused                           */
#define SIGTRAP22       55   /* trap 22, unused                           */
#define SIGTRAP23       56   /* trap 23, unused                           */
#define SIGTRAP24       57   /* trap 24, unused                           */
#define SIGTRAP25       58   /* trap 25, unused                           */
#define SIGTRAP26       59   /* trap 26, unused                           */
#define SIGTRAP27       60   /* trap 27, unused                           */
#define SIGTRAP28       61   /* trap 28, unused                           */
#define SIGTRAP29       62   /* trap 29, unused                           */
#define SIGTRAP30       63   /* trap 30, unused                           */

#define SIGPWRON        65   /* power went back on          [unsupported] */
#define SIGBOUNDS       66   /* Exceeded array bounds       [unsupported] */

#define	SIGUSR1	80	/* user defined signal 1                           */
#define	SIGUSR2	81	/* user defined signal 2                           */
#define SIGCLD  82      /* death of a child.                 [unsupported] */
#define	SIGPWR	83	/* power-fail restart                [unsupported] */

#define SIG_DBG		(int (*)())3
#endif

#ifndef KERNEL
int	(*signal())();
#endif

/*
 * Signal vector "template" used in sigvec call.
 */
struct	sigvec {
	int	(*sv_handler)();	/* signal handler */
	int	sv_mask;		/* signal mask to apply */
	int	sv_onstack;		/* if non-zero, take on signal stack */
};

/*
 * Structure used in sigstack call.
 */
struct	sigstack {
	char	*ss_sp;			/* signal stack pointer */
	int	ss_onstack;		/* current status */
};

/*
 * Information pushed on stack when a signal is delivered.
 * This is used by the kernel to restore state following
 * execution of the signal handler.  It is also made available
 * to the handler to allow it to properly restore state if
 * a non-standard exit is performed.
 */

#ifdef ridge
#include <sys/procstate.h>

struct sigcontext {
    int			sc_onstack;		/* onstack flag to be restored */
    int			sc_mask[3];		/* mask array to be restored */
    char		sc_instruction[8];	/* current instruction bytes */
    stateRecord		sc_pstate;		/* process state record */
};
#else
struct	sigcontext {
	int	sc_onstack;		/* sigstack state to restore */
	int	sc_mask;		/* signal mask to restore */
	int	sc_sp;			/* sp to restore */
	int	sc_pc;			/* pc to retore */
	int	sc_ps;			/* psl to restore */
};
#endif

#define	BADSIG		(int (*)())-1
#define	SIG_DFL		(int (*)())0
#define	SIG_IGN		(int (*)())1

#ifdef KERNEL
#define	SIG_CATCH	(int (*)())2
#define	SIG_HOLD	(int (*)())3
#endif
#endif
