/* "@(#)tcp.h	5.1	6/6/86" */

typedef	u_long	tcp_seq;
/*
 * TCP header.
 * Per RFC 793, September, 1981.
 */
struct tcphdr {
	u_short	th_sport;		/* source port */
	u_short	th_dport;		/* destination port */
	tcp_seq	th_seq;			/* sequence number */
	tcp_seq	th_ack;			/* acknowledgement number */
#ifdef vax
	u_char	th_x2:4,		/* (unused) */
		th_off:4;		/* data offset */
#endif
#ifdef ridge
/* ON RIDGE SWITCH th_off and th_x2 so th_off is first */
	u_char  th_off:4,		/* data offset */
	      	th_x2:4;		/* (unused) */
#endif ridge
	u_char	th_flags;
#define	TH_FIN	0x01
#define	TH_SYN	0x02
#define	TH_RST	0x04
#define	TH_PUSH	0x08
#define	TH_ACK	0x10
#define	TH_URG	0x20
	u_short	th_win;			/* window */
	u_short	th_sum;			/* checksum */
	u_short	th_urp;			/* urgent pointer */
};

#define	TCPOPT_EOL	0
#define	TCPOPT_NOP	1
#define	TCPOPT_MAXSEG	2
