C   FOR_T2D.FOR
C   FORTRAN test program using tape programming language interface.
C   Reads blocks from tape, writes them to a disk file (this program assumes
C   that 4000-byte blocks were written by the other demo program, FOR_D2T.FOR).
      EXTERNAL FORTAPE
      INTEGER*2 FUN, COUNT
C  Yes, the following is a valid variable name! (Embedded blanks are ignored.)
      LOGICAL MESSAGE DISPLAYED
C   Set up 4000-byte buffer as array of 80-byte "records":
      CHARACTER*80 BUFFER(50)
      CHARACTER*40 OUTFILE
      CHARACTER*1 STAT(16),READY
C   First, check whether tape is on-line:
1     FUN=0
      CALL FORTAPE(FUN,STAT,COUNT,BUFFER)
      IF (STAT(1).EQ.'T') GOTO 2
      WRITE(*,'(A)\') '* Tape drive is not on-line'
      READ(*,'(A)') READY
      GOTO 1
2     WRITE(*,'(A)\') '* Enter name for output DOS file: '
      READ(*,'(A)') OUTFILE
      OPEN(1,FILE=OUTFILE,STATUS='NEW')
C   Check if tape is at load point:
      FUN=0
      CALL FORTAPE(FUN,STAT,COUNT,BUFFER)
      IF(STAT(7).EQ.'T') GOTO 101
      WRITE(*,'(A)') '* Rewinding tape--please wait:'
C  Rewind tape:
      FUN=11
      CALL FORTAPE(FUN,STAT,COUNT,BUFFER)
      MESSAGE DISPLAYED=.FALSE.
C  Check status until "busy rewinding" no longer true:
100   FUN=0
      CALL FORTAPE(FUN,STAT,COUNT,BUFFER)
      IF (STAT(5).NE.'T') GOTO 101
      IF (STAT(7).EQ.'T') GOTO 101
      IF(MESSAGE DISPLAYED) GOTO 100
      WRITE(*,'(A)') '* Still rewinding:'
      MESSAGE DISPLAYED=.TRUE.
      GOTO 100
101   IF (STAT(7).NE.'T') GOTO 901
      WRITE(*,'(A)') '* Reading from tape:'
110   FUN=2
      COUNT=4000
      CALL FORTAPE(FUN,STAT,COUNT,BUFFER)
      IF (STAT(13) .EQ. 'T') GOTO 901
C  Check if tape mark was read (indicates EOF):
      IF (STAT(14).EQ.'T') GOTO 300
      K=1
      DO 200,K=1,50
         WRITE (1,'(A)') BUFFER(K)
200   CONTINUE
      GOTO 110
300   WRITE(*,'(A)') '* File ',OUTFILE,' has been written.'
      CLOSE (1)
      STOP
66    WRITE(*,'(A)') '* Error opening file ',OUTFILE,'--program ending.'
      STOP
901   WRITE(*,'(A)') '* Error from tape routine:'
      WRITE(*,'16(A,X2)') STAT
      END
 
