
#include "mince.gbl"
#ifdef DIRECT

MDirect()
{

	char name[20], drive[2], *p;
	int row, col, first;


	p = "This is the string to bash";
	*drive = '\0';
	
	if(!GetArg("Which drive do you want a directory of <CR>: ",CR, drive, 2))
		return;
	
	*drive = ToUpper(*drive);
	if(*drive && (*drive < 'A' || *drive > 'P')){
		error("Illegal drive!");
		return;
	}

	tlrow = -1;
	first = 1;
	for(row = 0; row < TMaxRow() - 3 && first != -1; row++){
		TSetPoint(row, 0);
		TCLEOL();
		BSetMod(BScrnMrk(row));
		for(col = 0; col < TMaxCol() - 15; col += 16)
			if(Direct(first, *drive, name)){
				fixname(name);
				TSetPoint(row, col);
				TPrntStr(name);
				first = 0;
			}
			else{
				first = -1;
				break;
			}
	}

	TSetPoint(row, 0);
	TCLEOL();
	BSetMod(BScrnMrk(row));
	TForce();
	KbWait();
	if (row>=divide) ModeLine();
}

fixname(name)
char *name;
{

	movmem(&name[8], &name[9], 4);
	name[8] = ' ';

}


/* ------------------------------------------------------------------------ */
/*			     DEFINES					    */
/* ------------------------------------------------------------------------ */

#define CURR_DRIVE	0x19	/* DOS call to retrieve current drive */
#define FALSE		0
#define FCB_SIZE	37	/* size of the File Control Block */
#define	FIRST		1	/* Flag if want first entry of directory */
#define FIRST_ENTRY	0x11	/* DOS call to get first filename entry */
#define LEN_FILENAME	0x0B	/* Length of filename plus extension */
#define NEXT_ENTRY	0x12	/* DOS call to get next filename entry */
#define RENAME		0x17	/* DOS call to rename a file */
#define SET_DTA		0x1A	/* DOS call to set Disk Transfer Area */
#define SPACE		0x20	/* Value of a space */
#define TRUE		1

/* ------------------------------------------------------------------------ */
/*			     PROGRAM					    */
/* ------------------------------------------------------------------------ */


/* ---------------------------------------------------------------------------

NAME

	Direct - get directory entries

SYNOPSIS

	ret = Direct(flag, drive, fn);
	int ret			return code
	char flag;		flag for first or subsequent retrievals
	char drive;		drive letter of directory to read
	char fn[];		location to put filename entry

DESCRIPTION

	Retrieves a filename entry from the directory specified and places
	the filename in fn.  To get the first entry, call this function
	using FIRST as the value of 'flag'.  To get the subsequent entries
	call this function with some other value other than FIRST for 'flag'.

	fn is in the form:

		FFFFFFFFXXX
	where "F" is the filename and "X" is the extension.  The string
	is terminated with a null byte.

RETURNS

	ret = zero if there are no more entries.

CAUTIONS

	Be sure fn points to a location large enough for the filename.

--------------------------------------------------------------------------- */
Direct(flag, drive, fn)
char flag;
char drive;
char fn[];
{
	static char dta[FCB_SIZE]; /* Data Transfer Area to store filename */
	static char fcb[FCB_SIZE] = {0, '?', '?', '?', '?', '?', '?', '?',
					'?', '?', '?', '?'};
	int func;			/* DOS function to use to get entry */

	bdos(SET_DTA, dta);		/* set the DTA to receive filenames */

	/* 
	 * If they want the first entry, determine
	 * the drive and set it.  Set func for the
	 * first or subsequent entry to retrieve.
	 */
	if ( flag == FIRST ) {
		if ( drive == 0 ) *fcb = bdos(CURR_DRIVE) + 1;
		else *fcb = tolower(drive) - 'a' + 1;
		func = FIRST_ENTRY;
	}
	else func = NEXT_ENTRY;

	/* Get the entry, return if no more entries */
	if ( bdos(func, fcb) == 0xFF ) return(0);

	/*
	 * Copy the filename from the DTA to fn
	 * and end fn with a NULL byte
	 */
	movmem(dta + 1, fn, LEN_FILENAME);
	fn[LEN_FILENAME] = NULL;
	return(1);
}
