#include	"mince.gbl"
#define	SPELLMARK	(175)
#define	SPELLADD	"ADDDICT.SPL"

SPInit()
{
	char *SpelAdd();
	arg=0;							/* how could this happen?? */
	CleanBuff(del_buff);				/* empty it out */
	BSwitchTo(del_buff);				/* set up the add dictionary */
	if(BReadFile(SpelAdd())){				/* read in the old one */
		BToEnd();						/* if it exists */
		BInsert(NL);					/* insert a NL to be safe */
	}
	else BInsert(' ');					/* else insert a space */
	BSwitchTo(buffs[cbuff].bbuff);		/* back to cbuff */
	BToStart();						/* catch the first */
	SPNext();							/* find misspelled words */
}

SPNext()
{
	char word[50];

	arg=0;							/* how could this happen?? */
	if (!BCSearch(SPELLMARK)) SPExit();	/* if all done, then all done */
	else{
		RDelOne();					/* Delete the spell mark */
		SPGetWord(word);				/* get word */
		strcat(word," : ");				/* prepare for display */
		Echo(word);					/* show it */
	}
}

SPAdd()
{

	arg=0;							/* how could this happen?? */
	tmark=BCreMrk();					/* tmark before word */
	FWord();							/* point after word */
	BCopyRgn(tmark,del_buff);			/* copy word to del_buff */
	BSwitchTo(del_buff);				/* switch to del_buff... */
	BInsert(NL);						/* ... and add whitespace */
	BSwitchTo(buffs[cbuff].bbuff);		/* back to main buffer */
	BKillMrk(tmark);					/* get rid of tmark	*/
	BWord();							/* Before word */
	SPIgnore();						/* ignore all other occurences */
	/* SPIgnore will call SPNext for us */
}

SPIgnore()
{
	char old[50], new[50];

	SPGetWord(new);					/* will replace with only word */
	BInsert(SPELLMARK);					/* stick in spell mark */
	BMove(-1);						/* so that we are going to.. */
	SPGetWord(old);					/* get it in the old word */
	ReplaceIt(old,new,FALSE);			/* replace them then... */
	BKillMrk(tmark);					/* kill mark */
	SPNext();							/* find next word */
}

SPRoot()
{
	char *ptr, root[50];

	arg=0;							/* how could this happen?? */
	if (!GetArg("What is the Root? <CR>",CR,root,50)) /* get root  */
		return(FALSE);					/* else back to edit */
	BSwitchTo(del_buff);				/* it will get put here */
	for (ptr = root; *ptr != NULL; ptr++)	/* for all the characters */
		BInsert(*ptr);					/* put them away */
	BInsert(NL);						/* terminate with whitespace */
	BSwitchTo(buffs[cbuff].bbuff);		/* return to cbuff */
	SPIgnore();						/* ignore all other occurences */
	/* SPIgnore will call SPNext for us */
}

SPChange()
{
	char old[50], new[50], prompt[80];

	arg=0;							/* how could this happen?? */
	BInsert(SPELLMARK);					/* put the mark back */
	BMove(-1);						/* and get before it */
	SPGetWord(old);					/* so that old contains it */
	strcpy(prompt,"What should '");		/* set up ... */
	strcat(prompt,&old[1]);				/* ... prompt with ... */
	strcat(prompt,"' be changed to? <ESC> ");/* ... the old word */
	*new = '\0';
	if (!GetArg(prompt,ESC,new,50)){		/* replace old with what? */
		BDelete(1);					/* no more SPELLMARK */
		return;						/* and return to edit */
	}
	ReplaceIt(old,new,FALSE);			/* do it now */
	SPNext();							/* search for next */
}

SPGetWord(word)
char word[];
{
	struct mrk *bmark, *amark;
	int ptr;

	ptr = 0;							/* initialize */
	bmark = BCreMrk();					/* bmark before word */
	FWord();							/* after word */
	amark = BCreMrk();					/* amark after word */
	BPntToMrk(bmark);					/* point before word */
	while (!BIsAtMrk(amark)){
		word[ptr++] = Buff();			/* copy word to word */
		BMove(1);
	}
	word[ptr++]=NULL;					/* terminate with null */
	PtMkKill(bmark);					/* point before word, no bmark */
	BKillMrk(amark);					/* goodbye amark */
}

SPEdit()								/* pop to edit mode */
{
	BInsert(SPELLMARK);					/* put the mark back in */
	SPExit();							/* exit spell mode */
}

SPExit()
{

	int i;
	char *bptr,*SpelAdd();

	arg=0;							/* how could this happen?? */
	BSwitchTo(del_buff);				/* switch to delete buff */
	MTrimWhite();						/* delete trailing whitespace */
	if (!(BIsEnd() && BIsStart())){		/* in otherwords, if not null */
		BWriteFile(SpelAdd());			/* write out dictionary */
		CleanBuff(del_buff);			/* clean up our mess */
	}
	BSwitchTo(buffs[cbuff].bbuff);		/* back to cbuff */
	def_mode = 'f';
	bptr = buffs[cbuff].bmodes;
	for (cnt=MAXMODES-1; cnt>=0; --cnt){
		if ('p' == *(bptr + cnt)){
			while (cnt>0 && *(bptr + cnt)){
				*(bptr + cnt) = *(bptr + cnt - 1);
				--cnt;
			}
			*(bptr + cnt) = '\0';
			SetModes();
		}
	}
}

SPHelp()								/* give spell mode help */
{
	Echo(
	"A-Add, C-Change, E-Edit, I-Ignore, R-Root, ?-Help, <Type CR Now>");
	TGetKb();							/* throw it away */
	BInsert(SPELLMARK);					/* put the mark back in */
	BMove(-1);						/* get before it */
	SPNext();							/* find it again */
	/* so it appears in echo line */
}

char *SpelAdd()
{
	return(SPELLADD);
}

RDelOne()					/* delete one character backwards */
{
	BMove(-1);
	BDelete(1);
}

