/* BINDINGS.C - Set up the key bindings for Mince

	This file contains the function table initializers and mode set up
functions */

#include "mince.gbl"

finit1()			/* initialize the control and self insert key bindings */
{
	int MInsert(), MSetMrk(), MBegLin(), MPrevChar();
	int MNotImpl(), MDelChar(), MEndLin(), MNextChar();
	int MAbort(), MDelLin(), MNewLin();
	int MNextLin(), MOpenLin(), MPrevLin(), MQuote();
	int MRSearch(), MSearch(), MSwapChar(), MArg();
	int MNextPage(), MDelRgn(), MCtrlX(), MYank();
	int MMeta(), MDelIndent(), MRDelChar(), MIndent();
	int MPrevPage(), MNewDsp(), MToglC(), MIndRest();
	int MDelELin();
	int cnt;

	for (cnt=0; cnt<128; ++cnt) functs[cnt] = MInsert;
	TKbChk();
	functs[0] = MSetMrk;	    /* C-@ */
	functs[1] = MBegLin;	    /* C-A */
	functs[2] = MPrevChar;	  /* C-B */
	functs[3] = MNotImpl;	   /* C-C */
	functs[4] = MDelChar;	   /* C-D */
	functs[5] = MEndLin;	    /* C-E */
	functs[6] = MNextChar;	  /* C-F */
	functs[7] = MAbort;		     /* C-G */
	functs[8] = MRDelChar;	  /* C-H */
	/* C-I */
	functs[10] = MIndRest;	   /* C-J */
	functs[11] = MDelLin;	   /* C-K */
	functs[12] = MNewDsp;	    /* C-L */
	functs[13] = MNewLin;	   /* C-M */
	functs[14] = MNextLin;	  /* C-N */
	functs[15] = MOpenLin;	  /* C-O */
	functs[16] = MPrevLin;	  /* C-P */
	functs[17] = MQuote;	    /* C-Q */
	functs[18] = MRSearch;	  /* C-R */
	functs[19] = MSearch;	   /* C-S */
	functs[20] = MSwapChar;	 /* C-T */
	functs[21] = MArg;		      /* C-U */
	functs[22] = MNextPage;	 /* C-V */
	functs[23] = MDelRgn;	   /* C-W */
	functs[24] = MCtrlX;	    /* C-X */
	functs[25] = MYank;		     /* C-Y */
	functs[26] = MPrevPage;	  /* C-Z */
	functs[ESC] = MMeta;	    /* ESC */
	functs[28] = MDelIndent;		/* C-\ */
	functs[29] = MNotImpl;	  /* C-] */
	functs[30] = MToglC;	  /* C-^ */
	functs[31] = MNotImpl;	  /* C-_ */
	functs[DEL] = MDelChar;		/* DEL */
}

finit2()			/* set up the Meta key bindings */
{
	int MNotImpl(), MAbort(), MDelELin(), MQryRplc();
	int MMakeDel(), MToStart(), MToEnd(), MBSent();
	int BWord(), MCapWord(), MDelWord(), MFSent();
	int FWord(), MMrkPara(), MDelSent(), MLowWord();
	int MFillPara(), MReplace(), MCntrLine(), MUpWord();
	int MPrevPage(), MCopyRgn(), MDelWhite();
	int MRDelWord(), MSetMrk(), MSwapWord();
	int MRNewDsp(), MDropLine(), MCloseWhite(), MArgDgt();
	int MIndNL(), MHelp(), MFPara(), MBPara(), MOpenIndLin();
	int MFKeyHelp(), MSFKeyHelp(), MCFKeyHelp(), MDebug(), MAFKeyHelp();
	int MPageBreaks();
	int cnt;

	for (cnt=128; cnt<256; ++cnt) functs[cnt] = MNotImpl;
	TKbChk();
	functs[128+7] = MAbort;				 /* M-C-G */
	functs[128+8] = MRDelWord;				/* M-C-H */
	functs[128+10] = MDropLine;				/* M-<NL> */
	functs[128+11] = MDelELin;			      /* M-C-K */
	functs[128+12] = MRNewDsp;				/* M-C-L */
	functs[128+15] = MCloseWhite;				/* M-C-O */
	functs[128+18] = MQryRplc;			      /* M-C-R */
	functs[128+23] = MMakeDel;			      /* M-C-W */
	functs[128+'@'] = MPageBreaks;
	functs[128+'<'] = MToStart;			     /* M-< */
	functs[128+'>'] = MToEnd;			       /* M-> */
	functs[128+'?'] = MHelp;					/* M-? */
	functs[128+' '] = MSetMrk;			      /* M-  */
	for(cnt = 128+'0'; cnt <= 128+'9'; ++cnt)
		functs[cnt] = MArgDgt;
	functs[128+27] = MAFKeyHelp;				/* M-C-[ */
	functs[128+29] = MFKeyHelp;			      /* M-C-] */
	functs[128+30] = MSFKeyHelp;			      /* M-C-^ */
	functs[128+31] = MCFKeyHelp;			      /* M-C-_ */
	functs[128+'A']=functs[128+'a'] = MBSent;       /* M-A */
	functs[128+'B']=functs[128+'b'] = BWord;	/* M-B */
	functs[128+'C']=functs[128+'c'] = MCapWord;     /* M-C */
	functs[128+'D']=functs[128+'d'] = MDelWord;     /* M-D */
	functs[128+'E']=functs[128+'e'] = MFSent;       /* M-E */
	functs[128+'F']=functs[128+'f'] = FWord;	/* M-F */
	functs[128+'H']=functs[128+'h'] = MMrkPara;     /* M-H */
	functs[128+'J']=functs[128+'j'] = MIndNL;		/* M-J */
	functs[128+'K']=functs[128+'k'] = MDelSent;     /* M-K */
	functs[128+'L']=functs[128+'l'] = MLowWord;     /* M-L */
	functs[128+'N']=functs[128+'n'] = MFPara;		/* M-N */
	functs[128+'O']=functs[128+'o'] = MOpenIndLin;	/* M-O */
	functs[128+'P']=functs[128+'p'] = MBPara;		/* M-P */
	functs[128+'Q']=functs[128+'q'] = MFillPara;    /* M-Q */
	functs[128+'R']=functs[128+'r'] = MReplace;     /* M-R */
	functs[128+'S']=functs[128+'s'] = MCntrLine;    /* M-S */
	functs[128+'T']=functs[128+'t'] = MSwapWord;    /* M-T */
	functs[128+'U']=functs[128+'u'] = MUpWord;      /* M-U */
	functs[128+'V']=functs[128+'v'] = MNotImpl;		/* M-V */
	functs[128+'W']=functs[128+'w'] = MCopyRgn;	/* M-W */
	functs[128+'['] = MNotImpl;			/* M-[ */
	/* XXX */
	functs[128+'\\'] = MDelWhite;			/* M-\ */
	functs[128+']'] = MNotImpl;			/* M-] */
	/* XXX */
	functs[128+DEL] = MRDelWord;			/* M-DEL */
}

finit3()			/* set up the Control-X key bindings */
{
	int	cnt;
	int	MNotImpl(), MLstBuffs(), MExit(), MFindFile();
	int	MAbort(), MSetTabs(), MDelMode(), MFileRead();
	int	MFileSave(), MFileWrite(), MSwapMrk(), MSetIndent();
	int	MPrintPos(), MSwitchTo(), MKillBuff(), MSetFill();
	int	MAddMode(), MOneWind(), MTwoWind(), MSwpWind();
	int	MNxtOthrWind(), MPrvOthrWind(), MGrowWind();
#ifdef YINYANG
	int	MUnix();
#endif

	int	MInsSFile(), MWrtRgn(), MUndntRg(), MIndntRg();
	int	MTrimWhite(), MHelp(), MGoSpell(), MPrint();
#ifdef DIRECT
	int  MDirect();
#endif

	for (cnt=256; cnt<384; ++cnt) functs[cnt] = MNotImpl;
	TKbChk();
	functs[256+2] = MLstBuffs;			/* C-X C-B */
	functs[256+3] = MExit;				/* C-X C-C */
	functs[256+6] = MFindFile;			/* C-X C-F */
	functs[256+7] = MAbort;				/* C-X C-G */
	functs[256+9] = MSetTabs;			/* C-X Tab */
	functs[256+13] = MDelMode;			/* C-X C-M */
	functs[256+16] = MPrint;				/* C-X C-P */
	functs[256+18] = MFileRead;			     /* C-X C-R */
	functs[256+19] = MFileSave;			     /* C-X C-S */
	functs[256+22] = MNxtOthrWind;		  /* C-X C-V */
	functs[256+23] = MFileWrite;			    /* C-X C-W */
	functs[256+24] = MSwapMrk;			      /* C-X C-X */
	functs[256+26] = MPrvOthrWind;		  /* C-X C-Z */
	functs[256+'.'] = MSetIndent;			   /* C-X . */
#ifdef YINYANG
	functs[256+'!'] = MUnix;					/* C-X ! */
#endif
	functs[256+'1'] = MOneWind;			     /* C-X 1 */
	functs[256+'2'] = MTwoWind;			     /* C-X 2 */
	functs[256+'<'] = MUndntRg;				/* C-X < */
	functs[256+'='] = MPrintPos;			    /* C-X = */
	functs[256+'>'] = MIndntRg;				/* C-X > */
	functs[256 + '?'] = MHelp;				/* C-X ? */
	functs[256+'B']=functs[256+'b'] = MSwitchTo;    /* C-X B */
#ifdef DIRECT
	functs[256+'D']=functs[256+'d'] =  MDirect;		/* C-X D */
#endif
	functs[256+'I']=functs[256+'i'] = MInsSFile;		/* C-X I */
	functs[256+'K']=functs[256+'k'] = MKillBuff;    /* C-X K */
	functs[256+'F']=functs[256+'f'] = MSetFill;     /* C-X F */
	functs[256+'M']=functs[256+'m'] = MAddMode;     /* C-X M */
	functs[256+'O']=functs[256+'o'] = MSwpWind;     /* C-X O */
	functs[256+'R']=functs[256+'r'] = MWrtRgn;		/* C-X R */
	functs[256+'S']=functs[256+'s'] = MGoSpell;
	functs[256+'^'] = MGrowWind;			    /* C-X ^ */
}

SetModes()		      /* Set the modes according to the bmodes array */
{      
	int MFillChk(), MInsert(), MOverwrite();
	/*
			int MPBegLine();
			int MPBChar(), MPEndLine(), MPFChar(), MPBackSpace();
			int MPNextLine(), MPPrevLine() MPTab();
		*/
	int MSInsert(), MNotImpl(), MTrimWhite();
	int SPAdd(), SPIgnore(), SPRoot(), SPChange(), SPHelp(), SPEdit();
	int MIndRest();
#ifdef LARGE
	int MNewLin(), MCIndent();
#endif 
	char *bptr;
	int cnt, spflg;

	*mode='\0';
	spflg = FALSE;
	finit1();				       /* Set up the key bindings */
	finit2();
	finit3();
	bptr = buffs[cbuff].bmodes;
	for (cnt=MAXMODES-1; cnt>=0; --cnt) {
		switch (*(bptr + cnt)){

#ifdef LARGE
		case 'c':
			functs[13] = MCIndent;
			strcat(mode,"C ");
			continue;
#endif 
		case 's':
			Rebind(MInsert,MSInsert);
			strcat(mode,"Save ");
			continue;

		case 'v':
			Rebind(MInsert,MNotImpl);		/* normal mode insert */
			functs[4] = MNotImpl;			/* C-D */
			functs[9] = MNotImpl;			/* C-I */
			functs[11] = MNotImpl;			/* C-K */
			functs[13] = MNotImpl;			/* C-M */
			functs[15] = MNotImpl;			/* C-O */
			functs[17] = MNotImpl;			/* C-Q */
			functs[20] = MNotImpl;			/* C-T */
			functs[23] = MNotImpl;			/* C-W */
			functs[25] = MNotImpl;			/* C-Y */
			functs[28] = MNotImpl;			/* C-\ */
			functs[30] = MNotImpl;			/* C-^ */
			functs[DEL] = MNotImpl;			/* DEL */
			functs[' '] = MNotImpl;			/* Space */
			functs[128+11] = MNotImpl;		/* M-C-K */
			functs[128+18] = MNotImpl;		/* M-C-R */
			functs[128+'C']=functs[128+'c'] = MNotImpl;	/* M-C */
			functs[128+'D']=functs[128+'d'] = MNotImpl;	/* M-D */
			functs[128+'J']=functs[128+'j'] = MNotImpl;	/* M-J */
			functs[128+'K']=functs[128+'k'] = MNotImpl;	/* M-K */
			functs[128+'L']=functs[128+'l'] = MNotImpl;	/* M-L */
			functs[128+'O']=functs[128+'o'] = MNotImpl;	/* M-O */
			functs[128+'Q']=functs[128+'q'] = MNotImpl;	/* M-Q */
			functs[128+'R']=functs[128+'r'] = MNotImpl;	/* M-R */
			functs[128+'S']=functs[128+'s'] = MNotImpl;	/* M-S */
			functs[128+'T']=functs[128+'t'] = MNotImpl;	/* M-T */
			functs[128+'U']=functs[128+'u'] = MNotImpl;	/* M-U */
			functs[128+'\\'] = MNotImpl;				/* M-\ */
			functs[128+10] = MNotImpl;				/* M-C-J */
			functs[128+11] = MNotImpl;				/* M-C-K */
			functs[128+15] = MNotImpl;				/* M-C-O */
			functs[128+18] = MNotImpl;				/* M-C-R */
			functs[128+DEL] = MNotImpl;				/* M-DEL */
			functs[256+19] = MNotImpl;				/* C-X C-S */
			functs[256+23] = MNotImpl;				/* C-X C-W */
			functs[256+'.'] = MNotImpl;				/* C-X . */
			functs[256+'F']=functs[256+'f'] = MNotImpl;	/* C-X F */
			functs[256+'I']=functs[256+'i'] = MNotImpl;	/* C-X I */
			functs[256+'W']=functs[256+'w'] = MNotImpl;	/* C-X W */
			functs[256+'<'] = MNotImpl;				/* C-X < */
			functs[256+'>'] = MNotImpl;				/* C-X > */
			functs[256+'\\'] = MNotImpl;				/* C-X \ */
			strcat(mode,"View ");
			Rebind(MSInsert,MNotImpl);		/* can't be too careful */
			continue;
		case 'p':
			for(spflg = 0; spflg < 384; spflg++)
				functs[spflg] = MNotImpl;
			functs['a']=functs['A'] = SPAdd;
			functs['i']=functs['I'] = SPIgnore;
			functs['r']=functs['R'] = SPRoot;
			functs['c']=functs['C'] = SPChange;
			functs['e']=functs['E'] = SPEdit;
			functs['?'] = SPHelp;
			strcat(mode,"Spell ");
			continue;
		case 'f':
			functs[' '] = MFillChk;
			strcat(mode,"Wrap ");
			continue;
		case 'o':
			Rebind(MInsert,MOverwrite);
			/*
									functs[1] = MPBegLine;
									functs[2] = MPBChar;
									functs[5] = MPEndLine;
									functs[6] = MPFChar;
									functs[8] = MPBackSpace;
									functs[9] = MPTab;
									functs[14] = MPNextLine;
									functs[16] = MPPrevLine;
									functs[256+'\\'] = MTrimWhite;
						*/
			strcat(mode,"Overwrite ");
		}
	}
	if (!*mode) strcpy(mode,"Normal ");
	mode[strlen(mode)-1]='\0';
	ModeLine();
	if(spflg)
		SPInit();
}

UInit()			 /* Do user code initilization */
/* This function is called once at the very begining. It may be used
	to do any initilization required for user code */
{
}

/* END OF BINDINGS.C - set up key bindings */
