/* SCREENS.C - Screen definitions for Config

	(C) 1982, 1983 Perfect Software, Inc.

	01/26/82	Version 1.00 by Barry A. Dobyns

	This file contains the screen layout routines, which are also
the entry and display routines for Config. */

#include "pfconfig.h"

#ifdef CPM
FLAG
EntPort(field)			/* Enter port paramiters */
	int field;
{
	int from, to;
	FLAG sevenbit;

	if (field==ALL) {
		from=1;
		to=7;
		}
	else from=to=field;
	for (; from<=to; ++from)  {
		switch (from) {

		case 1:
			if (DEnter(
				"Peripherals can be accessed either as CP/M devices or through",
				"direct port input/output.  It is simpler to access them as CP/M",
				"devices, but these interfaces are not always correctly",
				"implemented; on the other hand, direct port I/O is not always",
				"possible.  If in doubt, consult your hardware manual.",
				"Use CP/M (BIOS) input/output? ",
				FLAGTYPE,&portrec.dbiosp,
				NULL)) return(FALSE);
			break;
		case 2:
			if (portrec.dbiosp) { if (DEnter(
				"What is the number of the CP/M BIOS call to access this",
				"peripheral?  Standard calls are:",
				"  3 - console input",
				"  4 - console output",
				"  5 - printer output",
				"  6 - reader (modem) input",
				"  7 - punch (modem) output",
				"Your particular CP/M may have others defined.",
				"BIOS call number: ",
				BRANGE,2,64,&portrec.dataport,
				NULL)) return(FALSE);
				}
			else if (DEnter(
				"What is the port address of this peripheral's data port",
				"(in hex): ",
				HEXBYTE,&portrec.dataport,
				NULL)) return(FALSE);
			break;
		case 3:
			if (DEnter(
				"Should the high-order bit of data bytes be masked out, leaving",
				"seven bits of data? ",
				FLAGTYPE,&sevenbit,
				NULL)) return(FALSE);
			portrec.datamask = sevenbit ? 0x7F : 0xFF;
			break;
		case 4:
			if (DEnter(
				"There are two ways to determine when a byte can be read from",
				"or written to a peripheral.  CP/M BIOS calls exist to do this",
				"in some cases; in others, it is possible to directly read a",
				"status port.  In cases where it is not possible to determine",
				"the status at all, answer \"yes\" to this question.",
				"Use CP/M BIOS for status determination? ",
				FLAGTYPE,&portrec.sbiosp,
				NULL)) return(FALSE);
			break;
		case 5:
			if (portrec.sbiosp) { if (DEnter(
				"What is the number of the CP/M BIOS call to test the status of",
				"this peripheral?  The only completely standard call is 2, to",
				"test the console input status, but your CP/M may have others.",
				"In CP/M 2.0 and above BIOS call 15 is usually used for list",
				"status Determination.",
				"Enter 0 if none exists.",
				"BIOS call number: ",
				BRANGE,0,64,&portrec.statport,
				NULL)) return(FALSE);
				}
			else if (DEnter(
				"What is the port address of this peripheral's status port",
				"(in hex): ",
				HEXBYTE,&portrec.statport,
				NULL)) return(FALSE);
			break;
		case 6:
			if (DEnter(
				"A mask will be ANDed with the status byte (from either a port",
				"or the BIOS) to get a zero or non-zero value, depending only",
				"on whether the port is ready to send a character (for output",
				"ports) or has a received character ready (for input ports).",
				"If a BIOS call is being used to get the status, this should",
				"usually be FF hex; otherwise, it will be a byte of zeros except",
				"for a single 1 bit.  Ready mask (in hex): ",
				HEXBYTE,&portrec.readymask,
				NULL)) return(FALSE);
			break;
		case 7:
			if (DEnter(
				"Does ANDing the status byte with the ready mask give a non-zero",
				"value when the port is ready to send a character (for output",
				"ports) or has a received character ready (for input ports)?  If",
				"a BIOS call is being used to get the status, the answer is",
				"usually \"yes\".   Ready when non-zero? ",
				FLAGTYPE,&portrec.polarity,
				NULL)) return(FALSE);
			break;
			}
		}
	return(TRUE);
	}

int
SumPort()				/* Summarize port usage */
{
	int cnt;
	FLAG sevenbit;

	sevenbit = (portrec.datamask == 0xFF);
	cnt=DSummary(
		TITLE,"Current Port Description",

		"Use CP/M (BIOS) calls for input/output? ",
		FLAGTYPE,&portrec.dbiosp,

		portrec.dbiosp ? "BIOS call number: "
			: "Data port address (in hex): ",
		portrec.dbiosp ? BRANGE : HEXBYTE,&portrec.dataport,

		"Use eight-bit characters? ",
		FLAGTYPE,&sevenbit,

		"Use CP/M (BIOS) calls for status determination? ",
		FLAGTYPE,&portrec.sbiosp,

		portrec.sbiosp ? "BIOS call number: "
			: "Status port address (in hex): ",
		portrec.sbiosp ? BRANGE : HEXBYTE,&portrec.statport,

		"Ready mask (in hex): ",
		HEXBYTE,&portrec.readymask,

		"Ready when status non-zero? ",
		FLAGTYPE,&portrec.polarity,

		NULL);
	return(cnt);
	}

#endif

FLAG
EntPrnt(field)			/* Enter printer data */
	int field;
{
	int from, to;

	if (field==ALL) {
		from=1;
		to=30;
		}
	else from=to=field;
	for (; from<=to; ++from)  {
		switch (from) {

		case 1:
			if (DEnter(
				"What is the width of the paper <1 inch = 2540 micas;",
				"8 1/2 inches = 21590 micas>  Width in micas: ",
				MICATYPE,&printrec.dwidth,
				NULL)) return(FALSE);
			break;
		case 2:
			if (DEnter(
				"What is the height of the paper <1 inch = 2540 micas;",
				"11 inches = 27940 micas>  Height in micas: ",
				MICATYPE,&printrec.dheight,
				NULL)) return(FALSE);
			break;
		case 3:
			if (DEnter(
				"What is the standard character width (on a fixed-width device,",
				"the width of any character; on a proportionally-spaced device,",
				"the width Perfect Format will use when distances are specified in",
				"characters.  Capital 'O' is a good one to use.) <10 chars/inch:",
				"254; 12 chars/inch: 212; 16.5 chars/inch: 154>",
				"Width in micas: ",
				MICATYPE,&printrec.stdhoriz,
				NULL)) return(FALSE);
			break;
		case 4:
			if (DEnter(
				"What is the height of a single-spaced line <6 lines/inch: 423;",
				"8 lines/inch: 317>  Height in micas: ",
				MICATYPE,&printrec.stdvert,
				NULL)) return(FALSE);
			break;
		case 5:
			if (DEnter(
				"What is the smallest horizontal movement the printer can make",
				"(i.e., the horizontal resolution) <10 pitch: 254 micas;",
				"12 pitch: 212 micas; 16.5 pitch: 154 micas; 1/120 inch",
				"microspacing: 21>  Width in micas: ",
				MICATYPE,&printrec.micahoriz,
				NULL)) return(FALSE);
			break;
		case 6:
			if (DEnter(
				"What is the smallest vertical movement the printer can make",
				"(i.e., the vertical resolution) <6 lines/inch: 423;",
				"8 lines/inch: 317; 1/48 inch microfeeding: 53>",
				"Height in micas: ",
				MICATYPE,&printrec.micavert,
				NULL)) return(FALSE);
			break;
		case 7:
			if (DEnter(
				"Does your printer have a proportionally spaced font or",
				"printwheel that you intend to use for this device? ",
				FLAGTYPE,&printrec.isprop,
				NULL)) return(FALSE);
			if (!printrec.isprop) from+=1;
			else if (to < from+1) ++to;
			break;
		case 8:
			if (DEnter(
				"Perfect Format requires a table giving the width of each character.",
				"These tables are numbered 0 through 15 and are entered with",
				"option 5 in the main menu.  Which character width table should",
				"be used for this device: ",
				BRANGE,0,(hdr.ftran-hdr.fmicro)/2-1,&printrec.fontnum,
				NULL)) return(FALSE);
			break;
		case 9:
			if (DEnter(
				"Perfect Format can produce either online-readable files, or files",
				"in a special intermediate format for Perfect Print.  The latter is",
				"required for underlining, boldface, super- and sub-scripts,",
				"and microspace justificatin, but the special intermediate file",
				"cannot be used by any other program.",
				"Generate online-readable output? ",
				FLAGTYPE,&printrec.isfile,
				NULL)) return(FALSE);
			if (printrec.isfile) to=from;
			else to=24;
			break;
		case 10:
			if (DEnter(
				"For convenience in tearing off output, Perfect Print can advance the",
				"paper a specified amount past the last page boundary after",
				"printing a file.  It also assumes the paper has been advanced",
				"this distance when printing starts.  This can be used to align",
				"the perforations with a page cutter or other reference point.",
				"Enter 0 to disable this feature.  Paper advance distance (in",
				"micas): ",
				MICATYPE,&printrec.paperoffset,
				NULL)) return(FALSE);
			break;
		case 11:
			if (DEnter(
				"Perfect Print has special knowledge about certain printers to enable",
				"it to do fractional line and character movement.  The supported",
				"printers are:",
				"	1 - Plain non-fractional movement printers",
				"	2 - Diablo 1610, 1620, 1640, 1650, 630,",
				"	     NEC Spinwriter 5515, 5525",
				"	3 - Epson MX-80, MX-100",
				"	4 - IDS 460 Paper Tiger",
				"	5 - NEC Spinwriter 5510, 5520",
				"	6 - C. ITOH 8510, Anadex 8001, ",
				"	     Prowriter I, II, Intersil IPO",
				"	8 - Centronics 737",
				"Enter the number for your printer: ",
				BRANGE,1,8,&printrec.prtcode,
				NULL)) return(FALSE);
			break;
		case 12:
			if (DEnter(
				"Does the printer backspace when sent an ASCII backspace",
				"character (Control-H, 8 decimal)? ",
				FLAGTYPE,&printrec.backspace,
				NULL)) return(FALSE);
			break;
		case 13:
			if (DEnter(
				"Does the printer do a carriage return with no paper advance",
				"when sent an ASCII carriage return (Control-M, 13 decimal)? ",
				FLAGTYPE,&printrec.barecr,
				NULL)) return(FALSE);
			break;
		case 14:
			if (DEnter(
				"Does the printer advance the paper to the top of the next",
				"page when sent an ASCII form feed (Control-L, 12 decimal)? ",
				FLAGTYPE,&printrec.formfeed,
				NULL)) return(FALSE);
			break;
		case 15:
			if (DEnter(
				"Some printers require a synchronization protocol in order",
				"not to miss characters.  Perfect Print supports the following",
				"protocols:",
				"	1 - None",
				"	2 - ETX/ACK (e.g., Diablo 1610, 1620)",
				"	3 - X-ON/X-OFF (e.g., Diablo 1640, 1650, 630)",
				"Synchronization protocol: ",
				BRANGE,1,3,&printrec.synctype,
				NULL)) return(FALSE);
			break;
		case 16:
			if (DEnter(
				"Some printers, such as the NEC Spinwriter with proportional",
				"print thimbles, require a special translation of the character",
				"set; or, you may prefer to have some special characters print as",
				"other characters.  In these cases a character translation table",
				"may be used to produce apropriate output.",
				"Use a character translation table? ",
				FLAGTYPE,&printrec.needtran,
				NULL)) return(FALSE);
			if (!printrec.needtran) from+=1;
			else if (to<from+1) to++;
			break;
		case 17:
			if (DEnter(
				"There are several translation tables available.  They may be",
				"defined and printed using the Edit Character Translation Tables",
				"option on the main menu.",
				"Some of them come predfined, and you should consult the Perfect",
				"Writer manual to determine if any of them may be of use to you.",
				"Which translation table should be used: ",
				BRANGE,0,hdr.hmax-hdr.ftran-1,&printrec.trannum,
				NULL)) return(FALSE);
			break;
		case 18:
			if (DEnter(
				"The initialization string is sent to the printer to set",
				"various modes, fonts, character pitch, etc. before printing.",
				"Initialization string: ",
				STRING,20,&instr,
				NULL)) return(FALSE);
			break;
		case 19:
			if (DEnter(
				"The reset string is sent to the printer at the end of printing,",
				"to turn off the various modes, fonts, etc. that the",
				"initialization string turned on, or to perform other desired",
				"end-of-printing functions (e.g., extra paper feeding).",
				"Reset string: ",
				STRING,20,&fnstr,
				NULL)) return(FALSE);
			break;
		case 20:
			if (DEnter(
				"The new line string is sent to the printer to cause a carriage",
				"return and a single line feed.  Typically this string consists",
				"of an ASCII Carriage Return - Line Feed pair, but some printers",
				"perform this function on just a Carriage Return or Line Feed",
				"alone.  To enter a Carriage Return, type a Control-Q, then the",
				"Return key.",
				"New line string: ",
				STRING,20,&nlstr,
				NULL)) return(FALSE);
			break;
		case 21:
			if (DEnter(
				"If your printer has a special mode or font that can be turned",
				"on and off in the middle of a line, does not affect the widths",
				"of characters, and that you wish to use for text in boldface,",
				"then enter the character string that turns it on; otherwise,",
				"just type Return to use double-printing for boldface.",
				"Boldface-on string: ",
				STRING,20,&bonstr,
				NULL)) return(FALSE);
			if (bonstr[0]==NUL) from+=1;
			else if (to<from+1) to++;
			break;
		case 22:
			if (DEnter(
				"Enter the character string that turns off the boldface mode.",
				"Boldface-off string: ",
				STRING,20,&boffstr,
				NULL)) return(FALSE);
			break;
		case 23:
			if (DEnter(
				"If your printer has a special mode or font that can be turned",
				"on and off in the middle of a line, does not affect the widths",
				"of characters, and that you wish to use for text in italics,",
				"then enter the character string that turns it on; otherwise,",
				"just type Return to use underlining for italics.",
				"Italics-on string: ",
				STRING,20,&ionstr,
				NULL)) return(FALSE);
			if (ionstr[0]==NUL) from+=1;
			else if (to<from+1) to++;
			break;
		case 24:
			if (DEnter(
				"Enter the character string that turns off the italics mode.",
				"Italics-off string: ",
				STRING,20,&ioffstr,
				NULL)) return(FALSE);
			break;
		case 25:
			if (DEnter(
				"If your printer has a special mode or font that can be turned",
				"on and off in the middle of a line, does not affect the widths",
				"of characters, and that you wish to use for text in Font 1,",
				"then enter the character string that turns it on.",
				"Font 1-on string: ",
				STRING,20,&f1onstr,
				NULL)) return(FALSE);
			if (f1onstr[0]==NUL) from+=1;
			else if (to<from+1) to++;
			break;
		case 26:
			if (DEnter(
				"Enter the character string that turns off the Font 1 mode.",
				"Font 1-off string: ",
				STRING,20,&f1offstr,
				NULL)) return(FALSE);
			break;
		case 27:
			if (DEnter(
				"If your printer has a special mode or font that can be turned",
				"on and off in the middle of a line, does not affect the widths",
				"of characters, and that you wish to use for text in Font 2,",
				"then enter the character string that turns it on.",
				"Font 2-on string: ",
				STRING,20,&f2onstr,
				NULL)) return(FALSE);
			if (f2onstr[0]==NUL) from+=1;
			else if (to<from+1) to++;
			break;
		case 28:
			if (DEnter(
				"Enter the character string that turns off the Font 2 mode.",
				"Font 2-off string: ",
				STRING,20,&f2offstr,
				NULL)) return(FALSE);
			break;
		case 29:
			if (DEnter(
				"If your printer has a special mode or font that can be turned",
				"on and off in the middle of a line, does not affect the widths",
				"of characters, and that you wish to use for text in Font 3,",
				"then enter the character string that turns it on.",
				"Font 3-on string: ",
				STRING,20,&f3onstr,
				NULL)) return(FALSE);
			if (f3onstr[0]==NUL) from+=1;
			else if (to<from+1) to++;
			break;
		case 30:
			if (DEnter(
				"Enter the character string that turns off the Font 3 mode.",
				"Font 3-off string: ",
				STRING,20,&f3offstr,
				NULL)) return(FALSE);
			break;
			}
		}
	return(TRUE);
	}

/* END OF SCREENS.C - Config entry and display routines */
                                                                                                                       