#include "pfconfig.h"
int fd_new;

main()
{
	int t;

	if  ( (fd=open(DATABASE,UPDATE))<0 ) {
		printf("Error in opening original data file.\n");
		exit();
		}
	if (read(fd,tsect,RECSIZE)<0) Error("Data file read error.");
	movmem(tsect,&hdr,sizeof(hdr));
	if ( (fd_new=ECreate()) == -1 ) exit();

	printf("fport - first port = %u\n", hdr.fport);
	printf("fterm - first terminal port = %u\n", hdr.fterm);
	printf("fprint - first print record = %u\n", hdr.fprint);
	printf("fmicro - first micro table record = %u\n", hdr.fmicro);
	printf("ftran = first translation record = %u\n", hdr.ftran);

	ReadRec(SCRIBBLE,2);
	WriteRec(SCRIBBLE,-2, fd_new);
	for (t = hdr.fport; t < hdr.fterm; t++) {
		ReadRec(PORT, t);
		WriteRec(PORT, -t, fd_new);
	}
	for (t = hdr.fterm; t < hdr.fprint; t++) {
		ReadRec(TERM, t);
		WriteRec(TERM, -t, fd_new);
	}
	for (t = hdr.fprint; t < (hdr.fmicro); t++) {
		ReadRec(PRINT, t);
		WriteRec(PRINT, -t, fd_new);
	}
	for (t = hdr.fmicro; t < hdr.ftran; t++) {
		ReadRec(MICRO, t);
		WriteRec(MICRO, -t, fd_new);
	}
	for (t = hdr.ftran; t < (hdr.hmax-hdr.ftran-1); t++) {
		ReadRec(TRAN, t);
		WriteRec(TRAN, -t, fd_new);
	}
/*
	hdr.hmax -= 45;
	hdr.ftran -= 45;
*/
	strcpy(hdr.verse,VERSION);
	if (seek(fd_new,0,ABS)<0 || write(fd_new,&hdr,RECSIZE)<0)
		Error("Data file write error.");
	close(fd_new);
}

ECreate()				/* Create an initial database file */
{
	int fd, rcnt;

#ifdef CPM
	if ((fd=creat(DATABASE))<0) {
#endif
#ifdef LATTICE
	if ((fd=creat("PFNEW.DAT",0x8002))<0) {
#endif
#ifdef UNIX
	if ((fd=creat(DATABASE,0774))<0) {
#endif
		Error("Unable to create database file.");
		return(fd);
		}
	hdr.fport=3;
	hdr.coninp=hdr.conoutp=hdr.prtinp=hdr.prtoutp=hdr.modinp=hdr.modoutp=0;
	hdr.fterm=9;
	hdr.ourterm=hdr.simterm=0;
	hdr.fprint=14;
	hdr.ourprint=hdr.conprint=0;
	hdr.fmicro=30;
	hdr.maxmicro=0;
	hdr.ftran=38;
	hdr.hmax=40;
	strcpy(hdr.verse,VERSION);
	for (rcnt=40; rcnt>0; --rcnt) {
		if (write(fd,&hdr,RECSIZE)<0) {
			Error("Write error while creating database file.");
			close(fd);
			unlink("PFNEW.DAT");
			return(-1);
			}
		hdr.fport=0;
		}
	close(fd);
	if ((fd=open("PFNEW.DAT",UPDATE))<0) Error("Database creation error");
	return(fd);
	}

/* Supporting routines */

int
FindRec(type,name)			/* Locate a record by class and name */
						/* returns the record number if found */
						/* or negative of a usable record if not */
	int type;
	char *name;
{
	int frec, lrec, erec;

	switch (type) {

	case PORT:
		frec=hdr.fport;
		lrec=hdr.fterm;
		break;
	case TERM:
		frec=hdr.fterm;
		lrec=hdr.fprint;
		break;
	case PRINT:
		frec=hdr.fprint;
		lrec=hdr.fmicro;
		break;
	default:
		Error("Invalid record type.");
		return(-1);
		}
	if (seek(fd,frec*RECSIZE,ABS)<0) Error("Data file seek error.");
	tsect[0]=NUL;
	for (erec=0; frec<lrec; ++frec) {
		if (read(fd,tsect,RECSIZE)<0) Error("Data file read error.");
		if (CComp(name,tsect)) break;
		if (tsect[0]==NUL) erec=frec;
		}
	if (frec>=lrec) {
		strcpy(tsect,name);
		frec = -erec;
		}
	switch (type) {

	case PORT:
		movmem(tsect,&portrec,sizeof(portrec));
		break;
	case TERM:
		break;
	case PRINT:
		movmem(tsect,&printrec,sizeof(printrec));
		break;
		}
	return(frec);
	}

ReadRec(type,recnum)	/* Read a data record */
	int type, recnum;
{
	if (seek(fd,recnum*RECSIZE,ABS)<0 || read(fd,tsect,RECSIZE)!=RECSIZE)
		Error("Data file read error.");
	switch (type) {

	case SCRIBBLE:
		movmem(tsect,&scribrec,sizeof(scribrec));
	case PORT:
		movmem(tsect,&portrec,sizeof(portrec));
		break;
	case TERM:
		break;
	case PRINT:
		movmem(tsect,&printrec,sizeof(printrec));
		break;
	case MICRO:
		movmem(tsect,&widrec,128);
		if (read(fd,&widrec.cwid[64],RECSIZE)!=RECSIZE)
			Error("Data file read error.");
		break;
	case TRAN:
		movmem(tsect,&tranrec,sizeof(tranrec));
		break;
		}
	}

WriteRec(type,recnum, fd)	/* Write out a data record */
	int type, recnum, fd;
{
	switch (type) {

	case SCRIBBLE:
		movmem(&scribrec,tsect,sizeof(scribrec));
		break;
	case PORT:
		movmem(&portrec,tsect,sizeof(portrec));
		break;
	case TERM:
		break;
	case PRINT:
		movmem(&printrec,tsect,sizeof(printrec));
		break;
	case MICRO:
		movmem(&widrec,tsect,128);
		break;
	case TRAN:
		movmem(&tranrec,tsect,sizeof(tranrec));
		break;
		}
	if (seek(fd,recnum*RECSIZE,ABS)<0 || write(fd,tsect,RECSIZE)<0)
		Error("Data file write error.");
	if (type==MICRO && write(fd,&widrec.cwid[64],RECSIZE)<0)
		Error("Data file write error.");
	}

Error(mesg)			/* Print an error message */
	char *mesg;
{
	TNL();
	printf("Error: %s",mesg);
#ifdef LATTICE
	fflush(stdout);
#endif
	TNL();
	}

TNL()
{
	printf("\n");
}

CComp(a,b)			/* case indep. compare two C strings */
	char *a, *b;
{
	do {
		if (tolower(*a) != tolower(*b)) return(FALSE);
		} while (b++,*a++);
	return(TRUE);
	}
 