/* pfconfig.C - System configuration file editor for Scribble

	(C) 1982 Perfect Software, Inc.

	01/26/82	Version 1.00 by Barry A. Dobyns

	This program creates and maintains the configuration data
maintained in "PF.DAT".  It tries to be very user friendly and all
that sort of thing. */

#include "pfconfig.h"


main()				/* This is the top level entry point */
{
	int EPorts(), EPrints(), EStyle(), EWidths(), ETran();

#ifdef CPM
	dskreset();
#endif
	smartp=FALSE;
	TInit();
	DEnter(
		"","","","","",
		Copyright(),Version(),"",NULL);
#ifdef CPM
	if (SerChk() || checksum()) 	/* check for valid serial number */
		Broken();
#endif
	DEnter(
		"This is the Perfect Format configuration program.  It allows",
		"you to enter various pieces of system information that",
		"Perfect Format needs to work.  To successfully answer the",
		"questions you are about to be confronted with, you should have",
		"available to you the manual for the printer you intend to use,",
		"and the hardware manual for the computer you intend to use.",
		"A ruler (to measure paper with) and a calculator should prove",
		"very handy also. If you have not yet read the manual pages on how",
		"to configure Perfect Format, it might prove useful to do so now.",
		" ",
		"The Perfect Format Configuration Program is set up to edit the",
#ifndef UNIX
		"configuration file on the currently selected disk.",
		"Do you wish to exit and change disks? ",
#else
		"configuration file in the current working directory.",
		"Do you wish to exit and change directories? ",
#endif
		"",
		NULL);
	if (DYesNo()) {
		TFini();
		exit();
		}
	if ((fd=open(DATABASE,UPDATE))<0 && (fd=ECreate())<0) {
		TFini();
		exit();
		}
	if (read(fd,tsect,RECSIZE)<0) Error("Data file read error.");
	movmem(tsect,&hdr,sizeof(hdr));
#ifdef CPM
	if (strcmp(hdr.verse,VERSION) ){
		DEnter("",
			"This data file, PF.DAT is the wrong version!",
			"Do you wish to continue anyway?",
			"",
			NULL);
		if (!DYesNo()) {
			TFini();
			exit();
			}
		}
#endif
	DEnter(
		"","","","","","","","","","",
		Copyright(),"",
		"The configuration file supplied with Perfect Writer is initially",
		"set up to use a plain, 10 character-per-inch printer via",
#ifdef CPM
		"the CP/M list device.  With 8 1/2\" by 11\" paper, and with",
#endif
#ifdef LATTICE
		"the DOS list device.  With 8 1/2\" by 11\" paper, and with",
#endif
		"'standard' margins. If you have a fancier printer, you may want",
		"to enter the printer menu, list the predefined printers there,",
		"and select yours as the default if it is already defined or ",
		"define a new printer type for your printer. ",
		"",
#ifdef CPM
		"If your printer is not available as the CP/M list device, or",
		"if you are running a version of CP/M or a compatible operating",
		"system with which it is possible to determine when the printer",
		"is ready for characters (CP/M 2.0 and higher can), then you",
		"should enter the port menu and define the appropriate ports.",
		"",
#endif
		"You can at any time type Control-G (hold down the CTRL key and",
		"type G) to escape from the current section of the program.",
		"",
		NULL);
	TPuts("<Type any character to continue>");
	TGetChar();
	do DEnter(
		"","","","","","","","","",
		Copyright(),"",
		"If you are attempting to do this for the first time, then",
		"you should probably do selections 1 thru 3 in order, (consulting",
		"the manuals for Perfect Writer, your computer and your printer)",
		"and if necessary, 4 and 5. You should then test your work with the",
		"document TEST.MSS, provided with the Perfect Writer Package.",
		"",
		"We recommend that you try setting up your printer as a 'Vanilla'",
		"device first, and then proceed to incorporate other features that ",
		"your printer may support. Working in small steps and testing often ",
		"allows you to spot errors more easily.",
		NULL);
	while (!DMenu(
		TITLE,"Perfect Writer Configuration Program Master Menu",
#ifdef CPM
		"Define input/output port usage",&EPorts,
#endif
		"Specify, design or change printer types",&EPrints,
		"Select Perfect Writer default style parameters",&EStyle,
		"Edit character width tables",&EWidths,
		"Edit character translation tables",&ETran,
		"Exit configuration program and update data file",NULL,
		NULL));
	strcpy(hdr.verse,VERSION);
	if (seek(fd,0,ABS)<0 || write(fd,&hdr,RECSIZE)<0)
		Error("Data file write error.");
	close(fd);
	DEnter(
		"PF.DAT updated.",
		"Exiting pfconfig.",
		"",
		NULL);
	TFini();
	}

#ifdef CPM
EPorts()				/* Define the printer port type */
{
	int ENewPort(), EEditPort(), EDelPort(), ELstPort(), ESelPort();

	do DEnter(
		"","","","","","","","","","","",
		Copyright(),"",
		"This Menu is used to help you define how Perfect Printer will get",
		"information from Perfect Format to your printer. There are a number",
		"of ways that this can occur, but by far the simplest is to use the BIOS",
		"in CP/M for output. If your BIOS can determine when characters are ",
		"ready to be accepted by the printer (CP/M 2.0 and higher can) then",
		"you should specify this information. If your printer sends characters",
		"back to the computer and will need a synchronization protocol, then",
		"you will also need to define an input port for the printer in addition",
		"to an output port.",
		"",
		"All the information needed for this menu can probably be",
		"found in the hardware manuals for your computer and printer.",
		NULL);
	while (!DMenu(
		TITLE,"Port Definition Menu",
		"List currently defined ports",&ELstPort,
		"Enter a new port description",&ENewPort,
		"Update existing port definition",&EEditPort,
		"Delete a port definition",&EDelPort,
		"Select default printer ports",&ESelPort,
		"Return to main menu",NULL,
		NULL));
	}

ENewPort()			/* Define a new port type */
{
	int recnum;
	char tname[16];

	if (DEnter(
		"Name of port to be defined: ",
		STRING,16,&tname,
		NULL)) return;
	recnum=FindRec(PORT,tname);
	if (recnum>0) {
		DEnter("That port is already defined",NULL);
		return;
		}
	recnum = -recnum;
	if (EntPort(ALL)) {
		if (portrec.polarity) portrec.polarity=portrec.readymask;
		WriteRec(PORT,recnum);
		}
	}

EEditPort()			/* Edit a port type */
{
	int recnum, field, fcnt;
	char tname[16];

	if (DEnter(
		"Name of port to be edited: ",
		STRING,16,&tname,
		NULL)) return;
	recnum=FindRec(PORT,tname);
	if (recnum<=0) {
		DEnter("That port is not defined.",NULL);
		return;
		}
	repeat {
		fcnt=SumPort();
		if (DEnter(
			"Field number to edit (or Control-G): ",
			RANGE,1,fcnt,&field,
			NULL)) break;
		EntPort(field);
		}
	if (portrec.polarity) portrec.polarity=portrec.readymask;
	WriteRec(PORT,recnum);
	}

EDelPort()			/* Delete a port description */
{
	int recnum;
	char tname[16];

	if (DEnter(
		"Name of port to be deleted: ",
		STRING,16,&tname,
		NULL)) return;
	recnum=FindRec(PORT,tname);
	if (recnum<=0) {
		DEnter("That port is not defined.",NULL);
		return;
		}
	SumPort();
	TNL();
	DEnter(
		"OK to delete port definition? ",
		NULL);
	if (DYesNo()) {
		portrec.pname[0]=NUL;
		WriteRec(PORT,recnum);
		}
	}

ELstPort()			/* List the currently defined ports */
{
	int recnum;

	DEnter("The currently defined ports are: ",NULL);
	for (recnum=hdr.fport; recnum<hdr.fterm; ++recnum) {
		ReadRec(PORT,recnum);
		if (portrec.pname[0]) {
			TNL();
			printf("     %s",portrec.pname);
			}
		}
	TNL();
	TPuts("<Type any character to continue>");
	TGetChar();
	TNL();
	}

ESelPort()			/* Select the default printer ports */
{
	char tname[16];
	int recnum;

	if (hdr.prtoutp>0) {
		ReadRec(PORT,hdr.prtoutp);
		TNL();
		printf("The current printer output port is: %s",portrec.pname);
		TNL();
		}
	if (hdr.prtinp>0) {
		ReadRec(PORT,hdr.prtinp);
		TNL();
		printf("The current printer input port is: %s",portrec.pname);
		TNL();
		}
	TNL();
	recnum=hdr.prtoutp;
	repeat {
		if (DEnter(
			"What is the name of the printer output port: ",
			STRING,16,&tname,
			NULL)) break;
		recnum=FindRec(PORT,tname);
		if (recnum<=0) DEnter("That port is not defined.",NULL);
		else break;
		}
	hdr.prtoutp=recnum;
	recnum=hdr.prtinp;
	repeat {
		if (DEnter(
			"What is the name of the printer input port: ",
			STRING,16,&tname,
			NULL)) break;
		recnum=FindRec(PORT,tname);
		if (recnum<=0) DEnter("That port is not defined.",NULL);
		else break;
		}
	hdr.prtinp=recnum;
	}
#endif

EPrints()				/* Edit printer definition records */
{
	int ENewPrnt(), EEditPrnt(), EDelPrnt(), ELstPrnt(), ESelPrnt();

	do DEnter(
		"","","","","","","","","",
		Copyright(),"",
 		"This menu is intended to help you define the characteristics of the",
		"printer you will use with Perfect Format and Perfect Printer. You will",
		"define a different 'device' or 'printer type' for each physical printer",
		"that you will use, and also for each different paper size or character",
		"pitch. For instance if you have a dot matrix printer that can print in ",
		"four different character pitches, then you should define four printer",
		"types for this printer, and the initialization and de-init strings ",
		"should turn on the correct character size for each one. Or, if you have",
		"two sizes of paper you will be using, you will want to define different",
		"printer types for each one.",
		"",
		"All of the questions in this menu can probably be answered either",
		"by physically measuring paper, or by the manual for your printer.",
		NULL);
	while (!DMenu(
		TITLE,"Printer Type Definition Menu",
/*		"List the currently defined printer types",&ELstPrnt,
		"Define a new printer type",&ENewPrnt,
		"Update existing printer definition",&EEditPrnt,
		"Delete a printer definition",&EDelPrnt,
		"Select the default printer type",&ESelPrnt,	*/
		"Display the printer list",&ELstPrnt,
		"Define and add a new printer type to the printer list",&ENewPrnt,
		"Change an existing printer type from the printer list",&EEditPrnt,
		"Delete a printer type from the printer list",&EDelPrnt,
		"Choose the default printer type to be used by Perfect Format",&ESelPrnt,
		"Return to main menu",NULL,
		NULL));
	}

ENewPrnt()			/* Define a new printer type */
{
	int recnum;
	char tname[16];

	if (DEnter(
		"Name of printer to be defined: ",
		STRING,16,&tname,
		NULL)) return;
	recnum=FindRec(PRINT,tname);
	if (recnum>0) {
		DEnter("That printer type is already defined",NULL);
		return;
		}
	recnum = -recnum;
	instr[0]
		= fnstr[0]
		= nlstr[0]
		= bonstr[0]
		= boffstr[0]
		= ionstr[0]
		= ioffstr[0]
		= f1onstr[0]
		= f1offstr[0]
		= f2onstr[0]
		= f3onstr[0]
		= f2offstr[0]
		= f3offstr[0]
		= NUL;
	if (EntPrnt(ALL)) {
		PackStr(&printrec.initstr,&printrec.strspc,SSPACE,&instr,&fnstr,
			&nlstr,&bonstr,&boffstr,&ionstr,&ioffstr,
			&f1onstr, &f1offstr, &f2onstr, &f2offstr, &f3onstr, &f3offstr,
			NULL);
		WriteRec(PRINT,recnum);
		}
	}

EEditPrnt()			/* Edit a printer type */
{
	int recnum, field, fcnt;
	char tname[16];

	if (DEnter(
		"Name of printer to be edited: ",
		STRING,16,&tname,
		NULL)) return;
	recnum=FindRec(PRINT,tname);
	if (recnum<=0) {
		DEnter("That printer type is not defined.",NULL);
		return;
		}
	UnPackStr(&printrec.initstr,&printrec.strspc,&instr,&fnstr,&nlstr,
		&bonstr,&boffstr,&ionstr,&ioffstr,
		&f1onstr, &f1offstr, &f2onstr, &f2offstr, &f3onstr, &f3offstr,
		NULL);
	repeat {
		fcnt=SumPrnt();
		if (DEnter(
			"Field number to edit (or Control-G): ",
			RANGE,1,fcnt,&field,
			NULL)) break;
		EntPrnt(field);
		}
	PackStr(&printrec.initstr,&printrec.strspc,SSPACE,&instr,&fnstr,&nlstr,
		&bonstr,&boffstr,&ionstr,&ioffstr,
		&f1onstr, &f1offstr, &f2onstr, &f2offstr, &f3onstr, &f3offstr,
		NULL);
	WriteRec(PRINT,recnum);
	}

EDelPrnt()			/* Delete a printer type */
{
	int recnum;
	char tname[16];

	if (DEnter(
		"Name of printer to be deleted: ",
		STRING,16,&tname,
		NULL)) return;
	recnum=FindRec(PRINT,tname);
	if (recnum<=0) {
		DEnter("That printer type is not defined.",NULL);
		return;
		}
	UnPackStr(&printrec.initstr,&printrec.strspc,&instr,&fnstr,&nlstr,
		&bonstr,&boffstr,&ionstr,&ioffstr,
		&f1onstr, &f1offstr, &f2onstr, &f2offstr, &f3onstr, &f3offstr,
		NULL);
	SumPrnt();
	TNL();
	DEnter(
		"OK to delete printer definition? ",
		NULL);
	if (DYesNo()) {
		printrec.dname[0]=NUL;
		WriteRec(PRINT,recnum);
		}
	}

ELstPrnt()			/* List the currently defined printers */
{
	int recnum, cnt;

	cnt=0;
	DEnter("The currently defined printer types are: ",NULL);
	for (recnum=hdr.fprint; recnum<hdr.fmicro; ++recnum) {
		ReadRec(PRINT,recnum);
		if (printrec.dname[0]) {
			if ( !(cnt++ % 4) ) TNL(); 
			printf("   %-16s",printrec.dname);
#ifdef	LATTICE
			fflush(stdout);
#endif
			}
		}
	TNL();
	TPuts("<Type any character to continue>");
	TGetChar();
	TNL();
	}

ESelPrnt()			/* Select the default printer type */
{
	char tname[16];
	int recnum;

	if (hdr.ourprint>0) {
		ReadRec(PRINT,hdr.ourprint);
		TNL();
		printf("The current default printer is: %s",printrec.dname);
#ifdef LATTICE
		fflush(stdout);
#endif
		TNL();
		}
	if (hdr.conprint>0) {
		ReadRec(PRINT,hdr.conprint);
		TNL();
		printf("The current printer type for console output is: %s",
			printrec.dname);
#ifdef LATTICE
		fflush(stdout);
#endif
		TNL();
		}
	TNL();
	recnum=hdr.ourprint;
	repeat {
		if (DEnter(
			"What is the name of the default printer type: ",
			STRING,16,&tname,
			NULL)) break;
		recnum=FindRec(PRINT,tname);
		if (recnum<=0) DEnter("That printer type is not defined.",NULL);
		else break;
		}
	hdr.ourprint=recnum;
	recnum=hdr.conprint;
	repeat {
		if (DEnter(
			"What is the name of the printer type for console output: ",
			STRING,16,&tname,
			NULL)) break;
		recnum=FindRec(PRINT,tname);
		if (recnum<=0) DEnter("That printer type is not defined.",NULL);
		else break;
		}
	hdr.conprint=recnum;
	}

EStyle()				/* Select Perfect Writer default style paramiters */
{
	int fcnt, field;

	ReadRec(SCRIBBLE,2);
	repeat {
		fcnt=SumSty();
		if (DEnter(
			"Field number to edit (or Control-G): ",
			RANGE,1,fcnt,&field,
			NULL)) break;
		EntSty(field);
		}
	scribrec.levindent=TRUE;			/* default values */
	scribrec.levhang=FALSE;
	WriteRec(SCRIBBLE,2);
	}

EWidths()				/* Edit character width tables */
{
	int EEntWid(), ELstWid();

	do DEnter(
		"","","","","","","","",
		Copyright(),"",
		"There are a few character width tables which give the width",
		"of each character in micas for proportionally spaced devices.",
		"These numbers should be accurate to the nearest mica.  A mica",
		"is 1/2540 inch.  These records are selected by the character",
		"width table selection in the printer type definition.",
		NULL);
	while (!DMenu(
		TITLE,"Character Width Table Menu",
		"Enter character width values",&EEntWid,
		"List current width values",&ELstWid,
		"Return to main menu",NULL,
		NULL));
	}

EEntWid()				/* Enter character widhts */
{
	int tnum, from, to;

	if (DEnter(
		"Width table to use: ",
		RANGE,0,(hdr.ftran-hdr.fmicro)/2-1,&tnum,
		NULL)) return;
	ReadRec(MICRO,hdr.fmicro+tnum*2);
	repeat {
		if (DEnter(
			"","","","","",
			Copyright(),"",
			"Please enter the range of characters for which you wish",
			"to enter width values, or type Control-G to exit.",
			"This range is entered as the ASCII decimal code; the",
			"normal range is from 32 (<Space>) to 126 ('~').",
			"Starting character index: ",
			RANGE,0,127,&from,
			NULL)) break;
		if (DEnter(
			"Final character index: ",
			RANGE,from,127,&to,
			NULL)) break;
		for (; from<=to; ++from) {
			printf("Width of '%c': ",from);
#ifdef LATTICE
			fflush(stdout);
#endif
			if (DEnter(MICATYPE,&widrec.cwid[from],NULL)) break;
			}
		}
	WriteRec(MICRO,hdr.fmicro+tnum*2);
	}

ELstWid()				/* List character width values */
{
	int tnum, from, to;

	if (DEnter(
		"Width table to use: ",
		RANGE,0,(hdr.ftran-hdr.fmicro)/2-1,&tnum,
		NULL)) return;
	ReadRec(MICRO,hdr.fmicro+tnum*2);
	repeat {
		if (DEnter(
			"","","","","",
			Copyright(),"",
			"Please enter the range of characters for which you wish",
			"to display width values, or type Control-G to exit.",
			"This range is entered as the ASCII decimal code; the",
			"normal range is from 32 (<Space>) to 126 ('~').",
			"Starting character index: ",
			RANGE,0,127,&from,
			NULL)) break;
		if (DEnter(
			"Final character index: ",
			RANGE,from,127,&to,
			NULL)) break;
		for (; from<=to; ++from) {
			printf("Width of '%c': ",from);
#ifdef LATTICE
			fflush(stdout);
#endif
			DSummary(MICATYPE,&widrec.cwid[from],NULL);
			TNL();
			}
		}
	}

ETran()				/* Enter translation table records */
{
	int EEntTran(), ELstTran();

	do DEnter(
		"","","","","","","","","",
		Copyright(),"",
		"There are a few character translation tables which specify a",
		"translation from the normal ASCII character set into a user",
		"defined character set.  This is particularly useful with printers",
		"like the NEC Spinwriter, which has a proportionally spaced print",
		"thimble with a non-standard character arrangement.  Use of these",
		"translation tables is selected in the device description record.",
		NULL);
	while (!DMenu(
		TITLE,"Character Translation Table Menu",
		"Enter character translation table",&EEntTran,
		"List current translation table",&ELstTran,
		"Return to main menu",NULL,
		NULL));
	}

EEntTran()			/* Enter character translation table */
{
	int tnum, from, to;
	char tchar;

	if (DEnter(
		"Translation table to use: ",
		RANGE,0,hdr.hmax-hdr.ftran-1,&tnum,
		NULL)) return;
	ReadRec(TRAN,hdr.ftran+tnum);
	repeat {
		if (DEnter(
			"","","","","",
			Copyright(),"",
			"Please enter the range of characters for which you wish",
			"to enter translations, or type Control-G to exit.",
			"This range is entered as the ASCII code in decimal; the",
			"normal range is from 32 (<Space>) to 126 ('~').",
			"Starting character index: ",
			RANGE,0,127,&from,
			NULL)) break;
		if (DEnter(
			"Final character index: ",
			RANGE,from,127,&to,
			NULL)) break;
		DEnter(
			"","","","","",
			Copyright(),"",
			"Translation table entries are made by typing the character",
			"you would like the current character translated to when",
			"output.  Typing Control-G will abort further entry, typing",
			"Control-Q will quote the next character typed, typing ESCAPE",
			"followed by the desired character will cause the high bit",
			"to be set in the character.",
			"",
			NULL);
		for (; from<=to; ++from) {
			printf("Translate '%c' to: ",from);
#ifdef LATTICE
			fflush(stdout);
#endif
			switch (tchar=TGetChar()) {

			case CANCEL:
				from=to+1;
				break;
			case QUOTE:
				tchar=TGetChar();
				break;
			case ESC:
				tchar=TGetChar() | 0x80;
				break;
				}
			if (from>to) break;
			tranrec.trantbl[from]=tchar;
			printf("'%c'.",tchar);
#ifdef LATTICE
			fflush(stdout);
#endif
			TNL();
			}
		}
	WriteRec(TRAN,hdr.ftran+tnum);
	}

ELstTran()			/* List character translation tables */
{
	int tnum, from, to;

	if (DEnter(
		"Translation table to display: ",
		RANGE,0,hdr.hmax-hdr.ftran-1,&tnum,
		NULL)) return;
	ReadRec(TRAN,hdr.ftran+tnum);
	repeat {
		if (DEnter(
			"","","","","",
			Copyright(),"",
			"Please enter the range of characters for which you wish to",
			"display character translations, or type Control-G to exit.",
			"This range is entered as the ASCII code in decimal; the",
			"normal range is from 32 (<Space>) to 126 ('~').",
			"Starting character index: ",
			RANGE,0,127,&from,
			NULL)) break;
		if (DEnter(
			"Final character index: ",
			RANGE,from,127,&to,
			NULL)) break;
		for (; from<=to; ++from) {
			printf("Translating '%c' to '%c'.",from,tranrec.trantbl[from]);
#ifdef LATTICE
			fflush(stdout);
#endif
			TNL();
			}
		}
	}

int
ECreate()				/* Create an initial database file */
{
	int fd, rcnt;

	DEnter(
		"","","","","","","","","","","","",
		Copyright(),"",
		"There is no configuration file on the currently selected",
		"disk. You should probably at least be starting with the",
		"configuration file which was distributed with the Perfect",
		"Writer package. However, if you wish to create an empty",
		"configuration file, you can.",
		"Should I create a new file (\"PF.DAT\", 5K)? ",
		NULL);
	if (!DYesNo()) return(-1);
#ifdef CPM
	if ((fd=creat(DATABASE))<0) {
#endif
#ifdef LATTICE
	if ((fd=creat(DATABASE,0x8002))<0) {
#endif
#ifdef UNIX
	if ((fd=creat(DATABASE,0774))<0) {
#endif
		Error("Unable to create database file.");
		return(fd);
		}
	hdr.fport=3;
	hdr.coninp=hdr.conoutp=hdr.prtinp=hdr.prtoutp=hdr.modinp=hdr.modoutp=0;
	hdr.fterm=9;
	hdr.ourterm=hdr.simterm=0;
	hdr.fprint=14;
	hdr.ourprint=hdr.conprint=0;
	hdr.fmicro=30;
	hdr.maxmicro=0;
	hdr.ftran=38;
	hdr.hmax=40;
	strcpy(hdr.verse,VERSION);
	for (rcnt=40; rcnt>0; --rcnt) {
		if (write(fd,&hdr,RECSIZE)<0) {
			Error("Write error while creating database file.");
			close(fd);
			unlink(DATABASE);
			return(-1);
			}
		hdr.fport=0;
		}
	close(fd);
	if ((fd=open(DATABASE,UPDATE))<0) Error("Database creation error");
	return(fd);
	}

/* Supporting routines */

PackStr(strs,space,slen,arg)	/* Pack away the string arguments */
	struct str *strs;
	char *space;
	int slen, arg;
{
	int *argp;
	char *cptr;

	cptr=space;
	for (argp = &arg; *argp; ++argp) {
		slen -= strs->len=strlen(*argp);
		strs->idx=cptr-space;
		if (slen<0) {
			Error("Not enough room for strings.");
			break;
			}
		strcpy(cptr,*argp);
		cptr+=strs->len;
		++strs;
		}
	}

UnPackStr(strs,space,arg)	/* UnPack the string arguments */
	struct str *strs;
	char *space;
	int arg;
{
	int *argp, cnt;
	char *cptr, *dptr;

	for (argp = &arg; *argp; ++argp) {
		cptr = &printrec.strspc[strs->idx];
		dptr = *argp;
		for (cnt=strs->len; cnt>0; --cnt) *dptr++ = *cptr++;
		*dptr=NUL;
		++strs;
		}
	}

int
FindRec(type,name)			/* Locate a record by class and name */
						/* returns the record number if found */
						/* or negative of a usable record if not */
	int type;
	char *name;
{
	int frec, lrec, erec;

	switch (type) {

	case PORT:
		frec=hdr.fport;
		lrec=hdr.fterm;
		break;
	case TERM:
		frec=hdr.fterm;
		lrec=hdr.fprint;
		break;
	case PRINT:
		frec=hdr.fprint;
		lrec=hdr.fmicro;
		break;
	default:
		Error("Invalid record type.");
		return(-1);
		}
	if (seek(fd,frec*RECSIZE,ABS)<0) Error("Data file seek error.");
	tsect[0]=NUL;
	for (erec=0; frec<lrec; ++frec) {
		if (read(fd,tsect,RECSIZE)<0) Error("Data file read error.");
		if (CComp(name,tsect)) break;
		if (tsect[0]==NUL) erec=frec;
		}
	if (frec>=lrec) {
		strcpy(tsect,name);
		frec = -erec;
		}
	switch (type) {

	case PORT:
		movmem(tsect,&portrec,sizeof(portrec));
		break;
	case TERM:
		break;
	case PRINT:
		movmem(tsect,&printrec,sizeof(printrec));
		break;
		}
	return(frec);
	}

ReadRec(type,recnum)	/* Read a data record */
	int type, recnum;
{
	if (seek(fd,recnum*RECSIZE,ABS)<0 || read(fd,tsect,RECSIZE)!=RECSIZE)
		Error("Data file read error.");
	switch (type) {

	case SCRIBBLE:
		movmem(tsect,&scribrec,sizeof(scribrec));
	case PORT:
		movmem(tsect,&portrec,sizeof(portrec));
		break;
	case TERM:
		break;
	case PRINT:
		movmem(tsect,&printrec,sizeof(printrec));
		break;
	case MICRO:
		movmem(tsect,&widrec,128);
		if (read(fd,&widrec.cwid[64],RECSIZE)!=RECSIZE)
			Error("Data file read error.");
		break;
	case TRAN:
		movmem(tsect,&tranrec,sizeof(tranrec));
		break;
		}
	}

WriteRec(type,recnum)	/* Write out a data record */
	int type, recnum;
{
	switch (type) {

	case SCRIBBLE:
		movmem(&scribrec,tsect,sizeof(scribrec));
		break;
	case PORT:
		movmem(&portrec,tsect,sizeof(portrec));
		break;
	case TERM:
		break;
	case PRINT:
		movmem(&printrec,tsect,sizeof(printrec));
		break;
	case MICRO:
		movmem(&widrec,tsect,128);
		break;
	case TRAN:
		movmem(&tranrec,tsect,sizeof(tranrec));
		break;
		}
	if (seek(fd,recnum*RECSIZE,ABS)<0 || write(fd,tsect,RECSIZE)<0)
		Error("Data file write error.");
	if (type==MICRO && write(fd,&widrec.cwid[64],RECSIZE)<0)
		Error("Data file write error.");
	}

CComp(a,b)			/* case indep. compare two C strings */
	char *a, *b;
{
	do {
		if (tolower(*a) != tolower(*b)) return(FALSE);
		} while (b++,*a++);
	return(TRUE);
	}

Error(mesg)			/* Print an error message */
	char *mesg;
{
	TNL();
	printf("Error: %s",mesg);
#ifdef LATTICE
	fflush(stdout);
#endif
	TNL();
	}

Copyright()
{
	strlen("Written & directed by Barry A. Dobyns");
	return("Perfect Format Configuration (C) 1982 Perfect Software, Inc.");
	}

char foo[80];

Version()
{
	strcpy(foo,"Version: ");
	strcat(foo,VERSION);
#ifdef ALPHA
	strcat(foo,ALPHA);
#endif
	strcat(foo," created on ");
	strcat(foo,DATE);
#ifdef CPM
	strcat(foo," serial ");
	strcat(foo,sernum());
#endif
	return(foo);
	}

/* END OF PFPF.C - Configuration file editor */
                                                                                                        