/******************************************************************************
   INPUT.C -- Input file interface and tokenizer
		    Ultimate output device characteristics interface

	(C) 1982 Perfect Software, Inc.

	01/26/82	Version 1.00 by Barry A. Dobyns

******************************************************************************/

#include "pf.gbl"

#define NOTINITED	1
#define CONSOLE	32001

IAppTok()					/* append current token to buffered token */
{
	if ((inp.ibuflen+=tok.tbuflen) >= MAXINPLEN-1) {
		TIntError("Input buffer overflow.");
		inp.ibuflen=MAXINPLEN-50;
		return;
		}
	strcat(&inp.ibuffer,&tok.tbuffer);
	}

IClearBuf()				/* clear the buffered token register */
{
	inp.ibuflen=0;
	inp.ibuffer[0]=NUL;
	}

IConsInput(buffer,length)	/* read some text from the console */
	char *buffer;			/* NOTE: needs ^Q to be complete */
	unsigned length;
{
	char *cptr, chr;

	cptr=buffer;
	while ((*cptr=TGetChr())!=EOF) {
#ifdef LATTICE
		if (cptr>=(buffer+(length-1))) {
#else
		if (cptr>=&buffer[length-1]) {
#endif
			TBell();
			continue;
			}

		switch (*cptr) {

		case BS:
		case DEL:
			if (cptr>buffer) --cptr;
			TPut(BS);
			TPut(SP);
			TPut(BS);
			break;
		case CR:
			*cptr++=NL;
			TNL();
			break;
		case FF:
		case 18:	/* ^R */
			TNL();
			*cptr=NUL;
			TPuts(buffer);
			break;
		case 21:  /* ^U */
		case 24:  /* ^X */
			while (cptr>buffer && *(cptr-1)!=NL) {
				--cptr;
				TPut(BS);
				TPut(SP);
				TPut(BS);
				}
			break;
		default:
			TPut(*cptr++);
#ifdef LATTICE
			fflush(stdout);
#endif
			break;
			}
		}
	TNL();
	}

STRING *
IGetBuf()					/* return the buffered token register as a
							string */
{
	return(SCToS(inp.ibuffer));
	}

char *
IGetFile()				/* return "file <filename>" or "header" or... */
{
	return(&file.filedesc);
	}

unsigned
IGetLine()				/* return current line number of whatever */
{
	return(file.linenum);
	}

char *
IGetTok()					/* return the current token as a pointer to
							characters */
{
	return(tok.tbuffer);
	}

char
IGetType()				/* return type of current token */
{
	return(tokentype);
	}

IInclude(fname)			/* switch to include file */
	char *fname;
{
	char filename[LENFILENAME];
	INBUFFER *tmp;

	if (file.fileprev==NOTINITED) {
		file.fileprev=NULL;
		file.linenum=0;
		file.filedesc[0]=NUL;
		}
	else {
		tmp=MemGet(sizeof(file));
		movmem(&file,tmp,sizeof(file));
		file.fileprev=tmp;
		}

	if (SCompToC(fname,"con:") || SCompToC(fname,"tty:")) {
		strcpy(file.filedesc,"console input");
		IConsInput(&inputbuffer,BUFFSIZE);
		file.fd=CONSOLE;
		file.curchar=inputbuffer;
		}
	else {
		strcpy(&filename,fname);
		ProcessSuffix(filename,".MSS",FALSE);
#ifdef LATTICE
		if ((file.fd=open(filename,0x8000))<0) {
#else
		if ((file.fd=open(filename,0))<0) {
#endif
			TError("Can't open file '",filename,"'.");
			*file.curchar=EOF;
			return;
			}
		strcpy(file.filedesc,"file ");
		strcat(file.filedesc,filename);
		file.curchar = &inputbuffer[BUFFSIZE];	/* special hack to make */
		file.blocknum = -BUFFRECS;			/* first block work */
		INextChar();
		}
	file.linenum=1;

	INextTok();
	}

INextChar()				/* read the next character from a file/string */
{
	int status;

	++file.curchar;
	if (file.fd>=0 && file.curchar>&inputbuffer[BUFFSIZE-1]) {
		if ((status=read(file.fd,&inputbuffer,BUFFRECS))<0)
			TError("File read error.",NULL,NULL);
		if (status<BUFFRECS) inputbuffer[status*RECSIZE]=EOF;
		file.curchar=inputbuffer;
		file.blocknum+=BUFFRECS;
		}
	}

INextTok()				/* parse the next token */
{
	INBUFFER *sptr;

	if (unget) {
		unget=FALSE;
		return;
		}
#ifdef CPM
	while ((tokentype=typearray[*file.curchar])==FLUSH) INextChar();
	tok.tbuffer[0]= *file.curchar;
#else
	while ((tokentype=typearray[ICurChar()])==FLUSH) INextChar();
	tok.tbuffer[0]=ICurChar();
#endif
	tok.tbuflen=1;
	switch(tokentype) {

	case EOFT:
		if (file.fileprev) {
			if (file.fd>=0) {
				if (file.fd<CONSOLE) close(file.fd);
				for (sptr=file.fileprev; sptr->fd<0; sptr=sptr->fileprev);
#ifdef CPM
				seek(sptr->fd,sptr->blocknum,0);
#else
				lseek(sptr->fd,(long)sptr->blocknum,0);
#endif
				read(sptr->fd,&inputbuffer,BUFFRECS);
				}
			sptr=file.fileprev;
			movmem(file.fileprev,&file,sizeof(file));
			MemFree(sptr);
			if(file.fd>=0) 
				SetVar("filename",'s',SCToS(&file.filedesc[5]));	
			}
		break;
	case TOKEN:
	case WHITESPACE:
		repeat {
			INextChar();
			if (tok.tbuflen>=TOKMAXLEN) {
				TIntError("Current token overflow.");
				tok.tbuflen=TOKMAXLEN-50;
				break;
				}
#ifdef CPM
			if (typearray[*file.curchar]!=tokentype) break;
			tok.tbuffer[tok.tbuflen++]= *file.curchar;
#else
			if (typearray[ICurChar()]!=tokentype) break;
			tok.tbuffer[tok.tbuflen++]=ICurChar();
#endif
			}
		break;
	case NEWLINE:
		file.linenum++;
		INextChar();
		break;
	default:
		INextChar();
		break;
		}
	tok.tbuffer[tok.tbuflen]=NUL;
	}

IPopBuf()					/* pop the buffer from the stack */
{
	if (inpnum>0) movmem(&inpsave[--inpnum],&inp,sizeof(inp));
	}

IPushBuf()				/* push the buffered token register onto
							a stack.  don't alter the register */
{
	if (inpnum<2) movmem(&inp,&inpsave[inpnum++],sizeof(inp));
	IClearBuf();
	}

IUnGet()					/* return the current token again */
{
	unget=TRUE;
	}

IUse(str,from)				/* use a string for input */
	char *str, *from;
{
	INBUFFER *tmp;

	tmp=MemGet(sizeof(file));
	movmem(&file,tmp,sizeof(file));
	file.fileprev=tmp;

	file.curchar=str;
	strcpy(&file.filedesc,from);
	file.linenum=1;
	file.fd= -1;

	INextTok();
	}

DRead(fd,buffer,rec,nrecs,msg)	/* read from the configuration file */
	int fd, rec, nrecs;
	char *buffer, *msg;
{
#ifndef CPM
	rec *= 128;
	nrecs *= 128;
#endif
	if (
#ifdef CPM
	     seek(fd,rec,0)
#else
	     lseek(fd,(long)rec,0)
#endif
			   <0 || read(fd,buffer,nrecs)<nrecs) {
		TPuts(" Unable to read ");
		TPuts(msg);
		fatal(" from configuration file.\n");
		}
	}

#ifndef CPM
ICurChar()
{
	return(*file.curchar<0 ? *file.curchar+256 : *file.curchar);
	}
#endif

Fatal(msg)
char *msg;
{
	TPuts("\n Fatal: ");
	TPuts(msg);
	TPuts("\n");
	xxit(0);
	}

/* end of INPUT.C */
                                           