/* COMMANDS.C -- pf command interpeter **************************************

	(C) 1982 Perfect Software, Inc.

	01/26/82	Version 1.00 by Barry A. Dobyns

******************************************************************************/

#include "pf.gbl"

#ifndef CPM
FLAG CheckVar(), CheckEnv(), CheckSec();
#endif

SCommand(tkn)				/* process a command */
	char *tkn;
{
	STRING *token, *token2;
	char which, *SSToC();
	INDLIST *iptr, *iptr2, *iptrold;
	NOTELIST *nptr;
	MICA LGetCol(), amt;
	int CloseFoots();
	VALLIST *vptr;

	if (MulComp(tkn,"\\","/")) {			/* either '@\' or '@/' */
		if (SCComp(env.name,"description")) {
			BreakTok();
			if (LGetCol()>=env.cureleft) BreakLine();
			else LPutWhite(env.cureleft-LGetCol());
			}
		return;
		}

/* ENVIRONMENTS */

	if (CheckEnv(tkn)) return;

/* BEGIN and END */

	if (SCComp(tkn,"begin")) {
		token=GetOneArg(RETURN);
		if (SCompToC(token,"comment")) {
			SFree(token);
			FlushArg("comment");
			return;
			}
		openneeded=FALSE;
		if (CheckEnv(token)) env.howclose='e';
		else TError("Unknown environment '",SSToC(token),"'.");
		SFree(token);
		return;
		}
	if (SCComp(tkn,"end")) {
		token=GetOneArg(RETURN);
		if (env.howclose=='e' && SCComp(env.name,token)) (*env.closeproc)();
		else {
			TError("Incorrect Environment Closing.  Tried to end a '",
				SSToC(token),"' environment.");
			TPuts("A '");
			TPuts(env.name);
			TPuts("' environment is open, and it should be closed with '");
			if (env.howclose=='e') TPuts("@end");
 			else TPut(env.howclose);
			TPuts("'.\n");
			}
		SFree(token);
		return;
		}

/* INLINE Environment */

	if (InLine(tkn,"+",SUPERON,SUPEROFF)) return;
	if (InLine(tkn,"-",SUBON,SUBOFF)) return;
	if (InLine(tkn,"b",BOLDON,BOLDOFF)) return;
	if (InLine(tkn,"i",ITALON,ITALOFF)) return;
	if (InLine(tkn,"p",BITALON,BITALOFF)) return;
	if (InLine(tkn,"r",ROMANON,ROMANOFF)) return;
	if (InLine(tkn,"t",ROMANON,ROMANOFF)) return;
	if (InLine(tkn,"u",UNNBON,UNNBOFF)) return;
	if (InLine(tkn,"ux",UNALLON,UNALLOFF)) return;
	if (InLine(tkn,"un",UNANON,UNANOFF)) return;
	if (InLine(tkn,"f1",F1ON,F1OFF)) return;
	if (InLine(tkn,"f2",F2ON,F2OFF)) return;
	if (InLine(tkn,"f3",F3ON,F3OFF)) return;

/* I/O Commands */

	if (SCComp(tkn,"comment")) {
		GetOneArg(ARGFLUSH);
		return;
		}
	if (SCComp(tkn,"include")) {
		token=GetOneArg(RETURN);
		IInclude(SSToC(token));
		SFree(token);
#ifndef LATTICE
		if (!MulComp(token,"con:","tty:")) {
			TPuts("\nIncluding ");
			TPuts(IGetFile());
			TNL();
			}
#endif
		pf();
		return;
		}
	if (SCComp(tkn,"device")) {
#ifdef OVERLAID
		OvlCall(DSETTYPE,'n',SSToC(token=GetOneArg(RETURN)));
#else
		DSetType('n',SSToC(token=GetOneArg(RETURN)));
#endif
		SetVar("devicename",'s',SCToS(dev.dname));
		SFree(token);
		return;
		}
	if (SCComp(tkn,"message")) {
		TNL();
		GetOneArg(PRINT);
		return;
		}
	if (SCComp (tkn, "stringinput")) {
#ifdef OVERLAID
		OvlCall(DOSTRINPUT);
#else
		DoStrInput();
#endif
		return;
		}

/* HEADINGS, FOOTINGS, and FOOTNOTES */

	if (which=MulComp(tkn,"pageheading","pagefooting")) {
#ifdef OVERLAID
		OvlCall(DOHEADING,which);
#else
		DoHeading(which);
#endif
		return;
		}

	if (SCComp(tkn,"note") || (sty.footstyle=='e' && SCComp(tkn,"foot"))) {
#ifdef OVERLAID
		OvlCall(DONOTE);
#else
		DoNote();
#endif
		return;
		}

	if (SCComp(tkn,"foot")) {
#ifdef OVERLAID
		OvlCall(DOFOOT);
#else
		DoFoot();
#endif
		return(TRUE);
		}
	if (SCComp(tkn,"index")) {
#ifdef OVERLAID
		OvlCall(DOINDEX);
#else
		DoIndex();
#endif
		return(TRUE);
		}


/* CHAPTERS, SECTIONS, and SUBSECTIONS */

	if (CheckSec(tkn)) return;

/* VARIABLE STORING AND PRINTING */

	if (CheckVar(tkn)) return;

/* CASE */

	if (SCComp(tkn,"case")) {
#ifdef OVERLAID
		OvlCall(DOCASE);
#else
		DoCase();
#endif
		return;
		}

/* STYLE */

	if (SCComp(tkn,"style")) {
#ifdef OVERLAID
		OvlCall(DOSTYLE);
#else
		DoStyle();
#endif
		return;
		}

/* WHITESPACE COMMANDS */

	if (SCComp(tkn,"newpage")) {
		BreakLine();
		PNewPage();
		return;
		}
	if (SCComp(tkn,"condpage")) {
		ArgOn("@CondPage");
#ifdef OVERLAID
		amt=OvlCall(GETDIMARG);
#else
		amt=GetDimArg();
#endif
		ArgOff("@CondPage");
		if (PThisClose(amt)){
			BreakLine();
			PNewPage();
			}
		return;
		}
	if (SCComp(tkn,"blankpage")) {
		ArgOn("@BlankPage");
#ifdef OVERLAID
		blankpages+=OvlCall(GETNUMARG);
#else
		blankpages+=GetNumArg();
#endif
		ArgOff("@BlankPage");
		return;
		}
	if (SCComp(tkn,"blankspace")) {
		BreakLine();
		ArgOn("@BlankSpace");
#ifdef OVERLAID
		amt=OvlCall(GETDIMARG);
#else
		amt=GetDimArg();
#endif
		ArgOff("@BlankSpace");
		PPutVert(amt);
		return;
		}
	if (SCComp(tkn,"w")) {
		GetOneArg(HOLD);
		return;
		}

/* 'Variable Macros', a good idea by Gene Tenney */

	if (vptr=FindVar(tkn)) {
		if (vptr->valtype=='s') PutStr(SSToC(vptr->value));
		else PutNum(NULL,vptr->value,NULL);
		return;
		}

/* COMMAND NOT FOUND */

	TError("Unknown command '",tkn,"'.");
	openneeded=FALSE;
	IAppTok();
	}

FLAG
CheckVar(tkn)				/* do the variable processing commands */
	char *tkn;
{
	STRING *token, *token2, *sptr;
	char which, *secstr, *SSToC();
	int oldval, val;
	VALLIST *vptr;

	if (SCComp(tkn,"string")) {
#ifdef OVERLAID
		OvlCall (DOSTRING);
#else
		DoString();
#endif
		return(TRUE);
		}
	if (SCComp(tkn,"value")) {
		token=GetOneArg(RETURN);
 		vptr=FindVar(token);
		if (!vptr) TError("@Value: Variable not found '",SSToC(token),"'.");
		else if (vptr->valtype=='s') PutStr(SSToC(vptr->value));
		else PutNum(NULL,vptr->value,NULL);
		SFree(token);
		return(TRUE);
		}
	if (SCComp(tkn,"set")) {
#ifdef OVERLAID
		OvlCall(DOSET);
#else
		DoSet();
#endif
		return(TRUE);
		}
	secstr="chapter section subsection paragraph appendix appendixsection ";
	if (SCComp(tkn,"ref")) {
		val=Index((token=GetOneArg(RETURN)),secstr);
		if (val>5) {
			vptr=FindVar(token);
			if (!vptr) TError("@Ref: Variable not found '",
				SSToC(token),"'.");
			else if (vptr->valtype=='n') PutNum(NULL,vptr->value,NULL);
			else TError("@Ref: '",SSToC(token),
				"' does not contain a number.");
			}
		else Template("csbpan"[val]);
		SFree(token);
		return(TRUE);
		}
	if (SCComp(tkn,"title")) {
		vptr=NULL;
		switch (Index((token=GetOneArg(RETURN)),secstr)) {

		case 0:
			vptr=chaptitle;
			break;
		case 1:
			vptr=sectitle;
			break;
		case 2:
			vptr=subtitle;
			break;
		case 3:
			vptr=paratitle;
			break;
		case 4:
			vptr=apptitle;
			break;
		case 5:
			vptr=asectitle;
			break;
		default:
			TError("@Title: Unknown option '",SSToC(token),"'.");
			break;
			}
		if (vptr) PutStr(vptr->value);
		SFree(token);
		return;
		}
	}

/* END OF COMMANDS.C */
                                                                                                                      