#include "dm.h"
#include <sys/types.h>
#include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>

#define DMRS_FAIL 0
#define DMRS_INCOMPLETE 0
#define DMRS_OK 1
#define BYTEVAL(b) b - 0x30
extern char *GetSessionHost ();

int InitConnection ();

int
RequestRemoteSession (d)
	struct display *d;
{
  int sock;
  int i;
  char buffer[128];

  d->socket = 0;
  d->sessionStatus = DMRS_INCOMPLETE;
  d->verLength = 0;

  sock = InitConnection ();
  if (sock < 0) return 0;

  strcpy (buffer, d->name);
  i = strlen (buffer);
  buffer[i++] = ' ';
  if (d->class) {
	strcpy (&buffer[i], d->class);
	i += strlen (d->class);
  }
  buffer[i++] = ' ';
  buffer[i++] = (d->displayType.location == Local) ? '1' : '0';
  buffer[i++] = (d->displayType.lifetime == Permanent) ? '1' : '0';
  buffer[i++] = (d->displayType.origin == FromFile) ? '1' : '0';
  buffer[i++] = (char) 0;
  if (send (sock, buffer, i, 0) < 0) {
	LogError ("Error sending \"%s\"\n", d->name);
	return 0;
  }

  d->socket = sock;
  return 1;
}

static int
InitConnection ()
{
  char *serverhost;
  struct sockaddr_in name;
  struct hostent *hp, *gethostbyname ();
  int sock;

  serverhost = GetSessionHost ();
  Debug ("Connecting to session host \"%s\".\n", serverhost);
  sock = socket (AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    LogError ("Couldn't create socket.\n");
    return -1;
  }
  name.sin_family = AF_INET;
  hp = gethostbyname (serverhost);
  if (!hp) {
    LogError ("%s: unknown host\n", serverhost);
    return -1;
  }
  bcopy (hp->h_addr, &name.sin_addr, hp->h_length);
  {unsigned short hport = 5383;
  name.sin_port = htons (hport);
  }

  if (connect (sock, &name, sizeof (name)) < 0) {
    LogError ("Couldn't connect to %s\n", serverhost);
    return -1;
  }
  return sock;
}

static int
readRemoteByte (sock)
     int sock;
{
  FD_TYPE fd;
  static struct timeval timeout = {8, 0};
  char b;
  int nf;

    FD_ZERO (&fd);
    FD_SET (sock, &fd);
    nf = select (sock + 1, &fd, 0, 0, &timeout);
    if (nf) {
      if (recv (sock, &b, 1, 0) <= 0) {
	LogError ("error on socket %d", sock);
	return -2;
      }
      else {
        int i;
	i = (unsigned char) b;
	Debug ("read byte 0x%02x\n", i);
	return i;
      }
    }
    else return -1;
}

int
ReadRemoteStatus (d)
     struct display *d;
{
  /*static struct timeval timeout = {0, 0};*/
  char b;

  for (;;) {			/* Read 1 byte while available. */
    int i;
    i = readRemoteByte (d->socket);
    if (i < -1) {
	d->sessionStatus = DMRS_FAIL;
        return 1;
    }
    if (i >= 0) {
				/* Data is available to be read. */
      b = (char) i;

      if (d->verLength == 0) {
				/* This is the byte count header. */
	if (BYTEVAL (b) > 0) {
	  d->verLength = BYTEVAL (b);
	  d->recvdLength = 0;
	  d->verName = (char *) malloc (d->verLength + 1);
	  bzero (d->verName, d->verLength + 1);
	}
	else {
	  d->sessionStatus = DMRS_FAIL;
          Debug ("Remote host reports failed session.\n");
	  return 1;
	}
      }
      else {
	/* This is part of the message data. */
	d->verName[d->recvdLength] = b;
	++(d->recvdLength);
	if (d->recvdLength >= d->verLength) {
	  d->sessionStatus = DMRS_OK;
	  Debug ("Remote host returns \"%s\".\n", d->verName);
	  return 1;
	}
      }
    }
    else {
	Debug ("Incomplete session status read...\n");
	Debug ("%d bytes expected, %d read\n", d->verLength, d->recvdLength);
        return 0;
    }
  }
}

void
FailRemote (d)
     struct display *d;
{
  static char failMessage = 0x30;
  send (d->socket, &failMessage, 1, 0);
  close (d->socket);
}

void
AckRemote (d)
     struct display *d;
{
  static char ackMessage = 0x31;
  send (d->socket, &ackMessage, 1, 0);
  close (d->socket);
}

int
ReadRemoteAck (d)
     struct display *d;
{
  static char ackMessage = 0x31;
  static char failMessage = 0x30;
  int i;

  i = readRemoteByte (d->socket);
  if (i < -1) return -1;
  if (i < 0) return 0;
  if (i == ackMessage) return 1;
  if (i == failMessage) return -1;
  LogError ("Remote host returned unexpected ack 0x%x\n", i);
  return -1;
}
