/* 
 * xdm - display manager daemon
 *
 * $XConsortium: greet.c,v 1.18 89/12/06 19:35:57 keith Exp $
 *
 * Copyright 1988 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Keith Packard, MIT X Consortium
 */

/*
 * widget to get session host
 *
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Label.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>

#include "dm.h"
#include "hosts.h"
#include <time.h>

extern void	exit ();

void SetSessionHost ();
static int	done;

extern XtAppContext context;
extern Widget toplevel;
extern Display *dpy;
static Widget selectHost;

static int old_x, old_y, screen_height, screen_width;
static Dimension box_w, box_h;

static void
GreetMigrate (closure, intervalId)
    XtPointer       closure;
    XtIntervalId    *intervalId;
{
  if (!done) {
    struct display *d;
    int rand ();
    int new_y, new_x;

    d = (struct display *) closure;

    do {
	new_y = random () % (screen_height - box_h);
	new_x = random () % (screen_width - box_w);
    } while (((new_y < (old_y + box_h)) && (new_y > (old_y - box_h))) ||
	     ((new_x < (old_x + box_w)) && (new_x > (old_x - box_w))));

    XtMoveWidget (selectHost, new_x, new_y);
    old_x = new_x;
    old_y = new_y;

    XtAppAddTimeOut (context, d->migrateInterval * 1000, GreetMigrate,
		(closure));
  }
}


static XtIntervalId pingTimeout;

static void
GreetPingServer (closure, intervalId)
    XtPointer	    closure;
    XtIntervalId    *intervalId;
{
    struct display *d;

    d = (struct display *) closure;
    if (!PingServer (d, dpy))
	SessionExit (d, RESERVER_DISPLAY);
    pingTimeout = XtAppAddTimeOut (context, d->pingInterval * 60 * 1000,
				   GreetPingServer, (closure));
}

/*ARGSUSED*/
GreetDone (w, client_data, call_data)
    Widget	w;
    caddr_t client_data, call_data;
{
	int h = (int) client_data;

	Debug ("GreetDone: %d\n", h);
	SetSessionHost (h);
	done = 1;
}

#define BOXPAD 24
#define BUTTONH 48

void
InitGreet (d)
     struct display	*d;
{
  Arg		boxOpts[3];
  Arg		labelOpts[3];
  Arg		commandOpts[2];
  int		i, callback_arg, name_arg;
  Screen	*scrn;
  XtCallbackRec callbacks[2];
  static char *argv[] = {"selectHost", 0};
  int argc;
  Widget box;
  Widget popupShell;
  HostList hostnames;
  Widget topLabWid[3], cmdWid[MAXSESSIONHOSTS], cmdLabWid[MAXSESSIONHOSTS];
  int h;
  Pixel invisible;

  Debug ("greet %s\n", d->name);

  SecureDisplay (d, XtDisplay (toplevel));

  popupShell = XtCreatePopupShell ("selectHost", topLevelShellWidgetClass,
		toplevel, NULL, 0);
  selectHost = popupShell;

  box = XtCreateManagedWidget ("box", boxWidgetClass, popupShell,
			       (char *) 0, 0);

  {
	static char *labels[3] = {
		"label1",
		"label2",
		"label3"
	};
	int i;

	XtSetArg (labelOpts[0], XtNbackground, &invisible);
        XtGetValues (box, labelOpts, 1);
        XtSetArg (labelOpts[0], XtNborderColor, invisible);
	for (i=0; i<3; ++i)
		topLabWid[i] = XtCreateManagedWidget (labels[i],
			labelWidgetClass, box, labelOpts, 1);
  }

  callbacks[0].callback = (XtCallbackProc) GreetDone;
  callbacks[0].closure = (caddr_t) 0;
  callbacks[1].callback = (XtCallbackProc) 0;
  callbacks[1].closure = (caddr_t) 0;
  name_arg = 1;
  XtSetArg (commandOpts[0], XtNcallback, callbacks);
  callback_arg = 0;

  hostnames = GetSessionHosts ();

  XtSetArg (boxOpts[0], XtNborder, invisible);

  for (h = 0; hostnames[h].address[0]; ++h) {
    Widget hostBox;
    Widget command;
    Dimension hi;

    hostBox = XtCreateManagedWidget (hostnames[h].name,
			boxWidgetClass, box, boxOpts, 1);
    callbacks[0].closure = (caddr_t) h;
    XtSetArg (commandOpts[name_arg], XtNlabel, hostnames[h].name);
    command = XtCreateManagedWidget ("command", commandWidgetClass,
			hostBox, commandOpts, 2);
    cmdWid[h] = command;

    XtSetArg (labelOpts[0], XtNbackground, &invisible);
    XtGetValues (hostBox, labelOpts, 1);
    XtSetArg (labelOpts[1], XtNborderColor, invisible);
    XtSetArg (labelOpts[0], XtNheight, &hi);
    XtGetValues (command, labelOpts, 1);
    XtSetArg (labelOpts[0], XtNheight, hi);
    i = 2;
    if (hostnames[h].descrip[0]) {
	XtSetArg (labelOpts[i], XtNlabel, hostnames[h].descrip);
	++i;
    }
    cmdLabWid[h] = XtCreateManagedWidget ("label", labelWidgetClass,
	hostBox, labelOpts, i);
  }
  cmdWid[h] = (Widget) 0;
  cmdLabWid[h] = (Widget) 0;

  {
	Dimension wide, thisWide;
	Dimension high, thisHigh, wHigh;
	Dimension wideLeft, wideRight;
	Dimension hSpace, vSpace, border;
	int i;

	wide = 0;
	wideLeft = 0;
	wideRight = 0;
	wHigh = 0;

	XtSetArg (boxOpts[0], XtNvSpace, (char *) &vSpace);
	XtSetArg (boxOpts[1], XtNhSpace, (char *) &hSpace);
	XtSetArg (boxOpts[2], XtNborderWidth, (char *) &border);
	XtGetValues (box, boxOpts, 3);
	high = border*2 + vSpace;

	XtSetArg (commandOpts[0], XtNwidth, (char *) &thisWide);
	XtSetArg (commandOpts[1], XtNheight, (char *) &thisHigh);
	for (i=0; i<3; ++i) {
		XtGetValues (topLabWid[i], commandOpts, 2);
		if (wide < thisWide) wide = thisWide;
		high += thisHigh + vSpace;
	}
	for (i=0; cmdWid[i]; ++i) {
		Dimension cmdh;

		XtGetValues (cmdWid[i], commandOpts, 2);
		cmdh = thisHigh;
		if (wHigh < thisHigh) wHigh = thisHigh;
		if (wideLeft < thisWide) wideLeft = thisWide;
		XtGetValues (cmdLabWid[i], commandOpts, 2);
		if (wideRight < thisWide) wideRight = thisWide;
		if (cmdh < thisHigh) cmdh = thisHigh;
		if (wHigh < thisHigh) wHigh = thisHigh;
		high += cmdh + vSpace;
	}
	if ((wideLeft + wideRight) > wide) wide = wideLeft + wideRight;
	wide += (border*2 + hSpace*2);
	Debug ("wide %d l %d r %d h %d b %d\n", wide, wideLeft, wideRight, hSpace, border);
	box_h = high;
	box_w = wide;

	XtSetArg (commandOpts[0], XtNwidth, wide);
	for (i=0; i<3; ++i) {
		XtSetValues (topLabWid[i], commandOpts, 1);
	}
	XtSetArg (commandOpts[0], XtNheight, wHigh);
	XtSetArg (commandOpts[1], XtNwidth, wideLeft);
	for (i=0; cmdWid[i]; ++i) {
		XtSetValues (cmdWid[i], commandOpts, 2);
	}
	/*XtSetArg (commandOpts[0], XtNwidth, wideRight);*/
	for (i=0; cmdLabWid[i]; ++i) {
		XtSetValues (cmdLabWid[i], commandOpts, 1);
	}
  }
  scrn = DefaultScreenOfDisplay (dpy);
  screen_width = WidthOfScreen (scrn);
  screen_height = HeightOfScreen (scrn);
  old_x = screen_width/2 - box_w/2;
  old_y = screen_height/2 - box_h/2;
  XtMoveWidget (popupShell, old_x, old_y);

  Debug ("realizing widget\n");
  XtPopup (popupShell, XtGrabNone);

  if (d->pingInterval) {
    pingTimeout = XtAppAddTimeOut (context, d->pingInterval * 60 * 1000,
				   GreetPingServer, (XtPointer) d);
  }
  Debug ("Migration interval is %d\n", d->migrateInterval);
  if (d->migrateInterval) {
    struct timeval t;
    struct timezone z;

    gettimeofday (&t, &z);
    srandom (t.tv_usec);

    XtAppAddTimeOut (context, d->migrateInterval * 1000,
		GreetMigrate, (XtPointer) d);
  }
}

CloseGreet (d)
     struct display	*d;
{
    Boolean	    allow;
    Arg	    arglist[1];

    if (pingTimeout)
    {
	XtRemoveTimeOut (pingTimeout);
	pingTimeout = 0;
    }
    UnsecureDisplay (d, XtDisplay (toplevel));
    /*XtSetArg (arglist[0], XtNallowAccess, (char *) &allow);
    XtGetValues (login, arglist, 1);
    if (allow)
    {
	Debug ("Disabling access control\n");
	XSetAccessControl (XtDisplay (toplevel), DisableAccess);
    }*/
    /*XCloseDisplay (XtDisplay (toplevel));*/
    /*XtDestroyWidget (toplevel);
    XtDestroyApplicationContext (context);*/
}

Greet (d)
     struct display		*d;
{
	XEvent		event;
	Arg		arglist[1];

/*	XtSetArg (arglist[0], XtNallowAccess, False);
	XtSetValues (login, arglist, 1);
 */
	Debug ("dispatching %s\n", d->name);
	done = 0;
	while (!done) {
		XtAppNextEvent (context, &event);
		XtDispatchEvent (&event);
	}
	XtDestroyWidget (selectHost);
	XFlush (XtDisplay (toplevel));

	Debug ("Done dispatch %s\n", d->name);
/*	XtSetArg (arglist[0], XtNsessionArgument, (char *) &(greet->string));
	XtGetValues (login, arglist, 1);
	Debug ("sessionArgument: %s\n", greet->string ? greet->string : "<NULL>");
 */
}
