/************************************************************************
Copyright 1990 by Network Computing Devices, Inc.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of NCD not be used in advertising or
publicity pertaining to distribution of the software without specific
prior written permission.  NCD makes no representation about the
suitability of this software for any purpose. It is provided "as is"
without any express or implied warranty.

NCD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE.  IN NO EVENT SHALL SUN BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.

************************************************************************/

#ident "@(#)ncdsiestr.h	15.2	91/01/07"

/*
 * NCD Sie protocol requests constants and alignment values
 */

#include "ncdsie.h"

#define SIENAME "NCD-SIE"

#define SIE_MAJOR_VERSION	1		/* current major version */
#define SIE_MINOR_VERSION	0		/* current minor version */

/*
 * Requests
 */

typedef struct _SieQueryVersion
{
	CARD8		reqType;		/* always SieReqCode */
	CARD8		sieReqType;		/* always X_SieQueryVersion */
	CARD16		length B16;		/* request length */
}
xSieQueryVersionReq;
#define sz_xSieQueryVersionReq	4

typedef struct {
        CARD8		type;                   /* X_Reply */
        CARD8		unused;                 /* not used */
        CARD16		sequenceNumber B16;	/* sequence number */
        CARD32		length B32;		/* reply length */
        CARD16		majorVersion B16;       /* major version */
        CARD16		minorVersion B16;       /* minor version */
        CARD32		pad0 B32;
        CARD32		pad1 B32;
        CARD32		pad2 B32;
        CARD32		pad3 B32;
        CARD32		pad4 B32;
} xSieQueryVersionReply;
#define sz_xSieQueryVersionReply      32

typedef struct _SieCreateImage
{
	CARD8		reqType;		/* always SieReqCode */
	CARD8		sieReqType;		/* always X_SieCreateImage */
	CARD16		length B16;		/* request length */
	CARD32		pid B32;		/* destination pixmap id */
	CARD32		drawable B32;		/* dest screen from drawable */
	CARD8		compression;		/* compression scheme */
	CARD8		pad;
	CARD16		count B16;		/* num image pieces to come */
	CARD16		widthHint B16;		/* sie image width hint */
	CARD16		heightHint B16;		/* sie image height hint */
}						/* followed by LISTofBYTE */
xSieCreateImageReq;
#define sz_xSieCreateImageReq	20

typedef struct _SieSendImage
{
	CARD8		reqType;		/* always SieReqCode */
	CARD8		sieReqType;		/* always X_SieSendImage */
	CARD16		length B16;		/* request length */
	CARD32		dstDrawable B32;	/* destination Drawable */
	CARD32		gc B32;			/* graphics contxt */
	INT16		srcX B16;		/* source x */
	INT16		srcY B16;		/* source y */
	CARD16		srcWidth B16;		/* source width */
	CARD16		srcHeight B16;		/* source height */
	INT16		dstX B16;		/* destination x */
	INT16		dstY B16;		/* destination y */
	CARD16		dstWidth B16;		/* destination width */
	CARD16		dstHeight B16;		/* destination height */
	CARD8		compression;		/* compression scheme */
	CARD8		rotation;		/* rotation angle */
	CARD16		count B16;		/* num image pieces to come */
	CARD16		widthHint B16;		/* sie image width hint */
	CARD16		pad B16;
}						/* followed by LISTofBYTE */
xSieSendImageReq;
#define sz_xSieSendImageReq	36

typedef struct _SieCopyImage
{
	CARD8		reqType;		/* always SieReqCode */
	CARD8		sieReqType;		/* always X_SieCopyImage */
	CARD16		length B16;		/* request length */
	CARD32		srcDrawable B32;	/* source Drawable */
	CARD32		dstDrawable B32;	/* destination Drawable */
	CARD32		gc B32;			/* graphics contxt */
	INT16		srcX B16;		/* source x */
	INT16		srcY B16;		/* source y */
	CARD16		srcWidth B16;		/* source width */
	CARD16		srcHeight B16;		/* source height */
	INT16		dstX B16;		/* destination x */
	INT16		dstY B16;		/* destination y */
	CARD16		dstWidth B16;		/* destination width */
	CARD16		dstHeight B16;		/* destination height */
	CARD32		planeMask B32;		/* plane mask */
	CARD8		rotation;		/* rotation angle */
	CARD8		pad1;
	CARD16		pad2;
}
xSieCopyImageReq;
#define sz_xSieCopyImageReq	40

typedef struct _SieFetchImage
{
	CARD8		reqType;		/* always SieReqCode */
	CARD8		sieReqType;		/* always X_SieFetchImage */
	CARD16		length B16;		/* request length */
	CARD32		srcDrawable B32;	/* destination drawable */
	INT16		srcX B16;		/* source x */
	INT16		srcY B16;		/* source y */
	CARD16		srcWidth B16;		/* source width */
	CARD16		srcHeight B16;		/* source height */
	CARD16		dstWidth B16;		/* dest width */
	CARD16		dstHeight B16;		/* dest height */
	CARD32		planeMask B32;		/* plane mask */
	CARD8		rotation;		/* angle of rotataion */
	CARD8		compression;		/* compression scheme */
	CARD16		pad1;
}
xSieFetchImageReq;
#define sz_xSieFetchImageReq	28

typedef struct
{
	CARD8		type;			/* X_Reply */
	CARD8		unused;			/* not used */
	CARD16		sequenceNumber B16;	/* request sequence number */
	CARD32		length B32;		/* reply length */
	CARD32		imageLength B32;	/* total length in bytes */
	CARD32		pad1 B32;
	CARD32		pad2 B32;
	CARD32		pad3 B32;
	CARD32		pad4 B32;
	CARD32		pad5 B32;
}						/* followed by LISTofBYTE */
xSieFetchImageReply;
