# Copyright 1990 Network Computing Devices, Inc.  All rights reserved.

#ident "@(#)mkfontdir.mk	13.2	90/08/20"

SHELL = /bin/sh

RM = rm -f

NCDVERSION = 2.2.0

DEFINES = -DNCD # -DSYSV

# LDOPTIONS = -Bstatic

CFLAGS = -O $(INCLUDES) $(DEFINES)

INCLUDES = -I. -I../bdftosnf -I../include

SRCS = mkfontdir.c fontdir.c snf_util.c dwf_util.c Lower.c \
	../bdftosnf/fontutil.c

OBJS = mkfontdir.o fontdir.o snf_util.o dwf_util.o Lower.o fontutil.o

FONT_DEFINES = -DFONT_SNF -DFONT_DWF -DCOMPRESSED_FONTS \
	-DUNCOMPRESSFILT=\"/usr/ucb/uncompress\" \
	-DBDFTOSNFFILT=\"/usr/bin/X11//bdftosnf\" -DSHELLPATH=\"/bin/sh\" \
	-DZBDFTOSNFFILT=\"/usr/ucb/uncompress" | $(BINDIR)/bdftosnf -t\""

PROGRAM = mkfontdir

all:: mkfontdir

mkfontdir: $(OBJS)
	$(RM) $@
	$(CC) $(CFLAGS) -o $@ $(OBJS) $(LDOPTIONS)

clean::
	$(RM) $(PROGRAM) $(OBJS) errs core version.h

mkfontdir.o:
	$(RM) $@
	$(CC) -c $(CFLAGS) $(FONT_DEFINES) $*.c

fontutil.o:	../bdftosnf/fontutil.c
	$(RM) $@
	$(CC) -c $(CFLAGS) ../bdftosnf/fontutil.c

version.h:
	echo 'static char *copyright = "@(#)Copyright 1990 Network Computing Devices, Inc.  All rights reserved.";' > version.h
	echo 'static char *version = "@(#)mkfontdir version' $(NCDVERSION) '";' >> version.h

mkfontdir.o: version.h
