
/* Copyright 1988, 1989 Network Computing Devices, Inc.  All rights reserved. */

#ident "@(#)os.h	13.5	90/04/09"

/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* $XConsortium: os.h,v 1.37 89/07/21 12:56:53 keith Exp $ */

#ifndef OS_H
#define OS_H
#include "misc.h"

#ifdef INCLUDE_ALLOCA_H
#include <alloca.h>
#endif

#define NullFID ((FID) 0)

#define SCREEN_SAVER_ON   0
#define SCREEN_SAVER_OFF  1
#define SCREEN_SAVER_FORCER 2

#if defined(stellar)
#define MAX_REQUEST_SIZE 65535
#else
#define MAX_REQUEST_SIZE 16384
#endif

typedef pointer	FID;
typedef struct _FontPathRec *FontPathPtr;
typedef struct _NewClientRec *NewClientPtr;

#ifndef NO_ALLOCA
/*
 * os-dependent definition of local allocation and deallocation
 * If you want something other than Xalloc/Xfree for ALLOCATE/DEALLOCATE
 * LOCAL then you add that in here.
 */
#if defined(__HIGHC__)

extern char *alloca();

#if HCVERSION < 21003
#define ALLOCATE_LOCAL(size)	alloca((int)(size))
pragma on(alloca);
#else /* HCVERSION >= 21003 */
#define	ALLOCATE_LOCAL(size)	_Alloca((int)(size))
#endif /* HCVERSION < 21003 */

#define DEALLOCATE_LOCAL(ptr)  /* as nothing */

#endif /* defined(__HIGHC__) */


#ifndef NCD
#ifdef __GNUC__
#define alloca __builtin_alloca
#define ALLOCATE_LOCAL(size) alloca((int)(size))
#define DEALLOCATE_LOCAL(ptr)  /* as nothing */
#else /* ! __GNUC__ */
/*
 * warning: mips alloca is unsuitable in the server, do not use.
 */
#if defined(vax) || defined(sun) || defined(apollo) || defined(stellar)
/*
 * Some System V boxes extract alloca.o from /lib/libPW.a; if you
 * decide that you don't want to use alloca, you might want to fix 
 * ../os/4.2bsd/Imakefile
 */
char *alloca();
#define ALLOCATE_LOCAL(size) alloca((int)(size))
#define DEALLOCATE_LOCAL(ptr)  /* as nothing */
#endif /* who deos alloca */
#endif /* __GNUC__ */
#else NCD
#ifndef __PROC_HEADER__
extern pointer ustackbegin, ustackend;
#endif __PROC_HEADER__
#define ALLOCATE_LOCAL_MAX 300
#define ALLOCATE_LOCAL(size) ((int)(size)<ALLOCATE_LOCAL_MAX ? \
	(unsigned long *)__builtin_alloca((int)(size)) : Xalloc((int)(size)))
#define DEALLOCATE_LOCAL(ptr) if((pointer)(ptr) < ustackbegin \
	|| (pointer)(ptr) >= ustackend ) Xfree(ptr)
#endif NCD

#endif /* NO_ALLOCA */

#ifndef ALLOCATE_LOCAL
#define ALLOCATE_LOCAL(size) Xalloc((unsigned long)(size))
#define DEALLOCATE_LOCAL(ptr) Xfree((pointer)(ptr))
#endif /* ALLOCATE_LOCAL */


#define xalloc(size) Xalloc((unsigned long)(size))
#define xrealloc(ptr, size) Xrealloc((pointer)(ptr), (unsigned long)(size))
#define xfree(ptr) Xfree((pointer)(ptr))

int		ReadRequestFromClient();
char		*strcat();
char		*strncat();
char		*strcpy();
char		*strncpy();
Bool		CloseDownConnection();
FontPathPtr	GetFontPath();
FontPathPtr	ExpandFontNamePattern();
FID		FiOpenForRead();
void		CreateWellKnownSockets();
int		SetDefaultFontPath();
void		FreeFontRecord();
int		SetFontPath();
void		ErrorF();
void		Error();
void		FatalError();
void		ProcessCommandLine();
void		FlushAllOutput();
void		FlushIfCriticalOutputPending();
#ifndef MEMBUG
void		Xfree();
unsigned long	*Xalloc();
unsigned long	*Xrealloc();
unsigned long   *XallocFailOK();
unsigned long   *XreallocFailOK();
#else MEMBUG
void            _Xfree();
unsigned long   *_Xalloc();
unsigned long   *_Xrealloc();
#define Xfree(p) _Xfree(p,__FILE__,__LINE__)
#define Xalloc(s) _Xalloc(s,__FILE__,__LINE__)
#define Xrealloc(p,s) _Xrealloc(p,s,__FILE__,__LINE__)
#define XallocFailOK(s) _XallocFailOK(s,__FILE__,__LINE__)
#define XreallocFailOK(p,s) _XreallocFailOK(p,s,__FILE__,__LINE__)
#endif MEMBUG
long		GetTimeInMillis();

/*
 * MHM_SOFT_LIMIT defines how much memory we keep reserved for
 * allocations that can't recover from a NULL return from malloc or realloc
 * (have Must_have_memory set).
 */
#ifdef SHAPE    /* shape often makes things considerably worse */
#define MHM_SOFT_LIMIT  15000
#else
#define MHM_SOFT_LIMIT  5000
#endif

/* these are used in dispatch.c to decide when to warn the user about
 * low on memory conditions
 */
#define DEFAULT_LOW_MEM_MARK            MHM_SOFT_LIMIT
#define DEFAULT_LOW_MEM_CHUNKS          10
#define DEFAULT_LOW_MEM_AVG_CHUNK       300

#endif /* OS_H */
