* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*                                                                   *
*   ... ...  ...     ...       .....                                *
*   .............    ...      .......      ____________________     *
*   ....  ...  ...   ...     ...   ...                              *
*   ...   ...  ...   ...     ...   ...     MOLECULAR LOGIC CORP.    *
*   ...   ...  ...   ...     ...                                    *
*   ...   ...  ...   ...     ...   ...     SYSTEM SOFTWARE FILE     *
*   ...   ...  ...   ...     ...   ...                              *
*   ...   ...  ...    .....   .......      ____________________     *
*   ...   ...  ...     ....    .....                                *
*                                                                   *
*                                                                   *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*                                                                   *
*   FILE:		DSDPATCH                                    *
*                                                                   *
*   DESCRIPTION:	SYSTEM DIAGNOSTIC TERMINAL PATCH FILE       *
*                                                                   *
*   CREATE DATE:	03/12/82                                    *
*                                                                   *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*                                                                   *
*   THIS FILE IS TO BE USED TO INSTALL THE CONFIGURATION            *
*   PARAMETERS FOR THE TERMINAL YOU WILL BE USING.  MAKE THE        *
*   NECESSARY CHANGES TO THE PARAMETERS LISTED BELOW AND            *
*   ASSEMBLE THIS FILE TO PRODUCE "DSDPATCH.HEX".  ENTER THE        *
*   FOLLOWING COMMANDS TO SAVE A CUSTOMIZED COPY OF "DSD.COM":      *
*                                                                   *
*                                                                   *
*                        DDT DSD.COM                                *
*                        IDSDPATCH.HEX                              *
*                        R0                                         *
*                        G0                                         *
*                        SAVE 13 DSD.COM                            *
*                                                                   *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*                                                                   *
*   REVISION HISTORY                                                *
*                                                                   *
*   DATE	INIT.	DESCRIPTION                                 *
*                                                                   *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*                                                                   *
*   03/12/82	BLW	MODULE CREATED FROM DSD                     *
*                                                                   *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
	ORG	100H+2		;(DO NOT CHANGE)
*
*   THE EXAMPLE PARAMETERS PROVIDED IN THIS FILE WILL
*   WORK WITH TELEVIDEO TERMINALS.  THE PATCH PROCEDURE
*   IS NECESSARY ONLY IF YOU WILL BE USING ANOTHER TYPE
*   OF TERMINAL.
*
*   THE FOLLOWING DEFINES THE TERMINAL SCREEN SIZE
*
HITE:	DB	24		;NUMBER OF LINES ON SCREEN
WID:	DB	80		;NUMBER OF CHARACTERS PER LINE
*
*   THE FOLLOWING SPECIFIES THE CODE OR SEQUENCE
*   WHICH ERASES THE ENTIRE SCREEN.
*
CLR:	DB	1		;CLEAR SCREEN CODE LENGTH
	DB	1AH,0,0		;CLEAR SCREEN CHARACTER(S)
	DB	0,0,0
*
*   THE FOLLOWING SPECIFIES THE CURSOR POSITIONING
*   CODE SEQUENCE.
*
*   CURSOR POSITIONING USUALLY REQUIRES ONE OR MORE
*   OF THE FOLLOWING ELEMENTS:
*
*   1.  A "LEAD-IN" OR INITIAL ESCAPE SEQUENCE.
*
*   2.  THE LINE OR COLUMN NUMBER WITH AN OFFSET
*       ADDED (USUALLY 0 OR 32).
*
*   3.  AN OPTIONAL SECOND SEQUENCE OR SEPARATOR
*       CHARACTER.
*
*   4.  THE COLUMN OR LINE NUMBER WITH AN OFFSET
*       ADDED.
*
*   5.  AN OPTIONAL TRAILING SEQUENCE OR TERMINATOR.
*
*   MOST TERMINALS EXPECT A ONE-BYTE BINARY NUMBER
*   FOR THE LINE AND COLUMN INFORMATION.  SOME USE
*   ASCII NUMBERS EITHER IN FREE FORM OR FIXED TWO
*   OR THREE DIGIT FIELDS.
*
*   FOR EXAMPLE, THE TELEVIDEO TERMINALS POSITION
*   THE CURSOR WITH THE SEQUENCE:
*
*       ESCAPE (1BH), "=", LINE + 32 IN BINARY,
*       AND COLUMN + 32 ALSO IN BINARY.
*
*   NO SECOND OR TRAILING SEQUENCES ARE REQUIRED.
*
*   THE FOLLOWING PATCH AREAS ARE SET UP FOR THIS
*   SEQUENCE.
*
*   THE INITIAL LEAD-IN SEQUENCE FOLLOWS:
*
CLEAD1:	DB	2		;NUMBER CURSOR POSITION LEAD-IN BYTES
	DB	1BH		;CURSOR POSITION LEAD-IN CHARACTER(S)
	DB	'='
	DB	0,0,0,0
*
*   OPTIONAL SECOND SEQUENCE OR SEPARATOR
*
CLEAD2:	DB	0		;NUMBER OF BYTES BETWEEN ROW/COL
	DB	0,0,0,0		;CHARACTER(S)
*
*   OPTIONAL TRAILING SEQUENCE OR TERMINATOR
*
CTRAIL:	DB	0		;NUMBER OF BYTES AFTER ROW/COL
	DB	0,0,0,0		;CHARACTER(S)
*
*   THE FOLLOWING BYTE IS SET TO ONE IF THE
*   COLUMN NUMBER IS TO BE SENT BEFORE THE
*   ROW NUMBER.  OTHERWISE, IT IS SET TO ZERO
*   TO SEND THE ROW NUMBER FIRST.
*
CB4LFG:	DB	0		;COLUMN BEFORE LINE FLAG
*
*   THE FOLLOWING IS THE VALUE OF THE OFFSET
*   TO BE ADDED TO THE LINE NUMBER.
*
LINOFF:	DB	32		;LINE NUMBER OFFSET
*
*   THE FOLLOWING IS THE VALUE OF THE OFFSET
*   TO BE ADDED TO THE COLUMN NUMBER.
*
COLOFF:	DB	32		;COLUMN NUMBER OFFSET
*
*   THE FOLLOWING BYTE IS SET TO ZERO TO SEND
*   THE LINE AND COLUMN NUMBERS AS ONE-BYTE
*   BINARY CHARACTERS.
*
*   SET IT TO ONE TO SEND FREE-FORM ASCII
*   NUMBERS.
*
*   SET IT TO TWO TO SEND FIXED TWO-DIGIT
*   ASCII FIELDS.
*
*   SET IT TO THREE TO SEND FIXED THREE-DIGIT
*   ASCII FIELDS
*
ASCUR:	DB	0		;BINARY/ASCII FLAG AND FIELD SIZE
*
*   TERMINAL INITIALIZATION STRING FOLLOWS.
*   THIS IS AN OPTIONAL STRING TO BE SENT
*   TO THE TERMINAL TO INITIALIZE IT FOR
*   THE DIAGNOSTIC.
*
TRMINI:	DB	0		;NUMBER OF TERMINAL INITIALIZATION BYTES
	DB	0,0,0,0		;TERMINAL INITIALIZATION STRING
	DB	0,0,0,0
*
*   TERMINAL DE-INITIALIZATION STRING.
*   AN OPTIONAL STRING TO BE SENT TO THE
*   TERMINAL BEFORE EXITING THE DIAGNOSTIC
*
TRMUNI:	DB	0		;NUMBER OF TERMINAL DE-INITIALIZATION BYTES
	DB	0,0,0,0		;TERMINAL DE-INITIALIZATION STRING
	DB	0,0,0,0
*
*   STRING TO TURN ON HIGHLIGHTING (DIM, REVERSE,
*   UNDERSCORE, ETC.). REQUIRED.
*
IVON:	DB	2		;HIGHLIGHT ON CODE LENGTH
	DB	1BH,')',0	;HIGHLIGHT ON CODE
	DB	0,0,0
*
*   STRING TO TURN OFF HIGHLIGHTING
*
IVOFF:	DB	2		;HIGHLIGHT OFF CODE LENGTH
	DB	1BH,'(',0	;HIGHLIGHT OFF CODE
	DB	0,0,0
*
*   (END OF CONFIGURATION PARAMETERS)
*
	END
