static char SCCSID[] = "%W% %E%";

/*
 * Copyright 1988 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens Munich, unido!sinix!claus@uunet.uu.net
 */

#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include "PaletteP.h"
#include <math.h>

/*
 * preferable width is one, which divides without remainder by
 * sqrt of number-of-color-cells; this avoids truncating the rightmost
 * and bottommost squares ...
 * I use 240, which is good for 4, 16, 64, 256 which are most common...
 */
static XtResource resources[] = {
    {XtNwidth, XtCWidth, XtRInt, sizeof(int),
	XtOffset(Widget,core.width), XtRString, "240"},
    {XtNheight, XtCHeight, XtRInt, sizeof(int),
	XtOffset(Widget,core.height), XtRString, "240"},
};

static void Initialize(), Realize(), Destroy(), Redisplay();
static Boolean SetValues();

PaletteClassRec paletteClassRec = {
    { /* core fields */
    /* superclass		*/	&widgetClassRec,
    /* class_name               */      "Palette",
    /* widget_size              */      sizeof(PaletteRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	Realize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* resource_count		*/	XtNumber(resources),
    /* xrm_class		*/	NULL,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	NULL,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	NULL,
    /* query_geometry		*/	NULL,
    }
};

WidgetClass paletteWidgetClass = (WidgetClass) &paletteClassRec;

/* ARGSUSED */
static void Initialize (request, new)
    Widget request, new;
{
    PaletteWidget w = (PaletteWidget)new;
    int ncells;
    double dncells;
    XGCValues dummy;

    w->palette.GC = XtGetGC((Widget)w, 0L, &dummy);
    /*
     * compute layout; try to arrange all cells
     * as a square
     */
    ncells = CellsOfScreen(XtScreen(w));
    w->palette.nhoriz = (int)sqrt((double)ncells);
    w->palette.nvert = w->palette.nhoriz;
    /*
     * now, if the number of cells is not square, increase vertical
     * number until we got it ..
     */
    while (w->palette.nhoriz * w->palette.nvert < ncells)
	w->palette.nvert++;
}

static void Realize (gw, valueMask, attrs)
    Widget gw;
    XtValueMask *valueMask;
    XSetWindowAttributes *attrs;
{
    XtCreateWindow( gw, InputOutput, (Visual *)CopyFromParent,
		    *valueMask, attrs);
}

static void Destroy (gw)
    Widget gw;
{
    PaletteWidget w = (PaletteWidget) gw;

    XtDestroyGC (w->palette.GC);
}

/* ARGSUSED */
static void Redisplay (gw, event, region)
    Widget gw;
    XEvent *event;		/* unused */
    Region region;		/* unused */
{
    PaletteWidget w = (PaletteWidget) gw;
    register Display *dpy = XtDisplay(w);
    register Window win = XtWindow(w);
    int sqWidth, sqHeight;
    int color, nv, nh, x, y;

    nv = w->palette.nvert;
    nh = w->palette.nhoriz;
    sqWidth = (w->core.width - (nh-1)) / nh;
    sqHeight = (w->core.height - (nv-1)) / nv;
    color = 0;
    XClearWindow(dpy, win);
    for (y=0; nv; nv--, y += sqHeight+1)
	for (x=0, nh = w->palette.nhoriz; nh; nh--, x += sqWidth+1) {
	    XSetForeground(dpy, w->palette.GC, color);
	    XFillRectangle(dpy, win, w->palette.GC, x, y, sqWidth, sqHeight);
	    color++;
	}
}

/* ARGSUSED */
static Boolean SetValues (gcurrent, grequest, gnew)
    Widget gcurrent, grequest, gnew;
{
    Boolean redisplay = TRUE;

    return (redisplay);
}
