/*
 *			  COPYRIGHT 1988
 *	    MASSACHUSETTS COMPUTER CORPORATION (MASSCOMP)
 *		       WESTFORD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 *		       Author: Richard Carling
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MASSCOMP CORPORATION.
 * MASSCOMP MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR
 * ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT 
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN 
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that the
 * copyright notice, and this permission notice appear in 
 * supporting documentation.
 */


#include <stdio.h>
#include "editor.h"
#include <X11/Xatom.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/LabelP.h>
#include "../extensions/DLLabelP.h"
#include "../extensions/DLCommandP.h"
#include "../extensions/DLObedientP.h"

#define SUCCESS	1
#define FAIL	0
#define HALT	0
#define MAX_INSTRUCTION_SIZE	200


/*
#define XtIsComposite(widget)	\
		XtIsSubclass( widget, (WidgetClass) compositeWidgetClass )
*/
#define XtIsDLLabel(widget)	\
		XtIsSubclass( widget, (WidgetClass) DLlabelWidgetClass )
		
#define XtIsDLObedient(widget)	\
		XtIsSubclass( widget, (WidgetClass) DLobedientWidgetClass )
		
#define XtIsDLCommand(widget)	\
		XtIsSubclass(widget, (WidgetClass) DLcommandWidgetClass)

/* these are required to make XtCreateWidget happy */

extern int mode;		
extern int cur_color;

extern GC GlobalGC;
extern GC GlobalGrayGC;

extern Widget toplevel;
extern Display *display;
extern Display *toplevelDisplay;
extern WidgetClass labelWidgetClass;
extern WidgetClass commandWidgetClass;
extern WidgetClass buttonBoxWidgetClass;
extern WidgetClass DLcommandWidgetClass;
extern WidgetClass DLlabelWidgetClass;
extern WidgetClass DLobedientWidgetClass;

extern Widget workarea;
extern Window work_area_window;
extern int editor_load;

xDrawer(widget, closure, event)
    Widget widget;
    caddr_t closure;
    XEvent *event;
{
    int i;                   /* number of ASCII chars from XLookupString */
    char text[10];           /* string to receive translated keystroke */


/* if a displaylist widget, dray the displayt ;list, check that
Redisplay is not getting called and dropping out early as well

*/
	DLObedientWidget obw;
	DLLabelWidget lw;
	DLCommandWidget cw;

printf("DRAWER called\n");
    if (!widget) return;

		/* check if a display list widget */

    if ( XtIsDLLabel( widget)) {
	 lw = (DLLabelWidget) widget;
		draw_display_list( XtDisplay(widget), XtWindow(widget),
				GlobalGC, lw->label.DL );
       }
     if (XtIsDLCommand( widget )) {
	 cw = (DLCommandWidget) widget;
		draw_display_list( XtDisplay(widget), XtWindow(widget),
				GlobalGC, cw->command.DL );
       }
       if ( XtIsDLObedient( widget )) {
	 obw = (DLObedientWidget) widget;
		draw_display_list( XtDisplay(widget), XtWindow(widget),
				GlobalGC, obw->obedient.DL );
       }


/*    i = XLookupString (event, text, 9 , NULL, 0);
    if (i == 1 && text[0] == 'q')
         exit (1);
*/
}

do_make_obedient()
{
	Arg 	args[64];
	short *dl_ptr;
	unsigned short length;
    	unsigned int num_args;
	DLObedientWidget obw;
	char *str, *input_text(), widget_name[64];
	int x, y, x2, y2, width, height;
	Widget widget, parent, BeingEdited(), XtCreateManagedWidget();
	Window window, get_two_points_and_window();
	double fw, fh;
	
	printf("Please enter two points for obedient widgets location:\n");
	while (window = get_two_points_and_window( &x, &y, &x2, &y2 )) {
		
		/* 
		 * check if new widget is on top of a 
		 * currently edited widget
		 */
		
		parent = BeingEdited( window );
		if (!parent) {
			printf("Error looking up parent widget\n");
			exit();
		}
		if (!XtIsComposite( parent )) {
		    printf("Can't place widget except on composite widgets\n");
		    return FAIL;
		}
		num_args = 0;
		width = x2 - x + 1;
		height = y2 - y + 1;
		XtSetArg( args[num_args], XtNx, x );
		num_args++;
		XtSetArg( args[num_args], XtNy, y );
		num_args++;
		XtSetArg( args[num_args], XtNwidth, width );
		num_args++;
		XtSetArg( args[num_args], XtNheight, height );
		num_args++;

                str = input_text("Enter widget name:"); 
                if (str) printf("String is %s\n", str );
                else { printf("No string, widget not created\n"); return; }
		strcpy( widget_name, str );
		widget = XtCreateManagedWidget( widget_name, DLobedientWidgetClass,
						parent, args, num_args);
		if (!widget) {
			printf("Obedient Widget creation error\n"); 
			return NULL; 
		}
		
		/* register widget, so we don't think it is active */
		
		RegisterWidget( widget );
		
		/*
		 * create a display list with just an XFillrect of the
		 * current selected color, and give it a little extra space.
		 */
		
		obw = (DLObedientWidget) widget;
		obw->obedient.DLSize = MAX_INSTRUCTION_SIZE * 2;
		obw->obedient.DL = (short *) malloc( obw->obedient.DLSize );
				
		fw = width; fh = height;
		
		/* this is the only way to get the opcode of the instruction */

		*(obw->obedient.DL) = lookup_instruction( "filled_rectangle" );
		if ( !*(obw->obedient.DL) ) {
			printf("can't locate instruction\n");
			exit();
		}
		add_frect( obw->obedient.DL, 0, 0, 
				width, height, cur_color, fw, fh );
				
		/* bump to next instruction position in displaylist */
		
		dl_ptr = obw->obedient.DL;
		length = *(dl_ptr + 1) >> 1;
		dl_ptr += length;
		
		/* add HALT instruction */
		
		*dl_ptr = HALT; 
		*(dl_ptr + 1) = 0;

		/*
		 * add X events to it's window so we can edit and embellish it
		 */
		 
		 window =  XtWindow( widget );
    
		 XSelectInput( display, window, (unsigned long)
		 	KeyPressMask | KeyReleaseMask | ButtonPressMask
				| ButtonReleaseMask | ButtonMotionMask
					| ExposureMask
		                            | MapNotify | VisibilityNotify);
				
/*	XtAddEventHandler (obw, MapNotify|VisibilityNotify, FALSE, Drawer, NULL);
*/
		draw_display_list( XtDisplay(obw), XtWindow(obw),
				GlobalGC, obw->obedient.DL );

	} 
}

do_make_command()
{
	Arg 	args[64];
	short *dl_ptr;
	unsigned short length;
    	unsigned int num_args;
	DLCommandWidget cbw;
	char *str, *input_text(), widget_name[64];
	int x, y, x2, y2, width, height;
	Widget widget, parent, BeingEdited(), XtCreateManagedWidget();
	Window window, get_two_points_and_window();
	double fw, fh;
	
	/* first get parent, is it the work_area_window, or a child window 
	 * run thru the list of "watched" objects, to get this,
	 * use the pendown event
	 * then we need the user to name the widget 
	 * we need a list of "watched" windows AND we need
	 * a simple scheme to get the widget ptr from the window ptr
	 * 2 entry list maybe?
	 *
	 * WE NEED TOPLEVEL to be the whole work area!!!!!!!!!!!
	 */

	/* we also need to keep track of the depth so we know if
           if it is a primary level widget or just a lowlife */

	printf("Please enter two points for command widgets location:\n");
	while (window = get_two_points_and_window( &x, &y, &x2, &y2 )) {
		
		/* 
		 * check if new widget is on top of a 
		 * currently edited widget
		 */
		
		parent = BeingEdited( window );
		if (!parent) {
			printf("Error looking up parent widget\n");
			exit();
		}
		if (!XtIsComposite( parent )) {
		    printf("Can't place widget except on composite widgets\n");
		    return FAIL;
		}
		
		num_args = 0;
		width = x2 - x + 1;
		height = y2 - y + 1;
		XtSetArg( args[num_args], XtNx, x );
		num_args++;
		XtSetArg( args[num_args], XtNy, y );
		num_args++;
		XtSetArg( args[num_args], XtNwidth, width );
		num_args++;
		XtSetArg( args[num_args], XtNheight, height );
		num_args++;

                str = input_text("Enter widget name:"); 
                if (str) printf("String is %s\n", str );
                else { printf("No string, command widge not created\n"); return; }
		strcpy( widget_name, str );

		widget = XtCreateManagedWidget( widget_name, 
				DLcommandWidgetClass,
						parent, args, num_args);
		if (!widget) {
			printf("Command Widget creation error\n"); 
			return NULL; 
		}
		
                str = input_text("Enter callback name:"); 
                if (str) printf("Callback string is %s\n", str );
                else printf("Callback string is NULL\n");

		AssociateFakeFtn ( str, widget );

		/* register widget, so we don't think it is active, inhibit events to it */
		
		RegisterWidget( widget );
		
		/*
		 * create a display list with just an XFillrect of the
		 * current selected color, and give it a little extra space.
		 */
		
		cbw = (DLCommandWidget) widget;
		cbw->command.DLSize = MAX_INSTRUCTION_SIZE * 3;
		cbw->command.DL = (short *) malloc( cbw->command.DLSize );
		dl_ptr = cbw->command.DL;
		
		fw = width; fh = height;
		
		/* stuff opcode into instruction, (this is the only way to get the opcode of the instruction) */

		*dl_ptr = lookup_instruction( "filled_rectangle" );
		if ( ! *dl_ptr ) {
			printf("can't locate filled_rectangle instruction\n");
			exit();
		}
		add_frect( dl_ptr, 0, 0, width, height, cur_color, fw, fh );
				
		/* bump to next instruction position in displaylist */
		
		length = *(dl_ptr + 1) >> 1;
		dl_ptr += length;
		
		/* add text for label instruction */

		/* (this is the only way to get the opcode of the instruction) */
		*dl_ptr = lookup_instruction( "text" );
		if ( ! *dl_ptr ) {
			printf("can't locate text instruction\n");
			exit();
		}
		/* add in desired text for label button */

		add_text( dl_ptr, 0, 0, width, height, 1 /* color_index */ , 
					"center", "vg-20", widget_name, fw, fh );
				
		/* bump to next instruction position in displaylist */
		
		length = *(dl_ptr + 1) >> 1;
		dl_ptr += length;

		/* add HALT instruction */
		
		*dl_ptr = HALT; 
		*(dl_ptr + 1) = 0;

		/*
		 * add X events to it's window so we can edit and embellish it
		 */
		 
		 window =  XtWindow( widget );
    
		 XSelectInput( display, window, (unsigned long)
		 	KeyPressMask | KeyReleaseMask | ButtonPressMask
				| ButtonReleaseMask | ButtonMotionMask
					| ExposureMask
		                            | MapNotify | VisibilityNotify);
/*	XtAddEventHandler (cbw, MapNotify|VisibilityNotify, FALSE, Drawer, NULL);
*/
				
		draw_display_list( XtDisplay(cbw), XtWindow(cbw),
				GlobalGC, cbw->command.DL );
	} 
}

do_make_label()
{
	Arg 	args[64];
	short *dl_ptr;
	unsigned short length;
    	unsigned int num_args;
	DLLabelWidget lbw;
	char *str, *input_text(), widget_name[64];
	int x, y, x2, y2, width, height;
	Widget widget, parent, BeingEdited(), XtCreateManagedWidget();
	Window window, get_two_points_and_window();
	double fw, fh;
	
	printf("Please enter two points for label widgets location:\n");
	while (window = get_two_points_and_window( &x, &y, &x2, &y2 )) {
		
		/* 
		 * check if new widget is on top of a 
		 * currently edited widget
		 */
		
		parent = BeingEdited( window );
		if (!parent) {
			printf("Error looking up parent widget\n");
			exit();
		}
		
		if (!XtIsComposite( parent )) {
		    printf("Can't place widget except on composite widgets\n");
		    return FAIL;
		}
		num_args = 0;
		width = x2 - x + 1;
		height = y2 - y + 1;
		XtSetArg( args[num_args], XtNx, x );
		num_args++;
		XtSetArg( args[num_args], XtNy, y );
		num_args++;
		XtSetArg( args[num_args], XtNwidth, width );
		num_args++;
		XtSetArg( args[num_args], XtNheight, height );
		num_args++;

                str = input_text("Enter label widget name:"); 
                if (str) printf("String is %s\n", str );
                else { printf("No string, No label widget made, command ignored\n"); return; }

		strcpy( widget_name, str );

		widget = XtCreateManagedWidget( widget_name, 
				DLlabelWidgetClass,
					parent, args, num_args);
		if (!widget) {
			printf("Label Widget creation error\n"); 
			return NULL; 
		}
		
		/* register widget, so we don't think it is active */
		
		RegisterWidget( widget );

		/*
		 * create a display list with just an XFillrect of the
		 * current selected color, and give it a little extra space.
		 */
		
		lbw = (DLLabelWidget) widget;
		lbw->label.DLSize = MAX_INSTRUCTION_SIZE * 4;
		lbw->label.DL = (short *) malloc( lbw->label.DLSize );
		dl_ptr = lbw->label.DL;
		
		fw = width; fh = height;
		
		/* stuff instruction opcode into list (this is the only way to get the opcode of the instruction) */

		*dl_ptr = lookup_instruction( "filled_rectangle" );
		if ( !*dl_ptr ) {
			printf("can't locate filled_rectangle instruction\n");
			exit();
		}
		/* fill in the instruction */

		add_frect( dl_ptr, 0, 0, 
				width, height, cur_color, fw, fh );
				
		/* bump to next instruction position in displaylist */
		
		length = *(dl_ptr + 1) >> 1;
		dl_ptr += length;
		
		/* add text for label instruction */

		/* stuff text opcode (this is the only way to get the opcode of the instruction) */
		*dl_ptr = lookup_instruction( "text" );
		if ( ! *dl_ptr ) {
			printf("can't locate text instruction\n");
			exit();
		}
		/* add in desired text for label button */

		add_text( dl_ptr, 0, 0, width, height, 1 /* color_index */ , 
					"center", "vg-20", widget_name, fw, fh );
				
		/* bump to next instruction position in displaylist */
		
		length = *(dl_ptr + 1) >> 1;
		dl_ptr += length;

		/* add HALT instruction */
		
		*dl_ptr = HALT; 
		*(dl_ptr + 1) = 0;

		/*
		 * add X events to it's window so we can edit and embellish it
		 */
		 
		 window =  XtWindow( widget );
    
		 XSelectInput( display, window, (unsigned long)
		 	KeyPressMask | KeyReleaseMask | ButtonPressMask
				| ButtonReleaseMask | ButtonMotionMask
					| ExposureMask
		                            | MapNotify | VisibilityNotify);
				
/*	XtAddEventHandler (lbw, MapNotify|VisibilityNotify, FALSE, Drawer, NULL);
*/
		draw_display_list( XtDisplay(lbw), XtWindow(lbw),
				GlobalGC, lbw->label.DL );
	} 
}

do_relabel_widget()
{
        mode = 0;
/*if (isLabelClass() just a setvalues or setlabelvalue)
*/
}

do_copy_widget()
{
/*
read thru its components and build an arg list???
or does toolkit have a direct copy_widget( new_parent ) type call
*/
	int x1, y1, w, h, mdx, mdy;
	Point *pt, *loop_until_down_and_get_window();
	Window window1, window2, echo_box_and_loop_until_up();
	Widget widget, parent, BeingEdited();
	
        mode = 0;

	printf("Copy Widget not currently supported, rename and save tree.\n");
	return;

	/* first select widget (tree) to be moved) */
	
	pt = loop_until_down_and_get_window( &window1 );
	if (!window1) return NULL;
	
	/* 
	 * check if widget is part of a
	 * currently edited widget tree
	 */
		
	widget = BeingEdited( window1 );
	if (!widget) return NULL;

	/* create offsets to convert to coordinate system of top left corner */

	mdx = 0;
        mdy = 0;

	/* now echo for placement */
	
	window2 = echo_box_and_loop_until_up( XtWindow(widget->core.parent) , &x1, &y1, w, h, mdx, mdy );
	if (!window2) return NULL;
	
	parent = BeingEdited( window2 );
	if (!parent) return NULL;
	
	/* now perform actual operations required for copy */
	/* if parent the same, error out */

	if ((parent == widget->core.parent) || (parent == widget)) {
		return NULL;
	} else {
		if (!XtIsComposite( parent )) {
		   printf("Can't place widget except on composite widgets\n");
		   return FAIL;
	        }
		/* perform creation of clone of widget and attach to parent */
		/* ... */
	}
}

do_move_widget()
{
	int x1, y1, mdx, mdy;
	Point *pt, *loop_until_down_and_get_window();
	Window window1, window2, echo_box_and_loop_until_up();
	Widget widget, parent, BeingEdited();
	short *get_DL();
	
	/* first select widget (tree) to be moved) */
	
	printf("Select the widget to be moved:\n");
	pt = loop_until_down_and_get_window( &window1 );
	if (!pt) return NULL;
	if (!window1) return NULL;
	
	/* 
	 * check if widget is part of a
	 * currently edited widget tree
	 */
		
	widget = BeingEdited( window1 );
	if (!widget) { printf("Widget not active for editing\n");  return NULL; }
	if (widget == workarea) { printf("widget is workarea\n"); return NULL; }

	/* remove from screen (remove from parent's managed set) */

	XtUnmanageChild( widget );
	XtRealizeWidget( widget->core.parent );
	XtMapWidget( widget->core.parent );

	/* create offsets to convert to coordinate system of top left corner */

	mdx = pt->x;
        mdy = pt->y;

	/* now echo for placement */
	
	window2 = echo_box_and_loop_until_up( XtWindow( widget->core.parent ), 
					     &x1, &y1, widget->core.width, widget->core.height,
					                   mdx, mdy );
	if (!window2) return NULL;
	
	parent = BeingEdited( window2 );
	if (!parent) {
		printf("Error looking up new parent widget\n");
		exit();
	}
	
	/* now perform actual operations required for move */
	/* if parent the same, just change the X and Y of root child
	 * otherwise remove old parent-child relationship, and add new
	 * and adjust to new X and Y relationship
	 */
	if ((parent == widget->core.parent) || (parent == widget)) {
		/* get widget, do simple dx, dy adjustment */
	        XtMoveWidget( widget, x1, y1 );
		/* now redisplay widget tree from parent */
                XtManageChild( widget, 1 );
/*		XtRealizeWidget( widget ); */
		XtMapWidget( widget->core.parent );
		XtMapWidget( widget );

/*		you shouldn't need to do this 
                draw_display_list( XtDisplay(widget), XtWindow(widget),
				GlobalGC, get_DL(widget) );
 */
	} else {
printf("Currently unsupported move widget operation.\n");
		if (!XtIsComposite( parent )) {
		   printf("Can't place widget except on composite widgets.\n");
		   return FAIL;
	        }
                XtManageChild( widget, 1 );
		XtRealizeWidget( widget );
		XtMapWidget( widget->core.parent );
	}
}



do_resize_widget()
{
	int x, y, width, height, x2, y2;
	Point *pt, *loop_until_down_and_get_window();
	Window window1, window2;
	Widget widget, parent, new_parent, BeingEdited();
	double fw, fh;
	
	/* first select widget (tree) to be resized) */
	
	printf("Select the widget to be resized:\n");
	pt = loop_until_down_and_get_window( &window1 );
	if (!window1) return NULL;
	
	/* 
	 * check if widget is part of a
	 * currently edited widget tree
	 */
		
	widget = BeingEdited( window1 );
	if (!widget) return NULL;
	if (widget == workarea) return NULL;

	parent = widget->core.parent;

	/* now echo for rescaling placement */

	printf("Please enter two points for widgets new size:\n");
	window2 = get_two_points_and_window( &x, &y, &x2, &y2 );
		
	new_parent = BeingEdited( window2 );
	if (!new_parent) {
		printf("Error looking up existing widget\n");
		exit();
	}
	/* avoid selecting oneself as the parent (we leave widget down for rescaling) */

	if (new_parent == widget) {
	          new_parent = parent;	/* adjust to real parent */
		  x += widget->core.x; /* add in additional offset */
		  y += widget->core.y;
		  x2 += widget->core.x;
		  y2 += widget->core.y;
	}

	/* now perform actual operations required for resizing */

	width = x2 - x + 1;
	height = y2 - y + 1;

	/* if parent the same, just resize
	 * otherwise remove old parent-child relationship, and add new
	 * and then resize
	 */
	if ((new_parent == widget->core.parent) || (new_parent == widget)) {
		/* get widget, do simple dx, dy adjustment */
	        XtMoveWidget( widget, x, y );
		width = x2 - x + 1;
		height = y2 - y  + 1;
		XtResizeWidget( widget, width, height, 1);
		/* now redispl<ay widget tree from parent */
		XtRealizeWidget( widget->core.parent );
	} else {
		if (!XtIsComposite( parent )) {
		   printf("Can't place widget except on composite widgets\n");
		   return FAIL;
	        } else {
		  printf("We don't change structural relationships in this version\n"); 
		  return FAIL;
		}
	}
}

do_delete_widget() { 
        XEvent event;
	Point *pt, *loop_until_down_and_get_window();
	Window window;
	Widget widget, parent, BeingEdited();

        mode = 0;
	/* first select widget (tree) to be moved) */
	
        printf("Select the widget to delete:\n");
	pt = loop_until_down_and_get_window( &window );
	if (!window) return NULL;
	
	/* 
	 * check if widget is part of a
	 * currently edited widget tree
	 */
		
	widget = BeingEdited( window );
	if (!widget) return NULL;
	if (widget == workarea) return NULL;

	XtDestroyWidget( widget );
}
	
do_load_widget()
{
        Widget widget, ascii_load_widgets();  
        char *name, *input_text();
        mode = 0;
	name = input_text("Enter widget group to load:\n");
	if (name && *name) {
	  editor_load = 1;
	  widget = ascii_load_widgets( name, workarea );
	  editor_load = 0;
          if (widget) XtRealizeWidget( widget );
	} else printf("No widget name for load specified, Load ignored\n");
	return SUCCESS;
}

do_save_widget() 
{
	Point *pt, *loop_until_down_and_get_window();
	Window window;
	Widget widget, parent, BeingEdited();
	
	/* first select widget (tree) to be moved) */
	
	printf("Select widget tree to save:\n");
	pt = loop_until_down_and_get_window( &window );
	if (!window) return NULL;
	
	/* 
	 * check if widget is part of a
	 * currently edited widget tree
	 */
		
	widget = BeingEdited( window );
	if (!widget) return NULL;
	if (widget == workarea) return NULL;

	/* gwt the primary widget:: dangerous code if workarea removed */

	while (widget->core.parent && (widget->core.parent != workarea)) widget = widget->core.parent;

	/* for save to ascii file */
	
	printf("saving widget: %s\n", widget->core.name );
	save_widget( widget );
}

/*
 * callback's only support one callback for Command buttons for now.
 * This done to simplify the user interface to get the program out quickly.
 */

do_change_callback()
{
	Point *pt, *loop_until_down_and_get_window();
	Window window; Widget widget, parent, BeingEdited();
        char *callbackName, *input_text();

	/* get the widget */
	
	printf("Select command widget to change callback of:\n");
	pt = loop_until_down_and_get_window( &window );
	if (!window) return NULL;
	
	/* 
	 * check if widget is part of a
	 * currently edited widget tree
	 */
		
	widget = BeingEdited( window );
	if (!widget) return NULL;
	if (widget == workarea) return NULL;

	/* make sure it is a command button */
	
	if (! XtIsSubclass(widget, (WidgetClass) DLcommandWidgetClass)) return NULL;

	/* get it's new callback */

	callbackName = input_text("New callback name:");

	/* delete the old callback(s) */

	DeleteFtnsFromWidget( widget );

	/* add the new callback */

	AssociateFakeFtn ( callbackName, widget );
}



do_filledrect()
{
	short *DL, *dl_ptr;		/* display list pointer */
	short *get_DL();
	unsigned short opcode, size, length;
	unsigned int DL_size, new_size;
	int x, y, x2, y2, width, height;
	Widget widget, BeingEdited();
	Window window, get_two_points_and_window();
	double fw, fh;

        mode = 0;
	printf("Enter two points to define the filled rectangle:\n");
	while (window = get_two_points_and_window( &x, &y, &x2, &y2 )) {
		
		widget = BeingEdited( window );
		if (!widget) return NULL;
		if (widget == workarea) return NULL;
		
		width = x2 - x + 1;
		height = y2 - y + 1;
		fw = widget->core.width; fh = widget->core.height;
		/*
		 * add a filled rectangle to the display list
		 */

		/* first, get the displaylist of the widget */
		 
		DL = get_DL( widget );
		if (!DL) return;
		DL_size = get_DL_size( widget );
		
		/*
		 * now get the opcode for the instruction.
		 * This is the ONLY way to get the opcode of the instruction
		 * since it comes from the instruction registration file.
		 */
		opcode = lookup_instruction( "filled_rectangle" );
		
		/* get the size of the instruction */
		
		size = instruction_size( opcode );
		
		/* check if displaylist needs to be expanded */
		
		

		/* go to the end of the display list, count up sizes */
		
		dl_ptr = DL;
		while (*dl_ptr != HALT) {
			length = *(dl_ptr + 1);
			size += length;
			dl_ptr += (length >> 1);
		}
		/*
		 * see if display list needs to be expanded 
		 */
		 
		if (new_size = expand_DL_size( &DL, DL_size, size )) {
			replace_DL( widget, DL, new_size );
			/* again, get to end of (the new) display list */
			dl_ptr = DL;
			while (*dl_ptr != HALT) {
				length = *(dl_ptr + 1);
				size += length;
				dl_ptr += (length >> 1);
			}
		}
		/*
		 * now actually add the new instruction 
		 */

		*dl_ptr = opcode;  /* add in the opcode for this command */
		add_frect( dl_ptr, x, y, width, height, cur_color, fw, fh );
				
		/* bump to next instruction position in displaylist */
			
		length = *(dl_ptr + 1) >> 1;
		dl_ptr += length;
	
		/* add HALT instruction to terminate displaylist */
		
		*dl_ptr = HALT; 
		*(dl_ptr + 1) = 0;

		/* now draw what we have got */
		
		draw_display_list( XtDisplay(widget), XtWindow(widget),
				GlobalGC, DL );
	} 
}

do_rect()
{
	short *DL, *dl_ptr;		/* display list pointer */
	short *get_DL();
	unsigned short opcode, size, length;
	unsigned int DL_size, new_size;
	int x, y, x2, y2, width, height;
	Widget widget, BeingEdited();
	Window window, get_two_points_and_window();
	double fw, fh;

        mode = 0;
	printf("Enter two points to define the rectangle:\n");
	while (window = get_two_points_and_window( &x, &y, &x2, &y2 )) {
		
		widget = BeingEdited( window );
		if (!widget) return NULL;
		if (widget == workarea) return NULL;
		
		width = x2 - x + 1;
		height = y2 - y + 1;
		fw = widget->core.width; fh = widget->core.height;
		/*
		 * add a rectangle to the display list
		 */

		/* first, get the displaylist of the widget */
		 
		DL = get_DL( widget );
		if (!DL) return;

		DL_size = get_DL_size( widget );
		
		/*
		 * now get the opcode for the instruction.
		 * This is the ONLY way to get the opcode of the instruction
		 * since it comes from the instruction registration file.
		 */
		opcode = lookup_instruction( "rectangle" );
		
		/* get the size of the instruction */
		
		size = instruction_size( opcode );
		
		/* check if displaylist needs to be expanded */
		
		/* go to the end of the display list, count up sizes */
		
		dl_ptr = DL;
		while (*dl_ptr != HALT) {
			length = *(dl_ptr + 1);
			size += length;
			dl_ptr += (length >> 1);
		}
		/*
		 * see if display list needs to be expanded 
		 */
		 
		if (new_size = expand_DL_size( &DL, DL_size, size )) {
			replace_DL( widget, DL, new_size );
			/* again, get to end of (the new) display list */
			dl_ptr = DL;
			while (*dl_ptr != HALT) {
				length = *(dl_ptr + 1);
				size += length;
				dl_ptr += (length >> 1);
			}
		}
		/*
		 * now actually add the new instruction 
		 */

		*dl_ptr = opcode;  /* add in the opcode for this command */
		add_rect( dl_ptr, x, y, width, height, cur_color, fw, fh );
				
		/* bump to next instruction position in displaylist */
			
		length = *(dl_ptr + 1) >> 1;
		dl_ptr += length;
	
		/* add HALT instruction to terminate displaylist */
		
		*dl_ptr = HALT; 
		*(dl_ptr + 1) = 0;

		/* now draw what we have got */
		
		draw_display_list( XtDisplay(widget), XtWindow(widget),
				GlobalGC, DL );
	} 
}

do_line()
{
	short *DL, *dl_ptr;		/* display list pointer */
	short *get_DL();
	unsigned short opcode, size, length;
	unsigned int DL_size, new_size;
	int x, y, x2, y2, width, height;
	Widget widget, BeingEdited();
	Window window, get_two_points_and_window();
	double fw, fh; int display_class;

        mode = 0;
	printf("Enter two points to define the line:\n");
	while (window = get_two_line_points_and_window( &x, &y, &x2, &y2 )) {
		
		widget = BeingEdited( window );
		if (!widget) return NULL;
		if (widget == workarea) return NULL;
		
		/* check if a display list widget */

		display_class = XtIsDLLabel( widget) 
		      || XtIsDLObedient( widget )
			    || XtIsDLCommand( widget );
		if (!display_class) return;

		width = x2 - x + 1;
		height = y2 - y + 1;
		fw = widget->core.width; fh = widget->core.height;
		/*
		 * add a vector (line) to the display list
		 */

		/* first, get the displaylist of the widget */
		 
		DL = get_DL( widget );
		if (!DL) return;
		DL_size = get_DL_size( widget );
		
		/*
		 * now get the opcode for the instruction.
		 * This is the ONLY way to get the opcode of the instruction
		 * since it comes from the instruction registration file.
		 */
		opcode = lookup_instruction( "line" );
		
		/* get the size of the instruction */
		
		size = instruction_size( opcode );
		
		/* check if displaylist needs to be expanded */
		
		/* go to the end of the display list, count up sizes */
		
		dl_ptr = DL;
		while (*dl_ptr != HALT) {
			length = *(dl_ptr + 1);
			size += length;
			dl_ptr += (length >> 1);
		}
		/*
		 * see if display list needs to be expanded beyond this total
		 */
		 
		if (new_size = expand_DL_size( &DL, DL_size, size )) {
			replace_DL( widget, DL, new_size );
			/* again, get to end of (the new) display list */
			dl_ptr = DL;
			while (*dl_ptr != HALT) {
				length = *(dl_ptr + 1);
				size += length;
				dl_ptr += (length >> 1);
			}
		}
		/*
		 * now actually add the new instruction 
		 */

		*dl_ptr = opcode;  /* add in the opcode for this command */
		add_line( dl_ptr, x, y, x2, y2, cur_color, fw, fh );
				
		/* bump to next instruction position in displaylist */
			
		length = *(dl_ptr + 1) >> 1;
		dl_ptr += length;
	
		/* add HALT instruction to terminate displaylist */
		
		*dl_ptr = HALT; 
		*(dl_ptr + 1) = 0;

		/* now draw what we have got */
		
		draw_display_list( XtDisplay(widget), XtWindow(widget),
				GlobalGC, DL );
	} 
}

extern int text_justify;
#define TLEFT	1
#define TCENTER	2
#define TRIGHT	3
#define TCANCEL	4

do_text()
{
        XEvent event;
	int x, y, display_class;
        char *str, *input_text(), justification[32];
	Point *pt, *loop_until_down_and_get_window();
	Window window;
	Widget widget, parent, BeingEdited();
	short *DL, *dl_ptr;		/* display list pointer */
	short *get_DL();
	unsigned short opcode, size, length;
	unsigned int DL_size, new_size;
	double fw, fh;
	
        mode = 0;

	/* first select the widget to have text added */
	
	printf("Select the widget to add text to:\n");
	pt = loop_until_down_and_get_window( &window );
	x = pt->x; y = pt->y;
	if (!window) return NULL;
	
	/* 
	 * check if widget is part of a
	 * currently edited widget tree
	 */
		
	widget = BeingEdited( window );
	if (!widget) return NULL;
	if (widget == workarea) return NULL;

	/* check if a display list widget */

	display_class = XtIsDLLabel( widget) 
	      || XtIsDLObedient( widget )
		    || XtIsDLCommand( widget );
	if (!display_class) return;

	fw = widget->core.width; fh = widget->core.height;

        text_justify = 999;
        popup_justify();
        do {
		if(XPending( toplevelDisplay ) ) {
			XtNextEvent( &event );
			XtDispatchEvent( &event );
		}
        } while( text_justify == 999 );
        PopDown_Justify();
	strcpy( justification, "none" );
	if (text_justify == TLEFT) { 
	  strcpy( justification, "left" ); x = 0; y = 0; 
	}
	if (text_justify == TRIGHT) { 
	  strcpy( justification, "right" ); x = 0; y = 0; 
	}
	if (text_justify == TCENTER) { 
	  strcpy( justification, "center" ); x = 0; y = 0; 
	}
        printf("Justify = %d\n", text_justify );
        str = input_text("Enter text label:"); 
        if (str) printf("String is %s\n", str );
	else { printf("No string, command ignored\n"); return; }

	/* first, get the displaylist of the widget */
		 
	DL = get_DL( widget );
		if (!DL) return;
	DL_size = get_DL_size( widget );
		
	/*
	 * now get the opcode for the instruction.
	 * This is the ONLY way to get the opcode of the instruction
	 * since it comes from the instruction registration file.
	 */
	opcode = lookup_instruction( "text" );
		
	/* get the size of the instruction */
		
	size = instruction_size( opcode );
		
	/* check if displaylist needs to be expanded */
		
	/* go to the end of the display list, count up sizes */
		
	dl_ptr = DL;
	while (*dl_ptr != HALT) {
		length = *(dl_ptr + 1);
		size += length;
		dl_ptr += (length >> 1);
	}
	/*
	 * see if display list needs to be expanded 
	 */
		 
	if (new_size = expand_DL_size( &DL, DL_size, size )) {
		replace_DL( widget, DL, new_size );
		/* again, get to end of (the new) display list */
		dl_ptr = DL;
		while (*dl_ptr != HALT) {
			length = *(dl_ptr + 1);
			size += length;
			dl_ptr += (length >> 1);
		}
	}
	/*
	 * now actually add the new instruction 
	 */

	*dl_ptr = opcode;  /* add in the opcode for this command */

	/* add text for label instruction */

	add_text( dl_ptr, x, y, widget->core.width, widget->core.height, 1 /* color_index */ , 
					justification, "vg-20", str, fw, fh );
				

				
	/* bump to next instruction position in displaylist */
			
	length = *(dl_ptr + 1) >> 1;
	dl_ptr += length;
	
	/* add HALT instruction to terminate displaylist */
		
	*dl_ptr = HALT; 
	*(dl_ptr + 1) = 0;

	/* now draw what we have got */
		
	draw_display_list( XtDisplay(widget), XtWindow(widget),
				GlobalGC, DL );

}

do_rename_widget()
{
        XEvent event;
        char *str, *input_text();
	Point *pt, *loop_until_down_and_get_window();
	Window window;
	Widget widget, parent, BeingEdited();
	short *DL, *dl_ptr;		/* display list pointer */
	short *get_DL();
        short *get_instruction();
	unsigned short opcode, size, length;
	unsigned int DL_size, new_size;
	double fw, fh; int display_class;
	
	Arg arglist[12];
	Cardinal num_args;
	
        mode = 0;

	/* first select widget to be renamed */
	
	printf("Select the widget to be renamed:\n");
	pt = loop_until_down_and_get_window( &window );
	if (!window) return NULL;
	
	/* 
	 * check if widget is part of a
	 * currently edited widget tree
	 */
		
	widget = BeingEdited( window );
	if (!widget) return NULL;
	if (widget == workarea) return NULL;

	/* get the new label */

        str = input_text("Enter new widget name:"); 
        if (str) printf("New name is: %s\n", str );
	else { printf("No string, command ignored\n"); return; }

	/* change widgets name */

	if (strlen(widget->core.name) < strlen(str)) {
	       widget->core.name = (char *) malloc( strlen( str ) + 1);
	       strcpy( widget->core.name, str );					    
	     } else strcpy( widget->core.name, str );					    

	printf("Widgets Name is Now: %s\n", widget->core.name );

	/* check if a display list widget */

	if (XtIsDLObedient( widget )) return;
	display_class = XtIsDLLabel( widget) || XtIsDLCommand( widget );

	/* if a non-displaylist widget, change internal label */

	if (!display_class) {
	      num_args = 0;
	      XtSetArg( arglist[num_args],XtNlabel, str ); num_args++;
	      XtSetValues( widget, arglist, num_args );
	      XtMapWidget( widget );
	      printf("handled non display list widget\n");
	      return;
	}

	/* change displaylist widgets, first, get the displaylist of the widget */
	
	DL = get_DL( widget );
	if (!DL) return;
	DL_size = get_DL_size( widget );
		
	/*
	 * now get the opcode for the instruction.
	 * This is the ONLY way to get the opcode of the instruction
	 * since it comes from the instruction registration file.
	 */
	opcode = lookup_instruction( "text" );
		
	/* go to the desired instruction in the  display list  */
		
	dl_ptr = get_instruction( DL, opcode );
	if (dl_ptr && (*dl_ptr != HALT)) {
	  /* Now how do we change the text without violating our lack of instructions knowledge! */
	     update_text_instruction( dl_ptr, str );
	}
	draw_display_list( XtDisplay(widget), XtWindow(widget),
				GlobalGC, DL );

}

short *get_instruction( DL, opcode )
short *DL; unsigned short opcode;
{
	register short *dl_ptr;		/* display list pointer */
	unsigned short length;

	dl_ptr = DL;
	while (*dl_ptr != HALT) {
	        if (*dl_ptr == opcode) return dl_ptr;
		length = *(dl_ptr + 1);
		dl_ptr += (length >> 1);
	}
	return NULL;
}

short *get_DL( widget ) Widget widget;
{
	DLObedientWidget obw;
	DLCommandWidget cbw;
	DLLabelWidget lbw;
	if ( XtIsDLObedient( widget )) {
		obw = (DLObedientWidget) widget;
		return obw->obedient.DL;
	}
	if ( XtIsDLCommand( widget )) {
		cbw = (DLCommandWidget) widget;
		return cbw->command.DL;
	}
	if ( XtIsDLLabel( widget )) {
		lbw = (DLLabelWidget) widget;
		return lbw->label.DL;
	}
	return NULL;
}

int get_DL_size( widget ) Widget widget;
{
	DLObedientWidget obw;
	DLCommandWidget cbw;
	DLLabelWidget lbw;
	
	if ( XtIsDLObedient( widget )) {
		obw = (DLObedientWidget) widget;
		return obw->obedient.DLSize;
	}
	if ( XtIsDLCommand( widget )) {
		cbw = (DLCommandWidget) widget;
		return cbw->command.DLSize;
	}
	if ( XtIsDLLabel( widget )) {
		lbw = (DLLabelWidget) widget;
		return lbw->label.DLSize;
	}
	return NULL;
}

 /*
  *  expand_DL_size( display_list, current_size, new_size )
  *  return the new size 
  */

expand_DL_size( DL, dl_size, size ) 
unsigned short **DL;
unsigned short dl_size;
unsigned short size;
{
	unsigned short *dltmp;

	if (!DL) return FAIL;
	if (size <= 0) return FAIL;

	if (size > (dl_size - MAX_INSTRUCTION_SIZE)) { 
		dltmp = (unsigned short *) malloc( size * 2 );
		if (!dltmp) {
			fprintf(stderr, 
				"Malloc Failure in expand displaylist()\n");
			exit();
		}
		if (*DL && (dl_size > 0)) {
		    bcopy( *DL, dltmp, dl_size );
		    free( *DL );
		}
		*DL = dltmp;
		return size * 2;
	}
	return FAIL;
}


replace_DL( widget, DL, new_size )
Widget widget; short *DL; int new_size;
{
	DLObedientWidget obw;
	DLCommandWidget cbw;
	DLLabelWidget lbw;
	
	if ( XtIsDLObedient( widget )) {
		obw = (DLObedientWidget) widget;
		obw->obedient.DL = DL;
		obw->obedient.DLSize = new_size;
		return SUCCESS;
	}
	if ( XtIsDLCommand( widget )) {
		cbw = (DLCommandWidget) widget;
		cbw->command.DL = DL;
		cbw->command.DLSize = new_size;
		return SUCCESS;
	}
	if ( XtIsDLLabel( widget )) {
		lbw = (DLLabelWidget) widget;
		lbw->label.DL = DL;
		lbw->label.DLSize = new_size;
		return SUCCESS;
	}
	return FAIL;
}
