/*
.nf
*/

/*
 *  Display List based CommandClass Widget
 */

#define MASSCOMP 1

/*
 * Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of Digital Equipment
 * Corporation not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  
 * 
 * 
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/*
 * Command.c - Command button widget
 *
 * Rewritten for beta toolkit
 * Author:      Mark Ackerman
 *              MIT/Project Athena
 * Date:        August 27, 1987
 *
 * from Command.c (XToolkit, alpha version)
 *              Charles Haynes
 *              Digital Equipment Corporation
 *              Western Software Laboratory
 */
 
/*
 * Rewritten for "Display List" Widgets
 *
 *       	Richard Carling
 *		MASSCOMP Corp.
 *      	January 27, 1988
 *
 * For modified parts of this software:
 *
 *			  COPYRIGHT 1988
 *	    MASSACHUSETTS COMPUTER CORPORATION (MASSCOMP)
 *		       WESTFORD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MASSCOMP. MASSCOMP MAKES
 * NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY
 * PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT 
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN 
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that the
 * copyright notice, and this permission notice appear in 
 * supporting documentation.
 *
 */


#define IsSensitive(w)	((w)->core.sensitive && (w)->core.ancestor_sensitive)

  /* The following are defined for the reader's convenience.  Any
     Xt..Field macro in this code just refers to some field in
     one of the substructures of the WidgetRec.  */
     
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <X11/Xos.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include "DLCommandP.h"
#include "DLCommandI.h"

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */

static char defaultTranslations[] =
    "<Btn1Down>:	set() \n\
     <Btn1Up>:		notify() unset() \n\
     <EnterWindow>:	highlight() \n\
     <LeaveWindow>:	unset(NoRedisplay) unhighlight()";

static int defHighlight = 2;

static XtResource resources[] = { 

   {XtNcallback, XtCCallback, XtRCallback, sizeof(caddr_t), 
     XtOffset(DLCommandWidget, command.callbacks), XtRCallback, (caddr_t)NULL},

 };  

static XtActionsRec actionsList[] =
{
  {"set",		Set},
  {"notify",		Notify},
  {"highlight",		Highlight},
  {"unset",		Unset},
  {"unhighlight",	Unhighlight},
};

static void Initialize();
static void Realize();
static void Resize();
static void Redisplay();
static Boolean SetValues();
static void ClassInitialize();

DLCommandClassRec DLcommandClassRec = {
  {
    (WidgetClass) &widgetClassRec,         /* superclass	*/    
    "Command",                             /* class_name	*/
    sizeof(DLCommandRec),                  /* size		*/
    NULL,                                  /* class initialize  */
    NULL,	  			   /* class_part_initialize  */
    FALSE,                                 /* class_inited      */
    Initialize,                            /* initialize	*/
    NULL,				   /* initialize_hook	  */
    Realize,		                   /* realize		*/
    actionsList,                           /* actions		*/
    XtNumber(actionsList),                 /* num_actions	*/
    resources,                             /* resources	        */
    XtNumber(resources),                   /* resource_count	*/
    NULLQUARK,                             /* xrm_class	        */
    FALSE,                                 /* compress_motion	*/
    FALSE,                                 /* compress_exposure	*/
    TRUE,				   /* compress_enterleave    */
    FALSE,                                 /* visible_interest	*/
    Destroy,                               /* destroy		*/
    Resize,                                /* resize		*/
    Redisplay,                             /* expose		*/
    SetValues,                             /* set_values	*/
    NULL,				   /* set_values_hook	  */
    XtInheritSetValuesAlmost,		   /* set_values_almost	  */
    NULL,				   /* get_values_hook	  */
    NULL,                                  /* accept_focus	*/
    XtVersion,				   /* version		  */
    NULL,                                  /* callback_private	*/
    defaultTranslations,		/* tm_table		  */
    NULL,				/* query_geometry	  */
  },  /* CoreClass fields initialization */
  {
    0,                                     /* field not used    */
  },  /* CommandClass fields initialization */
};

  /* for public consumption */

WidgetClass DLcommandWidgetClass = (WidgetClass) &DLcommandClassRec;

extern GC GlobalGC;
extern GC GlobalGrayGC;
extern Pixmap GlobalGrayPixmap;


/*
 *
 * Private Procedures
 *
 */

 
static void Initialize(request, new)
Widget request, new;
{
    DLCommandWidget cbw = (DLCommandWidget) new;

    /* init flags for state */
    
    ComWset = FALSE;
    ComWhighlighted = FALSE;  
    ComWdisplayHighlighted = FALSE;
    ComWdisplaySet = FALSE;
    
    /*
     * NULL out display lists, these are loaded externally
     * if the resource manager held them, we could load them now
     * but that will be slow... 
     */
    
    cbw->command.DLSize = 0;
    cbw->command.DL = NULL;
    cbw->command.setDLSize = 0;
    cbw->command.setDL = NULL;
    cbw->command.highlightedDLSize = 0;
    cbw->command.highlightedDL = NULL;

} 

/*
 *  Event Handlers
 */


static void Set(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
	DLCommandWidget cbw = (DLCommandWidget)w;
	ComWset = TRUE;
	Redisplay(w, event, NULL);
}


static void Unset(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;
{
	DLCommandWidget cbw = (DLCommandWidget)w;
	ComWset = FALSE;
	if (*num_params == 0)
		Redisplay(w, event, NULL);
}


static void Highlight(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
	DLCommandWidget cbw = (DLCommandWidget)w;
	ComWhighlighted = TRUE;
	Redisplay(w, event, NULL);
}

static void Unhighlight(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
	DLCommandWidget cbw = (DLCommandWidget)w;
	ComWhighlighted = FALSE;
	Redisplay(w, event, NULL);
}

static void Notify(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
	DLCommandWidget cbw = (DLCommandWidget)w;
	if (ComWset)
		XtCallCallbacks(w, XtNcallback, NULL);
}

/*
 * Resize
 */

static void Resize(cbw)
DLCommandWidget	cbw;
{

	/* resize all of our displaylists, if we have them */
	
	if (cbw->command.DL)
		resize_display_list( cbw->command.DL, cbw->core.x, cbw->core.y, 
			cbw->core.width,  cbw->core.height);
			
	if (cbw->command.setDL)
		resize_display_list( cbw->command.setDL, cbw->core.x, cbw->core.y, 
			cbw->core.width,  cbw->core.height);
			
	if (cbw->command.highlightedDL)
		resize_display_list( cbw->command.highlightedDL,
			cbw->core.x, cbw->core.y, 
				cbw->core.width,  cbw->core.height);
			

}

/*
 * Redisplay
 */


static void Redisplay(w, event, region)
Widget w;
XEvent *event;		/* unused */
Region region;		/* unused */
{
	DLCommandWidget cbw = (DLCommandWidget) w;
	XSetWindowAttributes window_attributes;

	if (cbw->command.DLSize > 0) { /* use display lists if we have them */
		if (ComWset) {
			if (cbw->command.setDLSize > 0) 
				draw_display_list( XtDisplay(w), XtWindow(w),
					(ComWsensitive ? GlobalGC : GlobalGrayGC),
						cbw->command.setDL );
		} else if (ComWhighlighted) {
			if (cbw->command.highlightedDLSize > 0) 
				draw_display_list( XtDisplay(w), XtWindow(w),
					(ComWsensitive ? GlobalGC : GlobalGrayGC),
						cbw->command.highlightedDL );
		} else {
			if (cbw->command.DLSize > 0)
				draw_display_list( XtDisplay(w), XtWindow(w),
					(ComWsensitive ? GlobalGC : GlobalGrayGC),
						cbw->command.DL );
		}
		
	}
	ComWdisplayHighlighted = ComWhighlighted;
	ComWdisplaySet = ComWset;
}   


static void Realize(w, valueMask, attributes)
register Widget w;
Mask *valueMask;
XSetWindowAttributes *attributes;
{
    DLCommandWidget cbw = (DLCommandWidget)w;

    if (!IsSensitive(cbw))
      {
	  /* change border to gray */

	attributes->border_pixmap = GlobalGrayPixmap;
	*valueMask |= CWBorderPixmap;
	*valueMask &= ~CWBorderPixel;
      }
    

    XtCreateWindow( w, (unsigned int)InputOutput, (Visual *)CopyFromParent,
		    *valueMask, attributes );
}

static void Destroy(w)
Widget w;
{
  /* must free displaylists */
}

 
/*
 *
 * Set Values, we only handle Sensitive right now
 *
 */

static Boolean SetValues (current, request, new)
Widget current, request, new;
{
	DLCommandWidget cbw = (DLCommandWidget) current;
	DLCommandWidget newcbw = (DLCommandWidget) new;
    
	if ((cbw->core.sensitive != newcbw->core.sensitive ||
	 cbw->core.ancestor_sensitive != newcbw->core.ancestor_sensitive)
	&& XtIsRealized(newcbw)) {
		if (IsSensitive(newcbw))
			XSetWindowBorder( XtDisplay(newcbw), XtWindow(newcbw),
			      newcbw->core.border_pixel );
		else
			XSetWindowBorderPixmap(XtDisplay(newcbw), XtWindow(newcbw), 
	    			GlobalGrayPixmap);

		return True;
	}
	return False;
}





