/*
 *			  COPYRIGHT 1988
 *	    MASSACHUSETTS COMPUTER CORPORATION (MASSCOMP)
 *		       WESTFORD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 *		       Author: Richard Carling
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MASSCOMP CORPORATION.
 * MASSCOMP MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR
 * ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT 
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN 
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that the
 * copyright notice, and this permission notice appear in 
 * supporting documentation.
 */

/* some glue routines for the widget editor */


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>


/*
 *	The following functions handle registering of dummy external functions.
 *	This is only needed by the editor where application callback ftns don't actually exist
 *	If a widget has more then 1 ftn, they will have more links on the list
 *	Widgets being edited are stuffed with a harmless callback for now (which should be made
 *      to print out the callback name when sellected (Check Callback)).
 *
 *      A method for handling this type of functionality may already exist in the X Toolkit
 *      It seemded easier to write one.
 */


typedef struct FtnList {
	struct FtnList *next;
	Widget widget;
	char name[64];
} XtFtnListRec;

static XtFtnListRec *FList = NULL;	
XtFtnListRec **FtnList = &FList;

void AssociateFakeFtn ( callbackName, widget )
char *callbackName;
Widget widget;
{
    int n;
    XtFtnListRec *fmr, *fm;

    if (!widget) return;
    if (!callbackName) return;
    
    fm =  (XtFtnListRec*) XtMalloc((unsigned)sizeof(XtFtnListRec));
    fm->widget = widget;
    fm->next = NULL;
    n = strlen( callbackName );
    if (n > 63) n = 63;
    strncpy( fm->name, callbackName, n+1 );
    
    /* insert link into list */

    if (*FtnList == NULL){
             (*FtnList) = fm;
             return;
    }
    /* append to linked list */
    fmr = (*FtnList);
    while (fmr->next) fmr = fmr->next;
    fmr->next = fm;
    return;
}

/* delete all functions associated with this widget */


DeleteFtnsFromWidget( widget )
Widget widget;
{
	XtFtnListRec *fm, *ofm;

	ofm = NULL;
	for ( fm = *FtnList; fm != NULL; fm = fm->next ) {
		if (widget == fm->widget) {
		      if (ofm) ofm->next = fm->next;
                      else *FtnList = fm->next;
		} else ofm = fm;
	}
}

static XtFtnListRec *lastfm = NULL;

/* retrieve the ftn associated with a widget */

char *RetrieveFtnName( widget )
Widget widget;
{
	XtFtnListRec *fm;

	for ( fm = *FtnList; fm != NULL; fm = fm->next ) {
		if (widget == fm->widget) {
			lastfm = fm;
			return fm->name;
		}
		printf("Passed widget %s with callback: %s\n", (Widget)(fm->widget)->core.name, fm->name );
	}
	lastfm = NULL;
	return NULL;
}

/*
 * retrieve the next... ftn associated with widget
 * keep calling until returns null
 *
 * This seems to not work.
 */
 

char *RetrieveNextFtnName( widget )
Widget widget;
{
	XtFtnListRec *fm;

	if (!lastfm) {
	  for ( fm = *FtnList; fm != NULL; fm = fm->next ) {
		if (widget == fm->widget) {
			lastfm = fm;
			return fm->name;
		}
	  }
	  lastfm = NULL;
	  return NULL;
        }
	if (!lastfm) return NULL;

	for ( fm = lastfm; fm != NULL; fm = fm->next ) 
		if (widget == fm->widget) {
			lastfm = fm;
			return fm->name;
		}
	lastfm = NULL;
	return NULL;
}



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */




/*
 *     BeingEdited()::
 *     the following routines keep track of which widgets and windows
 *     are the ones being edited, and thus should have their events intercepted
 *     and interpreted differently. These routines are only necessary for
 *     the widget editor.
 */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* window to widget mapping */
 
typedef struct {
	Window window;
	Widget widget;
} WtoWdef;

static int WtoW_count = 0;
static WtoWdef WtoW[256];
 
/*
 * Register the widget which has been loaded or created 
 */

RegisterWidget( widget )
Widget widget;
{
	WtoW[ WtoW_count ].window = widget->core.window;
	WtoW[ WtoW_count ].widget = widget;
	WtoW_count++;
}


Widget EvBeingEdited( event )
XEvent *event;
{
	register int i;
	
	for (i=0; i<WtoW_count; i++) {
		if (event->xbutton.window == WtoW[i].window)
			return WtoW[i].widget;
	}
	return NULL;
}


Widget BeingEdited( window ) 
Window window;
{
	register int i;
	
	for (i=0; i<WtoW_count; i++)
		if (window == WtoW[i].window) return WtoW[i].widget;
	return NULL;
}
