/*
.nf
 *			  COPYRIGHT 1988
 *	    MASSACHUSETTS COMPUTER CORPORATION (MASSCOMP)
 *		       WESTFORD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 *		       Author: Richard Carling
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MASSCOMP CORPORATION.
 * MASSCOMP MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR
 * ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT 
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN 
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that the
 * copyright notice, and this permission notice appear in 
 * supporting documentation.
 */

/*
 * AsciiLoad.c  -- load ascii widget hierarchies from disk
 *
 *  This software provides ascii unpickling of widgets.
 *  Binary representations might be supported sometime
 *  in the future and will provide higher performance loading.
 *  Ascii Loading is SLOWWW...........
 *  Binary pickling would speed loading up, binary loading from a single
 *  archive file would speed it up even more. Binary pickling and unpickling
 *  has not been written at this time.
 *     (it still hasn't been written 8-21-88).
 *
 *	author: Richard Carling	11/11/87
 */


#include <stdio.h>
#include <X11/Xatom.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/Shell.h>
#include <X11/LabelP.h>
#include "XwP.h"
#include "DLLabelP.h"
#include "DLCommandP.h"
#include "DLObedientP.h"
#include "Fileio.h"

/* these two GC's are set up for shared use by all displaylists */

GC GlobalGC = NULL;
GC GlobalGrayGC = NULL;
Pixmap GlobalGrayPixmap = NULL;

/* some useful macro's */

/*
#define XtIsComposite(widget)	\
		XtIsSubclass( widget, (WidgetClass) compositeWidgetClass )
*/
#define XtIsXw(widget)	\
		XtIsSubclass( widget, (WidgetClass) XwWidgetClass )
		
#define XtIsDLLabel(widget)	\
		XtIsSubclass( widget, (WidgetClass) DLlabelWidgetClass )
		
#define XtIsDLObedient(widget)	\
		XtIsSubclass( widget, (WidgetClass) DLobedientWidgetClass )
		
#define XtIsDLCommand(widget)	\
		XtIsSubclass(widget, (WidgetClass) DLcommandWidgetClass)

		

struct symtab {
	char *name;		/* symbol name -- must be alphabetical order in list */
	int match;		/* minimum number of characters to match */
	int value;		/* just what it says */
};

/*
 * These are the symbols the parser recognizes.
 * Look at the ascii widget files for examples of how 
 * these symbols are used.
 */

struct symtab widget_symbols[] =
{
	"background",			10, F_BACKGROUND,
	"border_width", 		11, F_BORDER_WIDTH,
	"border_pixel", 		11, F_BORDER_PIXEL,
	"callback", 			8,  F_CALLBACK,
	"child", 			5,  F_CHILD_NAME,
	"class", 			5,  F_CLASS,
	"displaylist",			11, F_DISPLAYLIST,
	"end",				3,  F_END,
	"foreground",			10, F_FOREGROUND,
	"height", 			6,  F_HEIGHT,
	"highlighted_displaylist",	23, F_HIGHLIGHTED_DISPLAYLIST,
	"label", 			5,  F_LABEL,
	"name", 			4,  F_NAME,
        "primary_children",             16, F_PRIMARY_CHILDREN,
	"set_displaylist",		15, F_SET_DISPLAYLIST,
	"width", 			5,  F_WIDTH,
	"x", 				1,  F_X,
	"y", 				1,  F_Y,
	NULL,				0,  0
};


/* 
 *  Class name identifiers, this is a working but incomplete set
 *  of the widgets (the currently known working set I have available)
 *  Each new widget class whcih is to be supported by this 
 *  pickling/unpickling system  must be added to this list.
 *
 *  Since the Widget Display List is class Dependant (some widgets
 *  have multiple display lists, others only have one),
 *  we don't make it part of the core class structure 
 *  (not to mention the political implications of doing that),
 *  thus, each class must be handled specifically.
 */
 
#define F_LabelClass     	1
#define F_CommandClass   	2
#define F_DLCommandClass   	3
#define F_DLLabelClass   	4
#define F_DLObedientClass   	5
#define F_ButtonBoxClass	6
#define F_ObedientClass		7
#define F_XwClass		8
#define F_TopLevelClass  	1000

struct symtab widget_classes[] =
{
	"button",		6, F_ButtonBoxClass,
	"command",		7, F_CommandClass,
	"dlcommand",		9, F_DLCommandClass,
	"dllabel",		7, F_DLLabelClass,
	"dlobedient",		10, F_DLObedientClass,
	"label",		5, F_LabelClass,
	"obedient",		8, F_ObedientClass,
	"toplevel",		8, F_TopLevelClass,
	"xwindow",		7, F_XwClass,
	NULL,			0,  0
};

static WidgetClass DefinedClass;

/* these are required to make XtCreateWidget happy */

extern WidgetClass labelWidgetClass;
extern WidgetClass commandWidgetClass;
extern WidgetClass boxWidgetClass;
extern WidgetClass DLcommandWidgetClass;
extern WidgetClass DLlabelWidgetClass;
extern WidgetClass DLobedientWidgetClass;
extern WidgetClass xwWidgetClass;

extern Widget XtInitialize(), XtInitializeInWindow(), XtCreateWidget();

	
int Local_Directory = 0 ;
int editor_load = 0;
char *loadpath = NULL;
char directory_name[256];
char default_path[256] = ".";
char directory[256];

static char local_name[256]; 
static char primary_widget_name[256];

/*
 *	 XtUseDirectory( char *name ):	
 *	 allows user to load widgets from
 *	 an arbitrary directory	   
 */
 
XtUseDirectory(name) char *name;
{	char *dir, *getwd(), pathname[128];
	
	if (!name) return;
	strcpy( local_name, name );
	loadpath = local_name;
	Local_Directory = 1;
}


/*
 *  exposed routine for reading in widget information
 *  from an ascii data file.
 */
/* 
 *  ascii_load_widgets()
 *
 *  Read in an ascii widget "set", 
 *  allocate all it's core, class 
 *  and composite structures. Use this data to fill in
 *  object editor setable core, class and composite areas, 
 *  after the standard initialize code (this means that
 *  supported editor controlable attributes override
 *  Xdefaults resource values, most currently do not conflict).
 *
 *  then recursively read in all it's children, 
 *  generating the hierarchical structure desired.
 *
 */


static registered = 0;	/* displaylist instructions registered flag */
 
Widget ascii_load_widgets( widget_name, parent )
char *widget_name; Widget parent;
{
    	Widget ascii_load_primary();
	char registration_name[256];
	
	/* handle registration just once, the first time we are called */

	if (!registered) {
		if (Local_Directory) strcpy( registration_name, loadpath );
		else strcpy( registration_name, default_path );
		strcat( registration_name, "/inst.table" );
		XtReadDLRegistration( registration_name );
		registered = 1;
		
		/* now we do other things that only get done once */
		
		if (!GlobalGC || !GlobalGrayGC) XtDLInitialize( parent );
	}

	return ascii_load_primary( widget_name, parent );
}	

	/* in a widget editor, this stuff has to be done first */
	
	/* create global GC's used by the display lists */

XtDLInitialize( w ) Widget w;
{
	XGCValues values;
	Drawable drawable;
		
    
	/* create a global GC for use by ALL display lists */
	
	values.foreground = 1;
	values.background = 0;
	values.function = GXcopy;
	values.line_width = 0;
	values.font = 0;
		
	if (!GlobalGC) {
		if (XtWindow( w ) == NULL)
			drawable = XCreatePixmap( XtDisplay(w), 
				XtScreen(w)->root, 1,1,w->core.depth );
		else drawable = XtWindow( w );

		GlobalGC = XCreateGC( XtDisplay(w), drawable, 
			GCFunction | GCForeground | GCBackground | GCLineWidth, 
								&values);
	}	   

	/* create a GRAY stipple for use by ALL insensitive display lists */
		
	if (!GlobalGrayGC) {
    
		GlobalGrayPixmap = XtGrayPixmap( XtScreen( w ));
		values.tile = GlobalGrayPixmap;
		values.fill_style = FillTiled;
		GlobalGrayGC = XCreateGC( XtDisplay(w), drawable, 
			GCTile | GCFillStyle |GCFunction 
				| GCForeground | GCBackground | GCLineWidth, 
							&values);
	}
}

/*
 *  Widget ascii_load_primary( widget_name, parent, level )
 *
 *  set up directory paths to read the proper primary widget
 */

Widget ascii_load_primary( widget_name, parent )
char *widget_name; Widget parent;
{
	Widget ascii_load_widget();
	
	strcpy( primary_widget_name, widget_name );
	if (Local_Directory) strcpy( directory, loadpath );
	else strcpy( directory, default_path );
	sprintf( directory_name, "%s/%s", directory, primary_widget_name);
	
	printf(" reading primary widget: %s in directory: %s\n",
		widget_name, directory_name );	
		
	return ascii_load_widget( widget_name, parent );
}	
	
/*
 *  Widget ascii_load_widget( widget_name, parent )
 *
 *  read in the actual attributes of the specified widget
 */

Widget ascii_load_widget( widget_name, parent )
char *widget_name; Widget parent;
{
	register FILE *fp;
	register Widget widget;
	unsigned int Class;
	char filename[256];
	char callbackName[256], fg_color[64], bg_color[64];
	char label_buf[256], *label;
	int i, cmd, status;
	int isLabelClass, isCommandClass, isDLClass, isTopLevelClass;
	int isDLLabelClass, isDLCommandClass, isDLObedientClass;
	int isXwClass;
	int x, y, width, height, callback_set;
	int border_width, border_pixel, primary_children;
#define MAXCHILD	64	
	int child_count;
	char childname[MAXCHILD][64];
	
	unsigned int dlsize, hdlsize, sdlsize;
	short *displaylist, *hdisplaylist, *sdisplaylist;
	DLLabelWidget lbw;
	DLCommandWidget cbw; 
	DLObedientWidget obw;
	
	XtCallbackProc callbackFtn;
	extern XtCallbackProc XtRetrieveFtn();
	Arg 	args[64];
    	unsigned int num_args;
	extern char *malloc();
	static XtCallbackRec callback[] = {
		{ NULL, NULL },
		{ NULL, NULL },
	};
	
	/* 
	 * open ascii widget file 
	 */

printf("     --- reading widget %s in directory %s/%s\n", widget_name, directory, primary_widget_name );
	sprintf( filename, "%s/%s/%s", directory, primary_widget_name, widget_name);
	fp = fopen( filename, "r" );
	if (!fp) {
		sprintf(filename,"%s/%s", loadpath, primary_widget_name, widget_name);
		fp = fopen( filename, "r");
		/* try global directory, user may have mapped to local directory */
		if (!fp) {
			sprintf(filename,"%s/%s/%s", 
				default_path, primary_widget_name, widget_name);
			fp = fopen(filename,"r");
			if (!fp) {
				fprintf( stderr, "open failed for:%s\n", filename );
				return NULL;
			}
		}
	}
	
	/*
	 *  Read in ascii widget information
	 */
	
	width = 10; height = 10;	/* minimum size if not specified */
	
	dlsize = 0;
	hdlsize = 0;
	sdlsize = 0;
	displaylist = NULL;
	hdisplaylist = NULL;
	sdisplaylist = NULL;
	
	child_count = 0;
	primary_children = 0;
        callback_set = 0;
	num_args = 0;
	isLabelClass = 0;
	isCommandClass = 0;
	isDLClass = 0;
	isDLLabelClass = 0;
	isDLCommandClass = 0;
	isDLObedientClass = 0;
	isTopLevelClass = 0;
	
	while ( cmd = decode_token( fp, widget_symbols ) )
	{
		switch( cmd ) {
			
		case F_CLASS:
			if (( Class = decode_token( fp,  widget_classes ) ) <= 0) {
				fprintf( stderr, 
				    "Ascii widget: %s, has an unrecognized class: %d\n", 
				    	filename, Class );
				return NULL;
			}

			switch( Class ) {
				
				case F_TopLevelClass:
					isTopLevelClass = 1;
					/* current *parent* must be toplevel */
					if (XtClass(parent) != shellWidgetClass) {
					    printf("Modifying TopLevel incorrectly\n");
					    exit();
					}
					printf("swapping in toplevel\n");
					widget = parent;
					break;
					
				case F_LabelClass:
					isLabelClass = 1;
					DefinedClass = labelWidgetClass;
					break;
					
				case F_CommandClass:
					isLabelClass = 1;
					isCommandClass = 1;
					DefinedClass = commandWidgetClass;
					break;
					
				case F_ButtonBoxClass:
					DefinedClass = boxWidgetClass;
					break;
					
				case F_XwClass:
					isXwClass = 1;
					DefinedClass = xwWidgetClass;
					break;
					
				case F_DLLabelClass:
					isDLClass = 1;
					isDLLabelClass = 1;
					DefinedClass = DLlabelWidgetClass;
					break;
					
				case F_DLCommandClass:
					isDLClass = 1;
					isDLCommandClass = 1;
					DefinedClass = DLcommandWidgetClass;
					break;
					
				case F_ObedientClass:
				case F_DLObedientClass:
					isDLClass = 1;
					isDLObedientClass = 1;
					DefinedClass = DLobedientWidgetClass;
					break;
					
				defualt:
					printf("unknown class type: %d for %s\n", 
							Class, widget_name );
					return NULL;
			}
			break;
			
		case F_END:
			goto quit;
			
		case F_DISPLAYLIST:
			if (isDLClass) {
				dlsize = ReadDisplaylist( fp, &displaylist, 
									width, height );
			} else printf("Illegal Widget Class for Display List\n");
			break;
		
		case F_HIGHLIGHTED_DISPLAYLIST:
			if (isDLClass) {
				hdlsize = ReadDisplaylist( fp, &hdisplaylist, 
									width, height );
			} else printf("Illegal Widget Class for Display List\n");
			break;
		
		case F_SET_DISPLAYLIST:
			if (isDLClass) {
			    sdlsize = ReadDisplaylist( fp, &sdisplaylist, 
			    						width, height );
			} else printf("Illegal Widget Class for Display List\n");
			break;
		
		case F_BACKGROUND:
			if (( status = fscanf( fp, "%s", bg_color )) == EOF ) goto quit;
			XtSetArg( args[num_args], XtNbackground, bg_color );
			num_args++;
			break;
			
		case F_FOREGROUND:
			if (( status = fscanf( fp, "%s", fg_color )) == EOF ) goto quit;
			XtSetArg( args[num_args], XtNforeground, fg_color );
			num_args++;
			break;
			
		case F_X:
			if ((status = fscanf( fp, "%d", &x )) == EOF ) goto quit;
			XtSetArg( args[num_args], XtNx, x );
			num_args++;
			break;

			
		case F_Y:
			if (( status = fscanf( fp, "%d", &y )) == EOF )
				goto quit;
			XtSetArg( args[num_args], XtNy, y );
			num_args++;
			break;
			
		case F_WIDTH:
			if (( status = fscanf( fp, "%d", &width )) == EOF)
				goto quit;
			XtSetArg( args[num_args], XtNwidth, width );
			num_args++;
			break;
			
		case F_HEIGHT:
			if ((status = fscanf( fp, "%d", &height )) == EOF)
				goto quit;
			XtSetArg( args[num_args], XtNheight, height );
			num_args++;
			break;
			
		case F_LABEL:
			if ((status = fscanf( fp, "%s", label_buf )) == EOF ) goto quit;
			label = malloc( strlen( label_buf )+1 );
			if (!label) { printf("Malloc failure on IO\n"); exit(); }
			strcpy( label, label_buf );
			XtSetArg( args[num_args], XtNlabel, label );
			num_args++;
			break;
			
		case F_CALLBACK:
			if ((status = fscanf( fp, "%s", callbackName )) == EOF )
						goto quit;
			if (isCommandClass || isDLCommandClass || isXwClass) {
				if (editor_load) callback_set = 1;
				else {
				    callbackFtn = XtRetrieveFtn( callbackName );
				    if (callbackFtn) {
					  callback[0].callback = callbackFtn;
					  XtSetArg( args[num_args], XtNcallback, callback);
					  num_args++;
				     /*   XtAddCallback((Widget)widget, XtNcallback, 
								callbackFtn, NULL);
			 	      */
				    } else printf("No CALLBACK for %s registered!\n",
				 		callbackName );
				}
			}
			break;
			
		case F_BORDER_WIDTH:
			status = fscanf( fp, "%d", &border_width );
			if (status == EOF ) goto quit;
			XtSetArg( args[num_args], XtNborderWidth, border_width );
			num_args++;
			break;
			
		case F_BORDER_PIXEL:
			status = fscanf( fp, "%d", &border_pixel );
			if (status == EOF ) goto quit;
			XtSetArg( args[num_args], XtNborder, border_pixel );
			num_args++;
			break;

		case F_PRIMARY_CHILDREN:
			primary_children = 1;
			break;

		case F_CHILD_NAME:

			status = fscanf( fp, "%19[^\n]", childname[child_count] );
		/*	printf("Reading child name #%d, name: %s\n", 
				child_count+1, childname[child_count] );  */
			if (status == EOF ) goto quit;
			child_count++;
			break;

		default:
			if ( cmd == 0 || cmd == EOF ) goto quit;

			/*	Anything else is bogus.		*/
			
			fprintf( stderr, 
				"Invalid command in ascii widget file: %s\n", 
					widget_name );
			return NULL;

		}
	}

quit:

	/*
	 *  Create the actual widget
	 */

	if (!isTopLevelClass) {
		if (!parent) {
			fprintf( stderr, "No parent for subwidget %s!\n", widget_name );
			return NULL;
		}
		if (!DefinedClass) printf("No defined class!\n");
		widget = XtCreateManagedWidget( widget_name,  DefinedClass, 
						parent, args, num_args);
		if (!widget) {
			printf("Sub Widget creation error\n"); 
			return NULL; 
		}
		
		/*
 		 *
		 * Associate the Displaylists with the specific widgets.
		 *
		 */
		 
		/* this is not ideal, but here is where we associate the
		 * specific display lists with the respective fields in
		 * their particular widget structures. This is not ideal because
		 * 1) it would be nicer if XtCreateWidget had a way to handle it
 		 * 2) it is a pain to have to handle each widget individually
		 *
		 *        but there is no way for the individual widgets
		 *        to get this information, so we do it this way.
		 */

		
		 	/* handle the obedient widget's displaylist */
		 
		if (isDLObedientClass) {
				obw = (DLObedientWidget) widget;
				obw->obedient.DLSize = dlsize;
				obw->obedient.DL = displaylist;
			} 
		else  /* handle the command class widget's displaylists */
		
			if (isDLCommandClass) { 
				cbw = (DLCommandWidget) widget;
				cbw->command.DLSize = dlsize;
				cbw->command.DL = displaylist;
				cbw->command.setDLSize = sdlsize;
				cbw->command.setDL = sdisplaylist;
				cbw->command.highlightedDLSize = hdlsize;
				cbw->command.highlightedDL = hdisplaylist;
			}
		else	/* handle label widget's displaylist */
		
			if (isDLLabelClass) {
    				lbw = (DLLabelWidget) widget;
				lbw->label.DLSize = dlsize;
				lbw->label.DL = displaylist;
		}
		/* else if(...) handle new clases here, etc... */
	} 

	fclose( fp );
	fp = NULL;
	
	/* editor_load true if loading into widget editor workspace */

	if (editor_load) {
	    if (callback_set) AssociateFakeFtn ( callbackName, widget );
	   /*
            *  register widget, so we don't think it is active
            *  allows editor to inhibit events to it 
            */
	    RegisterWidget( widget );

	    XSelectInput( XtDisplay( widget ), XtWindow( widget ), (unsigned long)
		 	KeyPressMask | KeyReleaseMask | ButtonPressMask
				| ButtonReleaseMask | ButtonMotionMask
					| ExposureMask
		                            | MapNotify | VisibilityNotify);
				
	}
		
	/*
	 *  load all defined children widgets
	 */

	if (primary_children) {
		for (i=0; i<child_count; i++)
			if ( !ascii_load_primary( childname[i], widget ) )
				return NULL;
	} else {
		for (i=0; i<child_count; i++)
			if ( !ascii_load_widget( childname[i], widget ) )
				return NULL;
	}
	return widget;
}

/*********************************************************/

/*
 *	The following functions handle registering 
 *	external functions in a simple manner.
 *	This might be better handled by the resource manager,
 *	but is a small amount of code which can be released after
 *      all user interfaces are loaded.
 */

typedef struct FtnMap {
	struct FtnMap *next;		/* simple linked list */
	XtCallbackProc callback;	/* function pointer */
	char name[64];			/* function name */
} XtFtnMapRec;

XtFtnMapRec *FMList = NULL;	
XtFtnMapRec **FtnMapList = &FMList;

void XtRegisterFtn (callbackFtn, callbackName)
XtCallbackProc callbackFtn;
char *callbackName;
{
    int n;
    XtFtnMapRec *fmr, *fm;
    fm =  (XtFtnMapRec*) XtMalloc((unsigned)sizeof(XtFtnMapRec));
    fm->next = NULL;
    fm->callback = callbackFtn;
    n = strlen( callbackName );
    if (n > 63) n = 63;
    strncpy( fm->name, callbackName, n+1 );
    if (*FtnMapList == NULL){
             (*FtnMapList) = fm;
             return;
    }
    /* append to linked list */
    fmr = (*FtnMapList);
    while (fmr->next) fmr = fmr->next;
    fmr->next = fm;
    return;
}

XtCallbackProc XtRetrieveFtn( callbackName )
char *callbackName;
{
   XtFtnMapRec *fm;

   for ( fm = *FtnMapList; fm != NULL; fm = fm->next ) 
           if (!strcmp( fm->name, callbackName )) return fm->callback;
   return NULL;
}

/*  (see, wasn't that simple)  */
/*********************************************************/

/*
 *  Support routines for the simple widget parser
 */

 
/*
 *  lookup_by_name( string, symbol list )
 *
 *  this routine tries to find a match between
 *  the string passed and the list of legal symbols 
 *  passed.
 *  It returns 0 (zero) if no match, otherwise it returns
 *  the id value associated with the particular match.
 */
 
lookup_by_name( str, symbols )
register char *str;
struct symtab *symbols;
{
	register char c1, c2;
	register struct symtab *p;
	register len;
/*
fprintf( stderr, "lookup_by_name( '%s' )\n", str );
*/
	len = strlen( str );
	c1 = str[0];
	for ( p = symbols; p->name; p++ )
	{
								/* alphabetical order */
		if ( c1 > (c2 = p->name[0]) ) continue;		/* not there yet */
		else if ( c1 == c2 )				/* maybe */
		{
			if ( len < p->match ) continue;		/* can't tell yet */

			if ( strncmp( str, p->name, p->match ) == 0 ) return p->value ;
		}
		else	return 0;			/* passed any possible matches */
	}
	return 0;
}


/* Not used, looks up by id value, returning the name */

char *lookup_by_value( value, symbols )
register value;
struct symtab *symbols;
{
	register struct symtab *p;
	register cmp;

	for ( p = symbols; p->name; p++ )
		if ( value == p->value ) return p->name ;
	return NULL;
}


/*
 *	Scan for colon or end of line, leaving characters
 *	scanned in 'buf'.
 */
 
 /* tokens are delimited by either new-line, or colon or a blank (space) */
 
Boolean get_token( fp, buf, max )
register FILE *fp;
register char *buf;
register max;
{
	register c;


	while ( (c = getc( fp )) != EOF && (c==' ' || c=='\t' || c=='\n') ) ;
	if ( c == EOF ) return FALSE;
	
	ungetc( c, fp );
	
	while ( (--max >= 0) && (c = getc( fp )) != EOF )
	{

		if ( c == ':' || c == '\n' || c == ' ' )
		{
			*buf = '\0'; /* terminate token in buffer */
			
			if ( c != '\n' ) /* gobble up crud between tokens */
			{
				while ( (c = getc( fp )) != EOF && (c==' ' || c=='\t') );
				/* Push back last char, it might be important */
				if ( c != EOF ) ungetc( c, fp );
			}
			return TRUE;
		} else *buf++ = c;
	}
	return FALSE;
}


/*
 *  decode_token() reads in the stream, and tries to match the token
 *  against the list of legal tokens provided by the symbols structure
 */

#define MAXLINE	256

decode_token( fp, symbols )		/* the real thing */
register FILE *fp;
struct symtab *symbols;
{
	register int value, c;
	char buf[256];

	while ( (c = getc( fp )) != EOF && (c==' ' || c=='\t' || c=='\n') )
		;
	if ( c == EOF ) return EOF;
	ungetc( c, fp );
	if ( strchr( "0123456789-+.", c ) ) return 0;
	if ( !get_token( fp, buf, MAXLINE )) return 0;
	value = lookup_by_name( buf, symbols );
	return value;
}

/*
 * routines to handle ascii referencing of widgets easily 
 * (which is the only way available to an application which
 *  uses pickled widgets).
 */

/* 
 * get immediate decendant of this parent by name 
 */
 
Widget GetChildByName( parent, name )
Widget	parent;
char *name;
{
    Cardinal i;
    Widget widget;
    CompositeWidget cw;

    if (!name) return NULL;
    if (!parent) return NULL;
    if ( !XtIsComposite( parent )) return NULL;

    cw = (CompositeWidget) parent;

    for (i = 0; i< cw->composite.num_children; i++) {
	widget = cw->composite.children[i];
	if (widget)
		if ( !strcmp( name, widget->core.name))
			return widget;
    }
    return NULL;
}

/*
 * get any  decendant of this parent by name 
 */

Widget GetSubChildByName( parent, name )
Widget	parent;
char *name;
{
    Cardinal i;
    Widget widget;
    CompositeWidget cw;

    if (!name) return NULL;
    if (!parent) return NULL;
    if ( !XtIsComposite( parent )) return NULL;

    cw = (CompositeWidget) parent;

    for (i = 0; i< cw->composite.num_children; i++) {
	widget = cw->composite.children[i];
	if (widget) {
		if ( !strcmp( name, widget->core.name)) return widget;
		if (widget = GetSubChildByName( widget, name )) return widget;
	}
    }
    return NULL;
}

