#include "RcP.h"

static void yyerror () ;
static int yywrap () ;
static int input () ;
static void unput () ;

/* Private Definitions */

RcClassRec rcClassRec =
{
  { /* core_class fields */
    /* superclass         */    (WidgetClass) &tblClassRec,
    /* class_name         */    "Rc",
    /* widget_size        */    sizeof(RcRec),
    /* class_initialize   */    NULL,
    /* class_part_init    */    NULL,
    /* class_inited       */    FALSE,
    /* initialize         */    NULL,
    /* initialize_hook    */    NULL,
    /* realize            */    XtInheritRealize,
    /* actions            */    NULL,
    /* num_actions        */    0,
    /* resources          */    NULL,
    /* num_resources      */    0,
    /* xrm_class          */    NULLQUARK,
    /* compress_motion    */    TRUE,
    /* compress_exposure  */    TRUE,
    /* compress_enterleave*/    TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    XtInheritResize,
    /* expose             */    NULL,
    /* set_values         */    NULL,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */    NULL,
    /* accept_focus       */    NULL,
    /* version            */    XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry	  */	NULL,
  },
  { /* composite_class fields */
    /* geometry_manager   */   XtInheritGeometryManager,
    /* change_managed     */   XtInheritChangeManaged,
    /* insert_child       */   XtInheritInsertChild,
    /* delete_child       */   XtInheritDeleteChild,
    /* move_focus_to_next */   NULL,
    /* move_focus_to_prev */   NULL
  },
  { /* constraint_class fields */
    /* subresources       */   NULL,
    /* subresource_count  */   0,
    /* constraint_size    */   sizeof(RcConstraintsRec),
    /* initialize         */   NULL,
    /* destroy            */   NULL,
    /* set_values         */   NULL
  },
  { /* tbl_class fields   */
    /* interpret_string   */   MyString
  },
  { /* rc_class fields    */
    /* empty  		  */   NULL
  }
} ;

WidgetClass rcWidgetClass = (WidgetClass)&rcClassRec ;

/***** **** *** ** * InterpretString * ** *** **** *****/

static char *rc_format_string ;
static char *output_format ;
static char mystring[200] ;

static String MyString (string)
    char *string ;
{
rc_format_string = string ;
output_format = mystring ;
yyparse () ;
return mystring ;
}

#include "y.rc.c"

static void
yyerror (s)
    char *s ;
{
char *etext = "Rc: yacc parsing error\n" ;
XtError (etext) ;
}

static int
yywrap ()
{
return 1 ;
}

static int inbuffer[100] ;
static int inpointer = 0 ;

static int
input ()
{
int t ;
if (inpointer)
    {
    t = inbuffer[inpointer-1] ;
    inpointer-- ;
    }
else
    {
    t = *rc_format_string++ ;
    }

return t ;
}

static void
unput (c)
    int c ;
{
inbuffer[inpointer++] = c ;
return ;
}

