/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/
/*
 * $Header: SWindowP.h,v 1.1 88/08/20 09:07:02 michael Exp $ Sony Corporation
 *
 * $Log:	SWindowP.h,v $
 * Revision 1.1  88/08/20  09:07:02  michael
 * Initial revision
 * 
 */

/************************************************************************
 *									*
 *	< SWindowPrivate.h - Private definitions for Window widget >	*
 * 									*
 * 									*
 * 						Sony Corporation	*
 *						Wed Aug 10 1988		*
 *									*
 ************************************************************************/

#ifndef _XtSWindowPrivate_h
#define _XtSWindowPrivate_h

/*===============================================================
	New fields for the Window widget class record
===============================================================*/
typedef struct {
	int mumble;   /* No new procedures */
} SWindowClassPart;

/*===============================================================
	Full class record declaration/
===============================================================*/
typedef struct _SWindowClassRec {
	CoreClassPart	    core_class;
	CompositeClassPart  composite_class;
	SWindowClassPart    window_class;
} SWindowClassRec;
extern SWindowClassRec sWindowClassRec;

/*===============================================================
	New fields for the Window widget record
===============================================================*/
typedef struct {
    /* =============  pubric  ============= */
    XtWindowType	window_type;	    /* window type		*/
    Boolean		inactive;	    /* active / inactive mode	*/
    Cursor		cursor;		    /* cursor			*/
    Boolean		iconify;	    /* iconify on/off		*/
    XFontStruct		*font;		    /* icon label font		*/
#ifdef KANJI
    XFontStruct		*kanji_font;	    /* icon label font		*/
#endif KANJI
    String		icon_label;	    /* icon label		*/
    String		bitmap_path;	    /* bitmap path		*/
    String		icon_file;	    /* bitmap file		*/
    Dimension   	hspace; 	    /* window horizontal space	*/
    Dimension   	vspace;		    /*        vertical   space	*/
    Dimension   	screen_width;	    /* screen width		*/
    Dimension   	screen_height;	    /*        height		*/
    Dimension   	min_screen_width;   /* screen minimum width	*/
    Dimension   	min_screen_height;  /*                height	*/
    Dimension   	max_screen_width;   /* screen minimum width	*/
    Dimension   	max_screen_height;  /*                height	*/
    Boolean		close_flag;	    /* close box  on/off	*/
    Boolean		title_flag;	    /* title bar  on/off	*/
    Boolean		scroll_flag;	    /* scroll box on/off	*/
    Boolean		vscroll_flag;	    /* vertical   scroll bar on/off */
    Boolean		hscroll_flag;	    /* horizontal scroll bar on/off */
    Boolean		resize_flag;	    /* resize box on/off	*/
    XtCallbackList	selclr_callback;    /* callback list - selection clear */
    XtCallbackList	prop_callback;	    /* callback list - change property */
    XtCallbackList	raise_callback;	    /* callback list - raise 	*/
    XtCallbackList	move_callback;	    /* callback list - window move  */
    XtCallbackList	close_callback;	    /* callback list - close 	*/
    XtCallbackList	resize_callback;    /* callback list - resize	*/
    XtCallbackList	deiconify_callback; /* callback list - deiconify */
    WidgetClass		menu_class;	    /* menu bar  - widget class	*/
    ArgList		menu_args;	    /* 		   arguments  	*/
    Cardinal		num_menu_args;      /* 		   number of arguments */
    WidgetClass		screen_class;	    /* screen    - widget class	*/
    ArgList		screen_args;	    /*		   arguments	*/
    Cardinal		num_screen_args;    /*		   number of arguments */

    /* =============  private ============= */
    Widget		close_box;	    /* widget	(close box)	*/
    Widget		title_bar;	    /*   :	(title bar)	*/
    Widget		menu_bar;	    /*	 :	(menu bar)	*/
    Widget		screen;		    /*	 :	(screen)	*/
    Widget		scroll_box;	    /*	 :	(scroll box)	*/
    Widget              vscroll_bar;        /*	 :	(vertical   scroll bar) */
    Widget              hscroll_bar;        /*	 :	(horizontal scroll bar) */
    Widget              icon;		    /*	 :	(icon)		*/
    Dimension   	close_width;	    /* close box width		*/
    Dimension   	close_height;	    /*           height		*/
    Dimension   	title_height;	    /* title bar height		*/
    Dimension   	menu_height;	    /* menu bar height		*/
    Dimension   	scroll_width;	    /* scroll box width		*/
    Dimension   	scroll_height;	    /*            height	*/
    Dimension           hscroll_height;     /* horizontal scroll bar heiht */
    Dimension           vscroll_width;      /* vertical   scroll bar width */
    Dimension   	close_border;	    /* close box border width	*/
    Dimension   	title_border;	    /* title bar 	:	*/
    Dimension   	menu_border;	    /* menu bar 	:	*/
    Dimension   	scroll_border;	    /* scroll box 	:	*/
    Dimension   	screen_border;	    /* screen 		:	*/
    Dimension   	vscroll_border;	    /* vertical scroll bar	*/
    Dimension   	hscroll_border;	    /* horizontal scroll bar	*/
    Dimension   	resize_border;	    /* resize box		*/
    GC			frame_gc;
    GC			resize_gc;
    Time		time;
    Boolean		icon_flag;
    Boolean		open_flag;
    Boolean		flame;
    Boolean		redisp;
    Boolean		resize_event;
    Position		current_x;
    Position		current_y;
    Position		flame_x1;
    Position		flame_x2;
    Position		flame_y1;
    Position		flame_y2;
    Position		cursor_x;
    Position		cursor_y;
    Dimension   	max_width;
    Dimension   	max_height;
    Dimension   	min_window_width;   /* screen minimum width	*/
    Dimension   	min_window_height;  /*                height	*/
    Dimension   	max_window_width;   /* screen maximum width	*/
    Dimension   	max_window_height;  /*                height	*/
} SWindowPart;


/*===============================================================
	Full instance record declaration
===============================================================*/
typedef struct _SWindowRec {
    CorePart	    core;
    CompositePart   composite;
    SWindowPart      window;
} SWindowRec;


#endif _XtSWindowPrivate_h
/* DON'T ADD STUFF AFTER THIS #endif */
