/*
 * $Header: SText.h,v 1.1 88/08/20 09:06:59 michael Exp $ Sony Corporation
 *
 * $Log:	SText.h,v $
 * Revision 1.1  88/08/20  09:06:59  michael
 * Initial revision
 * 
 */
/***********************************************************
 *                                                         *
 *   Sony Text widget public header file                   *
 *	Copyright (c) 1988 Sony Corp.                      *
 *                                                         *
 *    Original: Text.h by DEC, M.I.T.                      *
 *    Modified: by Sony Corp.                              *
 *                                                         *
 ***********************************************************/

/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

#ifndef _XtSText_h
#define _XtSText_h

/****************************************************************
 *
 * Text widget
 *
 ****************************************************************/

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		pixel		White
 border		     BorderColor	pixel		Black
 borderWidth	     BorderWidth	int		1
 destroyCallback     Callback		Pointer		NULL
 dialogHOffset	     Margin		int		10
 dialogVOffset	     Margin		int		10
 displayPosition     TextPosition	int		0
 editType	     EditType		XtTextEditType	XttextRead
 height		     Height		int		font height
 insertPosition	     TextPosition	int		0
 leftMargin	     Margin		int		2
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 selectTypes	     SelectTypes	Pointer		(internal)
 selection	     Selection		Pointer		empty selection
 sensitive	     Sensitive		Boolean		True
 textOptions	     TextOptions	int		0
 textSink	     TextSink		Pointer		(none)
 textSource	     TextSource		Pointer		(none)
 width		     Width		int		100
 x		     Position		int		0
 y		     Position		int		0
 textCallback        Callback           Pointer         NULL
 textScrollCallback  Callback           Pointer         NULL

*/


#define XtNtextOptions		"textOptions"
#define XtNdialogHOffset	"dialogHOffset"
#define XtNdialogVOffset	"dialogVOffset"
#define XtNdisplayPosition      "displayPosition"
#define XtNinsertPosition	"insertPosition"
#define XtNleftMargin		"leftMargin"
#define XtNselectTypes		"selectTypes"
#define XtNtextSource		"textSource"
#define XtNtextSink		"textSink"
#define XtNselection		"selection"

#define XtNeditType		"editType"
#define XtNfile			"file"
#define XtNstring		"string"
#define XtNlength		"length"
#define XtNfont			"font"
/* added by M. Ono */
#define XtNtextCallback		"textCallback"
#define XtNtextScrollCallback	"textScrollCallback"
#define XtNtextShortcutCallback	"textShortcutCallback"
#define XtNshowInsertCursor	"showInsertCursor"
#ifdef KANJI
#define XtNkanjiFont		"kanjiFont"
#endif KANJI

#define XtCShowInsertCursor	"ShowInsertCursor"
#ifdef KANJI
#define XtCKanjiFont		"KanjiFont"
#endif KANJI

/* Class record constants */

extern WidgetClass sTextWidgetClass;

typedef struct _STextClassRec *STextWidgetClass;
typedef struct _STextRec      *STextWidget;

/* other stuff */
/* These are same as Xaw */

typedef long XtTextPosition;
typedef struct _XtTextSource XtTextSourceRec, *XtTextSource;
typedef struct _XtTextSink XtTextSinkRec, *XtTextSink;

typedef enum {XttextRead, XttextAppend, XttextEdit} XtTextEditType;
typedef enum {XtselectNull, XtselectPosition, XtselectChar, XtselectWord,
    XtselectLine, XtselectParagraph, XtselectAll} XtTextSelectType;

typedef struct {
    int  firstPos;
    int  length;
    char *ptr;
    Atom format;  /* unused? */
} XtTextBlock, *XtTextBlockPtr;

#define wordBreak		0x01
#define scrollVertical		0x02    /* Not used */
#define scrollHorizontal	0x04    /* Not used */
#define scrollOnOverflow	0x08
#define resizeWidth		0x10
#define resizeHeight		0x20
#define editable		0x40

extern void XtSTextDisplay(); /* w */
    /* Widget w; */

extern void XtSTextSetSelectionArray(); /* w, sarray */
    /* Widget        w;		*/
    /* SelectionType *sarray;   */

extern void XtSTextSetLastPos(); /* w, lastPos */
    /* Widget        w;		*/
    /* XtTextPosition lastPos;  */

extern void XtSTextGetSelectionPos(); /* w, left, right */
    /* Widget        w;		*/
    /* XtTextPosition *left, *right;    */

extern void XtSTextSetSource(); /* w, source, startPos */
    /* Widget         w;	    */
    /* XtTextSource   source;       */
    /* XtTextPosition startPos;     */

extern int XtSTextReplace(); /* w, startPos, endPos, text */
    /* Widget        w;		*/
    /* XtTextPosition   startPos, endPos; */
    /* XtTextBlock      *text; */

extern XtTextPosition XtSTextTopPosition(); /* w */
    /* Widget        w;		*/

extern void XtSTextSetInsertionPoint(); /*  w, position */
    /* Widget        w;		*/
    /* XtTextPosition position; */

extern XtTextPosition XtSTextGetInsertionPoint(); /* w */
    /* Widget        w;		*/

extern void XtSTextUnsetSelection(); /* w */
    /* Widget        w;		*/

extern void XtSTextChangeOptions(); /* w, options */
    /* Widget        w;		*/
    /* int    options; */

extern int XtSTextGetOptions(); /* w */
    /* Widget        w;		*/

extern void XtSTextSetSelection(); /* w, left, right */
    /* Widget        w;		*/
    /* XtTextPosition left, right; */

extern void XtSTextInvalidate(); /* w, from, to */
    /* Widget        w;		*/
    /* XtTextPosition from, to; */

extern XtTextSource XtSTextGetSource() ; /* w */
    /* Widget        w;		*/

extern void XtSTextShowCursor(); /* w, show */
    /* Widget        w;         */
    /* Boolean       show;      */

extern char * XtSTextGetWholeText(); /* w */
    /* Widget        w;         */
   
extern int XtSTextGetCurrentLine(); /* w */
    /* Widget	     w;		*/

extern int XtSTextGetLastLine(); /* w */
    /* Widget        w;         */

extern void XtSTextGotoLine(); /* w, line */
    /* Widget        w;         */
    /* int           line;      */

extern XtTextPosition XtSTextGetLastPosition(); /* w */
    /* Widget        w;         */

extern XtTextPosition XtSTextGetTopOfLine(); /* w, position */
    /* Widget        w;         */
    /* XtTextPosition position; */

extern Boolean XtSSTextIsWholeTextShown(); /* w */
    /* Widget        w;         */

extern int XtSTextGetShownLines(); /* w */
    /* Widget        w;         */

extern int XtSTextGetModifiedCount(); /* w */
    /* STextWidget   w;         */

extern void XtSTextResetModifiedCount(); /* w */
    /* STextWidget   w;         */

#ifdef SONY
extern void XtSTextPutClipboard(); /* w, from, to */
    /* STextWidget   w;         */
    /* XtTextPosition from, to; */

extern int XtSTextGetClipboard(); /* w */
    /* STextWidget   w;         */
#endif


/*
 * Stuff from SAsciiSink
 */

extern XtTextSink XtSAsciiSinkCreate(); /* parent, args, num_args */
    /* Widget parent;		*/
    /* ArgList args;		*/
    /* Cardinal num_args;	*/

extern void XtSAsciiSinkDestroy(); /* sink */
    /* XtTextSink  sink */

#ifdef KANJI
/*
 * Stuff from SKanjiSink
 */

extern XtTextSink XtSKanjiSinkCreate(); /* parent, args, num_args */
    /* Widget parent;		*/
    /* ArgList args;		*/
    /* Cardinal num_args;	*/

extern void XtSKanjiSinkDestroy(); /* sink */
    /* XtTextSink  sink */
#endif KANJI

/*
 * from SDiskSrc
 */
extern XtTextSource XtSDiskSourceCreate(); /* parent, args, num_args */
    /* Widget	parent;		*/
    /* ArgList	args;		*/
    /* Cardinal	num_args;	*/

extern void XtSDiskSourceDestroy(); /* src */
    /* XtTextSource src;	*/

/*
 * from SStringSrc
 */

extern XtTextSource XtSStringSourceCreate(); /* parent, args, num_args */
    /* Widget parent;		*/
    /* ArgList args;		*/
    /* Cardinal num_args;	*/

extern void XtSStringSourceDestroy(); /* src */
    /* XtTextSource src;	*/


#endif _XtSText_h
/* DON'T ADD STUFF AFTER THIS #endif */
