#ifndef lint
static char rcsid[] = "$Header: SScrollText.c,v 1.1 88/08/20 09:06:33 michael Exp $ Sony Corporation";
#endif lint
/*
 * $Log:	SScrollText.c,v $
 * Revision 1.1  88/08/20  09:06:33  michael
 * Initial revision
 * 
 */

/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

#include	<stdio.h>

#include	<X11/IntrinsicP.h>
#include	<X11/StringDefs.h>
#include        <X11/Cardinals.h>
#include	<X11/SStringDefs.h>
#include	<X11/SText.h>
#include        <X11/SKanjiText.h>
#include	<X11/SScroll.h>
#include	<X11/SScrollTextP.h>

#define max(x,y) ((x) > (y) ? (x):(y))

static int defWidth = 200;
static int defHeight = 100;

/****************************************************************
 *
 * ScrollText Resources
 *
 ****************************************************************/

static XtResource resources[] = {
    {XtNfile, XtCFile, XtRString, sizeof (char *),
        XtOffset(SScrollTextWidget, scrtext.fileName), XtRString, NULL},
    {XtNwidth, XtCWidth, XtRInt, sizeof(int),
	XtOffset(SScrollTextWidget, core.width), XtRInt, (caddr_t)&defWidth},
    {XtNheight, XtCHeight, XtRInt, sizeof(int),
	XtOffset(SScrollTextWidget, core.height), XtRInt, (caddr_t)&defHeight},
};

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

static void Initialize();
static void Resize();
static Boolean SetValues();
static XtGeometryResult GeometryManager();
static void ChangeManaged();
XtCallbackProc XtSCallbackUpdateText();
XtCallbackProc XtSCallbackUpdateScroll();

SScrollTextClassRec sScrollTextClassRec = {
  {
/* core_class fields      */
    /* superclass         */    (WidgetClass) &compositeClassRec,
    /* class_name         */    "SScrollText",
    /* widget_size        */    sizeof(SScrollTextRec),
    /* class_initialize   */    NULL,
    /* calss_part_init    */    NULL,
    /* class_inited       */	FALSE,
    /* initialize         */    NULL,
    /* initialize_hook    */    Initialize,
    /* realize            */    XtInheritRealize,
    /* actions            */    NULL,
    /* num_actions	  */	0,
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion	  */	TRUE,
    /* compress_exposure  */	TRUE,
    /* compress_enterleave*/	TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,  /* ??? */
    /* resize             */    Resize,
    /* expose             */    NULL,  /* ??? */
    /* set_values         */    SetValues,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */    NULL,
    /* accept_focus       */    XtInheritAcceptFocus,
    /* version            */    XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    XtInheritTranslations,
    /* query_geomtry      */    NULL
  },{
/* composite_class fields */
    /* geometry_manager   */    GeometryManager,
    /* change_managed     */    ChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,   /* Inherit from superclass */
    /* delete_child	  */	XtInheritDeleteChild,	/* Inherit from superclass */
    /* move_focus_to_next */    NULL,
    /* move_focus_to_prev */    NULL
  },{
/* sscrolltext_class fields */
    /* mumble		  */	0	/* Make C compiler happy   */
  }
};

WidgetClass sScrollTextWidgetClass = (WidgetClass)&sScrollTextClassRec;

#define ScrWidth 20
#define TextBorderWidth 1
#define ScrollBorderWidth 0
#define ScrollbarOffset 2
#define Smooth    1
#define ThumbLen 20

/* arguments for scroll bar */
#define SAx	0
#define SAy	1
#define SAwidth 2
#define SAheight 3
#define SAmax 5
#define SAsmooth 7
#define SAposition 8
#define SAbutton_len 9
#define SAinactive 10

static Arg ScrArgs[] = {
    { XtNx, (XtArgVal) 0 },
    { XtNy, (XtArgVal) 0 },
    { XtNwidth, (XtArgVal) ScrWidth - 2 * ScrollbarOffset },
    { XtNheight, (XtArgVal) 0 },
    { XtNscrollMinV, (XtArgVal) 1 },
    { XtNscrollMaxV, (XtArgVal) 0 },
    { XtNscrollThumbLenV, (XtArgVal) ThumbLen },
    { XtNscrollSmoothV, (XtArgVal) Smooth },
    { XtNscrollPositionV, (XtArgVal) 1 },
    { XtNscrollButtonLenV, (XtArgVal) ScrWidth - 2 * ScrollbarOffset},
    { XtNinactive, (XtArgVal) FALSE },
    { XtNscrollThumbFix, (XtArgVal) TRUE },
    { XtNscrollBarRaw, (XtArgVal) TRUE },
    { XtNscrollButtonRaw, (XtArgVal) TRUE },
    { XtNscrollPointMode, (XtArgVal) FALSE },
    { XtNhotSpot, (XtArgVal) XthotSpotTop },
    { XtNscrollShownV, (XtArgVal) 0 },
    { XtNscrollOrientation, (XtArgVal)Xtscroll_Vertical},
    { XtNborderWidth, (XtArgVal)ScrollBorderWidth}
};

static char scrollbarEventBindings[] =
    "<BtnDown>: set() notify() timeron() \n\
    <MouseMoved>:set()\n\
    <BtnUp>:    timeroff() unset()";
/* How can I set MouseMoved event is ignored? */


/* argments for text */
#define TAx 0
#define TAy 1
#define TAwidth 2
#define TAheight 3

static Arg TextArgs[] = {
    { XtNx, (XtArgVal) 0 },
    { XtNy, (XtArgVal) 0 },
    { XtNwidth, (XtArgVal) 0 },
    { XtNheight, (XtArgVal) 0 },
    { XtNborderWidth, (XtArgVal)TextBorderWidth}
};


/****************************************************************
 *
 * Private Routines
 *
 ****************************************************************/


/*
 *
 * Geometry Manager
 *
 */

/*ARGSUSED*/
static XtGeometryResult GeometryManager(w, request, reply)
    Widget		w;
    XtWidgetGeometry	*request;
    XtWidgetGeometry	*reply;	/* RETURN */

{
/* request is always denied. */
	return( XtGeometryNo );
}

static void ChangeManaged(vtw)
    SScrollTextWidget vtw;
{
/* Nothing to do. */
}

static void Initialize( new, args, num_args)
    SScrollTextWidget  new;
    ArgList args;
    Cardinal *num_args;
{
    STextWidget ctx;
    ArgList mrgTxtArg;
    ArgList mrgScrArg;
    ArgList check;
    Arg fname[1];
    int i;
    Boolean disk = FALSE;

    TextArgs[TAwidth].value = new->core.width - ScrWidth - 2 * TextBorderWidth;
    TextArgs[TAheight].value = new->core.height  - 2 * TextBorderWidth;

    mrgTxtArg = XtMergeArgLists( args, *num_args, TextArgs, XtNumber(TextArgs));
    if( new->scrtext.fileName != NULL  ) 
        new->scrtext.text = XtCreateManagedWidget( "text", sKanjiDiskWidgetClass, new, mrgTxtArg, *num_args + XtNumber(TextArgs));
    else
        new->scrtext.text = XtCreateManagedWidget( "text", sKanjiStringWidgetClass, new, mrgTxtArg, *num_args + XtNumber(TextArgs));
    ctx = (STextWidget)new->scrtext.text;

    ScrArgs[SAx].value = new->core.width - ScrWidth + ScrollbarOffset;
    ScrArgs[SAheight].value = new->core.height - 2 * TextBorderWidth;
    ScrArgs[SAmax].value = XtSTextGetLastLine( ctx );
    ScrArgs[SAinactive].value = XtSTextIsWholeTextShown( ctx );

    mrgScrArg = XtMergeArgLists( args, *num_args, ScrArgs, XtNumber(ScrArgs));
    new->scrtext.scroll = XtCreateManagedWidget( "scroll", sScrollWidgetClass, 
			   new, mrgScrArg, *num_args + XtNumber( ScrArgs ) );
    XtAddCallback( new->scrtext.text, XtNtextScrollCallback, XtSCallbackUpdateScroll, new->scrtext.scroll );
    XtAddCallback( new->scrtext.scroll, XtNcallback, XtSCallbackUpdateText, new->scrtext.text );
    XtOverrideTranslations( XtNameToWidget(new->scrtext.scroll, "scrollBar"),
			    XtParseTranslationTable(scrollbarEventBindings));

} /* Initialize */


/*
 * Resize
 */
static void Resize( w )
SScrollTextWidget w;
{
    Dimension text_width, scroll_x, height;
    STextWidget ctx;
    static Arg args[] = {
	{ XtNinactive, (XtArgVal) FALSE },
    };

    text_width = w->core.width - ScrWidth - 2 * TextBorderWidth;
    height = w->core.height - 2 * TextBorderWidth;
    ctx = (STextWidget) w->scrtext.text;
    XtResizeWidget( w->scrtext.text, text_width, height, TextBorderWidth );
    args[0].value = NULL;
    XtGetValues( w->scrtext.scroll, args, XtNumber(args));
    args[0].value = XtSTextIsWholeTextShown( ctx );
    XtSetValues( w->scrtext.scroll, args, XtNumber(args));
    XtResizeWidget( w->scrtext.scroll, (w->scrtext.scroll)->core.width, height, w->scrtext.scroll->core.border_width);
    XtMoveWidget( w->scrtext.scroll, w->core.width - ScrWidth + ScrollbarOffset, 0 );
}


/*
 *
 * Set Values
 *
 */

static Boolean SetValues (current, request, new, last)
    Widget current, request, new;
    Boolean last;
{
    SScrollTextWidget old = (SScrollTextWidget) current; 
    SScrollTextWidget w = (SScrollTextWidget) new; 
    if( w->scrtext.fileName != old->scrtext.fileName )
	XtError( "SetValues on SScrollTextWidget file not supported." );
    if( w->scrtext.text != old->scrtext.text )
	XtError( "SetValues on SScrollTextWidget text not supported." );
    if( w->scrtext.scroll != old->scrtext.scroll )
	XtError( "SetValues on SScrollTextWidget scroll not supported." );
    return (FALSE);
}


XtCallbackProc XtSCallbackUpdateText( w, closure, data )
Widget w;
caddr_t closure;
caddr_t data;

{
    SscrollEvent *se;
    STextWidget ctx;
    int current,new_position;
    
    se = (SscrollEvent *)data;
    ctx = (STextWidget) closure;
    current =  XtSTextGetCurrentLine( ctx );
    if (se->scrollEv_type & ScrollEv_Scroll) {
	if ( se->scrollEv_posV != current ) {
	    XtSTextGotoLine( ctx, se->scrollEv_posV );
	} else
	    return;
    } else {
        if (se->scrollEv_type & (ScrollEv_Inactive|ScrollEv_DeadendV)) {
	    return;
	    }
        else {
	    switch ( se->scrollEv_obj & 0x00ff) {
		case ScrollObj_Btn:
		    _XtSTextPrepareToUpdate(ctx);
		    if (se->scrollEv_obj & ScrollBtnDir)
		        _XtSTextScroll( ctx, Smooth );
		    else 
			_XtSTextScroll( ctx, -Smooth );
                    _XtSTextExecuteUpdate(ctx);
		    break;
		
		case ScrollObj_Bar:
		    if (se->scrollEv_obj & ScrollBarDir_V) {
		        if (se->scrollEv_posV >= current) {
                            _XtSTextPrepareToUpdate(ctx);
                            _XtSTextScroll( ctx, 
				    max(0, XtSTextGetShownLines(ctx) - 2 ));
                            _XtSTextExecuteUpdate(ctx);
		        }
		    } else
		        if (se->scrollEv_posV <  current ) {
                            _XtSTextPrepareToUpdate(ctx);
                            _XtSTextScroll( ctx, 
				    -max(0, XtSTextGetShownLines(ctx) - 2 ));
                            _XtSTextExecuteUpdate(ctx);
		        }
		    break;

		default:
		    break;
	    }
	}
    }
}

XtCallbackProc XtSCallbackUpdateScroll( w, closure, data )
Widget w;
caddr_t closure;
caddr_t data;
{
    static Arg args[] = {
	{ XtNscrollPositionV,  (XtArgVal)  0 },
	{ XtNscrollMaxV,  (XtArgVal)  0 },
	{ XtNinactive, (XtArgVal) 0 },
    };
    int top_pos, last_pos;
    Boolean active;
    STextWidget ctx;
    SScrollWidget sw;

    ctx = (STextWidget) w;
    sw = (SScrollWidget)closure;
    args[0].value = args[1].value = args[2].value = NULL;
    XtGetValues( sw, args, (unsigned)3 );
    top_pos =  XtSTextGetCurrentLine( ctx );
    last_pos = XtSTextGetLastLine( ctx );
    active = XtSTextIsWholeTextShown( ctx );
    if( args[0].value == top_pos &&
		args[1].value == last_pos &&
		args[2].value == active )
	return;
    args[0].value = top_pos;
    args[1].value = last_pos;
    args[2].value = active;
    XtSetValues(  sw, args, XtNumber( args ) );
}
